/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.bucket;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.OMBucketSetPropertyResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMBucketSetPropertyRequest
extends OMClientRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMBucketSetPropertyRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMBucketSetPropertyRequest.class);
    }

    public OMBucketSetPropertyRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        long modificationTime = Time.now();
        OzoneManagerProtocolProtos.SetBucketPropertyRequest.Builder setBucketPropertyRequestBuilder = this.getOmRequest().getSetBucketPropertyRequest().toBuilder().setModificationTime(modificationTime);
        return this.getOmRequest().toBuilder().setSetBucketPropertyRequest(setBucketPropertyRequestBuilder).setUserInfo(this.getUserInfo()).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        OMBucketSetPropertyResponse omClientResponse;
        boolean success;
        IOException exception;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        AuditLogger auditLogger;
        String bucketName;
        String volumeName;
        OmBucketArgs omBucketArgs;
        OMMetrics omMetrics;
        block21: {
            OzoneManagerProtocolProtos.SetBucketPropertyRequest setBucketPropertyRequest = this.getOmRequest().getSetBucketPropertyRequest();
            Preconditions.checkNotNull((Object)setBucketPropertyRequest);
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumBucketUpdates();
            OzoneManagerProtocolProtos.BucketArgs bucketArgs = setBucketPropertyRequest.getBucketArgs();
            omBucketArgs = OmBucketArgs.getFromProtobuf((OzoneManagerProtocolProtos.BucketArgs)bucketArgs);
            volumeName = bucketArgs.getVolumeName();
            bucketName = bucketArgs.getBucketName();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            OmBucketInfo omBucketInfo = null;
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            exception = null;
            boolean acquiredBucketLock = false;
            success = true;
            omClientResponse = null;
            try {
                try {
                    if (ozoneManager.getAclsEnabled()) {
                        this.checkAcls(ozoneManager, OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volumeName, bucketName, null);
                    }
                    acquiredBucketLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    String bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
                    OmBucketInfo dbBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)bucketKey);
                    if (dbBucketInfo == null) {
                        LOG.debug("bucket: {} not found ", (Object)bucketName);
                        throw new OMException("Bucket doesn't exist", OMException.ResultCodes.BUCKET_NOT_FOUND);
                    }
                    OmBucketInfo.Builder bucketInfoBuilder = OmBucketInfo.newBuilder();
                    bucketInfoBuilder.setVolumeName(dbBucketInfo.getVolumeName()).setBucketName(dbBucketInfo.getBucketName()).setObjectID(dbBucketInfo.getObjectID()).setUpdateID(transactionLogIndex);
                    bucketInfoBuilder.addAllMetadata(KeyValueUtil.getFromProtobuf((List)bucketArgs.getMetadataList()));
                    StorageType storageType = omBucketArgs.getStorageType();
                    if (storageType != null) {
                        bucketInfoBuilder.setStorageType(storageType);
                        LOG.debug("Updating bucket storage type for bucket: {} in volume: {}", (Object)bucketName, (Object)volumeName);
                    } else {
                        bucketInfoBuilder.setStorageType(dbBucketInfo.getStorageType());
                    }
                    Boolean versioning = omBucketArgs.getIsVersionEnabled();
                    if (versioning != null) {
                        bucketInfoBuilder.setIsVersionEnabled(versioning);
                        LOG.debug("Updating bucket versioning for bucket: {} in volume: {}", (Object)bucketName, (Object)volumeName);
                    } else {
                        bucketInfoBuilder.setIsVersionEnabled(Boolean.valueOf(dbBucketInfo.getIsVersionEnabled()));
                    }
                    String volumeKey = omMetadataManager.getVolumeKey(volumeName);
                    OmVolumeArgs omVolumeArgs = (OmVolumeArgs)omMetadataManager.getVolumeTable().get((Object)volumeKey);
                    if (this.checkQuotaBytesValid(omMetadataManager, omVolumeArgs, omBucketArgs)) {
                        bucketInfoBuilder.setQuotaInBytes(omBucketArgs.getQuotaInBytes());
                    } else {
                        bucketInfoBuilder.setQuotaInBytes(dbBucketInfo.getQuotaInBytes());
                    }
                    if (this.checkQuotaNamespaceValid(omVolumeArgs, omBucketArgs)) {
                        bucketInfoBuilder.setQuotaInNamespace(omBucketArgs.getQuotaInNamespace());
                    } else {
                        bucketInfoBuilder.setQuotaInNamespace(dbBucketInfo.getQuotaInNamespace());
                    }
                    bucketInfoBuilder.setCreationTime(dbBucketInfo.getCreationTime());
                    bucketInfoBuilder.setModificationTime(setBucketPropertyRequest.getModificationTime());
                    if (dbBucketInfo.getAcls() != null) {
                        bucketInfoBuilder.setAcls(dbBucketInfo.getAcls());
                    }
                    if (dbBucketInfo.getObjectID() != 0L) {
                        bucketInfoBuilder.setObjectID(dbBucketInfo.getObjectID());
                    }
                    bucketInfoBuilder.setUpdateID(transactionLogIndex);
                    bucketInfoBuilder.setUsedBytes(dbBucketInfo.getUsedBytes());
                    bucketInfoBuilder.setUsedNamespace(dbBucketInfo.getUsedNamespace());
                    omBucketInfo = bucketInfoBuilder.build();
                    omMetadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)bucketKey), new CacheValue(Optional.of((Object)omBucketInfo), transactionLogIndex));
                    omResponse.setSetBucketPropertyResponse(OzoneManagerProtocolProtos.SetBucketPropertyResponse.newBuilder().build());
                    omClientResponse = new OMBucketSetPropertyResponse(omResponse.build(), omBucketInfo);
                }
                catch (IOException ex) {
                    success = false;
                    exception = ex;
                    omClientResponse = new OMBucketSetPropertyResponse(this.createErrorOMResponse(omResponse, exception));
                    this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                    if (acquiredBucketLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                if (acquiredBucketLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquiredBucketLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.UPDATE_BUCKET, omBucketArgs.toAuditMap(), exception, userInfo));
        if (success) {
            LOG.debug("Setting bucket property for bucket:{} in volume:{}", (Object)bucketName, (Object)volumeName);
            return omClientResponse;
        }
        LOG.error("Setting bucket property failed for bucket:{} in volume:{}", new Object[]{bucketName, volumeName, exception});
        omMetrics.incNumBucketUpdateFails();
        return omClientResponse;
    }

    public boolean checkQuotaBytesValid(OMMetadataManager metadataManager, OmVolumeArgs omVolumeArgs, OmBucketArgs omBucketArgs) throws IOException {
        long quotaInBytes = omBucketArgs.getQuotaInBytes();
        if (quotaInBytes == -1L && omVolumeArgs.getQuotaInBytes() != -1L) {
            throw new OMException("Can not clear bucket spaceQuota because volume spaceQuota is not cleared.", OMException.ResultCodes.QUOTA_ERROR);
        }
        if (quotaInBytes < -1L || quotaInBytes == 0L) {
            return false;
        }
        long totalBucketQuota = 0L;
        long volumeQuotaInBytes = omVolumeArgs.getQuotaInBytes();
        if (quotaInBytes > -1L) {
            totalBucketQuota = quotaInBytes;
        }
        List bucketList = metadataManager.listBuckets(omVolumeArgs.getVolume(), null, null, Integer.MAX_VALUE);
        for (OmBucketInfo bucketInfo : bucketList) {
            long nextQuotaInBytes = bucketInfo.getQuotaInBytes();
            if (nextQuotaInBytes <= -1L || omBucketArgs.getBucketName().equals(bucketInfo.getBucketName())) continue;
            totalBucketQuota += nextQuotaInBytes;
        }
        if (volumeQuotaInBytes < totalBucketQuota && volumeQuotaInBytes != -1L) {
            throw new OMException("Total buckets quota in this volume should not be greater than volume quota : the total space quota is set to:" + totalBucketQuota + ". But the volume space quota is:" + volumeQuotaInBytes, OMException.ResultCodes.QUOTA_EXCEEDED);
        }
        return true;
    }

    public boolean checkQuotaNamespaceValid(OmVolumeArgs omVolumeArgs, OmBucketArgs omBucketArgs) {
        long quotaInNamespace = omBucketArgs.getQuotaInNamespace();
        return quotaInNamespace >= -1L && quotaInNamespace != 0L;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMBucketSetPropertyRequest.java", OMBucketSetPropertyRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.bucket.OMBucketSetPropertyRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 74);
    }
}

