/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.bucket;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.OMBucketDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMBucketDeleteRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMBucketDeleteRequest.class);

    public OMBucketDeleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        OMBucketDeleteResponse omClientResponse;
        boolean success;
        IOException exception;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        Map<String, String> auditMap;
        AuditLogger auditLogger;
        String bucketName;
        String volumeName;
        OMMetrics omMetrics;
        block16: {
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumBucketDeletes();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            OzoneManagerProtocolProtos.OMRequest omRequest = this.getOmRequest();
            OzoneManagerProtocolProtos.DeleteBucketRequest deleteBucketRequest = omRequest.getDeleteBucketRequest();
            volumeName = deleteBucketRequest.getVolumeName();
            bucketName = deleteBucketRequest.getBucketName();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            auditLogger = ozoneManager.getAuditLogger();
            auditMap = this.buildVolumeAuditMap(volumeName);
            auditMap.put("bucket", bucketName);
            userInfo = this.getOmRequest().getUserInfo();
            exception = null;
            boolean acquiredBucketLock = false;
            boolean acquiredVolumeLock = false;
            success = true;
            omClientResponse = null;
            try {
                try {
                    if (ozoneManager.getAclsEnabled()) {
                        this.checkAcls(ozoneManager, OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.DELETE, volumeName, bucketName, null);
                    }
                    acquiredVolumeLock = omMetadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
                    acquiredBucketLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    String bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
                    if (!omMetadataManager.getBucketTable().isExist((Object)bucketKey)) {
                        LOG.debug("bucket: {} not found ", (Object)bucketName);
                        throw new OMException("Bucket not exists", OMException.ResultCodes.BUCKET_NOT_FOUND);
                    }
                    if (!omMetadataManager.isBucketEmpty(volumeName, bucketName)) {
                        LOG.debug("bucket: {} is not empty ", (Object)bucketName);
                        throw new OMException("Bucket is not empty", OMException.ResultCodes.BUCKET_NOT_EMPTY);
                    }
                    omMetrics.decNumBuckets();
                    omMetadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)bucketKey), new CacheValue(Optional.absent(), transactionLogIndex));
                    omResponse.setDeleteBucketResponse(OzoneManagerProtocolProtos.DeleteBucketResponse.newBuilder().build());
                    String volumeKey = omMetadataManager.getVolumeKey(volumeName);
                    OmVolumeArgs omVolumeArgs = (OmVolumeArgs)omMetadataManager.getVolumeTable().getReadCopy((Object)volumeKey);
                    if (omVolumeArgs == null) {
                        throw new OMException("Volume " + volumeName + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
                    }
                    omVolumeArgs.incrUsedNamespace(-1L);
                    omMetadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)volumeKey), new CacheValue(Optional.of((Object)omVolumeArgs), transactionLogIndex));
                    omClientResponse = new OMBucketDeleteResponse(omResponse.build(), volumeName, bucketName, omVolumeArgs.copyObject());
                }
                catch (IOException ex) {
                    success = false;
                    exception = ex;
                    omClientResponse = new OMBucketDeleteResponse(this.createErrorOMResponse(omResponse, exception));
                    this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                    if (acquiredBucketLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    if (acquiredVolumeLock) {
                        omMetadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                if (acquiredBucketLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                if (acquiredVolumeLock) {
                    omMetadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
                }
                throw throwable;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquiredBucketLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
            if (acquiredVolumeLock) {
                omMetadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
            }
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.DELETE_BUCKET, auditMap, exception, userInfo));
        if (success) {
            LOG.debug("Deleted bucket:{} in volume:{}", (Object)bucketName, (Object)volumeName);
            return omClientResponse;
        }
        omMetrics.incNumBucketDeleteFails();
        LOG.error("Delete bucket failed for bucket:{} in volume:{}", new Object[]{bucketName, volumeName, exception});
        return omClientResponse;
    }
}

