/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditEventStatus;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditMessage;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.OzonePrefixPathImpl;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.om.request.RequestAuditor;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.ozone.security.acl.OzonePrefixPath;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OMClientRequest
implements RequestAuditor {
    private static final Logger LOG;
    private OzoneManagerProtocolProtos.OMRequest omRequest;
    private UserGroupInformation userGroupInformation;
    private InetAddress inetAddress;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMClientRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMClientRequest.class);
    }

    public OMClientRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        Preconditions.checkNotNull((Object)omRequest);
        this.omRequest = omRequest;
    }

    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.LayoutVersion layoutVersion = OzoneManagerProtocolProtos.LayoutVersion.newBuilder().setVersion((long)ozoneManager.getVersionManager().getMetadataLayoutVersion()).build();
        this.omRequest = this.getOmRequest().toBuilder().setUserInfo(this.getUserIfNotExists(ozoneManager)).setLayoutVersion(layoutVersion).build();
        return this.omRequest;
    }

    public abstract OMClientResponse validateAndUpdateCache(OzoneManager var1, long var2, OzoneManagerDoubleBufferHelper var4);

    @VisibleForTesting
    public OzoneManagerProtocolProtos.OMRequest getOmRequest() {
        return this.omRequest;
    }

    public OzoneManagerProtocolProtos.UserInfo getUserInfo() {
        UserGroupInformation user = ProtobufRpcEngine.Server.getRemoteUser();
        InetAddress remoteAddress = ProtobufRpcEngine.Server.getRemoteIp();
        OzoneManagerProtocolProtos.UserInfo.Builder userInfo = OzoneManagerProtocolProtos.UserInfo.newBuilder();
        if (user != null) {
            userInfo.setUserName(user.getUserName());
        }
        if (remoteAddress != null) {
            userInfo.setHostName(remoteAddress.getHostName());
            userInfo.setRemoteAddress(remoteAddress.getHostAddress()).build();
        }
        return userInfo.build();
    }

    public OzoneManagerProtocolProtos.UserInfo getUserIfNotExists(OzoneManager ozoneManager) {
        OzoneManagerProtocolProtos.UserInfo userInfo = this.getUserInfo();
        if (!userInfo.hasRemoteAddress() || !userInfo.hasUserName()) {
            InetAddress remoteAddress;
            UserGroupInformation user;
            OzoneManagerProtocolProtos.UserInfo.Builder newuserInfo = OzoneManagerProtocolProtos.UserInfo.newBuilder();
            try {
                user = UserGroupInformation.getCurrentUser();
                remoteAddress = ozoneManager.getOmRpcServerAddr().getAddress();
            }
            catch (Exception e) {
                LOG.debug("Couldn't get om Rpc server address", (Throwable)e);
                return this.getUserInfo();
            }
            newuserInfo.setUserName(user.getUserName());
            newuserInfo.setHostName(remoteAddress.getHostName());
            newuserInfo.setRemoteAddress(remoteAddress.getHostAddress());
            return newuserInfo.build();
        }
        return this.getUserInfo();
    }

    public void checkAcls(OzoneManager ozoneManager, OzoneObj.ResourceType resType, OzoneObj.StoreType storeType, IAccessAuthorizer.ACLType aclType, String vol, String bucket, String key) throws IOException {
        this.checkAcls(ozoneManager, resType, storeType, aclType, vol, bucket, key, ozoneManager.getVolumeOwner(vol, aclType, resType));
    }

    protected void checkACLs(OzoneManager ozoneManager, String volumeName, String bucketName, String keyName, IAccessAuthorizer.ACLType aclType) throws IOException {
        OzonePrefixPathImpl pathViewer = new OzonePrefixPathImpl(volumeName, bucketName, keyName, ozoneManager.getKeyManager());
        OzoneObjInfo obj = OzoneObjInfo.Builder.newBuilder().setResType(OzoneObj.ResourceType.KEY).setStoreType(OzoneObj.StoreType.OZONE).setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setOzonePrefixPath((OzonePrefixPath)pathViewer).build();
        boolean isDirectory = pathViewer.getOzoneFileStatus().isDirectory();
        RequestContext.Builder contextBuilder = RequestContext.newBuilder().setAclRights(aclType).setRecursiveAccessCheck(isDirectory);
        if (ozoneManager.getAclsEnabled()) {
            String volumeOwner = ozoneManager.getVolumeOwner(obj.getVolumeName(), contextBuilder.getAclRights(), obj.getResourceType());
            contextBuilder.setClientUgi(this.createUGI());
            contextBuilder.setIp(this.getRemoteAddress());
            contextBuilder.setHost(this.getHostName());
            contextBuilder.setAclType(IAccessAuthorizer.ACLIdentityType.USER);
            contextBuilder.setOwnerName(volumeOwner);
            ozoneManager.checkAcls((OzoneObj)obj, contextBuilder.build(), true);
        }
    }

    public void checkAcls(OzoneManager ozoneManager, OzoneObj.ResourceType resType, OzoneObj.StoreType storeType, IAccessAuthorizer.ACLType aclType, String vol, String bucket, String key, String volOwner) throws IOException {
        ozoneManager.checkAcls(resType, storeType, aclType, vol, bucket, key, this.createUGI(), this.getRemoteAddress(), this.getHostName(), true, volOwner);
    }

    @VisibleForTesting
    public UserGroupInformation createUGI() {
        if (this.userGroupInformation != null) {
            return this.userGroupInformation;
        }
        if (this.omRequest.hasUserInfo() && !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.omRequest.getUserInfo().getUserName())) {
            this.userGroupInformation = UserGroupInformation.createRemoteUser((String)this.omRequest.getUserInfo().getUserName());
            return this.userGroupInformation;
        }
        return null;
    }

    @VisibleForTesting
    public InetAddress getRemoteAddress() throws IOException {
        if (this.inetAddress != null) {
            return this.inetAddress;
        }
        if (this.omRequest.hasUserInfo()) {
            this.inetAddress = InetAddress.getByName(this.omRequest.getUserInfo().getRemoteAddress());
            return this.inetAddress;
        }
        return null;
    }

    @VisibleForTesting
    public String getHostName() {
        if (this.omRequest.hasUserInfo()) {
            return this.omRequest.getUserInfo().getHostName();
        }
        return null;
    }

    protected OzoneManagerProtocolProtos.OMResponse createErrorOMResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse.Builder omResponse, @Nonnull IOException ex) {
        omResponse.setSuccess(false);
        String errorMsg = this.exceptionErrorMessage(ex);
        if (errorMsg != null) {
            omResponse.setMessage(errorMsg);
        }
        omResponse.setStatus(OzoneManagerRatisUtils.exceptionToResponseStatus(ex));
        return omResponse.build();
    }

    protected void addResponseToDoubleBuffer(long trxIndex, OMClientResponse omClientResponse, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        if (omClientResponse != null) {
            omClientResponse.setFlushFuture(omDoubleBufferHelper.add(omClientResponse, trxIndex));
        }
    }

    private String exceptionErrorMessage(IOException ex) {
        if (ex instanceof OMException) {
            return ex.getMessage();
        }
        return StringUtils.stringifyException((Throwable)ex);
    }

    protected void auditLog(AuditLogger auditLogger, AuditMessage auditMessage) {
        auditLogger.logWrite(auditMessage);
    }

    @Override
    public AuditMessage buildAuditMessage(AuditAction op, Map<String, String> auditMap, Throwable throwable, OzoneManagerProtocolProtos.UserInfo userInfo) {
        return new AuditMessage.Builder().setUser(userInfo != null ? userInfo.getUserName() : null).atIp(userInfo != null ? userInfo.getRemoteAddress() : null).forOperation(op).withParams(auditMap).withResult(throwable != null ? AuditEventStatus.FAILURE : AuditEventStatus.SUCCESS).withException(throwable).build();
    }

    @Override
    public Map<String, String> buildVolumeAuditMap(String volume) {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", volume);
        return auditMap;
    }

    public static String validateAndNormalizeKey(boolean enableFileSystemPaths, String keyName) throws OMException {
        if (enableFileSystemPaths) {
            return OMClientRequest.validateAndNormalizeKey(keyName);
        }
        return keyName;
    }

    public static String validateAndNormalizeKey(String keyName) throws OMException {
        String normalizedKeyName = OmUtils.normalizeKey((String)keyName, (boolean)false);
        return OMClientRequest.isValidKeyPath(normalizedKeyName);
    }

    private static String isValidKeyPath(String path) throws OMException {
        boolean isValid = true;
        if (path.length() == 0) {
            throw new OMException("Invalid KeyPath, empty keyName" + path, OMException.ResultCodes.INVALID_KEY_NAME);
        }
        if (path.startsWith("/")) {
            isValid = false;
        } else {
            String[] components = org.apache.commons.lang3.StringUtils.split((String)path, (char)'/');
            int i = 0;
            while (i < components.length) {
                String element = components[i];
                if (element.equals(".") || element.contains(":") || element.contains("/") || element.equals("..")) {
                    isValid = false;
                    break;
                }
                if (element.isEmpty() && i != components.length - 1) {
                    isValid = false;
                }
                ++i;
            }
        }
        if (isValid) {
            return path;
        }
        throw new OMException("Invalid KeyPath " + path, OMException.ResultCodes.INVALID_KEY_NAME);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMClientRequest.java", OMClientRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.OMClientRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 95);
    }

    public static enum Result {
        SUCCESS,
        FAILURE;

    }
}

