/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ratis.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.ServiceException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.utils.HAUtils;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.codec.OMDBDefinition;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.exceptions.OMLeaderNotReadyException;
import org.apache.hadoop.ozone.om.exceptions.OMNotLeaderException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisServer;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.bucket.OMBucketCreateRequest;
import org.apache.hadoop.ozone.om.request.bucket.OMBucketDeleteRequest;
import org.apache.hadoop.ozone.om.request.bucket.OMBucketSetPropertyRequest;
import org.apache.hadoop.ozone.om.request.bucket.acl.OMBucketAddAclRequest;
import org.apache.hadoop.ozone.om.request.bucket.acl.OMBucketRemoveAclRequest;
import org.apache.hadoop.ozone.om.request.bucket.acl.OMBucketSetAclRequest;
import org.apache.hadoop.ozone.om.request.file.OMDirectoryCreateRequest;
import org.apache.hadoop.ozone.om.request.file.OMDirectoryCreateRequestWithFSO;
import org.apache.hadoop.ozone.om.request.file.OMFileCreateRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileCreateRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.OMAllocateBlockRequest;
import org.apache.hadoop.ozone.om.request.key.OMAllocateBlockRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.OMKeyCommitRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyCommitRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.OMKeyCreateRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyCreateRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.OMKeyDeleteRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyDeleteRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.OMKeyPurgeRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRenameRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRenameRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.OMKeysDeleteRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeysRenameRequest;
import org.apache.hadoop.ozone.om.request.key.OMPathsPurgeRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.OMTrashRecoverRequest;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeyAddAclRequest;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeyAddAclRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeyRemoveAclRequest;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeyRemoveAclRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeySetAclRequest;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeySetAclRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.acl.prefix.OMPrefixAddAclRequest;
import org.apache.hadoop.ozone.om.request.key.acl.prefix.OMPrefixRemoveAclRequest;
import org.apache.hadoop.ozone.om.request.key.acl.prefix.OMPrefixSetAclRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3InitiateMultipartUploadRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3InitiateMultipartUploadRequestWithFSO;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadAbortRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadAbortRequestWithFSO;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadCommitPartRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadCommitPartRequestWithFSO;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadCompleteRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadCompleteRequestWithFSO;
import org.apache.hadoop.ozone.om.request.s3.security.S3GetSecretRequest;
import org.apache.hadoop.ozone.om.request.s3.security.S3RevokeSecretRequest;
import org.apache.hadoop.ozone.om.request.security.OMCancelDelegationTokenRequest;
import org.apache.hadoop.ozone.om.request.security.OMGetDelegationTokenRequest;
import org.apache.hadoop.ozone.om.request.security.OMRenewDelegationTokenRequest;
import org.apache.hadoop.ozone.om.request.upgrade.OMCancelPrepareRequest;
import org.apache.hadoop.ozone.om.request.upgrade.OMFinalizeUpgradeRequest;
import org.apache.hadoop.ozone.om.request.upgrade.OMPrepareRequest;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeCreateRequest;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeDeleteRequest;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeSetOwnerRequest;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeSetQuotaRequest;
import org.apache.hadoop.ozone.om.request.volume.acl.OMVolumeAddAclRequest;
import org.apache.hadoop.ozone.om.request.volume.acl.OMVolumeRemoveAclRequest;
import org.apache.hadoop.ozone.om.request.volume.acl.OMVolumeSetAclRequest;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneManagerRatisUtils {
    private static boolean isBucketFSOptimized = false;
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerRatisUtils.class);

    private OzoneManagerRatisUtils() {
    }

    public static void setBucketFSOptimized(boolean enabledFSO) {
        isBucketFSOptimized = enabledFSO;
    }

    public static OMClientRequest createClientRequest(OzoneManagerProtocolProtos.OMRequest omRequest, OzoneManager ozoneManager) {
        OzoneManagerProtocolProtos.Type cmdType = omRequest.getCmdType();
        switch (cmdType) {
            case CreateVolume: {
                return new OMVolumeCreateRequest(omRequest);
            }
            case SetVolumeProperty: {
                boolean hasQuota = omRequest.getSetVolumePropertyRequest().hasQuotaInBytes();
                boolean hasOwner = omRequest.getSetVolumePropertyRequest().hasOwnerName();
                Preconditions.checkState((hasOwner || hasQuota ? 1 : 0) != 0, (Object)"Either Quota or owner should be set in the SetVolumeProperty request");
                Preconditions.checkState((!hasOwner || !hasQuota ? 1 : 0) != 0, (Object)"Either Quota or owner should be set in the SetVolumeProperty request. Should not set both");
                if (hasQuota) {
                    return new OMVolumeSetQuotaRequest(omRequest);
                }
                return new OMVolumeSetOwnerRequest(omRequest);
            }
            case DeleteVolume: {
                return new OMVolumeDeleteRequest(omRequest);
            }
            case CreateBucket: {
                return new OMBucketCreateRequest(omRequest);
            }
            case DeleteBucket: {
                return new OMBucketDeleteRequest(omRequest);
            }
            case SetBucketProperty: {
                return new OMBucketSetPropertyRequest(omRequest);
            }
            case AllocateBlock: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getAllocateBlockRequest().getKeyArgs();
                if (OzoneManagerRatisUtils.isBucketFSOptimized(keyArgs.getVolumeName(), keyArgs.getBucketName(), ozoneManager)) {
                    return new OMAllocateBlockRequestWithFSO(omRequest);
                }
                return new OMAllocateBlockRequest(omRequest);
            }
            case CreateKey: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getCreateKeyRequest().getKeyArgs();
                if (OzoneManagerRatisUtils.isBucketFSOptimized(keyArgs.getVolumeName(), keyArgs.getBucketName(), ozoneManager)) {
                    return new OMKeyCreateRequestWithFSO(omRequest);
                }
                return new OMKeyCreateRequest(omRequest);
            }
            case CommitKey: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getCommitKeyRequest().getKeyArgs();
                if (OzoneManagerRatisUtils.isBucketFSOptimized(keyArgs.getVolumeName(), keyArgs.getBucketName(), ozoneManager)) {
                    return new OMKeyCommitRequestWithFSO(omRequest);
                }
                return new OMKeyCommitRequest(omRequest);
            }
            case DeleteKey: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getDeleteKeyRequest().getKeyArgs();
                if (OzoneManagerRatisUtils.isBucketFSOptimized(keyArgs.getVolumeName(), keyArgs.getBucketName(), ozoneManager)) {
                    return new OMKeyDeleteRequestWithFSO(omRequest);
                }
                return new OMKeyDeleteRequest(omRequest);
            }
            case DeleteKeys: {
                return new OMKeysDeleteRequest(omRequest);
            }
            case RenameKey: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getRenameKeyRequest().getKeyArgs();
                if (OzoneManagerRatisUtils.isBucketFSOptimized(keyArgs.getVolumeName(), keyArgs.getBucketName(), ozoneManager)) {
                    return new OMKeyRenameRequestWithFSO(omRequest);
                }
                return new OMKeyRenameRequest(omRequest);
            }
            case RenameKeys: {
                return new OMKeysRenameRequest(omRequest);
            }
            case CreateDirectory: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getCreateDirectoryRequest().getKeyArgs();
                if (OzoneManagerRatisUtils.isBucketFSOptimized(keyArgs.getVolumeName(), keyArgs.getBucketName(), ozoneManager)) {
                    return new OMDirectoryCreateRequestWithFSO(omRequest);
                }
                return new OMDirectoryCreateRequest(omRequest);
            }
            case CreateFile: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getCreateFileRequest().getKeyArgs();
                if (OzoneManagerRatisUtils.isBucketFSOptimized(keyArgs.getVolumeName(), keyArgs.getBucketName(), ozoneManager)) {
                    return new OMFileCreateRequestWithFSO(omRequest);
                }
                return new OMFileCreateRequest(omRequest);
            }
            case PurgeKeys: {
                return new OMKeyPurgeRequest(omRequest);
            }
            case PurgePaths: {
                return new OMPathsPurgeRequestWithFSO(omRequest);
            }
            case InitiateMultiPartUpload: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getInitiateMultiPartUploadRequest().getKeyArgs();
                if (OzoneManagerRatisUtils.isBucketFSOptimized(keyArgs.getVolumeName(), keyArgs.getBucketName(), ozoneManager)) {
                    return new S3InitiateMultipartUploadRequestWithFSO(omRequest);
                }
                return new S3InitiateMultipartUploadRequest(omRequest);
            }
            case CommitMultiPartUpload: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getCommitMultiPartUploadRequest().getKeyArgs();
                if (OzoneManagerRatisUtils.isBucketFSOptimized(keyArgs.getVolumeName(), keyArgs.getBucketName(), ozoneManager)) {
                    return new S3MultipartUploadCommitPartRequestWithFSO(omRequest);
                }
                return new S3MultipartUploadCommitPartRequest(omRequest);
            }
            case AbortMultiPartUpload: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getAbortMultiPartUploadRequest().getKeyArgs();
                if (OzoneManagerRatisUtils.isBucketFSOptimized(keyArgs.getVolumeName(), keyArgs.getBucketName(), ozoneManager)) {
                    return new S3MultipartUploadAbortRequestWithFSO(omRequest);
                }
                return new S3MultipartUploadAbortRequest(omRequest);
            }
            case CompleteMultiPartUpload: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getCompleteMultiPartUploadRequest().getKeyArgs();
                if (OzoneManagerRatisUtils.isBucketFSOptimized(keyArgs.getVolumeName(), keyArgs.getBucketName(), ozoneManager)) {
                    return new S3MultipartUploadCompleteRequestWithFSO(omRequest);
                }
                return new S3MultipartUploadCompleteRequest(omRequest);
            }
            case AddAcl: 
            case RemoveAcl: 
            case SetAcl: {
                return OzoneManagerRatisUtils.getOMAclRequest(omRequest, ozoneManager);
            }
            case GetDelegationToken: {
                return new OMGetDelegationTokenRequest(omRequest);
            }
            case CancelDelegationToken: {
                return new OMCancelDelegationTokenRequest(omRequest);
            }
            case RenewDelegationToken: {
                return new OMRenewDelegationTokenRequest(omRequest);
            }
            case GetS3Secret: {
                return new S3GetSecretRequest(omRequest);
            }
            case RecoverTrash: {
                return new OMTrashRecoverRequest(omRequest);
            }
            case FinalizeUpgrade: {
                return new OMFinalizeUpgradeRequest(omRequest);
            }
            case Prepare: {
                return new OMPrepareRequest(omRequest);
            }
            case CancelPrepare: {
                return new OMCancelPrepareRequest(omRequest);
            }
            case RevokeS3Secret: {
                return new S3RevokeSecretRequest(omRequest);
            }
        }
        throw new IllegalStateException("Unrecognized write command type request" + cmdType);
    }

    private static OMClientRequest getOMAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest, OzoneManager ozoneManager) {
        OzoneManagerProtocolProtos.Type cmdType = omRequest.getCmdType();
        if (OzoneManagerProtocolProtos.Type.AddAcl == cmdType) {
            OzoneManagerProtocolProtos.OzoneObj.ObjectType type = omRequest.getAddAclRequest().getObj().getResType();
            if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.VOLUME == type) {
                return new OMVolumeAddAclRequest(omRequest);
            }
            if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.BUCKET == type) {
                return new OMBucketAddAclRequest(omRequest);
            }
            if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.KEY == type) {
                OMKeyAddAclRequest aclReq = new OMKeyAddAclRequest(omRequest);
                BucketLayout bucketLayout = aclReq.getBucketLayout(ozoneManager);
                if (BucketLayout.FILE_SYSTEM_OPTIMIZED.equals((Object)bucketLayout)) {
                    return new OMKeyAddAclRequestWithFSO(omRequest);
                }
                return aclReq;
            }
            return new OMPrefixAddAclRequest(omRequest);
        }
        if (OzoneManagerProtocolProtos.Type.RemoveAcl == cmdType) {
            OzoneManagerProtocolProtos.OzoneObj.ObjectType type = omRequest.getRemoveAclRequest().getObj().getResType();
            if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.VOLUME == type) {
                return new OMVolumeRemoveAclRequest(omRequest);
            }
            if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.BUCKET == type) {
                return new OMBucketRemoveAclRequest(omRequest);
            }
            if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.KEY == type) {
                OMKeyRemoveAclRequest aclReq = new OMKeyRemoveAclRequest(omRequest);
                BucketLayout bucketLayout = aclReq.getBucketLayout(ozoneManager);
                if (BucketLayout.FILE_SYSTEM_OPTIMIZED.equals((Object)bucketLayout)) {
                    return new OMKeyRemoveAclRequestWithFSO(omRequest);
                }
                return aclReq;
            }
            return new OMPrefixRemoveAclRequest(omRequest);
        }
        OzoneManagerProtocolProtos.OzoneObj.ObjectType type = omRequest.getSetAclRequest().getObj().getResType();
        if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.VOLUME == type) {
            return new OMVolumeSetAclRequest(omRequest);
        }
        if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.BUCKET == type) {
            return new OMBucketSetAclRequest(omRequest);
        }
        if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.KEY == type) {
            OMKeySetAclRequest aclReq = new OMKeySetAclRequest(omRequest);
            BucketLayout bucketLayout = aclReq.getBucketLayout(ozoneManager);
            if (BucketLayout.FILE_SYSTEM_OPTIMIZED.equals((Object)bucketLayout)) {
                return new OMKeySetAclRequestWithFSO(omRequest);
            }
            return aclReq;
        }
        return new OMPrefixSetAclRequest(omRequest);
    }

    public static OzoneManagerProtocolProtos.Status exceptionToResponseStatus(IOException exception) {
        if (exception instanceof OMException) {
            return OzoneManagerProtocolProtos.Status.values()[((OMException)((Object)exception)).getResult().ordinal()];
        }
        if (exception.getCause() != null && exception.getCause() instanceof RocksDBException) {
            return OzoneManagerProtocolProtos.Status.METADATA_ERROR;
        }
        return OzoneManagerProtocolProtos.Status.INTERNAL_ERROR;
    }

    public static TransactionInfo getTrxnInfoFromCheckpoint(OzoneConfiguration conf, Path dbPath) throws Exception {
        return HAUtils.getTrxnInfoFromCheckpoint((OzoneConfiguration)conf, (Path)dbPath, (DBDefinition)new OMDBDefinition());
    }

    public static boolean verifyTransactionInfo(TransactionInfo transactionInfo, long lastAppliedIndex, String leaderId, Path newDBlocation) {
        return HAUtils.verifyTransactionInfo((TransactionInfo)transactionInfo, (long)lastAppliedIndex, (String)leaderId, (Path)newDBlocation, (Logger)OzoneManager.LOG);
    }

    public static boolean isBucketFSOptimized() {
        return isBucketFSOptimized;
    }

    public static String getOMRatisDirectory(ConfigurationSource conf) {
        String storageDir = conf.get("ozone.om.ratis.storage.dir");
        if (Strings.isNullOrEmpty((String)storageDir)) {
            storageDir = ServerUtils.getDefaultRatisDirectory((ConfigurationSource)conf);
        }
        return storageDir;
    }

    public static String getOMRatisSnapshotDirectory(ConfigurationSource conf) {
        String snapshotDir = conf.get("ozone.om.ratis.snapshot.dir");
        if (Strings.isNullOrEmpty((String)snapshotDir)) {
            LOG.warn("{} is not configured. Falling back to {} config", (Object)"ozone.om.ratis.snapshot.dir", (Object)"ozone.metadata.dirs");
            File metaDirPath = ServerUtils.getOzoneMetaDirPath((ConfigurationSource)conf);
            snapshotDir = Paths.get(metaDirPath.getPath(), "snapshot").toString();
        }
        return snapshotDir;
    }

    public static void checkLeaderStatus(OzoneManagerRatisServer.RaftServerStatus raftServerStatus, RaftPeerId raftPeerId) throws ServiceException {
        switch (raftServerStatus) {
            case LEADER_AND_READY: {
                return;
            }
            case LEADER_AND_NOT_READY: {
                throw OzoneManagerRatisUtils.createLeaderNotReadyException(raftPeerId);
            }
            case NOT_LEADER: {
                throw OzoneManagerRatisUtils.createNotLeaderException(raftPeerId);
            }
        }
        throw new IllegalStateException("Unknown Ratis Server state: " + (Object)((Object)raftServerStatus));
    }

    private static ServiceException createNotLeaderException(RaftPeerId raftPeerId) {
        OMNotLeaderException notLeaderException = new OMNotLeaderException(raftPeerId);
        LOG.debug(notLeaderException.getMessage());
        return new ServiceException((Throwable)notLeaderException);
    }

    private static ServiceException createLeaderNotReadyException(RaftPeerId raftPeerId) {
        OMLeaderNotReadyException leaderNotReadyException = new OMLeaderNotReadyException(String.valueOf(raftPeerId.toString()) + " is Leader " + "but not ready to process request yet.");
        LOG.debug(leaderNotReadyException.getMessage());
        return new ServiceException((Throwable)leaderNotReadyException);
    }

    private static OmBucketInfo getOmBucketInfo(OzoneManager ozoneManager, OmBucketInfo buckInfo, String volName, String buckName) {
        String buckKey = ozoneManager.getMetadataManager().getBucketKey(volName, buckName);
        try {
            buckInfo = (OmBucketInfo)ozoneManager.getMetadataManager().getBucketTable().get((Object)buckKey);
        }
        catch (IOException iOException) {
            LOG.debug("Failed to get the value for the key: " + buckKey);
        }
        return buckInfo;
    }

    private static BucketLayout getBucketLayout(OmBucketInfo buckInfo, String volName, String buckName) {
        if (buckInfo != null) {
            return buckInfo.getBucketLayout();
        }
        LOG.error("Bucket not found: {}/{} ", (Object)volName, (Object)buckName);
        return BucketLayout.LEGACY;
    }

    private static boolean isBucketFSOptimized(String volName, String buckName, OzoneManager ozoneManager) {
        BucketLayout bucketLayout = null;
        OmBucketInfo buckInfo = null;
        buckInfo = OzoneManagerRatisUtils.getOmBucketInfo(ozoneManager, buckInfo, volName, buckName);
        bucketLayout = OzoneManagerRatisUtils.getBucketLayout(buckInfo, volName, buckName);
        return BucketLayout.FILE_SYSTEM_OPTIMIZED.equals((Object)bucketLayout);
    }
}

