/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ratis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.function.SupplierWithIOException;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.DBColumnFamilyDefinition;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.codec.OMDBDefinition;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisSnapshot;
import org.apache.hadoop.ozone.om.ratis.helpers.DoubleBufferEntry;
import org.apache.hadoop.ozone.om.ratis.metrics.OzoneManagerDoubleBufferMetrics;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.Time;
import org.apache.ratis.util.ExitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneManagerDoubleBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerDoubleBuffer.class);
    private Queue<DoubleBufferEntry<OMClientResponse>> currentBuffer;
    private Queue<DoubleBufferEntry<OMClientResponse>> readyBuffer;
    private volatile Queue<CompletableFuture<Void>> currentFutureQueue;
    private volatile Queue<CompletableFuture<Void>> readyFutureQueue;
    private Daemon daemon;
    private final OMMetadataManager omMetadataManager;
    private final AtomicLong flushedTransactionCount = new AtomicLong(0L);
    private final AtomicLong flushIterations = new AtomicLong(0L);
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private OzoneManagerDoubleBufferMetrics ozoneManagerDoubleBufferMetrics;
    private long maxFlushedTransactionsInOneIteration;
    private final OzoneManagerRatisSnapshot ozoneManagerRatisSnapShot;
    private final boolean isRatisEnabled;
    private final boolean isTracingEnabled;
    private Function<Long, Long> indexToTerm;

    private OzoneManagerDoubleBuffer(OMMetadataManager omMetadataManager, OzoneManagerRatisSnapshot ozoneManagerRatisSnapShot, boolean isRatisEnabled, boolean isTracingEnabled, Function<Long, Long> indexToTerm) {
        this.currentBuffer = new ConcurrentLinkedQueue<DoubleBufferEntry<OMClientResponse>>();
        this.readyBuffer = new ConcurrentLinkedQueue<DoubleBufferEntry<OMClientResponse>>();
        this.isRatisEnabled = isRatisEnabled;
        this.isTracingEnabled = isTracingEnabled;
        if (!isRatisEnabled) {
            this.currentFutureQueue = new ConcurrentLinkedQueue<CompletableFuture<Void>>();
            this.readyFutureQueue = new ConcurrentLinkedQueue<CompletableFuture<Void>>();
        } else {
            this.currentFutureQueue = null;
            this.readyFutureQueue = null;
        }
        this.omMetadataManager = omMetadataManager;
        this.ozoneManagerRatisSnapShot = ozoneManagerRatisSnapShot;
        this.ozoneManagerDoubleBufferMetrics = OzoneManagerDoubleBufferMetrics.create();
        this.indexToTerm = indexToTerm;
        this.isRunning.set(true);
        this.daemon = new Daemon(this::flushTransactions);
        this.daemon.setName("OMDoubleBufferFlushThread");
        this.daemon.start();
    }

    private Void addToBatchWithTrace(OzoneManagerProtocolProtos.OMResponse omResponse, SupplierWithIOException<Void> supplier) throws IOException {
        if (!this.isTracingEnabled) {
            return (Void)supplier.get();
        }
        String spanName = "DB-addToWriteBatch-" + omResponse.getCmdType().toString();
        return (Void)TracingUtil.executeAsChildSpan((String)spanName, (String)omResponse.getTraceID(), supplier);
    }

    private Void flushBatchWithTrace(String parentName, int batchSize, SupplierWithIOException<Void> supplier) throws IOException {
        if (!this.isTracingEnabled) {
            return (Void)supplier.get();
        }
        String spanName = "DB-commitWriteBatch-Size-" + batchSize;
        return (Void)TracingUtil.executeAsChildSpan((String)spanName, (String)parentName, supplier);
    }

    private Void addToBatchTransactionInfoWithTrace(String parentName, long transactionIndex, SupplierWithIOException<Void> supplier) throws IOException {
        if (!this.isTracingEnabled) {
            return (Void)supplier.get();
        }
        String spanName = "DB-addWriteBatch-transactioninfo-" + transactionIndex;
        return (Void)TracingUtil.executeAsChildSpan((String)spanName, (String)parentName, supplier);
    }

    private void flushTransactions() {
        while (this.isRunning.get()) {
            try {
                if (!this.canFlush()) continue;
                HashMap<String, List<Long>> cleanupEpochs = new HashMap<String, List<Long>>();
                this.setReadyBuffer();
                List<Long> flushedEpochs = null;
                Throwable throwable = null;
                Object var4_9 = null;
                try (BatchOperation batchOperation = this.omMetadataManager.getStore().initBatchOperation();){
                    AtomicReference lastTraceId = new AtomicReference();
                    this.readyBuffer.iterator().forEachRemaining(entry -> {
                        try {
                            OzoneManagerProtocolProtos.OMResponse omResponse = ((OMClientResponse)entry.getResponse()).getOMResponse();
                            lastTraceId.set(omResponse.getTraceID());
                            this.addToBatchWithTrace(omResponse, (SupplierWithIOException<Void>)((SupplierWithIOException)() -> {
                                ((OMClientResponse)entry.getResponse()).checkAndUpdateDB(this.omMetadataManager, batchOperation);
                                return null;
                            }));
                            this.addCleanupEntry((DoubleBufferEntry)entry, (Map<String, List<Long>>)cleanupEpochs);
                        }
                        catch (IOException ex) {
                            this.terminate(ex);
                        }
                    });
                    flushedEpochs = this.readyBuffer.stream().map(DoubleBufferEntry::getTrxLogIndex).sorted().collect(Collectors.toList());
                    long lastRatisTransactionIndex = (Long)flushedEpochs.get(flushedEpochs.size() - 1);
                    long term = this.isRatisEnabled ? this.indexToTerm.apply(lastRatisTransactionIndex) : -1L;
                    this.addToBatchTransactionInfoWithTrace((String)lastTraceId.get(), lastRatisTransactionIndex, (SupplierWithIOException<Void>)((SupplierWithIOException)() -> {
                        this.omMetadataManager.getTransactionInfoTable().putWithBatch(batchOperation, (Object)"#TRANSACTIONINFO", (Object)new TransactionInfo.Builder().setTransactionIndex(lastRatisTransactionIndex).setCurrentTerm(term).build());
                        return null;
                    }));
                    long startTime = Time.monotonicNow();
                    this.flushBatchWithTrace((String)lastTraceId.get(), this.readyBuffer.size(), (SupplierWithIOException<Void>)((SupplierWithIOException)() -> {
                        this.omMetadataManager.getStore().commitBatchOperation(batchOperation);
                        return null;
                    }));
                    this.ozoneManagerDoubleBufferMetrics.updateFlushTime(Time.monotonicNow() - startTime);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                if (!this.isRatisEnabled) {
                    this.readyFutureQueue.iterator().forEachRemaining(entry -> entry.complete(null));
                    this.readyFutureQueue.clear();
                }
                int flushedTransactionsSize = this.readyBuffer.size();
                this.flushedTransactionCount.addAndGet(flushedTransactionsSize);
                this.flushIterations.incrementAndGet();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sync Iteration {} flushed transactions in this iteration {}", (Object)this.flushIterations.get(), (Object)flushedTransactionsSize);
                }
                if (!this.isRatisEnabled) {
                    flushedEpochs = this.readyBuffer.stream().map(DoubleBufferEntry::getTrxLogIndex).sorted().collect(Collectors.toList());
                }
                this.cleanupCache(cleanupEpochs);
                this.readyBuffer.clear();
                this.ozoneManagerRatisSnapShot.updateLastAppliedIndex(flushedEpochs);
                this.updateMetrics(flushedTransactionsSize);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                if (this.isRunning.get()) {
                    String message = "OMDoubleBuffer flush thread " + Thread.currentThread().getName() + " encountered Interrupted " + "exception while running";
                    ExitUtils.terminate((int)1, (String)message, (Throwable)ex, (Logger)LOG);
                    continue;
                }
                LOG.info("OMDoubleBuffer flush thread {} is interrupted and will exit. {}", (Object)Thread.currentThread().getName(), (Object)Thread.currentThread().getName());
            }
            catch (IOException ex) {
                this.terminate(ex);
            }
            catch (Throwable t) {
                String s = "OMDoubleBuffer flush thread" + Thread.currentThread().getName() + "encountered Throwable error";
                ExitUtils.terminate((int)2, (String)s, (Throwable)t, (Logger)LOG);
            }
        }
    }

    private void addCleanupEntry(DoubleBufferEntry entry, Map<String, List<Long>> cleanupEpochs) {
        Class<?> responseClass = entry.getResponse().getClass();
        CleanupTableInfo cleanupTableInfo = responseClass.getAnnotation(CleanupTableInfo.class);
        if (cleanupTableInfo != null) {
            String[] cleanupTables = cleanupTableInfo.cleanupAll() ? (String[])Arrays.stream(new OMDBDefinition().getColumnFamilies()).map(DBColumnFamilyDefinition::getTableName).toArray(String[]::new) : cleanupTableInfo.cleanupTables();
            String[] stringArray = cleanupTables;
            int n = cleanupTables.length;
            int n2 = 0;
            while (n2 < n) {
                String table = stringArray[n2];
                cleanupEpochs.computeIfAbsent(table, list -> new ArrayList()).add(entry.getTrxLogIndex());
                ++n2;
            }
        } else {
            throw new RuntimeException("CleanupTableInfo Annotation is missing for" + responseClass);
        }
    }

    private void cleanupCache(Map<String, List<Long>> cleanupEpochs) {
        cleanupEpochs.forEach((tableName, epochs) -> {
            Collections.sort(epochs);
            this.omMetadataManager.getTable(tableName).cleanupCache(epochs);
        });
    }

    private void updateMetrics(long flushedTransactionsSize) {
        this.ozoneManagerDoubleBufferMetrics.incrTotalNumOfFlushOperations();
        this.ozoneManagerDoubleBufferMetrics.incrTotalSizeOfFlushedTransactions(flushedTransactionsSize);
        this.ozoneManagerDoubleBufferMetrics.setAvgFlushTransactionsInOneIteration((float)this.ozoneManagerDoubleBufferMetrics.getTotalNumOfFlushedTransactions() / (float)this.ozoneManagerDoubleBufferMetrics.getTotalNumOfFlushOperations());
        if (this.maxFlushedTransactionsInOneIteration < flushedTransactionsSize) {
            this.maxFlushedTransactionsInOneIteration = flushedTransactionsSize;
            this.ozoneManagerDoubleBufferMetrics.setMaxNumberOfTransactionsFlushedInOneIteration(flushedTransactionsSize);
        }
    }

    public void stop() {
        if (this.isRunning.compareAndSet(true, false)) {
            LOG.info("Stopping OMDoubleBuffer flush thread");
            this.daemon.interrupt();
            try {
                this.daemon.join();
            }
            catch (InterruptedException e) {
                LOG.debug("Interrupted while waiting for daemon to exit.", (Throwable)e);
            }
            this.ozoneManagerDoubleBufferMetrics.unRegister();
        } else {
            LOG.info("OMDoubleBuffer flush thread is not running.");
        }
    }

    private void terminate(IOException ex) {
        String message = "During flush to DB encountered error in OMDoubleBuffer flush thread " + Thread.currentThread().getName();
        ExitUtils.terminate((int)1, (String)message, (Throwable)ex, (Logger)LOG);
    }

    public long getFlushedTransactionCount() {
        return this.flushedTransactionCount.get();
    }

    public long getFlushIterations() {
        return this.flushIterations.get();
    }

    public synchronized CompletableFuture<Void> add(OMClientResponse response, long transactionIndex) {
        this.currentBuffer.add(new DoubleBufferEntry<OMClientResponse>(transactionIndex, response));
        this.notify();
        if (!this.isRatisEnabled) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            this.currentFutureQueue.add(future);
            return future;
        }
        return null;
    }

    private synchronized boolean canFlush() throws InterruptedException {
        while (this.currentBuffer.size() == 0) {
            this.wait(Long.MAX_VALUE);
        }
        return true;
    }

    private synchronized void setReadyBuffer() {
        Queue<DoubleBufferEntry<OMClientResponse>> temp = this.currentBuffer;
        this.currentBuffer = this.readyBuffer;
        this.readyBuffer = temp;
        if (!this.isRatisEnabled) {
            Queue<CompletableFuture<Void>> tempFuture = this.currentFutureQueue;
            this.currentFutureQueue = this.readyFutureQueue;
            this.readyFutureQueue = tempFuture;
        }
    }

    @VisibleForTesting
    public OzoneManagerDoubleBufferMetrics getOzoneManagerDoubleBufferMetrics() {
        return this.ozoneManagerDoubleBufferMetrics;
    }

    /* synthetic */ OzoneManagerDoubleBuffer(OMMetadataManager oMMetadataManager, OzoneManagerRatisSnapshot ozoneManagerRatisSnapshot, boolean bl, boolean bl2, Function function, OzoneManagerDoubleBuffer ozoneManagerDoubleBuffer) {
        this(oMMetadataManager, ozoneManagerRatisSnapshot, bl, bl2, function);
    }

    public static class Builder {
        private OMMetadataManager mm;
        private OzoneManagerRatisSnapshot rs;
        private boolean isRatisEnabled = false;
        private boolean isTracingEnabled = false;
        private Function<Long, Long> indexToTerm = null;

        public Builder setOmMetadataManager(OMMetadataManager omm) {
            this.mm = omm;
            return this;
        }

        public Builder setOzoneManagerRatisSnapShot(OzoneManagerRatisSnapshot omrs) {
            this.rs = omrs;
            return this;
        }

        public Builder enableRatis(boolean enableRatis) {
            this.isRatisEnabled = enableRatis;
            return this;
        }

        public Builder enableTracing(boolean enableTracing) {
            this.isTracingEnabled = enableTracing;
            return this;
        }

        public Builder setIndexToTerm(Function<Long, Long> termGet) {
            this.indexToTerm = termGet;
            return this;
        }

        public OzoneManagerDoubleBuffer build() {
            if (this.isRatisEnabled) {
                Preconditions.checkNotNull((Object)this.rs, (Object)"When ratis is enabled, OzoneManagerRatisSnapshot should not be null");
                Preconditions.checkNotNull(this.indexToTerm, (Object)"When ratis is enabled indexToTerm should not be null");
            }
            return new OzoneManagerDoubleBuffer(this.mm, this.rs, this.isRatisEnabled, this.isTracingEnabled, this.indexToTerm, null);
        }
    }
}

