/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.VolumeManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.apache.hadoop.ozone.storage.proto.OzoneManagerStorageProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeManagerImpl
implements VolumeManager {
    private static final Logger LOG = LoggerFactory.getLogger(VolumeManagerImpl.class);
    private final OMMetadataManager metadataManager;
    private final int maxUserVolumeCount;
    private final boolean aclEnabled;

    public VolumeManagerImpl(OMMetadataManager metadataManager, OzoneConfiguration conf) {
        this.metadataManager = metadataManager;
        this.maxUserVolumeCount = conf.getInt("ozone.om.user.max.volume", 1024);
        this.aclEnabled = conf.getBoolean("ozone.acl.enabled", false);
    }

    private OzoneManagerStorageProtos.PersistedUserVolumeInfo addVolumeToOwnerList(String volume, String owner) throws IOException {
        String dbUserKey = this.metadataManager.getUserKey(owner);
        OzoneManagerStorageProtos.PersistedUserVolumeInfo volumeList = (OzoneManagerStorageProtos.PersistedUserVolumeInfo)this.metadataManager.getUserTable().get((Object)dbUserKey);
        ArrayList<String> prevVolList = new ArrayList<String>();
        if (volumeList != null) {
            prevVolList.addAll(volumeList.getVolumeNamesList());
        }
        if (prevVolList.size() >= this.maxUserVolumeCount) {
            LOG.debug("Too many volumes for user:{}", (Object)owner);
            throw new OMException("Too many volumes for user:" + owner, OMException.ResultCodes.USER_TOO_MANY_VOLUMES);
        }
        prevVolList.add(volume);
        OzoneManagerStorageProtos.PersistedUserVolumeInfo newVolList = OzoneManagerStorageProtos.PersistedUserVolumeInfo.newBuilder().addAllVolumeNames(prevVolList).build();
        return newVolList;
    }

    private OzoneManagerStorageProtos.PersistedUserVolumeInfo delVolumeFromOwnerList(String volume, String owner) throws IOException {
        OzoneManagerStorageProtos.PersistedUserVolumeInfo volumeList = (OzoneManagerStorageProtos.PersistedUserVolumeInfo)this.metadataManager.getUserTable().get((Object)owner);
        ArrayList prevVolList = new ArrayList();
        if (volumeList == null) {
            LOG.debug("volume:{} not found for user:{}", (Object)volume, (Object)owner);
            throw new OMException(OMException.ResultCodes.USER_NOT_FOUND);
        }
        prevVolList.addAll(volumeList.getVolumeNamesList());
        prevVolList.remove(volume);
        OzoneManagerStorageProtos.PersistedUserVolumeInfo newVolList = OzoneManagerStorageProtos.PersistedUserVolumeInfo.newBuilder().addAllVolumeNames(prevVolList).build();
        return newVolList;
    }

    @Override
    public void createVolume(OmVolumeArgs omVolumeArgs) throws IOException {
        Preconditions.checkNotNull((Object)omVolumeArgs);
        boolean acquiredUserLock = false;
        this.metadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{omVolumeArgs.getVolume()});
        try {
            try {
                acquiredUserLock = this.metadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{omVolumeArgs.getOwnerName()});
                String dbVolumeKey = this.metadataManager.getVolumeKey(omVolumeArgs.getVolume());
                String dbUserKey = this.metadataManager.getUserKey(omVolumeArgs.getOwnerName());
                OmVolumeArgs volumeInfo = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
                if (volumeInfo != null) {
                    LOG.debug("volume:{} already exists", (Object)omVolumeArgs.getVolume());
                    throw new OMException(OMException.ResultCodes.VOLUME_ALREADY_EXISTS);
                }
                OzoneManagerStorageProtos.PersistedUserVolumeInfo volumeList = this.addVolumeToOwnerList(omVolumeArgs.getVolume(), omVolumeArgs.getOwnerName());
                omVolumeArgs.setCreationTime(System.currentTimeMillis());
                this.createVolumeCommitToDB(omVolumeArgs, volumeList, dbVolumeKey, dbUserKey);
                LOG.debug("created volume:{} user:{}", (Object)omVolumeArgs.getVolume(), (Object)omVolumeArgs.getOwnerName());
            }
            catch (IOException ex) {
                if (!(ex instanceof OMException)) {
                    LOG.error("Volume creation failed for user:{} volume:{}", new Object[]{omVolumeArgs.getOwnerName(), omVolumeArgs.getVolume(), ex});
                }
                throw ex;
            }
        }
        catch (Throwable throwable) {
            if (acquiredUserLock) {
                this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{omVolumeArgs.getOwnerName()});
            }
            this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{omVolumeArgs.getVolume()});
            throw throwable;
        }
        if (acquiredUserLock) {
            this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{omVolumeArgs.getOwnerName()});
        }
        this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{omVolumeArgs.getVolume()});
    }

    private void createVolumeCommitToDB(OmVolumeArgs omVolumeArgs, OzoneManagerStorageProtos.PersistedUserVolumeInfo volumeList, String dbVolumeKey, String dbUserKey) throws IOException {
        Throwable throwable = null;
        Object var6_8 = null;
        try (BatchOperation batch = this.metadataManager.getStore().initBatchOperation();){
            this.metadataManager.getVolumeTable().putWithBatch(batch, (Object)dbVolumeKey, (Object)omVolumeArgs);
            this.metadataManager.getUserTable().putWithBatch(batch, (Object)dbUserKey, (Object)volumeList);
            this.metadataManager.getStore().commitBatchOperation(batch);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void setOwner(String volume, String owner) throws IOException {
        Preconditions.checkNotNull((Object)volume);
        Preconditions.checkNotNull((Object)owner);
        boolean acquiredUsersLock = false;
        String actualOwner = null;
        this.metadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        try {
            try {
                String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
                OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
                if (volumeArgs == null) {
                    LOG.debug("Changing volume ownership failed for user:{} volume:{}", (Object)owner, (Object)volume);
                    throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
                }
                Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
                actualOwner = volumeArgs.getOwnerName();
                String originalOwner = this.metadataManager.getUserKey(actualOwner);
                acquiredUsersLock = this.metadataManager.getLock().acquireMultiUserLock(owner, originalOwner);
                OzoneManagerStorageProtos.PersistedUserVolumeInfo oldOwnerVolumeList = this.delVolumeFromOwnerList(volume, originalOwner);
                String newOwner = this.metadataManager.getUserKey(owner);
                OzoneManagerStorageProtos.PersistedUserVolumeInfo newOwnerVolumeList = this.addVolumeToOwnerList(volume, newOwner);
                volumeArgs.setOwnerName(owner);
                this.setOwnerCommitToDB(oldOwnerVolumeList, newOwnerVolumeList, volumeArgs, owner);
            }
            catch (IOException ex) {
                if (!(ex instanceof OMException)) {
                    LOG.error("Changing volume ownership failed for user:{} volume:{}", new Object[]{owner, volume, ex});
                }
                throw ex;
            }
        }
        catch (Throwable throwable) {
            if (acquiredUsersLock) {
                this.metadataManager.getLock().releaseMultiUserLock(owner, actualOwner);
            }
            this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            throw throwable;
        }
        if (acquiredUsersLock) {
            this.metadataManager.getLock().releaseMultiUserLock(owner, actualOwner);
        }
        this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
    }

    private void setOwnerCommitToDB(OzoneManagerStorageProtos.PersistedUserVolumeInfo oldOwnerVolumeList, OzoneManagerStorageProtos.PersistedUserVolumeInfo newOwnerVolumeList, OmVolumeArgs newOwnerVolumeArgs, String oldOwner) throws IOException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (BatchOperation batch = this.metadataManager.getStore().initBatchOperation();){
            if (oldOwnerVolumeList.getVolumeNamesList().size() == 0) {
                this.metadataManager.getUserTable().deleteWithBatch(batch, (Object)oldOwner);
            } else {
                this.metadataManager.getUserTable().putWithBatch(batch, (Object)oldOwner, (Object)oldOwnerVolumeList);
            }
            this.metadataManager.getUserTable().putWithBatch(batch, (Object)newOwnerVolumeArgs.getOwnerName(), (Object)newOwnerVolumeList);
            String dbVolumeKey = this.metadataManager.getVolumeKey(newOwnerVolumeArgs.getVolume());
            this.metadataManager.getVolumeTable().putWithBatch(batch, (Object)dbVolumeKey, (Object)newOwnerVolumeArgs);
            this.metadataManager.getStore().commitBatchOperation(batch);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public OmVolumeArgs getVolumeInfo(String volume) throws IOException {
        OmVolumeArgs omVolumeArgs;
        Preconditions.checkNotNull((Object)volume);
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        try {
            String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
            OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (volumeArgs == null) {
                LOG.debug("volume:{} does not exist", (Object)volume);
                throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            omVolumeArgs = volumeArgs;
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.warn("Info volume failed for volume:{}", (Object)volume, (Object)ex);
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        return omVolumeArgs;
    }

    @Override
    public void deleteVolume(String volume) throws IOException {
        Preconditions.checkNotNull((Object)volume);
        String owner = null;
        boolean acquiredUserLock = false;
        this.metadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        try {
            try {
                owner = this.getVolumeInfo(volume).getOwnerName();
                acquiredUserLock = this.metadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
                String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
                OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
                if (volumeArgs == null) {
                    LOG.debug("volume:{} does not exist", (Object)volume);
                    throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
                }
                if (!this.metadataManager.isVolumeEmpty(volume)) {
                    LOG.debug("volume:{} is not empty", (Object)volume);
                    throw new OMException(OMException.ResultCodes.VOLUME_NOT_EMPTY);
                }
                Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
                OzoneManagerStorageProtos.PersistedUserVolumeInfo newVolumeList = this.delVolumeFromOwnerList(volume, volumeArgs.getOwnerName());
                this.deleteVolumeCommitToDB(newVolumeList, volume, owner);
            }
            catch (IOException ex) {
                if (!(ex instanceof OMException)) {
                    LOG.error("Delete volume failed for volume:{}", (Object)volume, (Object)ex);
                }
                throw ex;
            }
        }
        catch (Throwable throwable) {
            if (acquiredUserLock) {
                this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
            }
            this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            throw throwable;
        }
        if (acquiredUserLock) {
            this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
        }
        this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
    }

    private void deleteVolumeCommitToDB(OzoneManagerStorageProtos.PersistedUserVolumeInfo newVolumeList, String volume, String owner) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (BatchOperation batch = this.metadataManager.getStore().initBatchOperation();){
            String dbUserKey = this.metadataManager.getUserKey(owner);
            if (newVolumeList.getVolumeNamesList().size() == 0) {
                this.metadataManager.getUserTable().deleteWithBatch(batch, (Object)dbUserKey);
            } else {
                this.metadataManager.getUserTable().putWithBatch(batch, (Object)dbUserKey, (Object)newVolumeList);
            }
            this.metadataManager.getVolumeTable().deleteWithBatch(batch, (Object)this.metadataManager.getVolumeKey(volume));
            this.metadataManager.getStore().commitBatchOperation(batch);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean checkVolumeAccess(String volume, OzoneManagerProtocolProtos.OzoneAclInfo userAcl) throws IOException {
        Preconditions.checkNotNull((Object)volume);
        Preconditions.checkNotNull((Object)userAcl);
        throw new OMException(OMException.ResultCodes.NOT_SUPPORTED_OPERATION);
    }

    @Override
    public List<OmVolumeArgs> listVolumes(String userName, String prefix, String startKey, int maxKeys) throws IOException {
        List list;
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{userName});
        try {
            list = this.metadataManager.listVolumes(userName, prefix, startKey, maxKeys);
        }
        catch (Throwable throwable) {
            this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{userName});
            throw throwable;
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{userName});
        return list;
    }

    @Override
    public boolean addAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        String volume;
        block7: {
            Objects.requireNonNull(obj);
            Objects.requireNonNull(acl);
            if (!obj.getResourceType().equals((Object)OzoneObj.ResourceType.VOLUME)) {
                throw new IllegalArgumentException("Unexpected argument passed to VolumeManager. OzoneObj type:" + obj.getResourceType());
            }
            volume = obj.getVolumeName();
            this.metadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            try {
                String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
                OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
                if (volumeArgs == null) {
                    LOG.debug("volume:{} does not exist", (Object)volume);
                    throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
                }
                if (!volumeArgs.addAcl(acl)) break block7;
                this.metadataManager.getVolumeTable().put((Object)dbVolumeKey, (Object)volumeArgs);
            }
            catch (IOException ex) {
                try {
                    if (!(ex instanceof OMException)) {
                        LOG.error("Add acl operation failed for volume:{} acl:{}", new Object[]{volume, acl, ex});
                    }
                    throw ex;
                }
                catch (Throwable throwable) {
                    this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                    throw throwable;
                }
            }
            this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            return true;
        }
        this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        return false;
    }

    @Override
    public boolean removeAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        OmVolumeArgs volumeArgs;
        String volume;
        block8: {
            Objects.requireNonNull(obj);
            Objects.requireNonNull(acl);
            if (!obj.getResourceType().equals((Object)OzoneObj.ResourceType.VOLUME)) {
                throw new IllegalArgumentException("Unexpected argument passed to VolumeManager. OzoneObj type:" + obj.getResourceType());
            }
            volume = obj.getVolumeName();
            this.metadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
            volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (volumeArgs == null) {
                LOG.debug("volume:{} does not exist", (Object)volume);
                throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            if (!volumeArgs.removeAcl(acl)) break block8;
            this.metadataManager.getVolumeTable().put((Object)dbVolumeKey, (Object)volumeArgs);
            this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            return true;
        }
        try {
            try {
                Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
            }
            catch (IOException ex) {
                if (!(ex instanceof OMException)) {
                    LOG.error("Remove acl operation failed for volume:{} acl:{}", new Object[]{volume, acl, ex});
                }
                throw ex;
            }
        }
        catch (Throwable throwable) {
            this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            throw throwable;
        }
        this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        return false;
    }

    @Override
    public boolean setAcl(OzoneObj obj, List<OzoneAcl> acls) throws IOException {
        Objects.requireNonNull(obj);
        Objects.requireNonNull(acls);
        if (!obj.getResourceType().equals((Object)OzoneObj.ResourceType.VOLUME)) {
            throw new IllegalArgumentException("Unexpected argument passed to VolumeManager. OzoneObj type:" + obj.getResourceType());
        }
        String volume = obj.getVolumeName();
        this.metadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        try {
            try {
                String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
                OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
                if (volumeArgs == null) {
                    LOG.debug("volume:{} does not exist", (Object)volume);
                    throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
                }
                volumeArgs.setAcls(acls);
                this.metadataManager.getVolumeTable().put((Object)dbVolumeKey, (Object)volumeArgs);
                Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
            }
            catch (IOException ex) {
                if (!(ex instanceof OMException)) {
                    LOG.error("Set acl operation failed for volume:{} acls:{}", new Object[]{volume, acls, ex});
                }
                throw ex;
            }
        }
        catch (Throwable throwable) {
            this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            throw throwable;
        }
        this.metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        return true;
    }

    @Override
    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        List list;
        Objects.requireNonNull(obj);
        if (!obj.getResourceType().equals((Object)OzoneObj.ResourceType.VOLUME)) {
            throw new IllegalArgumentException("Unexpected argument passed to VolumeManager. OzoneObj type:" + obj.getResourceType());
        }
        String volume = obj.getVolumeName();
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        try {
            String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
            OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (volumeArgs == null) {
                LOG.debug("volume:{} does not exist", (Object)volume);
                throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
            list = volumeArgs.getAcls();
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Get acl operation failed for volume:{}", (Object)volume, (Object)ex);
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        return list;
    }

    @Override
    public boolean checkAccess(OzoneObj ozObject, RequestContext context) throws OMException {
        boolean bl;
        Objects.requireNonNull(ozObject);
        Objects.requireNonNull(context);
        String volume = ozObject.getVolumeName();
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        try {
            String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
            OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (volumeArgs == null) {
                LOG.debug("volume:{} does not exist", (Object)volume);
                throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
            boolean hasAccess = OzoneAclUtil.checkAclRights((List)volumeArgs.getAcls(), (RequestContext)context);
            if (LOG.isDebugEnabled()) {
                LOG.debug("user:{} has access rights for volume:{} :{} ", new Object[]{context.getClientUgi(), ozObject.getVolumeName(), hasAccess});
            }
            bl = hasAccess;
        }
        catch (IOException ex) {
            try {
                if (ex instanceof OMException) {
                    throw (OMException)ex;
                }
                LOG.error("Check access operation failed for volume:{}", (Object)volume, (Object)ex);
                throw new OMException("Check access operation failed for volume:" + volume, (Throwable)ex, OMException.ResultCodes.INTERNAL_ERROR);
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        return bl;
    }
}

