/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.security.acl.OzonePrefixPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzonePrefixPathImpl
implements OzonePrefixPath {
    private static final Logger LOG = LoggerFactory.getLogger(OzonePrefixPathImpl.class);
    private String volumeName;
    private String bucketName;
    private KeyManager keyManager;
    private int batchSize = 1000;
    private OzoneFileStatus pathStatus;

    public OzonePrefixPathImpl(String volumeName, String bucketName, String keyPrefix, KeyManager keyManagerImpl) throws IOException {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.keyManager = keyManagerImpl;
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyPrefix).setRefreshPipeline(false).build();
        try {
            this.pathStatus = this.keyManager.getFileStatus(omKeyArgs);
        }
        catch (OMException ome) {
            if (ome.getResult() == OMException.ResultCodes.FILE_NOT_FOUND) {
                throw new OMException(ome.getMessage(), OMException.ResultCodes.KEY_NOT_FOUND);
            }
            throw ome;
        }
    }

    public OzoneFileStatus getOzoneFileStatus() {
        return this.pathStatus;
    }

    public Iterator<? extends OzoneFileStatus> getChildren(String keyPrefix) throws IOException {
        return new PathIterator(keyPrefix);
    }

    class PathIterator
    implements Iterator<OzoneFileStatus> {
        private Iterator<OzoneFileStatus> currentIterator;
        private String keyPrefix;
        private OzoneFileStatus currentValue;

        PathIterator(String keyPrefix) throws IOException {
            OzoneFileStatus keyStatus;
            this.keyPrefix = keyPrefix;
            this.currentValue = null;
            List<OzoneFileStatus> statuses = this.getNextListOfKeys("");
            if (statuses.size() == 1 && (keyStatus = statuses.get(0)).isFile() && StringUtils.equals((CharSequence)keyPrefix, (CharSequence)keyStatus.getTrimmedName())) {
                throw new OMException("Invalid keyPrefix: " + keyPrefix + ", file type is not allowed, expected directory type.", OMException.ResultCodes.INVALID_KEY_NAME);
            }
            this.currentIterator = statuses.iterator();
        }

        @Override
        public boolean hasNext() {
            if (!this.currentIterator.hasNext() && this.currentValue != null) {
                String keyName = "";
                try {
                    keyName = this.currentValue.getTrimmedName();
                    this.currentIterator = this.getNextListOfKeys(keyName).iterator();
                }
                catch (IOException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Exception while listing keys, keyName:" + keyName, (Throwable)e);
                    }
                    return false;
                }
            }
            return this.currentIterator.hasNext();
        }

        @Override
        public OzoneFileStatus next() {
            if (this.hasNext()) {
                this.currentValue = this.currentIterator.next();
                return this.currentValue;
            }
            throw new NoSuchElementException();
        }

        List<OzoneFileStatus> getNextListOfKeys(String prevKey) throws IOException {
            OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(OzonePrefixPathImpl.this.volumeName).setBucketName(OzonePrefixPathImpl.this.bucketName).setKeyName(this.keyPrefix).setRefreshPipeline(false).build();
            List<OzoneFileStatus> statuses = OzonePrefixPathImpl.this.keyManager.listStatus(omKeyArgs, false, prevKey, OzonePrefixPathImpl.this.batchSize);
            if (!statuses.isEmpty() && StringUtils.equals((CharSequence)prevKey, (CharSequence)statuses.get(0).getTrimmedName())) {
                statuses.remove(0);
            }
            return statuses;
        }
    }
}

