/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.IOException;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.VersionInfo;
import org.apache.hadoop.ozone.om.OMStarterInterface;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.util.OzoneVersionInfo;
import org.apache.hadoop.ozone.util.ShutdownHookManager;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ozone om", hidden=true, description={"Start or initialize the Ozone Manager."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true)
public class OzoneManagerStarter
extends GenericCli {
    private OzoneConfiguration conf;
    private OMStarterInterface receiver;
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerStarter.class);

    public static void main(String[] args) throws Exception {
        new OzoneManagerStarter(new OMStarterHelper()).run(args);
    }

    public OzoneManagerStarter(OMStarterInterface receiverObj) {
        this.receiver = receiverObj;
    }

    public Void call() throws Exception {
        try {
            this.commonInit();
            this.startOm();
        }
        catch (Exception ex) {
            LOG.error("OM start failed with exception", (Throwable)ex);
            throw ex;
        }
        return null;
    }

    private void startOm() throws Exception {
        this.receiver.start(this.conf);
    }

    @CommandLine.Command(name="--init", customSynopsis={"ozone om [global options] --init"}, hidden=false, description={"Initialize the Ozone Manager if not already initialized"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
    public void initOm() throws Exception {
        this.commonInit();
        boolean result = this.receiver.init(this.conf);
        if (!result) {
            throw new IOException("OM Init failed.");
        }
    }

    @CommandLine.Command(name="--upgrade", aliases={"--downgrade"}, customSynopsis={"ozone om [global options] --upgrade"}, description={"Cancels prepare state in this OM on startup"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
    public void startOmUpgrade() throws Exception {
        try {
            this.commonInit();
            this.receiver.startAndCancelPrepare(this.conf);
        }
        catch (Exception ex) {
            LOG.error("Cancelling prepare to start OM in upgrade mode failed with exception", (Throwable)ex);
            throw ex;
        }
    }

    @CommandLine.Command(name="--bootstrap", customSynopsis={"ozone om [global options] --bootstrap"}, hidden=false, description={"Initialize if not already initialized and Bootstrap the Ozone Manager"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
    public void bootstrapOM() throws Exception {
        this.commonInit();
        this.receiver.bootstrap(this.conf);
    }

    private void commonInit() {
        this.conf = this.createOzoneConfiguration();
        TracingUtil.initTracing((String)"OzoneManager", (ConfigurationSource)this.conf);
        String[] originalArgs = this.getCmd().getParseResult().originalArgs().toArray(new String[0]);
        StringUtils.startupShutdownMessage((VersionInfo)OzoneVersionInfo.OZONE_VERSION_INFO, OzoneManager.class, (String[])originalArgs, (Logger)LOG);
    }

    static class OMStarterHelper
    implements OMStarterInterface {
        OMStarterHelper() {
        }

        @Override
        public void start(OzoneConfiguration conf) throws IOException, AuthenticationException {
            OzoneManager om = OzoneManager.createOm(conf);
            om.start();
            ShutdownHookManager.get().addShutdownHook(() -> {
                try {
                    om.stop();
                    om.join();
                }
                catch (Exception e) {
                    LOG.error("Error during stop OzoneManager.", (Throwable)e);
                }
            }, 10);
        }

        @Override
        public boolean init(OzoneConfiguration conf) throws IOException, AuthenticationException {
            return OzoneManager.omInit(conf);
        }

        @Override
        public void bootstrap(OzoneConfiguration conf) throws IOException, AuthenticationException {
            boolean initialize = OzoneManager.omInit(conf);
            if (!initialize) {
                throw new IOException("OM Init failed.");
            }
            OzoneManager om = OzoneManager.createOm(conf, OzoneManager.StartupOption.BOOTSTRAP);
            om.start();
            om.join();
        }

        @Override
        public void startAndCancelPrepare(OzoneConfiguration conf) throws IOException, AuthenticationException {
            OzoneManager om = OzoneManager.createOm(conf);
            om.getPrepareState().cancelPrepare();
            om.start();
            om.join();
        }
    }
}

