/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.protobuf.BlockingService;
import com.google.protobuf.ProtocolMessageEnum;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdds.ExitManager;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.SCMSecurityProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.ha.SCMNodeInfo;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.security.OzoneSecurityException;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.client.OMCertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.apache.hadoop.hdds.security.x509.certificates.utils.CertificateSignRequest;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.server.ServiceRuntimeInfoImpl;
import org.apache.hadoop.hdds.server.http.RatisDropwizardExports;
import org.apache.hadoop.hdds.utils.DBStoreHAManager;
import org.apache.hadoop.hdds.utils.HAUtils;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.DBUpdatesWrapper;
import org.apache.hadoop.hdds.utils.db.SequenceNumberNotFoundException;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.OzoneIllegalArgumentException;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditEventStatus;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.AuditMessage;
import org.apache.hadoop.ozone.audit.Auditor;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.common.ha.ratis.RatisSnapshotInfo;
import org.apache.hadoop.ozone.om.BucketManager;
import org.apache.hadoop.ozone.om.BucketManagerImpl;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.KeyManagerImpl;
import org.apache.hadoop.ozone.om.OMMXBean;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OMPolicyProvider;
import org.apache.hadoop.ozone.om.OMStorage;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmMetricsInfo;
import org.apache.hadoop.ozone.om.OmUpgradeConfig;
import org.apache.hadoop.ozone.om.OzoneManagerHttpServer;
import org.apache.hadoop.ozone.om.OzoneManagerPrepareState;
import org.apache.hadoop.ozone.om.OzoneTrash;
import org.apache.hadoop.ozone.om.PrefixManager;
import org.apache.hadoop.ozone.om.PrefixManagerImpl;
import org.apache.hadoop.ozone.om.ResolvedBucket;
import org.apache.hadoop.ozone.om.S3SecretManager;
import org.apache.hadoop.ozone.om.S3SecretManagerImpl;
import org.apache.hadoop.ozone.om.ScmClient;
import org.apache.hadoop.ozone.om.TrashOzoneFileSystem;
import org.apache.hadoop.ozone.om.VolumeManager;
import org.apache.hadoop.ozone.om.VolumeManagerImpl;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.exceptions.OMLeaderNotReadyException;
import org.apache.hadoop.ozone.om.exceptions.OMNotLeaderException;
import org.apache.hadoop.ozone.om.ha.OMHANodeDetails;
import org.apache.hadoop.ozone.om.helpers.DBUpdates;
import org.apache.hadoop.ozone.om.helpers.OMNodeDetails;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDeleteKeys;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadListParts;
import org.apache.hadoop.ozone.om.helpers.OmRenameKeys;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.helpers.ServiceInfoEx;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.protocol.OMInterServiceProtocol;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.om.protocolPB.OMInterServiceProtocolClientSideImpl;
import org.apache.hadoop.ozone.om.protocolPB.OMInterServiceProtocolPB;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisServer;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.snapshot.OzoneManagerSnapshotProvider;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutVersionManager;
import org.apache.hadoop.ozone.om.upgrade.OMUpgradeFinalizer;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerInterServiceProtocolProtos;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMInterServiceProtocolServerSideImpl;
import org.apache.hadoop.ozone.protocolPB.OzoneManagerProtocolServerSideTranslatorPB;
import org.apache.hadoop.ozone.security.OzoneBlockTokenSecretManager;
import org.apache.hadoop.ozone.security.OzoneDelegationTokenSecretManager;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.IOzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneNativeAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.apache.hadoop.ozone.storage.proto.OzoneManagerStorageProtos;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;
import org.apache.hadoop.ozone.util.OzoneVersionInfo;
import org.apache.hadoop.ozone.util.ShutdownHookManager;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.hadoop.util.KMSUtil;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Time;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.LifeCycle;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "CBLOCK", "OZONE", "HBASE"})
public final class OzoneManager
extends ServiceRuntimeInfoImpl
implements OzoneManagerProtocol,
OMInterServiceProtocol,
OMMXBean,
Auditor {
    public static final Logger LOG = LoggerFactory.getLogger(OzoneManager.class);
    private static final AuditLogger AUDIT = new AuditLogger(AuditLoggerType.OMLOGGER);
    private static final String OM_DAEMON = "om";
    private static boolean securityEnabled = false;
    private OzoneDelegationTokenSecretManager delegationTokenMgr;
    private OzoneBlockTokenSecretManager blockTokenMgr;
    private CertificateClient certClient;
    private String caCertPem = null;
    private List<String> caCertPemList = new ArrayList<String>();
    private static boolean testSecureOmFlag = false;
    private final Text omRpcAddressTxt;
    private OzoneConfiguration configuration;
    private RPC.Server omRpcServer;
    private InetSocketAddress omRpcAddress;
    private String omId;
    private OMMetadataManager metadataManager;
    private VolumeManager volumeManager;
    private BucketManager bucketManager;
    private KeyManager keyManager;
    private PrefixManagerImpl prefixManager;
    private UpgradeFinalizer<OzoneManager> upgradeFinalizer;
    private final Collection<String> omAdminUsernames;
    private final OMMetrics metrics;
    private final ProtocolMessageMetrics<ProtocolMessageEnum> omClientProtocolMetrics;
    private OzoneManagerHttpServer httpServer;
    private final OMStorage omStorage;
    private final ScmBlockLocationProtocol scmBlockClient;
    private final StorageContainerLocationProtocol scmContainerClient;
    private ObjectName omInfoBeanName;
    private Timer metricsTimer;
    private ScheduleOMMetricsWriteTask scheduleOMMetricsWriteTask;
    private static final ObjectWriter WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter();
    private static final ObjectReader READER = new ObjectMapper().readerFor(OmMetricsInfo.class);
    private static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private final Runnable shutdownHook;
    private final File omMetaDir;
    private boolean isAclEnabled;
    private final boolean isSpnegoEnabled;
    private IAccessAuthorizer accessAuthorizer;
    private JvmPauseMonitor jvmPauseMonitor;
    private final SecurityConfig secConfig;
    private S3SecretManager s3SecretManager;
    private volatile boolean isOmRpcServerRunning = false;
    private String omComponent;
    private OzoneManagerProtocolServerSideTranslatorPB omServerProtocol;
    private boolean isRatisEnabled;
    private OzoneManagerRatisServer omRatisServer;
    private OzoneManagerSnapshotProvider omSnapshotProvider;
    private OMNodeDetails omNodeDetails;
    private Map<String, OMNodeDetails> peerNodesMap;
    private File omRatisSnapshotDir;
    private final RatisSnapshotInfo omRatisSnapshotInfo;
    private final Map<String, RatisDropwizardExports> ratisMetricsMap = new ConcurrentHashMap<String, RatisDropwizardExports>();
    private KeyProviderCryptoExtension kmsProvider = null;
    private static String keyProviderUriKeyName = "hadoop.security.key.provider.path";
    private OMLayoutVersionManager versionManager;
    private boolean allowListAllVolumes;
    private long maxUserVolumeCount;
    private int minMultipartUploadPartSize = 0x500000;
    private final ScmClient scmClient;
    private final long scmBlockSize;
    private final int preallocateBlocksMax;
    private final boolean grpcBlockTokenEnabled;
    private final boolean useRatisForReplication;
    private boolean isNativeAuthorizerEnabled;
    private ExitManager exitManager;
    private OzoneManagerPrepareState prepareState;
    private boolean isBootstrapping = false;
    private State omState;
    private Thread emptier;
    private static final int MSECS_PER_MINUTE = 60000;

    private OzoneManager(OzoneConfiguration conf, StartupOption startupOption) throws IOException, AuthenticationException {
        super(OzoneVersionInfo.OZONE_VERSION_INFO);
        ScmInfo scmInfo;
        Preconditions.checkNotNull((Object)conf);
        this.setConfiguration(conf);
        OMHANodeDetails omhaNodeDetails = OMHANodeDetails.loadOMHAConfig(this.configuration);
        this.peerNodesMap = omhaNodeDetails.getPeerNodesMap();
        this.omNodeDetails = omhaNodeDetails.getLocalNodeDetails();
        this.omStorage = new OMStorage(conf);
        this.omId = this.omStorage.getOmId();
        this.versionManager = new OMLayoutVersionManager(this.omStorage.getLayoutVersion());
        this.upgradeFinalizer = new OMUpgradeFinalizer(this.versionManager);
        this.exitManager = new ExitManager();
        if (this.omNodeDetails.getNodeId() == null) {
            this.omNodeDetails = OMHANodeDetails.getOMNodeDetails(conf, this.omNodeDetails.getServiceId(), this.omStorage.getOmId(), this.omNodeDetails.getRpcAddress(), this.omNodeDetails.getRatisPort());
        }
        OzoneManager.loginOMUserIfSecurityEnabled(conf);
        this.setInstanceVariablesFromConf();
        this.maxUserVolumeCount = conf.getInt("ozone.om.user.max.volume", 1024);
        Preconditions.checkArgument((this.maxUserVolumeCount > 0L ? 1 : 0) != 0, (Object)"ozone.om.user.max.volume value should be greater than zero");
        if (this.omStorage.getState() != Storage.StorageState.INITIALIZED) {
            throw new OMException("OM not initialized, current OM storage state: " + this.omStorage.getState().name() + ". Please ensure 'ozone om --init' " + "command is executed to generate all the required metadata to " + this.omStorage.getStorageDir() + " once before starting the OM service.", OMException.ResultCodes.OM_NOT_INITIALIZED);
        }
        this.omMetaDir = OMStorage.getOmDbDir((ConfigurationSource)this.configuration);
        this.isSpnegoEnabled = conf.get("ozone.om.http.auth.type", "simple").equals("kerberos");
        this.scmBlockSize = (long)conf.getStorageSize("ozone.scm.block.size", "256MB", StorageUnit.BYTES);
        this.preallocateBlocksMax = conf.getInt("ozone.key.preallocation.max.blocks", 64);
        this.grpcBlockTokenEnabled = conf.getBoolean("hdds.block.token.enabled", false);
        this.useRatisForReplication = conf.getBoolean("dfs.container.ratis.enabled", false);
        this.isRatisEnabled = this.configuration.getBoolean("ozone.om.ratis.enable", true);
        InetSocketAddress omNodeRpcAddr = this.omNodeDetails.getRpcAddress();
        this.omRpcAddressTxt = new Text(this.omNodeDetails.getRpcAddressString());
        this.scmContainerClient = OzoneManager.getScmContainerClient(this.configuration);
        this.scmBlockClient = OzoneManager.getScmBlockClient(this.configuration);
        this.scmClient = new ScmClient(this.scmBlockClient, this.scmContainerClient);
        if (!testSecureOmFlag && !(scmInfo = HAUtils.getScmInfo((OzoneConfiguration)this.configuration)).getClusterId().equals(this.omStorage.getClusterID())) {
            this.logVersionMismatch(conf, scmInfo);
            throw new OMException("SCM version info mismatch.", OMException.ResultCodes.SCM_VERSION_MISMATCH_ERROR);
        }
        RPC.setProtocolEngine((Configuration)this.configuration, OzoneManagerProtocolPB.class, ProtobufRpcEngine.class);
        this.secConfig = new SecurityConfig((ConfigurationSource)this.configuration);
        try {
            this.kmsProvider = this.createKeyProviderExt(this.configuration);
        }
        catch (IOException iOException) {
            this.kmsProvider = null;
            LOG.error("Fail to create Key Provider");
        }
        if (this.secConfig.isSecurityEnabled()) {
            this.omComponent = "om-" + this.omId;
            if (this.omStorage.getOmCertSerialId() == null) {
                throw new RuntimeException("OzoneManager started in secure mode but doesn't have SCM signed certificate.");
            }
            this.certClient = new OMCertificateClient(new SecurityConfig((ConfigurationSource)conf), this.omStorage.getOmCertSerialId());
        }
        if (this.secConfig.isBlockTokenEnabled()) {
            this.blockTokenMgr = this.createBlockTokenSecretManager(this.configuration);
        }
        this.omAdminUsernames = this.getOzoneAdminsFromConfig(this.configuration);
        this.instantiateServices(false);
        this.addS3GVolumeToDB();
        if (startupOption == StartupOption.BOOTSTRAP) {
            this.isBootstrapping = true;
        }
        this.omRatisSnapshotInfo = new RatisSnapshotInfo();
        this.initializeRatisDirs(conf);
        this.initializeRatisServer(this.isBootstrapping);
        this.metrics = OMMetrics.create();
        this.omClientProtocolMetrics = ProtocolMessageMetrics.create((String)"OmClientProtocol", (String)"Ozone Manager RPC endpoint", (Object[])OzoneManagerProtocolProtos.Type.values());
        this.omRpcServer = this.getRpcServer(this.configuration);
        this.omRpcAddress = ServerUtils.updateRPCListenAddress((OzoneConfiguration)this.configuration, (String)"ozone.om.address", (InetSocketAddress)omNodeRpcAddr, (RPC.Server)this.omRpcServer);
        this.shutdownHook = () -> this.saveOmMetrics();
        ShutdownHookManager.get().addShutdownHook(this.shutdownHook, 30);
        this.omState = State.INITIALIZED;
    }

    private void setInstanceVariablesFromConf() {
        this.isAclEnabled = this.configuration.getBoolean("ozone.acl.enabled", false);
        this.allowListAllVolumes = this.configuration.getBoolean("ozone.om.volume.listall.allowed", true);
    }

    public static OzoneManager createOm(OzoneConfiguration conf) throws IOException, AuthenticationException {
        return new OzoneManager(conf, StartupOption.REGUALR);
    }

    public static OzoneManager createOm(OzoneConfiguration conf, StartupOption startupOption) throws IOException, AuthenticationException {
        return new OzoneManager(conf, startupOption);
    }

    private void logVersionMismatch(OzoneConfiguration conf, ScmInfo scmInfo) {
        List scmNodeInfoList = SCMNodeInfo.buildNodeInfo((ConfigurationSource)conf);
        StringBuilder scmBlockAddressBuilder = new StringBuilder("");
        for (SCMNodeInfo scmNodeInfo : scmNodeInfoList) {
            scmBlockAddressBuilder.append(scmNodeInfo.getBlockClientAddress()).append(",");
        }
        String scmBlockAddress = scmBlockAddressBuilder.toString();
        if (!StringUtils.isBlank((CharSequence)scmBlockAddress)) {
            scmBlockAddress = scmBlockAddress.substring(0, scmBlockAddress.lastIndexOf(","));
        }
        if (!scmInfo.getClusterId().equals(this.omStorage.getClusterID())) {
            LOG.error("clusterId from {} is {}, but is {} in {}", new Object[]{scmBlockAddress, scmInfo.getClusterId(), this.omStorage.getClusterID(), this.omStorage.getVersionFile()});
        }
    }

    private void instantiateServices(boolean withNewSnapshot) throws IOException {
        this.metadataManager = new OmMetadataManagerImpl(this.configuration);
        this.volumeManager = new VolumeManagerImpl(this.metadataManager, this.configuration);
        this.bucketManager = new BucketManagerImpl(this.metadataManager, this.getKmsProvider(), this.isRatisEnabled);
        if (this.secConfig.isSecurityEnabled()) {
            this.s3SecretManager = new S3SecretManagerImpl(this.configuration, this.metadataManager);
            this.delegationTokenMgr = this.createDelegationTokenSecretManager(this.configuration);
        }
        this.prefixManager = new PrefixManagerImpl(this.metadataManager, this.isRatisEnabled);
        this.keyManager = new KeyManagerImpl(this, this.scmClient, this.configuration, this.omStorage.getOmId());
        if (withNewSnapshot) {
            Integer layoutVersionInDB = this.getLayoutVersionInDB();
            if (layoutVersionInDB != null && this.versionManager.getMetadataLayoutVersion() < layoutVersionInDB) {
                LOG.info("New OM snapshot received with higher layout version {}. Attempting to finalize current OM to that version.", (Object)layoutVersionInDB);
                OmUpgradeConfig uConf = (OmUpgradeConfig)this.configuration.getObject(OmUpgradeConfig.class);
                this.upgradeFinalizer.finalizeAndWaitForCompletion("om-ratis-snapshot", (Object)this, uConf.getRatisBasedFinalizationTimeout());
                if (this.versionManager.getMetadataLayoutVersion() < layoutVersionInDB) {
                    throw new IOException("Unable to finalize OM to the desired layout version " + layoutVersionInDB + " present in the snapshot DB.");
                }
                this.updateLayoutVersionInDB(this.versionManager, this.metadataManager);
            }
            this.instantiatePrepareStateAfterSnapshot();
        } else {
            this.instantiatePrepareStateOnStartup();
        }
        if (this.isAclEnabled) {
            this.accessAuthorizer = this.getACLAuthorizerInstance(this.configuration);
            if (this.accessAuthorizer instanceof OzoneNativeAuthorizer) {
                OzoneNativeAuthorizer authorizer = (OzoneNativeAuthorizer)this.accessAuthorizer;
                this.isNativeAuthorizerEnabled = true;
                authorizer.setVolumeManager(this.volumeManager);
                authorizer.setBucketManager(this.bucketManager);
                authorizer.setKeyManager(this.keyManager);
                authorizer.setPrefixManager(this.prefixManager);
                authorizer.setOzoneAdmins(this.omAdminUsernames);
                authorizer.setAllowListAllVolumes(this.allowListAllVolumes);
            }
        } else {
            this.accessAuthorizer = null;
        }
    }

    public boolean shouldUseRatis() {
        return this.useRatisForReplication;
    }

    public ScmClient getScmClient() {
        return this.scmClient;
    }

    public OzoneBlockTokenSecretManager getBlockTokenSecretManager() {
        return this.blockTokenMgr;
    }

    public long getScmBlockSize() {
        return this.scmBlockSize;
    }

    public int getPreallocateBlocksMax() {
        return this.preallocateBlocksMax;
    }

    public boolean isGrpcBlockTokenEnabled() {
        return this.grpcBlockTokenEnabled;
    }

    private KeyProviderCryptoExtension createKeyProviderExt(OzoneConfiguration conf) throws IOException {
        KeyProvider keyProvider = KMSUtil.createKeyProvider((Configuration)conf, (String)keyProviderUriKeyName);
        if (keyProvider == null) {
            return null;
        }
        KeyProviderCryptoExtension cryptoProvider = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)keyProvider);
        return cryptoProvider;
    }

    private IAccessAuthorizer getACLAuthorizerInstance(OzoneConfiguration conf) {
        Class clazz = conf.getClass("ozone.acl.authorizer.class", OzoneAccessAuthorizer.class, IAccessAuthorizer.class);
        return (IAccessAuthorizer)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
    }

    public void close() throws IOException {
        this.stop();
    }

    public void shutdown(Exception ex) throws IOException {
        if (this.omState != State.STOPPED) {
            this.stop();
            this.exitManager.exitSystem(1, ex.getLocalizedMessage(), (Throwable)ex, LOG);
        }
    }

    private void saveOmMetrics() {
        try {
            boolean success;
            File parent = this.getTempMetricsStorageFile().getParentFile();
            if (!parent.exists()) {
                Files.createDirectories(parent.toPath(), new FileAttribute[0]);
            }
            Throwable throwable = null;
            Object var4_4 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.getTempMetricsStorageFile()), StandardCharsets.UTF_8));){
                OmMetricsInfo metricsInfo = new OmMetricsInfo();
                metricsInfo.setNumKeys(this.metrics.getNumKeys());
                WRITER.writeValue((Writer)writer, (Object)metricsInfo);
                success = true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (success) {
                Files.move(this.getTempMetricsStorageFile().toPath(), this.getMetricsStorageFile().toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException ex) {
            LOG.error("Unable to write the om Metrics file", (Throwable)ex);
        }
    }

    private File getTempMetricsStorageFile() {
        return new File(this.omMetaDir, "omMetrics.tmp");
    }

    private File getMetricsStorageFile() {
        return new File(this.omMetaDir, "omMetrics");
    }

    private OzoneDelegationTokenSecretManager createDelegationTokenSecretManager(OzoneConfiguration conf) throws IOException {
        long tokenRemoverScanInterval = conf.getTimeDuration("ozone.manager.delegation.remover.scan.interval", 3600000L, TimeUnit.MILLISECONDS);
        long tokenMaxLifetime = conf.getTimeDuration("ozone.manager.delegation.token.max-lifetime", 604800000L, TimeUnit.MILLISECONDS);
        long tokenRenewInterval = conf.getTimeDuration("ozone.manager.delegation.token.renew-interval", 86400000L, TimeUnit.MILLISECONDS);
        return new OzoneDelegationTokenSecretManager.Builder().setConf(conf).setTokenMaxLifetime(tokenMaxLifetime).setTokenRenewInterval(tokenRenewInterval).setTokenRemoverScanInterval(tokenRemoverScanInterval).setService(this.omRpcAddressTxt).setS3SecretManager(this.s3SecretManager).setCertificateClient(this.certClient).setOmServiceId(this.omNodeDetails.getServiceId()).build();
    }

    private OzoneBlockTokenSecretManager createBlockTokenSecretManager(OzoneConfiguration conf) {
        long expiryTime = conf.getTimeDuration("hdds.block.token.expiry.time", "1d", TimeUnit.MILLISECONDS);
        if (testSecureOmFlag) {
            return new OzoneBlockTokenSecretManager(this.secConfig, expiryTime, "1");
        }
        Objects.requireNonNull(this.certClient);
        return new OzoneBlockTokenSecretManager(this.secConfig, expiryTime, this.certClient.getCertificate().getSerialNumber().toString());
    }

    private void stopSecretManager() {
        if (this.blockTokenMgr != null) {
            LOG.info("Stopping OM block token manager.");
            try {
                this.blockTokenMgr.stop();
            }
            catch (IOException e) {
                LOG.error("Failed to stop block token manager", (Throwable)e);
            }
        }
        if (this.delegationTokenMgr != null) {
            LOG.info("Stopping OM delegation token secret manager.");
            try {
                this.delegationTokenMgr.stop();
            }
            catch (IOException e) {
                LOG.error("Failed to stop delegation token manager", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    public void startSecretManager() {
        try {
            this.certClient.assertValidKeysAndCertificate();
        }
        catch (OzoneSecurityException e) {
            LOG.error("Unable to read key pair for OM.", (Throwable)e);
            throw new UncheckedIOException((IOException)((Object)e));
        }
        if (this.secConfig.isBlockTokenEnabled() && this.blockTokenMgr != null) {
            try {
                LOG.info("Starting OM block token secret manager");
                this.blockTokenMgr.start(this.certClient);
            }
            catch (IOException e) {
                LOG.error("Error starting block token secret manager.", (Throwable)e);
                throw new UncheckedIOException(e);
            }
        }
        if (this.delegationTokenMgr != null) {
            try {
                LOG.info("Starting OM delegation token secret manager");
                this.delegationTokenMgr.start(this.certClient);
            }
            catch (IOException e) {
                LOG.error("Error starting delegation token secret manager.", (Throwable)e);
                throw new UncheckedIOException(e);
            }
        }
    }

    public void setCertClient(CertificateClient certClient) {
        this.certClient = certClient;
    }

    private static void loginOMUser(OzoneConfiguration conf) throws IOException, AuthenticationException {
        if (SecurityUtil.getAuthenticationMethod((Configuration)conf).equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ozone security is enabled. Attempting login for OM user. Principal: {}, keytab: {}", (Object)conf.get("ozone.om.kerberos.principal"), (Object)conf.get("ozone.om.kerberos.keytab.file"));
            }
        } else {
            throw new AuthenticationException(SecurityUtil.getAuthenticationMethod((Configuration)conf) + " authentication method not supported. OM user login " + "failed.");
        }
        UserGroupInformation.setConfiguration((Configuration)conf);
        InetSocketAddress socAddr = OmUtils.getOmAddress((ConfigurationSource)conf);
        SecurityUtil.login((Configuration)conf, (String)"ozone.om.kerberos.keytab.file", (String)"ozone.om.kerberos.principal", (String)socAddr.getHostName());
        LOG.info("Ozone Manager login successful.");
    }

    private static ScmBlockLocationProtocol getScmBlockClient(OzoneConfiguration conf) throws IOException {
        return HAUtils.getScmBlockClient((OzoneConfiguration)conf);
    }

    private static StorageContainerLocationProtocol getScmContainerClient(OzoneConfiguration conf) {
        return HAUtils.getScmContainerClient((ConfigurationSource)conf);
    }

    private RPC.Server getRpcServer(OzoneConfiguration conf) throws IOException {
        if (this.isOmRpcServerRunning) {
            return this.omRpcServer;
        }
        InetSocketAddress omNodeRpcAddr = OmUtils.getOmAddress((ConfigurationSource)conf);
        int handlerCount = conf.getInt("ozone.om.handler.count.key", 100);
        RPC.setProtocolEngine((Configuration)this.configuration, OzoneManagerProtocolPB.class, ProtobufRpcEngine.class);
        this.omServerProtocol = new OzoneManagerProtocolServerSideTranslatorPB(this, this.omRatisServer, this.omClientProtocolMetrics, this.isRatisEnabled, this.getLastTrxnIndexForNonRatis());
        BlockingService omService = OzoneManagerProtocolProtos.OzoneManagerService.newReflectiveBlockingService((OzoneManagerProtocolProtos.OzoneManagerService.BlockingInterface)this.omServerProtocol);
        OMInterServiceProtocolServerSideImpl omInterServerProtocol = new OMInterServiceProtocolServerSideImpl(this.omRatisServer, this.isRatisEnabled);
        BlockingService omInterService = OzoneManagerInterServiceProtocolProtos.OzoneManagerInterService.newReflectiveBlockingService((OzoneManagerInterServiceProtocolProtos.OzoneManagerInterService.BlockingInterface)omInterServerProtocol);
        return this.startRpcServer(this.configuration, omNodeRpcAddr, omService, omInterService, handlerCount);
    }

    private RPC.Server startRpcServer(OzoneConfiguration conf, InetSocketAddress addr, BlockingService clientProtocolService, BlockingService interOMProtocolService, int handlerCount) throws IOException {
        RPC.Server rpcServer = new RPC.Builder((Configuration)conf).setProtocol(OzoneManagerProtocolPB.class).setInstance((Object)clientProtocolService).setBindAddress(addr.getHostString()).setPort(addr.getPort()).setNumHandlers(handlerCount).setVerbose(false).setSecretManager((SecretManager)this.delegationTokenMgr).build();
        HddsServerUtil.addPBProtocol((Configuration)conf, OMInterServiceProtocolPB.class, (BlockingService)interOMProtocolService, (RPC.Server)rpcServer);
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            rpcServer.refreshServiceAcl((Configuration)conf, (PolicyProvider)OMPolicyProvider.getInstance());
        }
        rpcServer.addSuppressedLoggingExceptions(new Class[]{OMNotLeaderException.class, OMLeaderNotReadyException.class});
        return rpcServer;
    }

    private static boolean isOzoneSecurityEnabled() {
        return securityEnabled;
    }

    private static void loginOMUserIfSecurityEnabled(OzoneConfiguration conf) throws IOException, AuthenticationException {
        securityEnabled = OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf);
        if (securityEnabled) {
            OzoneManager.loginOMUser(conf);
        }
    }

    @VisibleForTesting
    public static boolean omInit(OzoneConfiguration conf) throws IOException, AuthenticationException {
        OMHANodeDetails.loadOMHAConfig(conf);
        OzoneManager.loginOMUserIfSecurityEnabled(conf);
        OMStorage omStorage = new OMStorage(conf);
        Storage.StorageState state = omStorage.getState();
        if (state != Storage.StorageState.INITIALIZED) {
            try {
                ScmInfo scmInfo = HAUtils.getScmInfo((OzoneConfiguration)conf);
                String clusterId = scmInfo.getClusterId();
                String scmId = scmInfo.getScmId();
                if (clusterId == null || clusterId.isEmpty()) {
                    throw new IOException("Invalid Cluster ID");
                }
                if (scmId == null || scmId.isEmpty()) {
                    throw new IOException("Invalid SCM ID");
                }
                omStorage.setClusterId(clusterId);
                if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
                    OzoneManager.initializeSecurity(conf, omStorage, scmId);
                }
                omStorage.initialize();
                System.out.println("OM initialization succeeded.Current cluster id for sd=" + omStorage.getStorageDir() + ";cid=" + omStorage.getClusterID() + ";layoutVersion=" + omStorage.getLayoutVersion());
                return true;
            }
            catch (IOException ioe) {
                LOG.error("Could not initialize OM version file", (Throwable)ioe);
                return false;
            }
        }
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf) && omStorage.getOmCertSerialId() == null) {
            ScmInfo scmInfo = HAUtils.getScmInfo((OzoneConfiguration)conf);
            String scmId = scmInfo.getScmId();
            if (scmId == null || scmId.isEmpty()) {
                throw new IOException("Invalid SCM ID");
            }
            LOG.info("OM storage is already initialized. Initializing security");
            OzoneManager.initializeSecurity(conf, omStorage, scmId);
            omStorage.persistCurrentState();
        }
        System.out.println("OM already initialized.Reusing existing cluster id for sd=" + omStorage.getStorageDir() + ";cid=" + omStorage.getClusterID() + ";layoutVersion=" + omStorage.getLayoutVersion());
        return true;
    }

    @VisibleForTesting
    public static void initializeSecurity(OzoneConfiguration conf, OMStorage omStore, String scmId) throws IOException {
        LOG.info("Initializing secure OzoneManager.");
        OMCertificateClient certClient = new OMCertificateClient(new SecurityConfig((ConfigurationSource)conf), omStore.getOmCertSerialId());
        CertificateClient.InitResponse response = certClient.init();
        LOG.info("Init response: {}", (Object)response);
        switch (response) {
            case SUCCESS: {
                LOG.info("Initialization successful.");
                break;
            }
            case GETCERT: {
                OzoneManager.getSCMSignedCert((CertificateClient)certClient, conf, omStore, scmId);
                LOG.info("Successfully stored SCM signed certificate.");
                break;
            }
            case FAILURE: {
                LOG.error("OM security initialization failed.");
                throw new RuntimeException("OM security initialization failed.");
            }
            case RECOVER: {
                LOG.error("OM security initialization failed. OM certificate is missing.");
                throw new RuntimeException("OM security initialization failed.");
            }
            default: {
                LOG.error("OM security initialization failed. Init response: {}", (Object)response);
                throw new RuntimeException("OM security initialization failed.");
            }
        }
    }

    private void initializeRatisDirs(OzoneConfiguration conf) throws IOException {
        if (this.isRatisEnabled) {
            String omRatisDirectory = OzoneManagerRatisUtils.getOMRatisDirectory((ConfigurationSource)conf);
            if (omRatisDirectory == null || omRatisDirectory.isEmpty()) {
                throw new IllegalArgumentException("ozone.metadata.dirs must be defined.");
            }
            OmUtils.createOMDir((String)omRatisDirectory);
            this.omRatisSnapshotDir = OmUtils.createOMDir((String)OzoneManagerRatisUtils.getOMRatisSnapshotDirectory((ConfigurationSource)conf));
            File snapshotDir = new File(omRatisDirectory, "snapshot");
            if (snapshotDir.isDirectory()) {
                FileUtils.moveDirectory((Path)snapshotDir.toPath(), (Path)this.omRatisSnapshotDir.toPath());
            }
            File omRatisDir = new File(omRatisDirectory);
            String groupIDfromServiceID = RaftGroupId.valueOf((UUID)OzoneManagerRatisServer.getRaftGroupIdFromOmServiceId(this.getOMServiceId())).getUuid().toString();
            File[] ratisDirFiles = omRatisDir.listFiles();
            if (ratisDirFiles != null) {
                File[] fileArray = ratisDirFiles;
                int n = ratisDirFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File ratisGroupDir = fileArray[n2];
                    if (ratisGroupDir.isDirectory()) {
                        if (!ratisGroupDir.getName().equals(groupIDfromServiceID)) {
                            throw new IOException("Ratis group Dir on disk " + ratisGroupDir.getName() + " does not match with RaftGroupID" + groupIDfromServiceID + " generated from service id " + this.getOMServiceId() + ". Looks like there is a change to " + "ozone.om.service.ids" + " value after the " + "cluster is setup. Currently change to this value is not " + "supported.");
                        }
                    } else {
                        LOG.warn("Unknown file {} exists in ratis storage dir {}", (Object)ratisGroupDir, (Object)omRatisDir);
                    }
                    ++n2;
                }
            }
            if (this.peerNodesMap != null && !this.peerNodesMap.isEmpty()) {
                this.omSnapshotProvider = new OzoneManagerSnapshotProvider((MutableConfigurationSource)this.configuration, this.omRatisSnapshotDir, this.peerNodesMap);
            }
        }
    }

    private static String buildRpcServerStartMessage(String description, InetSocketAddress addr) {
        return addr != null ? String.format("%s is listening at %s", description, addr.toString()) : String.format("%s not started", description);
    }

    @VisibleForTesting
    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    @VisibleForTesting
    public OMStorage getOmStorage() {
        return this.omStorage;
    }

    @VisibleForTesting
    public OzoneManagerRatisServer getOmRatisServer() {
        return this.omRatisServer;
    }

    @VisibleForTesting
    public OzoneManagerSnapshotProvider getOmSnapshotProvider() {
        return this.omSnapshotProvider;
    }

    @VisibleForTesting
    public InetSocketAddress getOmRpcServerAddr() {
        return this.omRpcAddress;
    }

    @VisibleForTesting
    public LifeCycle.State getOmRatisServerState() {
        if (this.omRatisServer == null) {
            return null;
        }
        return this.omRatisServer.getServerState();
    }

    @VisibleForTesting
    public KeyProviderCryptoExtension getKmsProvider() {
        return this.kmsProvider;
    }

    public PrefixManager getPrefixManager() {
        return this.prefixManager;
    }

    public OMMetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    public OzoneBlockTokenSecretManager getBlockTokenMgr() {
        return this.blockTokenMgr;
    }

    public OzoneManagerProtocolServerSideTranslatorPB getOmServerProtocol() {
        return this.omServerProtocol;
    }

    public OMMetrics getMetrics() {
        return this.metrics;
    }

    public void start() throws IOException {
        this.initFSOLayout();
        this.omClientProtocolMetrics.register();
        HddsServerUtil.initializeMetrics((OzoneConfiguration)this.configuration, (String)"OzoneManager");
        LOG.info(OzoneManager.buildRpcServerStartMessage("OzoneManager RPC server", this.omRpcAddress));
        this.metadataManager.start(this.configuration);
        this.validatesBucketLayoutMismatches();
        if (this.omRatisServer != null) {
            this.omRatisServer.start();
        }
        this.startSecretManagerIfNecessary();
        this.upgradeFinalizer.runPrefinalizeStateActions((Storage)this.omStorage, (Object)this);
        Integer layoutVersionInDB = this.getLayoutVersionInDB();
        if (layoutVersionInDB == null || this.versionManager.getMetadataLayoutVersion() != layoutVersionInDB.intValue()) {
            LOG.info("Version File has different layout version ({}) than OM DB ({}). That is expected if this OM has never been finalized to a newer layout version.", (Object)this.versionManager.getMetadataLayoutVersion(), (Object)layoutVersionInDB);
        }
        if (this.certClient != null) {
            this.caCertPem = CertificateCodec.getPEMEncodedString((X509Certificate)this.certClient.getCACertificate());
            this.caCertPemList = HAUtils.buildCAList((CertificateClient)this.certClient, (ConfigurationSource)this.configuration);
        }
        this.metrics.setNumVolumes(this.metadataManager.countRowsInTable(this.metadataManager.getVolumeTable()));
        this.metrics.setNumBuckets(this.metadataManager.countRowsInTable(this.metadataManager.getBucketTable()));
        if (this.getMetricsStorageFile().exists()) {
            OmMetricsInfo metricsInfo = (OmMetricsInfo)READER.readValue(this.getMetricsStorageFile());
            this.metrics.setNumKeys(metricsInfo.getNumKeys());
        }
        long period = this.configuration.getTimeDuration("ozone.om.save.metrics.interval", "5m", TimeUnit.MILLISECONDS);
        this.scheduleOMMetricsWriteTask = new ScheduleOMMetricsWriteTask();
        this.metricsTimer = new Timer();
        this.metricsTimer.schedule((TimerTask)this.scheduleOMMetricsWriteTask, 0L, period);
        this.keyManager.start(this.configuration);
        try {
            this.httpServer = new OzoneManagerHttpServer((MutableConfigurationSource)this.configuration, this);
            this.httpServer.start();
        }
        catch (Exception ex) {
            LOG.error("OM HttpServer failed to start.", (Throwable)ex);
        }
        this.omRpcServer.start();
        this.isOmRpcServerRunning = true;
        this.startTrashEmptier((Configuration)this.configuration);
        this.registerMXBean();
        this.startJVMPauseMonitor();
        this.setStartTime();
        if (this.isBootstrapping) {
            this.omState = State.BOOTSTRAPPING;
            this.bootstrap(this.omNodeDetails);
        }
        this.omState = State.RUNNING;
    }

    public void restart() throws IOException {
        this.initFSOLayout();
        this.setInstanceVariablesFromConf();
        LOG.info(OzoneManager.buildRpcServerStartMessage("OzoneManager RPC server", this.omRpcAddress));
        HddsServerUtil.initializeMetrics((OzoneConfiguration)this.configuration, (String)"OzoneManager");
        this.instantiateServices(false);
        this.validatesBucketLayoutMismatches();
        this.startSecretManagerIfNecessary();
        this.metrics.setNumVolumes(this.metadataManager.countRowsInTable(this.metadataManager.getVolumeTable()));
        this.metrics.setNumBuckets(this.metadataManager.countRowsInTable(this.metadataManager.getBucketTable()));
        if (this.getMetricsStorageFile().exists()) {
            OmMetricsInfo metricsInfo = (OmMetricsInfo)READER.readValue(this.getMetricsStorageFile());
            this.metrics.setNumKeys(metricsInfo.getNumKeys());
        }
        long period = this.configuration.getTimeDuration("ozone.om.save.metrics.interval", "5m", TimeUnit.MILLISECONDS);
        this.scheduleOMMetricsWriteTask = new ScheduleOMMetricsWriteTask();
        this.metricsTimer = new Timer();
        this.metricsTimer.schedule((TimerTask)this.scheduleOMMetricsWriteTask, 0L, period);
        this.initializeRatisServer(false);
        if (this.omRatisServer != null) {
            this.omRatisServer.start();
        }
        this.omRpcServer = this.getRpcServer(this.configuration);
        try {
            this.httpServer = new OzoneManagerHttpServer((MutableConfigurationSource)this.configuration, this);
            this.httpServer.start();
        }
        catch (Exception ex) {
            LOG.error("OM HttpServer failed to start.", (Throwable)ex);
        }
        this.omRpcServer.start();
        this.isOmRpcServerRunning = true;
        this.startTrashEmptier((Configuration)this.configuration);
        this.registerMXBean();
        this.startJVMPauseMonitor();
        this.setStartTime();
        this.omState = State.RUNNING;
    }

    public void bootstrap(OMNodeDetails newOMNode) throws IOException {
        block10: {
            if (this.isRatisEnabled) {
                Throwable throwable = null;
                Object var3_4 = null;
                try (OMInterServiceProtocolClientSideImpl omInterServiceProtocol = new OMInterServiceProtocolClientSideImpl((ConfigurationSource)this.configuration, OzoneManager.getRemoteUser(), this.getOMServiceId());){
                    omInterServiceProtocol.bootstrap(this.omNodeDetails);
                    LOG.info("Successfully bootstrapped OM {} and joined the Ratis group {}", (Object)this.getOMNodeId(), (Object)this.omRatisServer.getRaftGroup());
                    break block10;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            throw new IOException("OzoneManager can be bootstrapped only when ratis is enabled and there is atleast one OzoneManager to bootstrap from.");
        }
    }

    public void updatePeerList(List<String> omNodeIds) {
        List<String> ratisServerPeerIdsList = this.omRatisServer.getPeerIds();
        for (String omNodeId : omNodeIds) {
            if (!this.peerNodesMap.containsKey(omNodeId) && !this.isCurrentNode(omNodeId)) {
                this.addOMNodeToPeers(omNodeId);
                continue;
            }
            if (ratisServerPeerIdsList.contains(omNodeId)) continue;
            if (this.isCurrentNode(omNodeId)) {
                this.omRatisServer.addRaftPeer(this.omNodeDetails);
                continue;
            }
            this.omRatisServer.addRaftPeer(this.peerNodesMap.get(omNodeId));
        }
    }

    private boolean isCurrentNode(String omNodeID) {
        return this.getOMNodeId().equals(omNodeID);
    }

    public void addOMNodeToPeers(String newOMNodeId) {
        OMNodeDetails newOMNodeDetails = OMNodeDetails.getOMNodeDetailsFromConf((OzoneConfiguration)this.getConfiguration(), (String)this.getOMServiceId(), (String)newOMNodeId);
        if (newOMNodeDetails == null) {
            this.setConfiguration(new OzoneConfiguration());
            newOMNodeDetails = OMNodeDetails.getOMNodeDetailsFromConf((OzoneConfiguration)this.getConfiguration(), (String)this.getOMServiceId(), (String)newOMNodeId);
            if (newOMNodeDetails == null) {
                throw new OzoneIllegalArgumentException("There is no OM configuration for node ID " + newOMNodeId + " in ozone-site.xml.");
            }
        }
        if (this.omSnapshotProvider == null) {
            this.omSnapshotProvider = new OzoneManagerSnapshotProvider((MutableConfigurationSource)this.configuration, this.omRatisSnapshotDir, this.peerNodesMap);
        } else {
            this.omSnapshotProvider.addNewPeerNode(newOMNodeDetails);
        }
        this.omRatisServer.addRaftPeer(newOMNodeDetails);
        this.peerNodesMap.put(newOMNodeId, newOMNodeDetails);
        LOG.info("Added OM {} to the Peer list.", (Object)newOMNodeId);
    }

    @VisibleForTesting
    public boolean doesPeerExist(String omNodeId) {
        if (this.getOMNodeId().equals(omNodeId)) {
            return true;
        }
        if (this.peerNodesMap != null && !this.peerNodesMap.isEmpty()) {
            return this.peerNodesMap.containsKey(omNodeId);
        }
        return false;
    }

    private void startTrashEmptier(Configuration conf) throws IOException {
        float hadoopTrashInterval = conf.getFloat("fs.trash.interval", 0.0f);
        long trashInterval = (long)(conf.getFloat("ozone.fs.trash.interval", hadoopTrashInterval) * 60000.0f);
        if (trashInterval == 0L) {
            LOG.info("Trash Interval set to 0. Files deleted will not move to trash");
            return;
        }
        if (trashInterval < 0L) {
            throw new IOException("Cannot start trash emptier with negative interval. Set fs.trash.interval to a positive value.");
        }
        final OzoneManager i = this;
        FileSystem fs = (FileSystem)SecurityUtil.doAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws IOException {
                return new TrashOzoneFileSystem(i);
            }
        });
        this.emptier = new Thread(new OzoneTrash(fs, conf, this).getEmptier(), "Trash Emptier");
        this.emptier.setDaemon(true);
        this.emptier.start();
    }

    private void initializeRatisServer(boolean shouldBootstrap) throws IOException {
        if (this.isRatisEnabled) {
            if (this.omRatisServer == null) {
                RatisDropwizardExports.registerRatisMetricReporters(this.ratisMetricsMap);
                this.omRatisServer = OzoneManagerRatisServer.newOMRatisServer((ConfigurationSource)this.configuration, this, this.omNodeDetails, this.peerNodesMap, this.secConfig, this.certClient, shouldBootstrap);
            }
            LOG.info("OzoneManager Ratis server initialized at port {}", (Object)this.omRatisServer.getServerPort());
        } else {
            this.omRatisServer = null;
        }
    }

    public long getObjectIdFromTxId(long trxnId) {
        return OmUtils.getObjectIdFromTxId((long)this.metadataManager.getOmEpoch(), (long)trxnId);
    }

    @VisibleForTesting
    long getLastTrxnIndexForNonRatis() throws IOException {
        TransactionInfo transactionInfo = TransactionInfo.readTransactionInfo((DBStoreHAManager)this.metadataManager);
        if (transactionInfo == null || transactionInfo.getTerm() != -1L) {
            return 0L;
        }
        return transactionInfo.getTransactionIndex();
    }

    private Integer getLayoutVersionInDB() throws IOException {
        String layoutVersion = (String)this.metadataManager.getMetaTable().get((Object)"#LAYOUTVERSION");
        return layoutVersion == null ? null : Integer.valueOf(Integer.parseInt(layoutVersion));
    }

    public RatisSnapshotInfo getSnapshotInfo() {
        return this.omRatisSnapshotInfo;
    }

    public long getRatisSnapshotIndex() throws IOException {
        TransactionInfo dbTxnInfo = TransactionInfo.readTransactionInfo((DBStoreHAManager)this.metadataManager);
        if (dbTxnInfo == null) {
            return 0L;
        }
        return dbTxnInfo.getTransactionIndex();
    }

    public void stop() {
        LOG.info("Stopping Ozone Manager");
        try {
            this.omState = State.STOPPED;
            if (this.metricsTimer != null) {
                this.metricsTimer.cancel();
                this.metricsTimer = null;
                this.scheduleOMMetricsWriteTask = null;
            }
            this.omRpcServer.stop();
            if (!this.isRatisEnabled) {
                this.omServerProtocol.stop();
            }
            if (this.omRatisServer != null) {
                this.omRatisServer.stop();
                this.omRatisServer = null;
            }
            this.isOmRpcServerRunning = false;
            this.keyManager.stop();
            this.stopSecretManager();
            if (this.httpServer != null) {
                this.httpServer.stop();
            }
            this.stopTrashEmptier();
            this.metadataManager.stop();
            this.metrics.unRegister();
            this.omClientProtocolMetrics.unregister();
            this.unregisterMXBean();
            if (this.jvmPauseMonitor != null) {
                this.jvmPauseMonitor.stop();
            }
            if (this.omSnapshotProvider != null) {
                this.omSnapshotProvider.stop();
            }
            this.omState = State.STOPPED;
        }
        catch (Exception e) {
            LOG.error("OzoneManager stop failed.", (Throwable)e);
        }
    }

    public void join() {
        try {
            this.omRpcServer.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info("Interrupted during OzoneManager join.", (Throwable)e);
        }
    }

    private void startSecretManagerIfNecessary() {
        boolean shouldRun = OzoneManager.isOzoneSecurityEnabled();
        if (shouldRun) {
            boolean running;
            boolean bl = running = this.delegationTokenMgr.isRunning() && this.blockTokenMgr.isRunning();
            if (!running) {
                this.startSecretManager();
            }
        }
    }

    private static void getSCMSignedCert(CertificateClient client, OzoneConfiguration config, OMStorage omStore, String scmId) throws IOException {
        CertificateSignRequest.Builder builder = client.getCSRBuilder();
        KeyPair keyPair = new KeyPair(client.getPublicKey(), client.getPrivateKey());
        InetSocketAddress omRpcAdd = OmUtils.getOmAddress((ConfigurationSource)config);
        if (omRpcAdd == null || omRpcAdd.getAddress() == null) {
            LOG.error("Incorrect om rpc address. omRpcAdd:{}", (Object)omRpcAdd);
            throw new RuntimeException("Can't get SCM signed certificate. omRpcAdd: " + omRpcAdd);
        }
        String hostname = omRpcAdd.getAddress().getHostName();
        String ip = omRpcAdd.getAddress().getHostAddress();
        String subject = builder.hasDnsName() ? String.valueOf(UserGroupInformation.getCurrentUser().getShortUserName()) + "@" + hostname : hostname;
        builder.setCA(Boolean.valueOf(false)).setKey(keyPair).setConfiguration((ConfigurationSource)config).setScmID(scmId).setClusterID(omStore.getClusterID()).setSubject(subject);
        OMHANodeDetails haOMHANodeDetails = OMHANodeDetails.loadOMHAConfig(config);
        String serviceName = haOMHANodeDetails.getLocalNodeDetails().getServiceId();
        if (!StringUtils.isEmpty((CharSequence)serviceName)) {
            builder.addServiceName(serviceName);
        }
        LOG.info("Creating csr for OM->dns:{},ip:{},scmId:{},clusterId:{},subject:{}", new Object[]{hostname, ip, scmId, omStore.getClusterID(), subject});
        HddsProtos.OzoneManagerDetailsProto.Builder omDetailsProtoBuilder = HddsProtos.OzoneManagerDetailsProto.newBuilder().setHostName(omRpcAdd.getHostName()).setIpAddress(ip).setUuid(omStore.getOmId()).addPorts(HddsProtos.Port.newBuilder().setName("RPC").setValue(omRpcAdd.getPort()).build());
        PKCS10CertificationRequest csr = builder.build();
        HddsProtos.OzoneManagerDetailsProto omDetailsProto = omDetailsProtoBuilder.build();
        LOG.info("OzoneManager ports added:{}", (Object)omDetailsProto.getPortsList());
        SCMSecurityProtocolClientSideTranslatorPB secureScmClient = HddsServerUtil.getScmSecurityClientWithFixedDuration((OzoneConfiguration)config);
        SCMSecurityProtocolProtos.SCMGetCertResponseProto response = secureScmClient.getOMCertChain(omDetailsProto, CertificateSignRequest.getEncodedString((PKCS10CertificationRequest)csr));
        String pemEncodedCert = response.getX509Certificate();
        try {
            if (response.hasX509CACertificate()) {
                String pemEncodedRootCert = response.getX509CACertificate();
                client.storeCertificate(pemEncodedRootCert, true, true);
                client.storeCertificate(pemEncodedCert, true);
                if (response.hasX509RootCACertificate()) {
                    client.storeRootCACertificate(response.getX509RootCACertificate(), true);
                }
            } else {
                throw new RuntimeException("Unable to retrieve OM certificate chain");
            }
            omStore.setOmCertSerialId(CertificateCodec.getX509Certificate((String)pemEncodedCert).getSerialNumber().toString());
        }
        catch (IOException | CertificateException e) {
            LOG.error("Error while storing SCM signed certificate.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean isAllowedDelegationTokenOp() throws IOException {
        UserGroupInformation.AuthenticationMethod authMethod = this.getConnectionAuthenticationMethod();
        return !UserGroupInformation.isSecurityEnabled() || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS_SSL || authMethod == UserGroupInformation.AuthenticationMethod.CERTIFICATE;
    }

    private UserGroupInformation.AuthenticationMethod getConnectionAuthenticationMethod() throws IOException {
        UserGroupInformation ugi = OzoneManager.getRemoteUser();
        UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == UserGroupInformation.AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod;
    }

    private static UserGroupInformation getRemoteUser() throws IOException {
        UserGroupInformation ugi = Server.getRemoteUser();
        return ugi != null ? ugi : UserGroupInformation.getCurrentUser();
    }

    public Token<OzoneTokenIdentifier> getDelegationToken(Text renewer) throws OMException {
        block6: {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new OMException("Delegation Token can be issued only with kerberos or web authentication", OMException.ResultCodes.INVALID_AUTH_METHOD);
            }
            if (this.delegationTokenMgr != null && this.delegationTokenMgr.isRunning()) break block6;
            LOG.warn("trying to get DT with no secret manager running in OM.");
            return null;
        }
        try {
            UserGroupInformation ugi = OzoneManager.getRemoteUser();
            String user = ugi.getUserName();
            Text owner = new Text(user);
            Text realUser = null;
            if (ugi.getRealUser() != null) {
                realUser = new Text(ugi.getRealUser().getUserName());
            }
            return this.delegationTokenMgr.createToken(owner, renewer, realUser);
        }
        catch (OMException oex) {
            throw oex;
        }
        catch (IOException ex) {
            LOG.error("Get Delegation token failed, cause: {}", (Object)ex.getMessage());
            throw new OMException("Get Delegation token failed.", (Throwable)ex, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
    }

    public long renewDelegationToken(Token<OzoneTokenIdentifier> token) throws OMException {
        long expiryTime;
        try {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new OMException("Delegation Token can be renewed only with kerberos or web authentication", OMException.ResultCodes.INVALID_AUTH_METHOD);
            }
            String renewer = OzoneManager.getRemoteUser().getShortUserName();
            expiryTime = this.delegationTokenMgr.renewToken(token, renewer);
        }
        catch (OMException oex) {
            throw oex;
        }
        catch (IOException ex) {
            OzoneTokenIdentifier id = null;
            try {
                id = OzoneTokenIdentifier.readProtoBuf((byte[])token.getIdentifier());
            }
            catch (IOException iOException) {}
            LOG.error("Delegation token renewal failed for dt id: {}, cause: {}", (Object)id, (Object)ex.getMessage());
            throw new OMException("Delegation token renewal failed for dt: " + token, (Throwable)ex, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
        return expiryTime;
    }

    public void cancelDelegationToken(Token<OzoneTokenIdentifier> token) throws OMException {
        OzoneTokenIdentifier id = null;
        try {
            String canceller = OzoneManager.getRemoteUser().getUserName();
            id = this.delegationTokenMgr.cancelToken(token, canceller);
            LOG.trace("Delegation token cancelled for dt: {}", (Object)id);
        }
        catch (OMException oex) {
            throw oex;
        }
        catch (IOException ex) {
            LOG.error("Delegation token cancellation failed for dt id: {}, cause: {}", id, (Object)ex.getMessage());
            throw new OMException("Delegation token renewal failed for dt: " + token, (Throwable)ex, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
    }

    public void createVolume(OmVolumeArgs args) throws IOException {
        try {
            this.metrics.incNumVolumeCreates();
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.CREATE, args.getVolume(), null, null);
            }
            this.volumeManager.createVolume(args);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.CREATE_VOLUME, args == null ? null : args.toAuditMap()));
            this.metrics.incNumVolumes();
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeCreateFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.CREATE_VOLUME, args == null ? null : args.toAuditMap(), ex));
            throw ex;
        }
    }

    private void checkAcls(OzoneObj.ResourceType resType, OzoneObj.StoreType store, IAccessAuthorizer.ACLType acl, String vol, String bucket, String key) throws IOException {
        UserGroupInformation user = ProtobufRpcEngine.Server.getRemoteUser();
        InetAddress remoteIp = ProtobufRpcEngine.Server.getRemoteIp();
        this.checkAcls(resType, store, acl, vol, bucket, key, user != null ? user : OzoneManager.getRemoteUser(), remoteIp != null ? remoteIp : this.omRpcAddress.getAddress(), remoteIp != null ? remoteIp.getHostName() : this.omRpcAddress.getHostName(), true, this.getVolumeOwner(vol, acl, resType));
    }

    private boolean hasAcls(String userName, OzoneObj.ResourceType resType, OzoneObj.StoreType store, IAccessAuthorizer.ACLType acl, String vol, String bucket, String key) {
        try {
            return this.checkAcls(resType, store, acl, vol, bucket, key, UserGroupInformation.createRemoteUser((String)userName), ProtobufRpcEngine.Server.getRemoteIp(), ProtobufRpcEngine.Server.getRemoteIp().getHostName(), false, this.getVolumeOwner(vol, acl, resType));
        }
        catch (OMException oMException) {
            return false;
        }
    }

    public String getVolumeOwner(String vol, IAccessAuthorizer.ACLType type, OzoneObj.ResourceType resType) throws OMException {
        String volOwnerName = null;
        if (!(vol.equals("/") || type == IAccessAuthorizer.ACLType.CREATE && resType == OzoneObj.ResourceType.VOLUME)) {
            volOwnerName = this.getVolumeOwner(vol);
        }
        return volOwnerName;
    }

    private String getVolumeOwner(String volume) throws OMException {
        Boolean lockAcquired = this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
        OmVolumeArgs volumeArgs = null;
        try {
            try {
                volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
            }
            catch (IOException ioe) {
                if (ioe instanceof OMException) {
                    throw (OMException)((Object)ioe);
                }
                throw new OMException("getVolumeOwner for Volume " + volume + " failed", OMException.ResultCodes.INTERNAL_ERROR);
            }
        }
        catch (Throwable throwable) {
            if (lockAcquired.booleanValue()) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            }
            throw throwable;
        }
        if (lockAcquired.booleanValue()) {
            this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        }
        if (volumeArgs != null) {
            return volumeArgs.getOwnerName();
        }
        throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
    }

    public boolean checkAcls(OzoneObj.ResourceType resType, OzoneObj.StoreType storeType, IAccessAuthorizer.ACLType aclType, String vol, String bucket, String key, UserGroupInformation ugi, InetAddress remoteAddress, String hostName, boolean throwIfPermissionDenied, String volumeOwner) throws OMException {
        OzoneObjInfo obj = OzoneObjInfo.Builder.newBuilder().setResType(resType).setStoreType(storeType).setVolumeName(vol).setBucketName(bucket).setKeyName(key).build();
        RequestContext context = RequestContext.newBuilder().setClientUgi(ugi).setIp(remoteAddress).setHost(hostName).setAclType(IAccessAuthorizer.ACLIdentityType.USER).setAclRights(aclType).setOwnerName(volumeOwner).build();
        return this.checkAcls((OzoneObj)obj, context, throwIfPermissionDenied);
    }

    public boolean checkAcls(OzoneObj obj, RequestContext context, boolean throwIfPermissionDenied) throws OMException {
        if (!this.accessAuthorizer.checkAccess((IOzoneObj)obj, context)) {
            if (throwIfPermissionDenied) {
                LOG.warn("User {} doesn't have {} permission to access {} /{}/{}/{}", new Object[]{context.getClientUgi().getUserName(), context.getAclRights(), obj.getResourceType(), obj.getVolumeName(), obj.getBucketName(), obj.getKeyName()});
                throw new OMException("User " + context.getClientUgi().getUserName() + " doesn't have " + context.getAclRights() + " permission to access " + obj.getResourceType() + " " + obj.getVolumeName() + " " + obj.getBucketName() + " " + obj.getKeyName(), OMException.ResultCodes.PERMISSION_DENIED);
            }
            return false;
        }
        return true;
    }

    public boolean getAclsEnabled() {
        return this.isAclEnabled;
    }

    public boolean isSpnegoEnabled() {
        return this.isSpnegoEnabled;
    }

    public boolean setOwner(String volume, String owner) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, null, null);
        }
        Map<String, String> auditMap = this.buildAuditMap(volume);
        auditMap.put("owner", owner);
        try {
            this.metrics.incNumVolumeUpdates();
            this.volumeManager.setOwner(volume, owner);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.SET_OWNER, auditMap));
            return true;
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeUpdateFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.SET_OWNER, auditMap, ex));
            throw ex;
        }
    }

    public void setQuota(String volume, long quotaInNamespace, long quotaInBytes) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented. As this requests use a new approach");
    }

    public boolean checkVolumeAccess(String volume, OzoneManagerProtocolProtos.OzoneAclInfo userAcl) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, volume, null, null);
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volume);
        auditMap.put("userAcl", userAcl == null ? null : userAcl.getName());
        try {
            this.metrics.incNumVolumeCheckAccesses();
            boolean bl = this.volumeManager.checkVolumeAccess(volume, userAcl);
            return bl;
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeCheckAccessFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.CHECK_VOLUME_ACCESS, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.CHECK_VOLUME_ACCESS, auditMap));
            }
        }
    }

    public OmVolumeArgs getVolumeInfo(String volume) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, volume, null, null);
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volume);
        try {
            this.metrics.incNumVolumeInfos();
            OmVolumeArgs omVolumeArgs = this.volumeManager.getVolumeInfo(volume);
            return omVolumeArgs;
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeInfoFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.READ_VOLUME, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.READ_VOLUME, auditMap));
            }
        }
    }

    public void deleteVolume(String volume) throws IOException {
        try {
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.DELETE, volume, null, null);
            }
            this.metrics.incNumVolumeDeletes();
            this.volumeManager.deleteVolume(volume);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.DELETE_VOLUME, this.buildAuditMap(volume)));
            this.metrics.decNumVolumes();
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeDeleteFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.DELETE_VOLUME, this.buildAuditMap(volume), ex));
            throw ex;
        }
    }

    public List<OmVolumeArgs> listVolumeByUser(String userName, String prefix, String prevKey, int maxKeys) throws IOException {
        UserGroupInformation remoteUserUgi = ProtobufRpcEngine.Server.getRemoteUser();
        if (this.isAclEnabled && remoteUserUgi == null) {
            LOG.error("Rpc user UGI is null. Authorization failed.");
            throw new OMException("Rpc user UGI is null. Authorization failed.", OMException.ResultCodes.PERMISSION_DENIED);
        }
        boolean auditSuccess = true;
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("prevKey", prevKey);
        auditMap.put("prefix", prefix);
        auditMap.put("maxKeys", String.valueOf(maxKeys));
        auditMap.put("username", userName);
        try {
            this.metrics.incNumVolumeLists();
            if (this.isAclEnabled) {
                List<OmVolumeArgs> listAllVolumes = this.volumeManager.listVolumes(null, prefix, prevKey, maxKeys);
                ArrayList<OmVolumeArgs> result = new ArrayList<OmVolumeArgs>();
                for (OmVolumeArgs volumeArgs : listAllVolumes) {
                    if (!this.hasAcls(userName, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.LIST, volumeArgs.getVolume(), null, null)) continue;
                    result.add(volumeArgs);
                }
                ArrayList<OmVolumeArgs> arrayList = result;
                return arrayList;
            }
            List<OmVolumeArgs> list = this.volumeManager.listVolumes(userName, prefix, prevKey, maxKeys);
            return list;
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_VOLUMES, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_VOLUMES, auditMap));
            }
        }
    }

    public List<OmVolumeArgs> listAllVolumes(String prefix, String prevKey, int maxKeys) throws IOException {
        boolean auditSuccess = true;
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("prevKey", prevKey);
        auditMap.put("prefix", prefix);
        auditMap.put("maxKeys", String.valueOf(maxKeys));
        auditMap.put("username", null);
        try {
            this.metrics.incNumVolumeLists();
            if (!this.allowListAllVolumes && this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.LIST, "/", null, null);
            }
            List<OmVolumeArgs> list = this.volumeManager.listVolumes(null, prefix, prevKey, maxKeys);
            return list;
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_VOLUMES, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_VOLUMES, auditMap));
            }
        }
    }

    public void createBucket(OmBucketInfo bucketInfo) throws IOException {
        try {
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.CREATE, bucketInfo.getVolumeName(), bucketInfo.getBucketName(), null);
            }
            this.metrics.incNumBucketCreates();
            this.bucketManager.createBucket(bucketInfo);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.CREATE_BUCKET, bucketInfo == null ? null : bucketInfo.toAuditMap()));
            this.metrics.incNumBuckets();
        }
        catch (Exception ex) {
            this.metrics.incNumBucketCreateFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.CREATE_BUCKET, bucketInfo == null ? null : bucketInfo.toAuditMap(), ex));
            throw ex;
        }
    }

    public List<OmBucketInfo> listBuckets(String volumeName, String startKey, String prefix, int maxNumOfBuckets) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.LIST, volumeName, null, null);
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volumeName);
        auditMap.put("startKey", startKey);
        auditMap.put("prefix", prefix);
        auditMap.put("maxNumOfBuckets", String.valueOf(maxNumOfBuckets));
        try {
            this.metrics.incNumBucketLists();
            List<OmBucketInfo> list = this.bucketManager.listBuckets(volumeName, startKey, prefix, maxNumOfBuckets);
            return list;
        }
        catch (IOException ex) {
            this.metrics.incNumBucketListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_BUCKETS, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_BUCKETS, auditMap));
            }
        }
    }

    public OmBucketInfo getBucketInfo(String volume, String bucket) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, volume, bucket, null);
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volume);
        auditMap.put("bucket", bucket);
        try {
            this.metrics.incNumBucketInfos();
            OmBucketInfo omBucketInfo = this.bucketManager.getBucketInfo(volume, bucket);
            return omBucketInfo;
        }
        catch (Exception ex) {
            this.metrics.incNumBucketInfoFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.READ_BUCKET, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.READ_BUCKET, auditMap));
            }
        }
    }

    public OpenKeySession openKey(OmKeyArgs args) throws IOException {
        ResolvedBucket bucket = this.resolveBucketLink(args);
        if (this.isAclEnabled) {
            try {
                this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, bucket.realVolume(), bucket.realBucket(), args.getKeyName());
            }
            catch (OMException ex) {
                if (ex.getResult().equals((Object)OMException.ResultCodes.KEY_NOT_FOUND)) {
                    this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, bucket.realVolume(), bucket.realBucket(), args.getKeyName());
                }
                throw ex;
            }
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = bucket.audit(args.toAuditMap());
        args = bucket.update(args);
        try {
            this.metrics.incNumKeyAllocates();
            OpenKeySession openKeySession = this.keyManager.openKey(args);
            return openKeySession;
        }
        catch (Exception ex) {
            this.metrics.incNumKeyAllocateFails();
            auditSuccess = false;
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.ALLOCATE_KEY, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.ALLOCATE_KEY, auditMap));
            }
        }
    }

    public void commitKey(OmKeyArgs args, long clientID) throws IOException {
        ResolvedBucket bucket = this.resolveBucketLink(args);
        if (this.isAclEnabled) {
            try {
                this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, bucket.realVolume(), bucket.realBucket(), args.getKeyName());
            }
            catch (OMException ex) {
                if (ex.getResult().equals((Object)OMException.ResultCodes.KEY_NOT_FOUND)) {
                    this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, bucket.realVolume(), bucket.realBucket(), args.getKeyName());
                }
                throw ex;
            }
        }
        Map<String, String> auditMap = bucket.audit(args.toAuditMap());
        auditMap.put("clientID", String.valueOf(clientID));
        args = bucket.update(args);
        try {
            this.metrics.incNumKeyCommits();
            this.keyManager.commitKey(args, clientID);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.COMMIT_KEY, auditMap));
            if (args.getLocationInfoList() != null && args.getLocationInfoList().size() > 0 && args.getLocationInfoList().get(0) != null && ((OmKeyLocationInfo)args.getLocationInfoList().get(0)).getCreateVersion() == 0L) {
                this.metrics.incNumKeys();
            }
        }
        catch (Exception ex) {
            this.metrics.incNumKeyCommitFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.COMMIT_KEY, auditMap, ex));
            throw ex;
        }
    }

    public OmKeyLocationInfo allocateBlock(OmKeyArgs args, long clientID, ExcludeList excludeList) throws IOException {
        ResolvedBucket bucket = this.resolveBucketLink(args);
        if (this.isAclEnabled) {
            try {
                this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, bucket.realVolume(), bucket.realBucket(), args.getKeyName());
            }
            catch (OMException ex) {
                if (ex.getResult().equals((Object)OMException.ResultCodes.KEY_NOT_FOUND)) {
                    this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, bucket.realVolume(), bucket.realBucket(), args.getKeyName());
                }
                throw ex;
            }
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = bucket.audit(args.toAuditMap());
        auditMap.put("clientID", String.valueOf(clientID));
        args = bucket.update(args);
        try {
            this.metrics.incNumBlockAllocateCalls();
            OmKeyLocationInfo omKeyLocationInfo = this.keyManager.allocateBlock(args, clientID, excludeList);
            return omKeyLocationInfo;
        }
        catch (Exception ex) {
            this.metrics.incNumBlockAllocateCallFails();
            auditSuccess = false;
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.ALLOCATE_BLOCK, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.ALLOCATE_BLOCK, auditMap));
            }
        }
    }

    public OmKeyInfo lookupKey(OmKeyArgs args) throws IOException {
        ResolvedBucket bucket = this.resolveBucketLink(args);
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, bucket.realVolume(), bucket.realBucket(), args.getKeyName());
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = bucket.audit(args.toAuditMap());
        args = bucket.update(args);
        try {
            this.metrics.incNumKeyLookups();
            OmKeyInfo omKeyInfo = this.keyManager.lookupKey(args, OzoneManager.getClientAddress());
            return omKeyInfo;
        }
        catch (Exception ex) {
            this.metrics.incNumKeyLookupFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.READ_KEY, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.READ_KEY, auditMap));
            }
        }
    }

    public void renameKeys(OmRenameKeys omRenameKeys) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented. As write requests use a new approach");
    }

    public void renameKey(OmKeyArgs args, String toKeyName) throws IOException {
        Preconditions.checkNotNull((Object)args);
        ResolvedBucket bucket = this.resolveBucketLink(args);
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, bucket.realVolume(), bucket.realBucket(), args.getKeyName());
        }
        Map<String, String> auditMap = bucket.audit(args.toAuditMap());
        auditMap.put("toKeyName", toKeyName);
        args = bucket.update(args);
        try {
            this.metrics.incNumKeyRenames();
            this.keyManager.renameKey(args, toKeyName);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.RENAME_KEY, auditMap));
        }
        catch (IOException e) {
            this.metrics.incNumKeyRenameFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.RENAME_KEY, auditMap, e));
            throw e;
        }
    }

    public void deleteKey(OmKeyArgs args) throws IOException {
        Map auditMap = args.toAuditMap();
        try {
            ResolvedBucket bucket = this.resolveBucketLink(args);
            args = bucket.update(args);
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.DELETE, bucket.realVolume(), bucket.realBucket(), args.getKeyName());
            }
            this.metrics.incNumKeyDeletes();
            this.keyManager.deleteKey(args);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.DELETE_KEY, auditMap));
            this.metrics.decNumKeys();
        }
        catch (Exception ex) {
            this.metrics.incNumKeyDeleteFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.DELETE_KEY, auditMap, ex));
            throw ex;
        }
    }

    public void deleteKeys(OmDeleteKeys deleteKeys) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented. As write requests use a new approach");
    }

    public List<OmKeyInfo> listKeys(String volumeName, String bucketName, String startKey, String keyPrefix, int maxKeys) throws IOException {
        ResolvedBucket bucket = this.resolveBucketLink((Pair<String, String>)Pair.of((Object)volumeName, (Object)bucketName));
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.LIST, bucket.realVolume(), bucket.realBucket(), keyPrefix);
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = bucket.audit();
        auditMap.put("startKey", startKey);
        auditMap.put("maxKeys", String.valueOf(maxKeys));
        auditMap.put("keyPrefix", keyPrefix);
        try {
            this.metrics.incNumKeyLists();
            List<OmKeyInfo> list = this.keyManager.listKeys(bucket.realVolume(), bucket.realBucket(), startKey, keyPrefix, maxKeys);
            return list;
        }
        catch (IOException ex) {
            this.metrics.incNumKeyListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_KEYS, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_KEYS, auditMap));
            }
        }
    }

    public List<RepeatedOmKeyInfo> listTrash(String volumeName, String bucketName, String startKeyName, String keyPrefix, int maxKeys) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.LIST, volumeName, bucketName, keyPrefix);
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volumeName);
        auditMap.put("bucket", bucketName);
        auditMap.put("startKey", startKeyName);
        auditMap.put("keyPrefix", keyPrefix);
        auditMap.put("maxKeys", String.valueOf(maxKeys));
        try {
            this.metrics.incNumTrashKeyLists();
            List<RepeatedOmKeyInfo> list = this.keyManager.listTrash(volumeName, bucketName, startKeyName, keyPrefix, maxKeys);
            return list;
        }
        catch (IOException ex) {
            this.metrics.incNumTrashKeyListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_TRASH, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_TRASH, auditMap));
            }
        }
    }

    public void setBucketProperty(OmBucketArgs args) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, args.getVolumeName(), args.getBucketName(), null);
        }
        try {
            this.metrics.incNumBucketUpdates();
            this.bucketManager.setBucketProperty(args);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.UPDATE_BUCKET, args == null ? null : args.toAuditMap()));
        }
        catch (Exception ex) {
            this.metrics.incNumBucketUpdateFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.UPDATE_BUCKET, args == null ? null : args.toAuditMap(), ex));
            throw ex;
        }
    }

    public void deleteBucket(String volume, String bucket) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volume, bucket, null);
        }
        Map<String, String> auditMap = this.buildAuditMap(volume);
        auditMap.put("bucket", bucket);
        try {
            this.metrics.incNumBucketDeletes();
            this.bucketManager.deleteBucket(volume, bucket);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.DELETE_BUCKET, auditMap));
            this.metrics.decNumBuckets();
        }
        catch (Exception ex) {
            this.metrics.incNumBucketDeleteFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.DELETE_BUCKET, auditMap, ex));
            throw ex;
        }
    }

    private Map<String, String> buildAuditMap(String volume) {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", volume);
        return auditMap;
    }

    public AuditLogger getAuditLogger() {
        return AUDIT;
    }

    public AuditMessage buildAuditMessageForSuccess(AuditAction op, Map<String, String> auditMap) {
        return new AuditMessage.Builder().setUser(ServerUtils.getRemoteUserName()).atIp(Server.getRemoteAddress()).forOperation(op).withParams(auditMap).withResult(AuditEventStatus.SUCCESS).build();
    }

    public AuditMessage buildAuditMessageForFailure(AuditAction op, Map<String, String> auditMap, Throwable throwable) {
        return new AuditMessage.Builder().setUser(ServerUtils.getRemoteUserName()).atIp(Server.getRemoteAddress()).forOperation(op).withParams(auditMap).withResult(AuditEventStatus.FAILURE).withException(throwable).build();
    }

    private void registerMXBean() {
        HashMap<String, String> jmxProperties = new HashMap<String, String>();
        jmxProperties.put("component", "ServerRuntime");
        this.omInfoBeanName = HddsUtils.registerWithJmxProperties((String)"OzoneManager", (String)"OzoneManagerInfo", jmxProperties, (Object)this);
    }

    private void unregisterMXBean() {
        if (this.omInfoBeanName != null) {
            MBeans.unregister((ObjectName)this.omInfoBeanName);
            this.omInfoBeanName = null;
        }
    }

    private static String getClientAddress() {
        String clientMachine = Server.getRemoteAddress();
        if (clientMachine == null) {
            clientMachine = "";
        }
        return clientMachine;
    }

    @Override
    public String getRpcPort() {
        return "" + this.omRpcAddress.getPort();
    }

    @VisibleForTesting
    public OzoneManagerHttpServer getHttpServer() {
        return this.httpServer;
    }

    public List<ServiceInfo> getServiceList() throws IOException {
        ArrayList<ServiceInfo> services = new ArrayList<ServiceInfo>();
        ServiceInfo.Builder omServiceInfoBuilder = ServiceInfo.newBuilder().setNodeType(HddsProtos.NodeType.OM).setHostname(this.omRpcAddress.getHostName()).addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.RPC).setValue(this.omRpcAddress.getPort()).build());
        if (this.httpServer != null && this.httpServer.getHttpAddress() != null) {
            omServiceInfoBuilder.addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.HTTP).setValue(this.httpServer.getHttpAddress().getPort()).build());
        }
        if (this.httpServer != null && this.httpServer.getHttpsAddress() != null) {
            omServiceInfoBuilder.addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.HTTPS).setValue(this.httpServer.getHttpsAddress().getPort()).build());
        }
        OzoneManagerProtocolProtos.OMRoleInfo omRole = OzoneManagerProtocolProtos.OMRoleInfo.newBuilder().setNodeId(this.getOMNodeId()).setServerRole(RaftProtos.RaftPeerRole.LEADER.name()).build();
        omServiceInfoBuilder.setOmRoleInfo(omRole);
        if (this.isRatisEnabled) {
            if (this.omRatisServer != null) {
                omServiceInfoBuilder.addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.RATIS).setValue(this.omNodeDetails.getRatisPort()).build());
            }
            for (OMNodeDetails peerNode : this.peerNodesMap.values()) {
                ServiceInfo.Builder peerOmServiceInfoBuilder = ServiceInfo.newBuilder().setNodeType(HddsProtos.NodeType.OM).setHostname(peerNode.getHostName()).addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.RPC).setValue(peerNode.getRpcPort()).build());
                OzoneManagerProtocolProtos.OMRoleInfo peerOmRole = OzoneManagerProtocolProtos.OMRoleInfo.newBuilder().setNodeId(peerNode.getNodeId()).setServerRole(RaftProtos.RaftPeerRole.FOLLOWER.name()).build();
                peerOmServiceInfoBuilder.setOmRoleInfo(peerOmRole);
                services.add(peerOmServiceInfoBuilder.build());
            }
        }
        services.add(omServiceInfoBuilder.build());
        Collection scmAddresses = HddsUtils.getScmAddressForClients((ConfigurationSource)this.configuration);
        for (InetSocketAddress scmAddr : scmAddresses) {
            ServiceInfo.Builder scmServiceInfoBuilder = ServiceInfo.newBuilder().setNodeType(HddsProtos.NodeType.SCM).setHostname(scmAddr.getHostName()).addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.RPC).setValue(scmAddr.getPort()).build());
            services.add(scmServiceInfoBuilder.build());
        }
        this.metrics.incNumGetServiceLists();
        return services;
    }

    public ServiceInfoEx getServiceInfo() throws IOException {
        return new ServiceInfoEx(this.getServiceList(), this.caCertPem, this.caCertPemList);
    }

    public UpgradeFinalizer.StatusAndMessages finalizeUpgrade(String upgradeClientID) throws IOException {
        return this.upgradeFinalizer.finalize(upgradeClientID, (Object)this);
    }

    public UpgradeFinalizer.StatusAndMessages queryUpgradeFinalizationProgress(String upgradeClientID, boolean takeover, boolean readonly) throws IOException {
        if (readonly) {
            return new UpgradeFinalizer.StatusAndMessages(this.upgradeFinalizer.getStatus(), Collections.emptyList());
        }
        return this.upgradeFinalizer.reportStatus(upgradeClientID, takeover);
    }

    public S3SecretValue getS3Secret(String kerberosID) throws IOException {
        UserGroupInformation user = ProtobufRpcEngine.Server.getRemoteUser();
        if (!user.getUserName().equals(kerberosID)) {
            throw new OMException("User mismatch. Requested user name is mismatched " + kerberosID + ", with current user " + user.getUserName(), OMException.ResultCodes.USER_MISMATCH);
        }
        return this.s3SecretManager.getS3Secret(kerberosID);
    }

    public void revokeS3Secret(String kerberosID) {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented. As write requests use a new approach");
    }

    public OmMultipartInfo initiateMultipartUpload(OmKeyArgs keyArgs) throws IOException {
        Preconditions.checkNotNull((Object)keyArgs);
        ResolvedBucket bucket = this.resolveBucketLink(keyArgs);
        Map<String, String> auditMap = bucket.audit(keyArgs.toAuditMap());
        keyArgs = bucket.update(keyArgs);
        this.metrics.incNumInitiateMultipartUploads();
        try {
            OmMultipartInfo result = this.keyManager.initiateMultipartUpload(keyArgs);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.INITIATE_MULTIPART_UPLOAD, auditMap));
            return result;
        }
        catch (IOException ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.INITIATE_MULTIPART_UPLOAD, auditMap, ex));
            this.metrics.incNumInitiateMultipartUploadFails();
            throw ex;
        }
    }

    public OmMultipartCommitUploadPartInfo commitMultipartUploadPart(OmKeyArgs keyArgs, long clientID) throws IOException {
        Preconditions.checkNotNull((Object)keyArgs);
        ResolvedBucket bucket = this.resolveBucketLink(keyArgs);
        Map<String, String> auditMap = bucket.audit(keyArgs.toAuditMap());
        keyArgs = bucket.update(keyArgs);
        this.metrics.incNumCommitMultipartUploadParts();
        try {
            OmMultipartCommitUploadPartInfo result = this.keyManager.commitMultipartUploadPart(keyArgs, clientID);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.COMMIT_MULTIPART_UPLOAD_PARTKEY, auditMap));
            return result;
        }
        catch (IOException ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.INITIATE_MULTIPART_UPLOAD, auditMap, ex));
            this.metrics.incNumCommitMultipartUploadPartFails();
            throw ex;
        }
    }

    public OmMultipartUploadCompleteInfo completeMultipartUpload(OmKeyArgs omKeyArgs, OmMultipartUploadCompleteList multipartUploadList) throws IOException {
        Preconditions.checkNotNull((Object)omKeyArgs);
        ResolvedBucket bucket = this.resolveBucketLink(omKeyArgs);
        Map<String, String> auditMap = bucket.audit(omKeyArgs.toAuditMap());
        auditMap.put("multipartList", multipartUploadList.getMultipartMap().toString());
        omKeyArgs = bucket.update(omKeyArgs);
        this.metrics.incNumCompleteMultipartUploads();
        try {
            OmMultipartUploadCompleteInfo result = this.keyManager.completeMultipartUpload(omKeyArgs, multipartUploadList);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.COMPLETE_MULTIPART_UPLOAD, auditMap));
            return result;
        }
        catch (IOException ex) {
            this.metrics.incNumCompleteMultipartUploadFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.COMPLETE_MULTIPART_UPLOAD, auditMap, ex));
            throw ex;
        }
    }

    public void abortMultipartUpload(OmKeyArgs omKeyArgs) throws IOException {
        Preconditions.checkNotNull((Object)omKeyArgs);
        ResolvedBucket bucket = this.resolveBucketLink(omKeyArgs);
        Map<String, String> auditMap = bucket.audit(omKeyArgs.toAuditMap());
        omKeyArgs = bucket.update(omKeyArgs);
        this.metrics.incNumAbortMultipartUploads();
        try {
            this.keyManager.abortMultipartUpload(omKeyArgs);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.COMPLETE_MULTIPART_UPLOAD, auditMap));
        }
        catch (IOException ex) {
            this.metrics.incNumAbortMultipartUploadFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.COMPLETE_MULTIPART_UPLOAD, auditMap, ex));
            throw ex;
        }
    }

    public OmMultipartUploadListParts listParts(String volumeName, String bucketName, String keyName, String uploadID, int partNumberMarker, int maxParts) throws IOException {
        ResolvedBucket bucket = this.resolveBucketLink((Pair<String, String>)Pair.of((Object)volumeName, (Object)bucketName));
        Map<String, String> auditMap = bucket.audit();
        auditMap.put("key", keyName);
        auditMap.put("uploadID", uploadID);
        auditMap.put("partNumberMarker", Integer.toString(partNumberMarker));
        auditMap.put("maxParts", Integer.toString(maxParts));
        this.metrics.incNumListMultipartUploadParts();
        try {
            OmMultipartUploadListParts omMultipartUploadListParts = this.keyManager.listParts(bucket.realVolume(), bucket.realBucket(), keyName, uploadID, partNumberMarker, maxParts);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_MULTIPART_UPLOAD_PARTS, auditMap));
            return omMultipartUploadListParts;
        }
        catch (IOException ex) {
            this.metrics.incNumListMultipartUploadPartFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_MULTIPART_UPLOAD_PARTS, auditMap, ex));
            throw ex;
        }
    }

    public OmMultipartUploadList listMultipartUploads(String volumeName, String bucketName, String prefix) throws IOException {
        ResolvedBucket bucket = this.resolveBucketLink((Pair<String, String>)Pair.of((Object)volumeName, (Object)bucketName));
        Map<String, String> auditMap = bucket.audit();
        auditMap.put("prefix", prefix);
        this.metrics.incNumListMultipartUploads();
        try {
            OmMultipartUploadList omMultipartUploadList = this.keyManager.listMultipartUploads(bucket.realVolume(), bucket.realBucket(), prefix);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_MULTIPART_UPLOADS, auditMap));
            return omMultipartUploadList;
        }
        catch (IOException ex) {
            this.metrics.incNumListMultipartUploadFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_MULTIPART_UPLOADS, auditMap, ex));
            throw ex;
        }
    }

    public OzoneFileStatus getFileStatus(OmKeyArgs args) throws IOException {
        ResolvedBucket bucket = this.resolveBucketLink(args);
        boolean auditSuccess = true;
        Map<String, String> auditMap = bucket.audit(args.toAuditMap());
        args = bucket.update(args);
        try {
            this.metrics.incNumGetFileStatus();
            OzoneFileStatus ozoneFileStatus = this.keyManager.getFileStatus(args, OzoneManager.getClientAddress());
            return ozoneFileStatus;
        }
        catch (IOException ex) {
            this.metrics.incNumGetFileStatusFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.GET_FILE_STATUS, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.GET_FILE_STATUS, auditMap));
            }
        }
    }

    private OzoneObj.ResourceType getResourceType(OmKeyArgs args) {
        if (args.getKeyName() == null || args.getKeyName().length() == 0) {
            return OzoneObj.ResourceType.BUCKET;
        }
        return OzoneObj.ResourceType.KEY;
    }

    public void createDirectory(OmKeyArgs args) throws IOException {
        ResolvedBucket bucket = this.resolveBucketLink(args);
        boolean auditSuccess = true;
        Map<String, String> auditMap = bucket.audit(args.toAuditMap());
        args = bucket.update(args);
        try {
            try {
                this.metrics.incNumCreateDirectory();
                this.keyManager.createDirectory(args);
            }
            catch (IOException ex) {
                this.metrics.incNumCreateDirectoryFails();
                auditSuccess = false;
                AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.CREATE_DIRECTORY, auditMap, ex));
                throw ex;
            }
        }
        finally {
            if (auditSuccess) {
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.CREATE_DIRECTORY, auditMap));
            }
        }
    }

    public OpenKeySession createFile(OmKeyArgs args, boolean overWrite, boolean recursive) throws IOException {
        ResolvedBucket bucket = this.resolveBucketLink(args);
        boolean auditSuccess = true;
        Map<String, String> auditMap = bucket.audit(args.toAuditMap());
        args = bucket.update(args);
        try {
            this.metrics.incNumCreateFile();
            OpenKeySession openKeySession = this.keyManager.createFile(args, overWrite, recursive);
            return openKeySession;
        }
        catch (Exception ex) {
            this.metrics.incNumCreateFileFails();
            auditSuccess = false;
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.CREATE_FILE, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.CREATE_FILE, auditMap));
            }
        }
    }

    public OmKeyInfo lookupFile(OmKeyArgs args) throws IOException {
        ResolvedBucket bucket = this.resolveBucketLink(args);
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, bucket.realVolume(), bucket.realBucket(), args.getKeyName());
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = bucket.audit(args.toAuditMap());
        args = bucket.update(args);
        try {
            this.metrics.incNumLookupFile();
            OmKeyInfo omKeyInfo = this.keyManager.lookupFile(args, OzoneManager.getClientAddress());
            return omKeyInfo;
        }
        catch (Exception ex) {
            this.metrics.incNumLookupFileFails();
            auditSuccess = false;
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LOOKUP_FILE, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LOOKUP_FILE, auditMap));
            }
        }
    }

    public List<OzoneFileStatus> listStatus(OmKeyArgs args, boolean recursive, String startKey, long numEntries) throws IOException {
        ResolvedBucket bucket = this.resolveBucketLink(args);
        if (this.isAclEnabled) {
            this.checkAcls(this.getResourceType(args), OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, bucket.realVolume(), bucket.realBucket(), args.getKeyName());
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = bucket.audit(args.toAuditMap());
        args = bucket.update(args);
        try {
            this.metrics.incNumListStatus();
            List<OzoneFileStatus> list = this.keyManager.listStatus(args, recursive, startKey, numEntries, OzoneManager.getClientAddress());
            return list;
        }
        catch (Exception ex) {
            this.metrics.incNumListStatusFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_STATUS, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_STATUS, auditMap));
            }
        }
    }

    private void auditAcl(OzoneObj ozoneObj, List<OzoneAcl> ozoneAcl, OMAction omAction, Exception ex) {
        Map auditMap = ozoneObj.toAuditMap();
        if (ozoneAcl != null) {
            auditMap.put("acl", ozoneAcl.toString());
        }
        if (ex == null) {
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)omAction, auditMap));
        } else {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)omAction, auditMap, ex));
        }
    }

    /*
     * Exception decompiling
     */
    public boolean addAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean removeAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean setAcl(OzoneObj obj, List<OzoneAcl> acls) throws IOException {
        boolean auditSuccess = true;
        try {
            if (this.isAclEnabled) {
                this.checkAcls(obj.getResourceType(), obj.getStoreType(), IAccessAuthorizer.ACLType.WRITE_ACL, obj.getVolumeName(), obj.getBucketName(), obj.getKeyName());
            }
            this.metrics.incNumSetAcl();
            switch (obj.getResourceType()) {
                case VOLUME: {
                    boolean bl = this.volumeManager.setAcl(obj, acls);
                    return bl;
                }
                case BUCKET: {
                    boolean bl = this.bucketManager.setAcl(obj, acls);
                    return bl;
                }
                case KEY: {
                    boolean bl = this.keyManager.setAcl(obj, acls);
                    return bl;
                }
                case PREFIX: {
                    boolean bl = this.prefixManager.setAcl(obj, acls);
                    return bl;
                }
            }
            try {
                throw new OMException("Unexpected resource type: " + obj.getResourceType(), OMException.ResultCodes.INVALID_REQUEST);
            }
            catch (Exception ex) {
                auditSuccess = false;
                this.auditAcl(obj, acls, OMAction.SET_ACL, ex);
                throw ex;
            }
        }
        finally {
            if (auditSuccess) {
                this.auditAcl(obj, acls, OMAction.SET_ACL, null);
            }
        }
    }

    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        boolean auditSuccess = true;
        try {
            if (this.isAclEnabled) {
                this.checkAcls(obj.getResourceType(), obj.getStoreType(), IAccessAuthorizer.ACLType.READ_ACL, obj.getVolumeName(), obj.getBucketName(), obj.getKeyName());
            }
            this.metrics.incNumGetAcl();
            switch (obj.getResourceType()) {
                case VOLUME: {
                    List<OzoneAcl> list = this.volumeManager.getAcl(obj);
                    return list;
                }
                case BUCKET: {
                    List<OzoneAcl> list = this.bucketManager.getAcl(obj);
                    return list;
                }
                case KEY: {
                    List<OzoneAcl> list = this.keyManager.getAcl(obj);
                    return list;
                }
                case PREFIX: {
                    List<OzoneAcl> list = this.prefixManager.getAcl(obj);
                    return list;
                }
            }
            try {
                throw new OMException("Unexpected resource type: " + obj.getResourceType(), OMException.ResultCodes.INVALID_REQUEST);
            }
            catch (Exception ex) {
                auditSuccess = false;
                this.auditAcl(obj, null, OMAction.GET_ACL, ex);
                throw ex;
            }
        }
        finally {
            if (auditSuccess) {
                this.auditAcl(obj, null, OMAction.GET_ACL, null);
            }
        }
    }

    public TermIndex installSnapshotFromLeader(String leaderId) {
        if (this.omSnapshotProvider == null) {
            LOG.error("OM Snapshot Provider is not configured as there are no peer nodes.");
            return null;
        }
        DBCheckpoint omDBCheckpoint = this.getDBCheckpointFromLeader(leaderId);
        LOG.info("Downloaded checkpoint from Leader {} to the location {}", (Object)leaderId, (Object)omDBCheckpoint.getCheckpointLocation());
        TermIndex termIndex = null;
        try {
            termIndex = this.installCheckpoint(leaderId, omDBCheckpoint);
        }
        catch (Exception ex) {
            LOG.error("Failed to install snapshot from Leader OM.", (Throwable)ex);
        }
        return termIndex;
    }

    TermIndex installCheckpoint(String leaderId, DBCheckpoint omDBCheckpoint) throws Exception {
        Path checkpointLocation = omDBCheckpoint.getCheckpointLocation();
        TransactionInfo checkpointTrxnInfo = OzoneManagerRatisUtils.getTrxnInfoFromCheckpoint(this.configuration, checkpointLocation);
        LOG.info("Installing checkpoint with OMTransactionInfo {}", (Object)checkpointTrxnInfo);
        return this.installCheckpoint(leaderId, checkpointLocation, checkpointTrxnInfo);
    }

    TermIndex installCheckpoint(String leaderId, Path checkpointLocation, TransactionInfo checkpointTrxnInfo) throws Exception {
        File oldDBLocation = this.metadataManager.getStore().getDbLocation();
        try {
            this.stopServices();
            this.omRatisServer.getOmStateMachine().pause();
        }
        catch (Exception e) {
            LOG.error("Failed to stop/ pause the services. Cannot proceed with installing the new checkpoint.");
            this.keyManager.start(this.configuration);
            this.startTrashEmptier((Configuration)this.configuration);
            throw e;
        }
        File dbBackup = null;
        TermIndex termIndex = this.omRatisServer.getLastAppliedTermIndex();
        long term = termIndex.getTerm();
        long lastAppliedIndex = termIndex.getIndex();
        boolean canProceed = OzoneManagerRatisUtils.verifyTransactionInfo(checkpointTrxnInfo, lastAppliedIndex, leaderId, checkpointLocation);
        if (canProceed) {
            try {
                dbBackup = this.replaceOMDBWithCheckpoint(lastAppliedIndex, oldDBLocation, checkpointLocation);
                term = checkpointTrxnInfo.getTerm();
                lastAppliedIndex = checkpointTrxnInfo.getTransactionIndex();
                LOG.info("Replaced DB with checkpoint from OM: {}, term: {}, index: {}", new Object[]{leaderId, term, lastAppliedIndex});
            }
            catch (Exception e) {
                LOG.error("Failed to install Snapshot from {} as OM failed to replace DB with downloaded checkpoint. Reloading old OM state.", (Throwable)e);
            }
        } else {
            LOG.warn("Cannot proceed with InstallSnapshot as OM is at TermIndex {} and checkpoint has lower TermIndex {}. Reloading old state of OM.", (Object)termIndex, (Object)checkpointTrxnInfo.getTermIndex());
        }
        try {
            this.reloadOMState(lastAppliedIndex, term);
            this.omRatisServer.getOmStateMachine().unpause(lastAppliedIndex, term);
            LOG.info("Reloaded OM state with Term: {} and Index: {}", (Object)term, (Object)lastAppliedIndex);
        }
        catch (Exception ex) {
            String errorMsg = "Failed to reload OM state and instantiate services.";
            this.exitManager.exitSystem(1, errorMsg, (Throwable)ex, LOG);
        }
        try {
            if (dbBackup != null) {
                FileUtils.deleteFully((File)dbBackup);
            }
        }
        catch (Exception exception) {
            LOG.error("Failed to delete the backup of the original DB {}", (Object)dbBackup);
        }
        if (lastAppliedIndex != checkpointTrxnInfo.getTransactionIndex()) {
            return null;
        }
        TermIndex newTermIndex = TermIndex.valueOf((long)term, (long)lastAppliedIndex);
        return newTermIndex;
    }

    private DBCheckpoint getDBCheckpointFromLeader(String leaderId) {
        LOG.info("Downloading checkpoint from leader OM {} and reloading state from the checkpoint.", (Object)leaderId);
        try {
            return this.omSnapshotProvider.getOzoneManagerDBSnapshot(leaderId);
        }
        catch (IOException e) {
            LOG.error("Failed to download checkpoint from OM leader {}", (Object)leaderId, (Object)e);
            return null;
        }
    }

    void stopServices() throws Exception {
        this.keyManager.stop();
        this.stopSecretManager();
        this.metadataManager.stop();
        this.stopTrashEmptier();
    }

    private void stopTrashEmptier() {
        if (this.emptier != null) {
            this.emptier.interrupt();
            this.emptier = null;
        }
    }

    File replaceOMDBWithCheckpoint(long lastAppliedIndex, File oldDB, Path checkpointPath) throws IOException {
        String dbBackupName = "om.db.backup." + lastAppliedIndex + "_" + System.currentTimeMillis();
        File dbDir = oldDB.getParentFile();
        File dbBackup = new File(dbDir, dbBackupName);
        try {
            Files.move(oldDB.toPath(), dbBackup.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            LOG.error("Failed to create a backup of the current DB. Aborting snapshot installation.");
            throw e;
        }
        Path markerFile = new File(dbDir, "dbInconsistentMarker").toPath();
        try {
            Files.createFile(markerFile, new FileAttribute[0]);
            Files.move(checkpointPath, oldDB.toPath(), new CopyOption[0]);
            Files.deleteIfExists(markerFile);
        }
        catch (IOException e) {
            LOG.error("Failed to move downloaded DB checkpoint {} to metadata directory {}. Resetting to original DB.", (Object)checkpointPath, (Object)oldDB.toPath());
            try {
                Files.move(dbBackup.toPath(), oldDB.toPath(), new CopyOption[0]);
                Files.deleteIfExists(markerFile);
            }
            catch (IOException ex) {
                String errorMsg = "Failed to reset to original DB. OM is in an inconsistent state.";
                this.exitManager.exitSystem(1, errorMsg, (Throwable)ex, LOG);
            }
            throw e;
        }
        return dbBackup;
    }

    void reloadOMState(long newSnapshotIndex, long newSnapshotTermIndex) throws IOException {
        this.instantiateServices(true);
        this.metadataManager.start(this.configuration);
        this.keyManager.start(this.configuration);
        this.startTrashEmptier((Configuration)this.configuration);
        this.metrics.setNumVolumes(this.metadataManager.countRowsInTable(this.metadataManager.getVolumeTable()));
        this.metrics.setNumBuckets(this.metadataManager.countRowsInTable(this.metadataManager.getBucketTable()));
        this.metrics.setNumKeys(this.metadataManager.countEstimatedRowsInTable(this.metadataManager.getKeyTable()));
        Files.deleteIfExists(this.getMetricsStorageFile().toPath());
        this.saveOmMetrics();
        this.omRatisSnapshotInfo.updateTermIndex(newSnapshotTermIndex, newSnapshotIndex);
    }

    public static Logger getLogger() {
        return LOG;
    }

    public OzoneConfiguration getConfiguration() {
        return this.configuration;
    }

    @VisibleForTesting
    public void setConfiguration(OzoneConfiguration conf) {
        this.configuration = conf;
    }

    public static void setTestSecureOmFlag(boolean testSecureOmFlag) {
        OzoneManager.testSecureOmFlag = testSecureOmFlag;
    }

    public String getOMNodeId() {
        return this.omNodeDetails.getNodeId();
    }

    public String getOMServiceId() {
        return this.omNodeDetails.getServiceId();
    }

    @VisibleForTesting
    public List<OMNodeDetails> getPeerNodes() {
        return new ArrayList<OMNodeDetails>(this.peerNodesMap.values());
    }

    @VisibleForTesting
    public CertificateClient getCertificateClient() {
        return this.certClient;
    }

    public String getComponent() {
        return this.omComponent;
    }

    public long getMaxUserVolumeCount() {
        return this.maxUserVolumeCount;
    }

    public boolean isLeaderReady() {
        return this.isRatisEnabled ? this.omRatisServer.checkLeaderStatus() == OzoneManagerRatisServer.RaftServerStatus.LEADER_AND_READY : true;
    }

    public boolean isRatisEnabled() {
        return this.isRatisEnabled;
    }

    public DBUpdates getDBUpdates(OzoneManagerProtocolProtos.DBUpdatesRequest dbUpdatesRequest) throws SequenceNumberNotFoundException {
        DBUpdatesWrapper updatesSince = this.metadataManager.getStore().getUpdatesSince(dbUpdatesRequest.getSequenceNumber());
        DBUpdates dbUpdates = new DBUpdates(updatesSince.getData());
        dbUpdates.setCurrentSequenceNumber(updatesSince.getCurrentSequenceNumber());
        return dbUpdates;
    }

    public OzoneDelegationTokenSecretManager getDelegationTokenMgr() {
        return this.delegationTokenMgr;
    }

    Collection<String> getOzoneAdminsFromConfig(OzoneConfiguration conf) throws IOException {
        String omSPN;
        Collection ozAdmins = conf.getTrimmedStringCollection("ozone.administrators");
        if (!ozAdmins.contains(omSPN = UserGroupInformation.getCurrentUser().getShortUserName())) {
            ozAdmins.add(omSPN);
        }
        return ozAdmins;
    }

    Collection<String> getOmAdminUsernames() {
        return this.omAdminUsernames;
    }

    public boolean isAdmin(UserGroupInformation callerUgi) {
        if (callerUgi == null) {
            return false;
        }
        return this.isAdmin(callerUgi.getShortUserName()) || this.isAdmin(callerUgi.getUserName());
    }

    public boolean isAdmin(String username) {
        if (this.omAdminUsernames == null) {
            return false;
        }
        return this.omAdminUsernames.contains("*") || this.omAdminUsernames.contains(username);
    }

    public boolean isNativeAuthorizerEnabled() {
        return this.isNativeAuthorizerEnabled;
    }

    @VisibleForTesting
    public boolean isRunning() {
        return this.omState == State.RUNNING;
    }

    private void startJVMPauseMonitor() {
        this.jvmPauseMonitor = new JvmPauseMonitor();
        this.jvmPauseMonitor.init((Configuration)this.configuration);
        this.jvmPauseMonitor.start();
    }

    public ResolvedBucket resolveBucketLink(OzoneManagerProtocolProtos.KeyArgs args, OMClientRequest omClientRequest) throws IOException {
        return this.resolveBucketLink((Pair<String, String>)Pair.of((Object)args.getVolumeName(), (Object)args.getBucketName()), omClientRequest);
    }

    public ResolvedBucket resolveBucketLink(OmKeyArgs args) throws IOException {
        return this.resolveBucketLink((Pair<String, String>)Pair.of((Object)args.getVolumeName(), (Object)args.getBucketName()));
    }

    public ResolvedBucket resolveBucketLink(Pair<String, String> requested, OMClientRequest omClientRequest) throws IOException {
        Pair<String, String> resolved = this.isAclEnabled ? this.resolveBucketLink(requested, new HashSet<Pair<String, String>>(), omClientRequest.createUGI(), omClientRequest.getRemoteAddress(), omClientRequest.getHostName()) : this.resolveBucketLink(requested, new HashSet<Pair<String, String>>(), null, null, null);
        return new ResolvedBucket(requested, resolved);
    }

    public ResolvedBucket resolveBucketLink(Pair<String, String> requested) throws IOException {
        Pair<String, String> resolved;
        if (this.isAclEnabled) {
            InetAddress remoteIp = Server.getRemoteIp();
            resolved = this.resolveBucketLink(requested, new HashSet<Pair<String, String>>(), Server.getRemoteUser(), remoteIp, remoteIp != null ? remoteIp.getHostName() : this.omRpcAddress.getHostName());
        } else {
            resolved = this.resolveBucketLink(requested, new HashSet<Pair<String, String>>(), null, null, null);
        }
        return new ResolvedBucket(requested, resolved);
    }

    private Pair<String, String> resolveBucketLink(Pair<String, String> volumeAndBucket, Set<Pair<String, String>> visited, UserGroupInformation userGroupInformation, InetAddress remoteAddress, String hostName) throws IOException {
        String bucketName;
        String volumeName = (String)volumeAndBucket.getLeft();
        OmBucketInfo info = this.bucketManager.getBucketInfo(volumeName, bucketName = (String)volumeAndBucket.getRight());
        if (!info.isLink()) {
            return volumeAndBucket;
        }
        if (!visited.add(volumeAndBucket)) {
            throw new OMException("Detected loop in bucket links", OMException.ResultCodes.DETECTED_LOOP_IN_BUCKET_LINKS);
        }
        if (this.isAclEnabled) {
            IAccessAuthorizer.ACLType type = IAccessAuthorizer.ACLType.READ;
            this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, type, volumeName, bucketName, null, userGroupInformation, remoteAddress, hostName, true, this.getVolumeOwner(volumeName, type, OzoneObj.ResourceType.BUCKET));
        }
        return this.resolveBucketLink((Pair<String, String>)Pair.of((Object)info.getSourceVolume(), (Object)info.getSourceBucket()), visited, userGroupInformation, remoteAddress, hostName);
    }

    @VisibleForTesting
    void setExitManagerForTesting(ExitManager exitManagerForTesting) {
        this.exitManager = exitManagerForTesting;
    }

    public boolean getEnableFileSystemPaths() {
        return this.configuration.getBoolean("ozone.om.enable.filesystem.paths", false);
    }

    public String getOMMetadataLayout() {
        return this.configuration.getTrimmed("ozone.om.metadata.layout", "SIMPLE");
    }

    private void addS3GVolumeToDB() throws IOException {
        String s3VolumeName = HddsClientUtils.getS3VolumeName((ConfigurationSource)this.configuration);
        String dbVolumeKey = this.metadataManager.getVolumeKey(s3VolumeName);
        if (!s3VolumeName.equals("s3v")) {
            LOG.warn("Make sure that all S3Gateway use same volume name. Otherwise user need to manually create/configure Volume configured by S3Gateway");
        }
        if (!this.metadataManager.getVolumeTable().isExist((Object)dbVolumeKey)) {
            long transactionID = 0x3FFFFFFFFFFFFFL;
            long objectID = OmUtils.addEpochToTxId((long)this.metadataManager.getOmEpoch(), (long)transactionID);
            String userName = UserGroupInformation.getCurrentUser().getShortUserName();
            OmVolumeArgs omVolumeArgs = this.createS3VolumeInfo(s3VolumeName, objectID);
            String dbUserKey = this.metadataManager.getUserKey(userName);
            OzoneManagerStorageProtos.PersistedUserVolumeInfo userVolumeInfo = OzoneManagerStorageProtos.PersistedUserVolumeInfo.newBuilder().setObjectID(objectID).setUpdateID(transactionID).addVolumeNames(s3VolumeName).build();
            Throwable throwable = null;
            Object var12_11 = null;
            try (BatchOperation batchOperation = this.metadataManager.getStore().initBatchOperation();){
                this.metadataManager.getVolumeTable().putWithBatch(batchOperation, (Object)dbVolumeKey, (Object)omVolumeArgs);
                this.metadataManager.getUserTable().putWithBatch(batchOperation, (Object)dbUserKey, (Object)userVolumeInfo);
                this.metadataManager.getStore().commitBatchOperation(batchOperation);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.metadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)dbVolumeKey), new CacheValue(Optional.of((Object)omVolumeArgs), transactionID));
            this.metadataManager.getUserTable().addCacheEntry(new CacheKey((Object)dbUserKey), new CacheValue(Optional.of((Object)userVolumeInfo), transactionID));
            LOG.info("Created Volume {} With Owner {} required for S3Gateway operations.", (Object)s3VolumeName, (Object)userName);
        }
    }

    private OmVolumeArgs createS3VolumeInfo(String s3Volume, long objectID) throws IOException {
        String userName = UserGroupInformation.getCurrentUser().getShortUserName();
        long time = Time.now();
        OmVolumeArgs.Builder omVolumeArgs = new OmVolumeArgs.Builder().setVolume(s3Volume).setUpdateID(-1L).setObjectID(objectID).setCreationTime(time).setModificationTime(time).setOwnerName(userName).setAdminName(userName).setQuotaInBytes(-1L);
        ArrayList<OzoneAcl> listOfAcls = new ArrayList<OzoneAcl>();
        listOfAcls.add(new OzoneAcl(IAccessAuthorizer.ACLIdentityType.USER, userName, IAccessAuthorizer.ACLType.ALL, OzoneAcl.AclScope.ACCESS));
        List<String> userGroups = Arrays.asList(UserGroupInformation.createRemoteUser((String)userName).getGroupNames());
        userGroups.stream().forEach(group -> {
            boolean bl = listOfAcls.add(new OzoneAcl(IAccessAuthorizer.ACLIdentityType.GROUP, group, IAccessAuthorizer.ACLType.ALL, OzoneAcl.AclScope.ACCESS));
        });
        for (OzoneAcl ozoneAcl : listOfAcls) {
            omVolumeArgs.addOzoneAcls(ozoneAcl);
        }
        return omVolumeArgs.build();
    }

    public OMLayoutVersionManager getVersionManager() {
        return this.versionManager;
    }

    public OzoneManagerPrepareState getPrepareState() {
        return this.prepareState;
    }

    private void instantiatePrepareStateOnStartup() throws IOException {
        TransactionInfo txnInfo = (TransactionInfo)this.metadataManager.getTransactionInfoTable().get((Object)"#TRANSACTIONINFO");
        if (txnInfo == null) {
            this.prepareState = new OzoneManagerPrepareState((ConfigurationSource)this.configuration);
        } else {
            boolean hasDBMarker;
            this.prepareState = new OzoneManagerPrepareState((ConfigurationSource)this.configuration, txnInfo.getTransactionIndex());
            TransactionInfo dbPrepareValue = (TransactionInfo)this.metadataManager.getTransactionInfoTable().get((Object)"#PREPAREDINFO");
            boolean hasMarkerFile = this.prepareState.getState().getStatus() == OzoneManagerProtocolProtos.PrepareStatusResponse.PrepareStatus.PREPARE_COMPLETED;
            boolean bl = hasDBMarker = dbPrepareValue != null;
            if (hasDBMarker) {
                long dbPrepareIndex = dbPrepareValue.getTransactionIndex();
                if (hasMarkerFile) {
                    long prepareFileIndex = this.prepareState.getState().getIndex();
                    if (prepareFileIndex != dbPrepareIndex) {
                        LOG.warn("Prepare marker file index {} does not match DB prepare index {}. Writing DB index to prepare file and maintaining prepared state.", (Object)prepareFileIndex, (Object)dbPrepareIndex);
                        this.prepareState.finishPrepare(dbPrepareIndex);
                    }
                } else {
                    this.metadataManager.getTransactionInfoTable().delete((Object)"#PREPAREDINFO");
                }
            } else if (hasMarkerFile) {
                throw new OMException("Prepare marker file found on startup without a corresponding database entry. Corrupt prepare state.", OMException.ResultCodes.PREPARE_FAILED);
            }
        }
    }

    private void instantiatePrepareStateAfterSnapshot() throws IOException {
        TransactionInfo txnInfo = (TransactionInfo)this.metadataManager.getTransactionInfoTable().get((Object)"#TRANSACTIONINFO");
        if (txnInfo == null) {
            this.prepareState = new OzoneManagerPrepareState((ConfigurationSource)this.configuration);
        } else {
            boolean hasDBMarker;
            this.prepareState = new OzoneManagerPrepareState((ConfigurationSource)this.configuration, txnInfo.getTransactionIndex());
            TransactionInfo dbPrepareValue = (TransactionInfo)this.metadataManager.getTransactionInfoTable().get((Object)"#PREPAREDINFO");
            boolean bl = hasDBMarker = dbPrepareValue != null;
            if (hasDBMarker) {
                long dbPrepareIndex = dbPrepareValue.getTransactionIndex();
                this.prepareState.restorePrepareFromIndex(dbPrepareIndex, txnInfo.getTransactionIndex());
            } else {
                this.prepareState.cancelPrepare();
            }
        }
    }

    public int getMinMultipartUploadPartSize() {
        return this.minMultipartUploadPartSize;
    }

    @VisibleForTesting
    public void setMinMultipartUploadPartSize(int partSizeForTest) {
        this.minMultipartUploadPartSize = partSizeForTest;
    }

    private void updateLayoutVersionInDB(OMLayoutVersionManager lvm, OMMetadataManager omMetadataManager) throws IOException {
        omMetadataManager.getMetaTable().put((Object)"#LAYOUTVERSION", (Object)String.valueOf(lvm.getMetadataLayoutVersion()));
    }

    private void initFSOLayout() {
        String metaLayout = this.getOMMetadataLayout();
        boolean omMetadataLayoutPrefix = StringUtils.equalsIgnoreCase((CharSequence)metaLayout, (CharSequence)"PREFIX");
        boolean omMetadataLayoutSimple = StringUtils.equalsIgnoreCase((CharSequence)metaLayout, (CharSequence)"SIMPLE");
        if (!omMetadataLayoutPrefix && !omMetadataLayoutSimple) {
            StringBuilder msg = new StringBuilder();
            msg.append("Invalid Configuration. Failed to start OM in ");
            msg.append(metaLayout);
            msg.append(" layout format. Supported values are either ");
            msg.append("SIMPLE");
            msg.append(" or ");
            msg.append("PREFIX");
            LOG.error(msg.toString());
            throw new IllegalArgumentException(msg.toString());
        }
        if (omMetadataLayoutPrefix && !this.getEnableFileSystemPaths()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Invalid Configuration. Failed to start OM in ");
            msg.append("PREFIX");
            msg.append(" layout format as '");
            msg.append("ozone.om.enable.filesystem.paths");
            msg.append("' is false!");
            LOG.error(msg.toString());
            throw new IllegalArgumentException(msg.toString());
        }
        OzoneManagerRatisUtils.setBucketFSOptimized(omMetadataLayoutPrefix);
        String status = omMetadataLayoutPrefix ? "enabled" : "disabled";
        LOG.info("Configured {}={} and {} optimized OM FS operations", new Object[]{"ozone.om.metadata.layout", metaLayout, status});
    }

    private void validatesBucketLayoutMismatches() throws IOException {
        String clusterLevelMetaLayout = this.getOMMetadataLayout();
        TableIterator iterator = this.metadataManager.getBucketTable().iterator();
        while (iterator.hasNext()) {
            Map bucketMeta = ((OmBucketInfo)((Table.KeyValue)iterator.next()).getValue()).getMetadata();
            this.verifyBucketMetaLayout(clusterLevelMetaLayout, bucketMeta);
        }
    }

    private void verifyBucketMetaLayout(String clusterLevelMetaLayout, Map<String, String> bucketMetadata) throws IOException {
        boolean supportedMetadataLayout;
        String bucketMetaLayout = bucketMetadata.get("ozone.om.metadata.layout");
        if (StringUtils.isBlank((CharSequence)bucketMetaLayout)) {
            bucketMetaLayout = "SIMPLE";
        }
        if (!(supportedMetadataLayout = StringUtils.equalsIgnoreCase((CharSequence)clusterLevelMetaLayout, (CharSequence)bucketMetaLayout))) {
            StringBuilder msg = new StringBuilder();
            msg.append("Failed to start OM in ");
            msg.append(clusterLevelMetaLayout);
            msg.append(" layout format as existing bucket has a different layout ");
            msg.append(bucketMetaLayout);
            msg.append(" metadata format");
            LOG.error(msg.toString());
            throw new IOException(msg.toString());
        }
    }

    private class ScheduleOMMetricsWriteTask
    extends TimerTask {
        private ScheduleOMMetricsWriteTask() {
        }

        @Override
        public void run() {
            OzoneManager.this.saveOmMetrics();
        }
    }

    public static enum StartupOption {
        REGUALR,
        BOOTSTRAP;

    }

    private static enum State {
        INITIALIZED,
        BOOTSTRAPPING,
        RUNNING,
        STOPPED;

    }
}

