/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.util.Collection;
import javax.servlet.ServletException;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.recon.ReconConfig;
import org.apache.hadoop.hdds.utils.DBCheckpointServlet;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMDBCheckpointServlet
extends DBCheckpointServlet {
    private static final Logger LOG = LoggerFactory.getLogger(OMDBCheckpointServlet.class);
    private static final long serialVersionUID = 1L;

    public void init() throws ServletException {
        OzoneManager om = (OzoneManager)this.getServletContext().getAttribute("ozone.om");
        if (om == null) {
            LOG.error("Unable to initialize OMDBCheckpointServlet. OM is null");
            return;
        }
        OzoneConfiguration conf = om.getConfiguration();
        Collection<String> allowedUsers = om.getOmAdminUsernames();
        ReconConfig reconConfig = (ReconConfig)conf.getObject(ReconConfig.class);
        String reconPrincipal = reconConfig.getKerberosPrincipal();
        if (!reconPrincipal.isEmpty()) {
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)reconPrincipal);
            allowedUsers.add(ugi.getShortUserName());
        }
        this.initialize(om.getMetadataManager().getStore(), om.getMetrics().getDBCheckpointMetrics(), om.getAclsEnabled(), allowedUsers, om.isSpnegoEnabled());
    }
}

