/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.OMRatisHelper;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Time;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public class DirectoryDeletingService
extends BackgroundService {
    private final OzoneManager ozoneManager;
    private AtomicLong deletedDirsCount;
    private AtomicLong deletedFilesCount;
    private final AtomicLong runCount;
    private static ClientId clientId = ClientId.randomId();
    private static final int DIR_DELETING_CORE_POOL_SIZE = 1;
    private final long pathLimitPerTask;

    public DirectoryDeletingService(long interval, TimeUnit unit, long serviceTimeout, OzoneManager ozoneManager, OzoneConfiguration configuration) {
        super("DirectoryDeletingService", interval, unit, 1, serviceTimeout);
        this.ozoneManager = ozoneManager;
        this.deletedDirsCount = new AtomicLong(0L);
        this.deletedFilesCount = new AtomicLong(0L);
        this.runCount = new AtomicLong(0L);
        this.pathLimitPerTask = configuration.getInt("ozone.path.deleting.limit.per.task", 10000);
    }

    private boolean shouldRun() {
        if (this.ozoneManager == null) {
            return true;
        }
        return this.ozoneManager.isLeaderReady();
    }

    private boolean isRatisEnabled() {
        if (this.ozoneManager == null) {
            return false;
        }
        return this.ozoneManager.isRatisEnabled();
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new DirDeletingTask());
        return queue;
    }

    @VisibleForTesting
    public long getDeletedDirsCount() {
        return this.deletedDirsCount.get();
    }

    @VisibleForTesting
    public long getMovedFilesCount() {
        return this.deletedFilesCount.get();
    }

    @VisibleForTesting
    public long getRunCount() {
        return this.runCount.get();
    }

    private int submitPurgePaths(List<String> purgeDeletedDirs, List<OmKeyInfo> purgeDeletedFiles, List<OmKeyInfo> markDirsAsDeleted) {
        int deletedCount = 0;
        OzoneManagerProtocolProtos.PurgePathsRequest.Builder purgePathsRequest = OzoneManagerProtocolProtos.PurgePathsRequest.newBuilder();
        for (String purgeDir : purgeDeletedDirs) {
            purgePathsRequest.addDeletedDirs(purgeDir);
        }
        for (OmKeyInfo purgeFile : purgeDeletedFiles) {
            purgePathsRequest.addDeletedSubFiles(purgeFile.getProtobuf(true, 1));
        }
        for (OmKeyInfo dir : markDirsAsDeleted) {
            purgePathsRequest.addMarkDeletedSubDirs(dir.getProtobuf(1));
        }
        OzoneManagerProtocolProtos.OMRequest omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.PurgePaths).setPurgePathsRequest(purgePathsRequest).setClientId(clientId.toString()).build();
        try {
            RaftClientRequest raftClientRequest = this.createRaftClientRequestForDelete(omRequest);
            this.ozoneManager.getOmRatisServer().submitRequest(omRequest, raftClientRequest);
        }
        catch (ServiceException serviceException) {
            BackgroundService.LOG.error("PurgePaths request failed. Will retry at next run.");
            return 0;
        }
        return deletedCount;
    }

    private RaftClientRequest createRaftClientRequestForDelete(OzoneManagerProtocolProtos.OMRequest omRequest) {
        return RaftClientRequest.newBuilder().setClientId(clientId).setServerId(this.ozoneManager.getOmRatisServer().getRaftPeerId()).setGroupId(this.ozoneManager.getOmRatisServer().getRaftGroupId()).setCallId(this.runCount.get()).setMessage(Message.valueOf((ByteString)OMRatisHelper.convertRequestToByteString((OzoneManagerProtocolProtos.OMRequest)omRequest))).setType(RaftClientRequest.writeRequestType()).build();
    }

    private class DirDeletingTask
    implements BackgroundTask {
        private DirDeletingTask() {
        }

        public int getPriority() {
            return 0;
        }

        public BackgroundTaskResult call() throws Exception {
            if (DirectoryDeletingService.this.shouldRun()) {
                DirectoryDeletingService.this.runCount.incrementAndGet();
                long count = DirectoryDeletingService.this.pathLimitPerTask;
                try {
                    long startTime = Time.monotonicNow();
                    OmKeyInfo pendingDeletedDirInfo = DirectoryDeletingService.this.ozoneManager.getKeyManager().getPendingDeletionDir();
                    if (pendingDeletedDirInfo != null) {
                        if (BackgroundService.LOG.isDebugEnabled()) {
                            BackgroundService.LOG.debug("Pending deleted dir name: {}", (Object)pendingDeletedDirInfo.getKeyName());
                        }
                        List<OmKeyInfo> dirs = DirectoryDeletingService.this.ozoneManager.getKeyManager().getPendingDeletionSubDirs(pendingDeletedDirInfo, count);
                        count -= (long)dirs.size();
                        ArrayList<OmKeyInfo> deletedSubDirList = new ArrayList<OmKeyInfo>();
                        for (OmKeyInfo dirInfo : dirs) {
                            deletedSubDirList.add(dirInfo);
                            if (!BackgroundService.LOG.isDebugEnabled()) continue;
                            BackgroundService.LOG.debug("deleted sub dir name: {}", (Object)dirInfo.getKeyName());
                        }
                        List<OmKeyInfo> purgeDeletedFiles = DirectoryDeletingService.this.ozoneManager.getKeyManager().getPendingDeletionSubFiles(pendingDeletedDirInfo, count);
                        count -= (long)purgeDeletedFiles.size();
                        if (BackgroundService.LOG.isDebugEnabled()) {
                            for (OmKeyInfo fileInfo : purgeDeletedFiles) {
                                BackgroundService.LOG.debug("deleted sub file name: {}", (Object)fileInfo.getKeyName());
                            }
                        }
                        ArrayList<String> purgeDeletedDirs = new ArrayList<String>();
                        if (count > 0L) {
                            purgeDeletedDirs.add(pendingDeletedDirInfo.getPath());
                        }
                        if (DirectoryDeletingService.this.isRatisEnabled()) {
                            DirectoryDeletingService.this.submitPurgePaths(purgeDeletedDirs, purgeDeletedFiles, deletedSubDirList);
                        }
                        DirectoryDeletingService.this.deletedDirsCount.addAndGet(purgeDeletedDirs.size());
                        DirectoryDeletingService.this.deletedFilesCount.addAndGet(purgeDeletedFiles.size());
                        if (BackgroundService.LOG.isDebugEnabled()) {
                            BackgroundService.LOG.debug("Number of dirs deleted: {}, Number of files moved: {} to DeletedTable, elapsed time: {}ms", new Object[]{DirectoryDeletingService.this.deletedDirsCount, DirectoryDeletingService.this.deletedFilesCount, Time.monotonicNow() - startTime});
                        }
                    }
                }
                catch (IOException e) {
                    BackgroundService.LOG.error("Error while running delete directories and files background task. Will retry at next run.", (Throwable)e);
                }
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }
    }
}

