/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;
import org.apache.hadoop.ozone.recon.tasks.ReconOmTask;
import org.apache.hadoop.ozone.recon.tasks.ReconTaskController;
import org.hadoop.ozone.recon.schema.tables.daos.ReconTaskStatusDao;
import org.hadoop.ozone.recon.schema.tables.pojos.ReconTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconTaskControllerImpl
implements ReconTaskController {
    private static final Logger LOG = LoggerFactory.getLogger(ReconTaskControllerImpl.class);
    private Map<String, ReconOmTask> reconOmTasks;
    private ExecutorService executorService;
    private final int threadCount;
    private Map<String, AtomicInteger> taskFailureCounter = new HashMap<String, AtomicInteger>();
    private static final int TASK_FAILURE_THRESHOLD = 2;
    private ReconTaskStatusDao reconTaskStatusDao;

    @Inject
    public ReconTaskControllerImpl(OzoneConfiguration configuration, ReconTaskStatusDao reconTaskStatusDao, Set<ReconOmTask> tasks) {
        this.reconOmTasks = new HashMap<String, ReconOmTask>();
        this.threadCount = configuration.getInt("ozone.recon.task.thread.count", 5);
        this.reconTaskStatusDao = reconTaskStatusDao;
        for (ReconOmTask task : tasks) {
            this.registerTask(task);
        }
    }

    @Override
    public void registerTask(ReconOmTask task) {
        String taskName = task.getTaskName();
        LOG.info("Registered task {} with controller.", (Object)taskName);
        this.reconOmTasks.put(taskName, task);
        this.taskFailureCounter.put(taskName, new AtomicInteger(0));
        ReconTaskStatus reconTaskStatusRecord = new ReconTaskStatus(taskName, 0L, 0L);
        if (!this.reconTaskStatusDao.existsById(taskName)) {
            this.reconTaskStatusDao.insert(reconTaskStatusRecord);
        }
    }

    @Override
    public synchronized void consumeOMEvents(OMUpdateEventBatch events, OMMetadataManager omMetadataManager) throws InterruptedException {
        try {
            if (!events.isEmpty()) {
                ReconOmTask task;
                ArrayList<Callable<Pair>> tasks = new ArrayList<Callable<Pair>>();
                for (Map.Entry<String, ReconOmTask> taskEntry : this.reconOmTasks.entrySet()) {
                    ReconOmTask task2 = taskEntry.getValue();
                    tasks.add(() -> task2.process(events));
                }
                List<Future<Object>> results = this.executorService.invokeAll(tasks);
                List<String> failedTasks = this.processTaskResults(results, events);
                List<Object> retryFailedTasks = new ArrayList();
                if (!failedTasks.isEmpty()) {
                    tasks.clear();
                    for (String taskName : failedTasks) {
                        task = this.reconOmTasks.get(taskName);
                        tasks.add(() -> task.process(events));
                    }
                    results = this.executorService.invokeAll(tasks);
                    retryFailedTasks = this.processTaskResults(results, events);
                }
                if (!retryFailedTasks.isEmpty()) {
                    tasks.clear();
                    for (String taskName : failedTasks) {
                        task = this.reconOmTasks.get(taskName);
                        tasks.add(() -> task.reprocess(omMetadataManager));
                    }
                    results = this.executorService.invokeAll(tasks);
                    List<String> reprocessFailedTasks = this.processTaskResults(results, events);
                    this.ignoreFailedTasks(reprocessFailedTasks);
                }
            }
        }
        catch (ExecutionException e) {
            LOG.error("Unexpected error : ", (Throwable)e);
        }
    }

    private void ignoreFailedTasks(List<String> failedTasks) {
        for (String taskName : failedTasks) {
            LOG.info("Reprocess step failed for task {}.", (Object)taskName);
            if (this.taskFailureCounter.get(taskName).incrementAndGet() <= 2) continue;
            LOG.info("Ignoring task since it failed retry and reprocess more than {} times.", (Object)2);
            this.reconOmTasks.remove(taskName);
        }
    }

    @Override
    public synchronized void reInitializeTasks(ReconOMMetadataManager omMetadataManager) throws InterruptedException {
        try {
            ArrayList<Callable<Pair>> tasks = new ArrayList<Callable<Pair>>();
            for (Map.Entry<String, ReconOmTask> taskEntry : this.reconOmTasks.entrySet()) {
                ReconOmTask task = taskEntry.getValue();
                tasks.add(() -> task.reprocess(omMetadataManager));
            }
            List results = this.executorService.invokeAll(tasks);
            for (Future f : results) {
                String taskName = (String)((Pair)f.get()).getLeft();
                if (!((Boolean)((Pair)f.get()).getRight()).booleanValue()) {
                    LOG.info("Init failed for task {}.", (Object)taskName);
                    continue;
                }
                ReconTaskStatus reconTaskStatusRecord = new ReconTaskStatus(taskName, System.currentTimeMillis(), omMetadataManager.getLastSequenceNumberFromDB());
                this.reconTaskStatusDao.update(reconTaskStatusRecord);
            }
        }
        catch (ExecutionException e) {
            LOG.error("Unexpected error : ", (Throwable)e);
        }
    }

    private void storeLastCompletedTransaction(String taskName, long lastSequenceNumber) {
        ReconTaskStatus reconTaskStatusRecord = new ReconTaskStatus(taskName, System.currentTimeMillis(), lastSequenceNumber);
        this.reconTaskStatusDao.update(reconTaskStatusRecord);
    }

    @Override
    public Map<String, ReconOmTask> getRegisteredTasks() {
        return this.reconOmTasks;
    }

    @Override
    public ReconTaskStatusDao getReconTaskStatusDao() {
        return this.reconTaskStatusDao;
    }

    @Override
    public synchronized void start() {
        LOG.info("Starting Recon Task Controller.");
        this.executorService = Executors.newFixedThreadPool(this.threadCount);
    }

    @Override
    public synchronized void stop() {
        LOG.info("Stopping Recon Task Controller.");
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    private List<String> processTaskResults(List<Future<Pair<String, Boolean>>> results, OMUpdateEventBatch events) throws ExecutionException, InterruptedException {
        ArrayList<String> failedTasks = new ArrayList<String>();
        for (Future<Pair<String, Boolean>> f : results) {
            String taskName = (String)f.get().getLeft();
            if (!((Boolean)f.get().getRight()).booleanValue()) {
                LOG.info("Failed task : {}", (Object)taskName);
                failedTasks.add((String)f.get().getLeft());
                continue;
            }
            this.taskFailureCounter.get(taskName).set(0);
            this.storeLastCompletedTransaction(taskName, events.getLastSequenceNumber());
        }
        return failedTasks;
    }
}

