/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import java.time.Duration;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;

@ConfigGroup(prefix="ozone.recon.task")
public class ReconTaskConfig {
    @Config(key="pipelinesync.interval", type=ConfigType.TIME, defaultValue="300s", tags={ConfigTag.RECON, ConfigTag.OZONE}, description="The time interval of periodic sync of pipeline state from SCM to Recon.")
    private long pipelineSyncTaskInterval = Duration.ofMinutes(5L).toMillis();
    @Config(key="missingcontainer.interval", type=ConfigType.TIME, defaultValue="300s", tags={ConfigTag.RECON, ConfigTag.OZONE}, description="The time interval of the periodic check for unhealthy containers in the cluster as reported by Datanodes.")
    private long missingContainerTaskInterval = Duration.ofMinutes(5L).toMillis();

    public Duration getPipelineSyncTaskInterval() {
        return Duration.ofMillis(this.pipelineSyncTaskInterval);
    }

    public void setPipelineSyncTaskInterval(Duration interval) {
        this.pipelineSyncTaskInterval = interval.toMillis();
    }

    public Duration getMissingContainerTaskInterval() {
        return Duration.ofMillis(this.missingContainerTaskInterval);
    }

    public void setMissingContainerTaskInterval(Duration interval) {
        this.missingContainerTaskInterval = interval.toMillis();
    }
}

