/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.apache.hadoop.ozone.recon.tasks.OMDBUpdateEvent;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;
import org.apache.hadoop.ozone.recon.tasks.ReconOmTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSummaryTask
implements ReconOmTask {
    private static final Logger LOG = LoggerFactory.getLogger(NSSummaryTask.class);
    private ReconNamespaceSummaryManager reconNamespaceSummaryManager;

    @Inject
    public NSSummaryTask(ReconNamespaceSummaryManager reconNamespaceSummaryManager) {
        this.reconNamespaceSummaryManager = reconNamespaceSummaryManager;
    }

    @Override
    public String getTaskName() {
        return "NSSummaryTask";
    }

    public Collection<String> getTaskTables() {
        return Arrays.asList("fileTable", "directoryTable");
    }

    @Override
    public Pair<String, Boolean> process(OMUpdateEventBatch events) {
        Iterator<OMDBUpdateEvent> eventIterator = events.getIterator();
        Collection<String> taskTables = this.getTaskTables();
        while (eventIterator.hasNext()) {
            OMDBUpdateEvent omdbUpdateEvent = eventIterator.next();
            OMDBUpdateEvent.OMDBUpdateAction action = omdbUpdateEvent.getAction();
            String table = omdbUpdateEvent.getTable();
            boolean updateOnFileTable = table.equals("fileTable");
            if (!taskTables.contains(table)) continue;
            String updatedKey = (String)omdbUpdateEvent.getKey();
            try {
                if (updateOnFileTable) {
                    OMDBUpdateEvent keyTableUpdateEvent = omdbUpdateEvent;
                    OmKeyInfo updatedKeyInfo = (OmKeyInfo)keyTableUpdateEvent.getValue();
                    OmKeyInfo oldKeyInfo = (OmKeyInfo)keyTableUpdateEvent.getOldValue();
                    switch (action) {
                        case PUT: {
                            this.writeOmKeyInfoOnNamespaceDB(updatedKeyInfo);
                            break;
                        }
                        case DELETE: {
                            this.deleteOmKeyInfoOnNamespaceDB(updatedKeyInfo);
                            break;
                        }
                        case UPDATE: {
                            if (oldKeyInfo != null) {
                                this.deleteOmKeyInfoOnNamespaceDB(oldKeyInfo);
                            } else {
                                LOG.warn("Update event does not have the old keyInfo for {}.", (Object)updatedKey);
                            }
                            this.writeOmKeyInfoOnNamespaceDB(updatedKeyInfo);
                            break;
                        }
                        default: {
                            LOG.debug("Skipping DB update event : {}", (Object)omdbUpdateEvent.getAction());
                            break;
                        }
                    }
                    continue;
                }
                OMDBUpdateEvent dirTableUpdateEvent = omdbUpdateEvent;
                OmDirectoryInfo updatedDirectoryInfo = (OmDirectoryInfo)dirTableUpdateEvent.getValue();
                OmDirectoryInfo oldDirectoryInfo = (OmDirectoryInfo)dirTableUpdateEvent.getOldValue();
                switch (action) {
                    case PUT: {
                        this.writeOmDirectoryInfoOnNamespaceDB(updatedDirectoryInfo);
                        break;
                    }
                    case DELETE: {
                        this.deleteOmDirectoryInfoOnNamespaceDB(updatedDirectoryInfo);
                        break;
                    }
                    case UPDATE: {
                        if (oldDirectoryInfo != null) {
                            this.deleteOmDirectoryInfoOnNamespaceDB(oldDirectoryInfo);
                        } else {
                            LOG.warn("Update event does not have the old dirInfo for {}.", (Object)updatedKey);
                        }
                        this.writeOmDirectoryInfoOnNamespaceDB(updatedDirectoryInfo);
                        break;
                    }
                    default: {
                        LOG.debug("Skipping DB update event : {}", (Object)omdbUpdateEvent.getAction());
                    }
                }
            }
            catch (IOException ioEx) {
                LOG.error("Unable to process Namespace Summary data in Recon DB. ", (Throwable)ioEx);
                return new ImmutablePair((Object)this.getTaskName(), (Object)false);
            }
        }
        LOG.info("Completed a process run of NSSummaryTask");
        return new ImmutablePair((Object)this.getTaskName(), (Object)true);
    }

    @Override
    public Pair<String, Boolean> reprocess(OMMetadataManager omMetadataManager) {
        try {
            this.reconNamespaceSummaryManager.clearNSSummaryTable();
            Table dirTable = omMetadataManager.getDirectoryTable();
            for (Table.KeyValue kv : dirTable) {
                OmDirectoryInfo directoryInfo = (OmDirectoryInfo)kv.getValue();
                this.writeOmDirectoryInfoOnNamespaceDB(directoryInfo);
            }
            Table keyTable = omMetadataManager.getFileTable();
            for (Table.KeyValue kv : keyTable) {
                OmKeyInfo keyInfo = (OmKeyInfo)kv.getValue();
                this.writeOmKeyInfoOnNamespaceDB(keyInfo);
            }
        }
        catch (IOException ioEx) {
            LOG.error("Unable to reprocess Namespace Summary data in Recon DB. ", (Throwable)ioEx);
            return new ImmutablePair((Object)this.getTaskName(), (Object)false);
        }
        LOG.info("Completed a reprocess run of NSSummaryTask");
        return new ImmutablePair((Object)this.getTaskName(), (Object)true);
    }

    private void writeOmKeyInfoOnNamespaceDB(OmKeyInfo keyInfo) throws IOException {
        int binIndex;
        long parentObjectId = keyInfo.getParentObjectID();
        NSSummary nsSummary = this.reconNamespaceSummaryManager.getNSSummary(parentObjectId);
        if (nsSummary == null) {
            nsSummary = new NSSummary();
        }
        int numOfFile = nsSummary.getNumOfFiles();
        long sizeOfFile = nsSummary.getSizeOfFiles();
        int[] fileBucket = nsSummary.getFileSizeBucket();
        nsSummary.setNumOfFiles(numOfFile + 1);
        long dataSize = keyInfo.getDataSize();
        nsSummary.setSizeOfFiles(sizeOfFile + dataSize);
        int n = binIndex = ReconUtils.getBinIndex(dataSize);
        fileBucket[n] = fileBucket[n] + 1;
        nsSummary.setFileSizeBucket(fileBucket);
        this.reconNamespaceSummaryManager.storeNSSummary(parentObjectId, nsSummary);
    }

    private void writeOmDirectoryInfoOnNamespaceDB(OmDirectoryInfo directoryInfo) throws IOException {
        long parentObjectId = directoryInfo.getParentObjectID();
        long objectId = directoryInfo.getObjectID();
        String dirName = directoryInfo.getName();
        NSSummary curNSSummary = this.reconNamespaceSummaryManager.getNSSummary(objectId);
        if (curNSSummary == null) {
            curNSSummary = new NSSummary();
        }
        curNSSummary.setDirName(dirName);
        this.reconNamespaceSummaryManager.storeNSSummary(objectId, curNSSummary);
        NSSummary nsSummary = this.reconNamespaceSummaryManager.getNSSummary(parentObjectId);
        if (nsSummary == null) {
            nsSummary = new NSSummary();
        }
        nsSummary.addChildDir(objectId);
        this.reconNamespaceSummaryManager.storeNSSummary(parentObjectId, nsSummary);
    }

    private void deleteOmKeyInfoOnNamespaceDB(OmKeyInfo keyInfo) throws IOException {
        long parentObjectId = keyInfo.getParentObjectID();
        NSSummary nsSummary = this.reconNamespaceSummaryManager.getNSSummary(parentObjectId);
        if (nsSummary == null) {
            LOG.error("The namespace table is not correctly populated.");
            return;
        }
        int numOfFile = nsSummary.getNumOfFiles();
        long sizeOfFile = nsSummary.getSizeOfFiles();
        int[] fileBucket = nsSummary.getFileSizeBucket();
        long dataSize = keyInfo.getDataSize();
        int binIndex = ReconUtils.getBinIndex(dataSize);
        nsSummary.setNumOfFiles(numOfFile - 1);
        nsSummary.setSizeOfFiles(sizeOfFile - dataSize);
        int n = binIndex;
        fileBucket[n] = fileBucket[n] - 1;
        nsSummary.setFileSizeBucket(fileBucket);
        this.reconNamespaceSummaryManager.storeNSSummary(parentObjectId, nsSummary);
    }

    private void deleteOmDirectoryInfoOnNamespaceDB(OmDirectoryInfo directoryInfo) throws IOException {
        long parentObjectId = directoryInfo.getParentObjectID();
        long objectId = directoryInfo.getObjectID();
        NSSummary nsSummary = this.reconNamespaceSummaryManager.getNSSummary(parentObjectId);
        if (nsSummary == null) {
            LOG.error("The namespace table is not correctly populated.");
            return;
        }
        nsSummary.removeChildDir(objectId);
        this.reconNamespaceSummaryManager.storeNSSummary(parentObjectId, nsSummary);
    }
}

