/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.tasks.OMDBUpdateEvent;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;
import org.apache.hadoop.ozone.recon.tasks.ReconOmTask;
import org.hadoop.ozone.recon.schema.UtilizationSchemaDefinition;
import org.hadoop.ozone.recon.schema.tables.FileCountBySizeTable;
import org.hadoop.ozone.recon.schema.tables.daos.FileCountBySizeDao;
import org.hadoop.ozone.recon.schema.tables.pojos.FileCountBySize;
import org.jooq.DSLContext;
import org.jooq.Record3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSizeCountTask
implements ReconOmTask {
    private static final Logger LOG = LoggerFactory.getLogger(FileSizeCountTask.class);
    private FileCountBySizeDao fileCountBySizeDao;
    private DSLContext dslContext;

    @Inject
    public FileSizeCountTask(FileCountBySizeDao fileCountBySizeDao, UtilizationSchemaDefinition utilizationSchemaDefinition) {
        this.fileCountBySizeDao = fileCountBySizeDao;
        this.dslContext = utilizationSchemaDefinition.getDSLContext();
    }

    @Override
    public Pair<String, Boolean> reprocess(OMMetadataManager omMetadataManager) {
        Table omKeyInfoTable = omMetadataManager.getKeyTable();
        HashMap<FileSizeCountKey, Long> fileSizeCountMap = new HashMap<FileSizeCountKey, Long>();
        try (TableIterator keyIter = omKeyInfoTable.iterator();){
            while (keyIter.hasNext()) {
                Table.KeyValue kv = (Table.KeyValue)keyIter.next();
                this.handlePutKeyEvent((OmKeyInfo)kv.getValue(), fileSizeCountMap);
            }
        }
        catch (IOException ioEx) {
            LOG.error("Unable to populate File Size Count in Recon DB. ", (Throwable)ioEx);
            return new ImmutablePair((Object)this.getTaskName(), (Object)false);
        }
        int execute = this.dslContext.delete((org.jooq.Table)FileCountBySizeTable.FILE_COUNT_BY_SIZE).execute();
        LOG.info("Deleted {} records from {}", (Object)execute, (Object)FileCountBySizeTable.FILE_COUNT_BY_SIZE);
        this.writeCountsToDB(true, fileSizeCountMap);
        LOG.info("Completed a 'reprocess' run of FileSizeCountTask.");
        return new ImmutablePair((Object)this.getTaskName(), (Object)true);
    }

    @Override
    public String getTaskName() {
        return "FileSizeCountTask";
    }

    public Collection<String> getTaskTables() {
        return Collections.singletonList("keyTable");
    }

    @Override
    public Pair<String, Boolean> process(OMUpdateEventBatch events) {
        Iterator<OMDBUpdateEvent> eventIterator = events.getIterator();
        HashMap<FileSizeCountKey, Long> fileSizeCountMap = new HashMap<FileSizeCountKey, Long>();
        Collection<String> taskTables = this.getTaskTables();
        while (eventIterator.hasNext()) {
            OMDBUpdateEvent omdbUpdateEvent = eventIterator.next();
            if (!taskTables.contains(omdbUpdateEvent.getTable())) continue;
            String updatedKey = (String)omdbUpdateEvent.getKey();
            OmKeyInfo omKeyInfo = (OmKeyInfo)omdbUpdateEvent.getValue();
            try {
                switch (omdbUpdateEvent.getAction()) {
                    case PUT: {
                        this.handlePutKeyEvent(omKeyInfo, fileSizeCountMap);
                        break;
                    }
                    case DELETE: {
                        this.handleDeleteKeyEvent(updatedKey, omKeyInfo, fileSizeCountMap);
                        break;
                    }
                    case UPDATE: {
                        this.handleDeleteKeyEvent(updatedKey, (OmKeyInfo)omdbUpdateEvent.getOldValue(), fileSizeCountMap);
                        this.handlePutKeyEvent(omKeyInfo, fileSizeCountMap);
                        break;
                    }
                    default: {
                        LOG.trace("Skipping DB update event : {}", (Object)omdbUpdateEvent.getAction());
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Unexpected exception while processing key {}.", (Object)updatedKey, (Object)e);
                return new ImmutablePair((Object)this.getTaskName(), (Object)false);
            }
        }
        this.writeCountsToDB(false, fileSizeCountMap);
        LOG.info("Completed a 'process' run of FileSizeCountTask.");
        return new ImmutablePair((Object)this.getTaskName(), (Object)true);
    }

    private void writeCountsToDB(boolean isDbTruncated, Map<FileSizeCountKey, Long> fileSizeCountMap) {
        fileSizeCountMap.keySet().forEach(key -> {
            FileCountBySize newRecord = new FileCountBySize();
            newRecord.setVolume(((FileSizeCountKey)key).volume);
            newRecord.setBucket(((FileSizeCountKey)key).bucket);
            newRecord.setFileSize(((FileSizeCountKey)key).fileSizeUpperBound);
            newRecord.setCount((Long)fileSizeCountMap.get(key));
            if (!isDbTruncated) {
                Record3 recordToFind = this.dslContext.newRecord(FileCountBySizeTable.FILE_COUNT_BY_SIZE.VOLUME, FileCountBySizeTable.FILE_COUNT_BY_SIZE.BUCKET, FileCountBySizeTable.FILE_COUNT_BY_SIZE.FILE_SIZE).value1((Object)((FileSizeCountKey)key).volume).value2((Object)((FileSizeCountKey)key).bucket).value3((Object)((FileSizeCountKey)key).fileSizeUpperBound);
                FileCountBySize fileCountRecord = (FileCountBySize)this.fileCountBySizeDao.findById(recordToFind);
                if (fileCountRecord == null && newRecord.getCount() > 0L) {
                    this.fileCountBySizeDao.insert(newRecord);
                } else if (fileCountRecord != null) {
                    newRecord.setCount(fileCountRecord.getCount() + (Long)fileSizeCountMap.get(key));
                    this.fileCountBySizeDao.update(newRecord);
                }
            } else if (newRecord.getCount() > 0L) {
                this.fileCountBySizeDao.insert(newRecord);
            }
        });
    }

    private FileSizeCountKey getFileSizeCountKey(OmKeyInfo omKeyInfo) {
        return new FileSizeCountKey(omKeyInfo.getVolumeName(), omKeyInfo.getBucketName(), ReconUtils.getFileSizeUpperBound(omKeyInfo.getDataSize()));
    }

    private void handlePutKeyEvent(OmKeyInfo omKeyInfo, Map<FileSizeCountKey, Long> fileSizeCountMap) {
        FileSizeCountKey key = this.getFileSizeCountKey(omKeyInfo);
        Long count = fileSizeCountMap.containsKey(key) ? fileSizeCountMap.get(key) + 1L : 1L;
        fileSizeCountMap.put(key, count);
    }

    private void handleDeleteKeyEvent(String key, OmKeyInfo omKeyInfo, Map<FileSizeCountKey, Long> fileSizeCountMap) {
        if (omKeyInfo == null) {
            LOG.warn("Deleting a key not found while handling DELETE key event. Key not found in Recon OM DB : {}", (Object)key);
        } else {
            FileSizeCountKey countKey = this.getFileSizeCountKey(omKeyInfo);
            Long count = fileSizeCountMap.containsKey(countKey) ? fileSizeCountMap.get(countKey) - 1L : -1L;
            fileSizeCountMap.put(countKey, count);
        }
    }

    private static class FileSizeCountKey {
        private String volume;
        private String bucket;
        private Long fileSizeUpperBound;

        FileSizeCountKey(String volume, String bucket, Long fileSizeUpperBound) {
            this.volume = volume;
            this.bucket = bucket;
            this.fileSizeUpperBound = fileSizeUpperBound;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FileSizeCountKey) {
                FileSizeCountKey s = (FileSizeCountKey)obj;
                return this.volume.equals(s.volume) && this.bucket.equals(s.bucket) && this.fileSizeUpperBound.equals(s.fileSizeUpperBound);
            }
            return false;
        }

        public int hashCode() {
            return (this.volume + this.bucket + this.fileSizeUpperBound).hashCode();
        }
    }
}

