/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.spi.impl;

import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.ozone.recon.spi.StorageContainerServiceProvider;

public class StorageContainerServiceProviderImpl
implements StorageContainerServiceProvider {
    private StorageContainerLocationProtocol scmClient;

    @Inject
    public StorageContainerServiceProviderImpl(StorageContainerLocationProtocol scmClient) {
        this.scmClient = scmClient;
    }

    @Override
    public List<Pipeline> getPipelines() throws IOException {
        return this.scmClient.listPipelines();
    }

    @Override
    public Pipeline getPipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        return this.scmClient.getPipeline(pipelineID);
    }

    @Override
    public ContainerWithPipeline getContainerWithPipeline(long containerId) throws IOException {
        return this.scmClient.getContainerWithPipeline(containerId);
    }

    @Override
    public List<ContainerWithPipeline> getExistContainerWithPipelinesInBatch(List<Long> containerIDs) {
        return this.scmClient.getExistContainerWithPipelinesInBatch(containerIDs);
    }

    @Override
    public List<HddsProtos.Node> getNodes() throws IOException {
        return this.scmClient.queryNode(null, null, HddsProtos.QueryScope.CLUSTER, "", 1);
    }
}

