/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.spi.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.ProvisionException;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.spi.impl.ReconDBDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconDBProvider {
    private OzoneConfiguration configuration;
    private ReconUtils reconUtils;
    private DBStore dbStore;
    @VisibleForTesting
    private static final Logger LOG = LoggerFactory.getLogger(ReconDBProvider.class);

    @Inject
    ReconDBProvider(OzoneConfiguration configuration, ReconUtils reconUtils) {
        this.configuration = configuration;
        this.reconUtils = reconUtils;
        this.dbStore = this.provideReconDB();
    }

    public DBStore provideReconDB() {
        DBStore db;
        File reconDbDir = this.reconUtils.getReconDbDir((ConfigurationSource)this.configuration, "ozone.recon.db.dir");
        File lastKnownContainerKeyDb = this.reconUtils.getLastKnownDB(reconDbDir, "recon-container-key.db");
        if (lastKnownContainerKeyDb != null) {
            LOG.info("Last known Recon DB : {}", (Object)lastKnownContainerKeyDb.getAbsolutePath());
            db = ReconDBProvider.initializeDBStore(this.configuration, lastKnownContainerKeyDb.getName());
        } else {
            db = ReconDBProvider.getNewDBStore(this.configuration);
        }
        if (db == null) {
            throw new ProvisionException("Unable to provide instance of DBStore store.");
        }
        return db;
    }

    public DBStore getDbStore() {
        return this.dbStore;
    }

    static void truncateTable(Table table) throws IOException {
        if (table == null) {
            return;
        }
        for (Table.KeyValue entry : table) {
            table.delete(entry.getKey());
        }
    }

    static DBStore getNewDBStore(OzoneConfiguration configuration) {
        String dbName = "recon-container-key.db_" + System.currentTimeMillis();
        return ReconDBProvider.initializeDBStore(configuration, dbName);
    }

    private static DBStore initializeDBStore(OzoneConfiguration configuration, String dbName) {
        DBStore dbStore = null;
        try {
            dbStore = DBStoreBuilder.createDBStore((ConfigurationSource)configuration, (DBDefinition)new ReconDBDefinition(dbName));
        }
        catch (Exception ex) {
            LOG.error("Unable to initialize Recon container metadata store.", (Throwable)ex);
        }
        return dbStore;
    }

    public void close() throws Exception {
        if (this.dbStore != null) {
            this.dbStore.close();
            this.dbStore = null;
        }
    }
}

