/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.spi.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.api.types.ContainerKeyPrefix;
import org.apache.hadoop.ozone.recon.api.types.ContainerMetadata;
import org.apache.hadoop.ozone.recon.scm.ContainerReplicaHistory;
import org.apache.hadoop.ozone.recon.scm.ContainerReplicaHistoryList;
import org.apache.hadoop.ozone.recon.spi.ReconContainerMetadataManager;
import org.apache.hadoop.ozone.recon.spi.impl.ReconDBDefinition;
import org.apache.hadoop.ozone.recon.spi.impl.ReconDBProvider;
import org.hadoop.ozone.recon.schema.tables.daos.GlobalStatsDao;
import org.hadoop.ozone.recon.schema.tables.pojos.GlobalStats;
import org.jooq.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReconContainerMetadataManagerImpl
implements ReconContainerMetadataManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReconContainerMetadataManagerImpl.class);
    private Table<ContainerKeyPrefix, Integer> containerKeyTable;
    private Table<Long, Long> containerKeyCountTable;
    private Table<Long, ContainerReplicaHistoryList> containerReplicaHistoryTable;
    private GlobalStatsDao globalStatsDao;
    private DBStore containerDbStore;
    @Inject
    private Configuration sqlConfiguration;

    @Inject
    public ReconContainerMetadataManagerImpl(ReconDBProvider reconDBProvider, Configuration sqlConfiguration) {
        this.containerDbStore = reconDBProvider.getDbStore();
        this.globalStatsDao = new GlobalStatsDao(sqlConfiguration);
        this.initializeTables();
    }

    @Override
    public void reinitWithNewContainerDataFromOm(Map<ContainerKeyPrefix, Integer> containerKeyPrefixCounts) throws IOException {
        ReconDBProvider.truncateTable(this.containerKeyTable);
        ReconDBProvider.truncateTable(this.containerKeyCountTable);
        this.initializeTables();
        if (containerKeyPrefixCounts != null) {
            for (Map.Entry<ContainerKeyPrefix, Integer> entry : containerKeyPrefixCounts.entrySet()) {
                this.containerKeyTable.put((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        this.storeContainerCount(0L);
    }

    private void initializeTables() {
        try {
            this.containerKeyTable = ReconDBDefinition.CONTAINER_KEY.getTable(this.containerDbStore);
            this.containerKeyCountTable = ReconDBDefinition.CONTAINER_KEY_COUNT.getTable(this.containerDbStore);
            this.containerReplicaHistoryTable = ReconDBDefinition.REPLICA_HISTORY.getTable(this.containerDbStore);
        }
        catch (IOException e) {
            LOG.error("Unable to create Container Key tables.", (Throwable)e);
        }
    }

    @Override
    public void storeContainerKeyMapping(ContainerKeyPrefix containerKeyPrefix, Integer count) throws IOException {
        this.containerKeyTable.put((Object)containerKeyPrefix, (Object)count);
    }

    @Override
    public void storeContainerKeyCount(Long containerID, Long count) throws IOException {
        this.containerKeyCountTable.put((Object)containerID, (Object)count);
    }

    @Override
    public void storeContainerReplicaHistory(Long containerID, Map<UUID, ContainerReplicaHistory> tsMap) throws IOException {
        ArrayList<ContainerReplicaHistory> tsList = new ArrayList<ContainerReplicaHistory>();
        for (Map.Entry<UUID, ContainerReplicaHistory> e : tsMap.entrySet()) {
            tsList.add(e.getValue());
        }
        this.containerReplicaHistoryTable.put((Object)containerID, (Object)new ContainerReplicaHistoryList(tsList));
    }

    @Override
    public void batchStoreContainerReplicaHistory(Map<Long, Map<UUID, ContainerReplicaHistory>> replicaHistoryMap) throws IOException {
        BatchOperation batchOperation = this.containerDbStore.initBatchOperation();
        for (Map.Entry<Long, Map<UUID, ContainerReplicaHistory>> entry : replicaHistoryMap.entrySet()) {
            long containerId = entry.getKey();
            Map<UUID, ContainerReplicaHistory> tsMap = entry.getValue();
            ArrayList<ContainerReplicaHistory> tsList = new ArrayList<ContainerReplicaHistory>();
            for (Map.Entry<UUID, ContainerReplicaHistory> e : tsMap.entrySet()) {
                tsList.add(e.getValue());
            }
            this.containerReplicaHistoryTable.putWithBatch(batchOperation, (Object)containerId, (Object)new ContainerReplicaHistoryList(tsList));
        }
        this.containerDbStore.commitBatchOperation(batchOperation);
    }

    @Override
    public long getKeyCountForContainer(Long containerID) throws IOException {
        Long keyCount = (Long)this.containerKeyCountTable.get((Object)containerID);
        return keyCount == null ? 0L : keyCount;
    }

    @Override
    public Map<UUID, ContainerReplicaHistory> getContainerReplicaHistory(Long containerID) throws IOException {
        ContainerReplicaHistoryList tsList = (ContainerReplicaHistoryList)this.containerReplicaHistoryTable.get((Object)containerID);
        if (tsList == null) {
            return new HashMap<UUID, ContainerReplicaHistory>();
        }
        HashMap<UUID, ContainerReplicaHistory> res = new HashMap<UUID, ContainerReplicaHistory>();
        for (ContainerReplicaHistory ts : tsList.getList()) {
            UUID uuid = ts.getUuid();
            res.put(uuid, ts);
        }
        return res;
    }

    @Override
    public boolean doesContainerExists(Long containerID) throws IOException {
        return this.containerKeyCountTable.isExist((Object)containerID);
    }

    @Override
    public Integer getCountForContainerKeyPrefix(ContainerKeyPrefix containerKeyPrefix) throws IOException {
        Integer count = (Integer)this.containerKeyTable.get((Object)containerKeyPrefix);
        return count == null ? Integer.valueOf(0) : count;
    }

    @Override
    public Map<ContainerKeyPrefix, Integer> getKeyPrefixesForContainer(long containerId) throws IOException {
        return this.getKeyPrefixesForContainer(containerId, "");
    }

    @Override
    public Map<ContainerKeyPrefix, Integer> getKeyPrefixesForContainer(long containerId, String prevKeyPrefix) throws IOException {
        ContainerKeyPrefix seekKey;
        LinkedHashMap<ContainerKeyPrefix, Integer> prefixes = new LinkedHashMap<ContainerKeyPrefix, Integer>();
        TableIterator containerIterator = this.containerKeyTable.iterator();
        boolean skipPrevKey = false;
        if (StringUtils.isNotBlank((CharSequence)prevKeyPrefix)) {
            skipPrevKey = true;
            seekKey = new ContainerKeyPrefix(containerId, prevKeyPrefix);
        } else {
            seekKey = new ContainerKeyPrefix(containerId);
        }
        Table.KeyValue seekKeyValue = (Table.KeyValue)containerIterator.seek((Object)seekKey);
        if (seekKeyValue == null || StringUtils.isNotBlank((CharSequence)prevKeyPrefix) && !((ContainerKeyPrefix)seekKeyValue.getKey()).getKeyPrefix().equals(prevKeyPrefix)) {
            return prefixes;
        }
        while (containerIterator.hasNext()) {
            Table.KeyValue keyValue = (Table.KeyValue)containerIterator.next();
            ContainerKeyPrefix containerKeyPrefix = (ContainerKeyPrefix)keyValue.getKey();
            if (skipPrevKey && containerKeyPrefix.getKeyPrefix().equals(prevKeyPrefix)) continue;
            if (containerKeyPrefix.getContainerId() != containerId) break;
            if (StringUtils.isNotEmpty((CharSequence)containerKeyPrefix.getKeyPrefix())) {
                prefixes.put(new ContainerKeyPrefix(containerId, containerKeyPrefix.getKeyPrefix(), containerKeyPrefix.getKeyVersion()), (Integer)keyValue.getValue());
                continue;
            }
            LOG.warn("Null key prefix returned for containerId = {} ", (Object)containerId);
        }
        return prefixes;
    }

    @Override
    public Map<Long, ContainerMetadata> getContainers(int limit, long prevContainer) throws IOException {
        LinkedHashMap<Long, ContainerMetadata> containers = new LinkedHashMap<Long, ContainerMetadata>();
        TableIterator containerIterator = this.containerKeyTable.iterator();
        if (prevContainer > 0L) {
            ContainerKeyPrefix seekKey = new ContainerKeyPrefix(prevContainer);
            Table.KeyValue seekKeyValue = (Table.KeyValue)containerIterator.seek((Object)seekKey);
            if (seekKeyValue != null && ((ContainerKeyPrefix)seekKeyValue.getKey()).getContainerId() != prevContainer) {
                return containers;
            }
            seekKey = new ContainerKeyPrefix(prevContainer + 1L);
            containerIterator.seek((Object)seekKey);
        }
        while (containerIterator.hasNext()) {
            Table.KeyValue keyValue = (Table.KeyValue)containerIterator.next();
            ContainerKeyPrefix containerKeyPrefix = (ContainerKeyPrefix)keyValue.getKey();
            Long containerID = containerKeyPrefix.getContainerId();
            Integer numberOfKeys = (Integer)keyValue.getValue();
            if (containers.size() == limit && !containers.containsKey(containerID)) break;
            containers.computeIfAbsent(containerID, ContainerMetadata::new);
            ContainerMetadata containerMetadata = (ContainerMetadata)containers.get(containerID);
            containerMetadata.setNumberOfKeys(containerMetadata.getNumberOfKeys() + (long)numberOfKeys.intValue());
            containers.put(containerID, containerMetadata);
        }
        return containers;
    }

    @Override
    public void deleteContainerMapping(ContainerKeyPrefix containerKeyPrefix) throws IOException {
        this.containerKeyTable.delete((Object)containerKeyPrefix);
    }

    @Override
    public long getCountForContainers() {
        GlobalStats containerCountRecord = this.globalStatsDao.fetchOneByKey("containerCount");
        return containerCountRecord == null ? 0L : containerCountRecord.getValue();
    }

    @Override
    public TableIterator getContainerTableIterator() {
        return this.containerKeyTable.iterator();
    }

    @Override
    public void storeContainerCount(Long count) {
        ReconUtils.upsertGlobalStatsTable(this.sqlConfiguration, this.globalStatsDao, "containerCount", count);
    }

    @Override
    public void incrementContainerCountBy(long count) {
        long containersCount = this.getCountForContainers();
        this.storeContainerCount(containersCount + count);
    }
}

