/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.ha.SCMHAManager;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineFactory;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManagerImpl;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManagerImpl;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.recon.scm.ReconPipelineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReconPipelineManager
extends PipelineManagerImpl {
    private static final Logger LOG = LoggerFactory.getLogger(ReconPipelineManager.class);

    private ReconPipelineManager(ConfigurationSource conf, SCMHAManager scmhaManager, NodeManager nodeManager, PipelineStateManager pipelineStateManager, PipelineFactory pipelineFactory, EventPublisher eventPublisher, SCMContext scmContext) {
        super(conf, scmhaManager, nodeManager, pipelineStateManager, pipelineFactory, eventPublisher, scmContext);
    }

    public static ReconPipelineManager newReconPipelineManager(ConfigurationSource conf, NodeManager nodeManager, Table<PipelineID, Pipeline> pipelineStore, EventPublisher eventPublisher, SCMHAManager scmhaManager, SCMContext scmContext) throws IOException {
        PipelineStateManager stateManager = PipelineStateManagerImpl.newBuilder().setPipelineStore(pipelineStore).setNodeManager(nodeManager).setRatisServer(scmhaManager.getRatisServer()).setSCMDBTransactionBuffer(scmhaManager.getDBTransactionBuffer()).build();
        ReconPipelineFactory pipelineFactory = new ReconPipelineFactory();
        return new ReconPipelineManager(conf, scmhaManager, nodeManager, stateManager, pipelineFactory, eventPublisher, scmContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializePipelines(List<Pipeline> pipelinesFromScm) throws IOException {
        this.acquireWriteLock();
        try {
            List pipelinesInHouse = this.getPipelines();
            LOG.info("Recon has {} pipelines in house.", (Object)pipelinesInHouse.size());
            for (Pipeline pipeline : pipelinesFromScm) {
                if (!this.containsPipeline(pipeline.getId())) {
                    LOG.info("Adding new pipeline {} from SCM.", (Object)pipeline.getId());
                    this.addPipeline(pipeline);
                } else {
                    this.getStateManager().updatePipelineState(pipeline.getId().getProtobuf(), Pipeline.PipelineState.getProtobuf((Pipeline.PipelineState)pipeline.getPipelineState()));
                    this.getPipeline(pipeline.getId()).setCreationTimestamp(pipeline.getCreationTimestamp());
                }
                this.removeInvalidPipelines(pipelinesFromScm);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvalidPipelines(List<Pipeline> pipelinesFromScm) {
        this.acquireWriteLock();
        try {
            List pipelinesInHouse = this.getPipelines();
            List<Pipeline> invalidPipelines = pipelinesInHouse.stream().filter(p -> !pipelinesFromScm.contains(p)).collect(Collectors.toList());
            invalidPipelines.forEach(p -> {
                PipelineID pipelineID = p.getId();
                if (!p.getPipelineState().equals((Object)Pipeline.PipelineState.CLOSED)) {
                    try {
                        this.getStateManager().updatePipelineState(pipelineID.getProtobuf(), HddsProtos.PipelineState.PIPELINE_CLOSED);
                    }
                    catch (IOException e) {
                        LOG.warn("Pipeline {} not found while updating state. ", (Object)p.getId(), (Object)e);
                    }
                }
                try {
                    LOG.info("Removing invalid pipeline {} from Recon.", (Object)pipelineID);
                    this.closePipeline((Pipeline)p, false);
                }
                catch (IOException e) {
                    LOG.warn("Unable to remove pipeline {}", (Object)pipelineID, (Object)e);
                }
            });
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @VisibleForTesting
    public void addPipeline(Pipeline pipeline) throws IOException {
        this.acquireWriteLock();
        try {
            this.getStateManager().addPipeline(pipeline.getProtobufMessage(1));
        }
        finally {
            this.releaseWriteLock();
        }
    }
}

