/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManagerImpl;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaNotFoundException;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.ha.SCMHAManager;
import org.apache.hadoop.hdds.scm.ha.SequenceIdGenerator;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.recon.persistence.ContainerHealthSchemaManager;
import org.apache.hadoop.ozone.recon.persistence.ContainerHistory;
import org.apache.hadoop.ozone.recon.scm.ContainerReplicaHistory;
import org.apache.hadoop.ozone.recon.scm.ReconSCMDBDefinition;
import org.apache.hadoop.ozone.recon.spi.ReconContainerMetadataManager;
import org.apache.hadoop.ozone.recon.spi.StorageContainerServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconContainerManager
extends ContainerManagerImpl {
    private static final Logger LOG = LoggerFactory.getLogger(ReconContainerManager.class);
    private StorageContainerServiceProvider scmClient;
    private PipelineManager pipelineManager;
    private final ContainerHealthSchemaManager containerHealthSchemaManager;
    private final ReconContainerMetadataManager cdbServiceProvider;
    private final Table<UUID, DatanodeDetails> nodeDB;
    private final Map<Long, Map<UUID, ContainerReplicaHistory>> replicaHistoryMap;
    private final Map<PipelineID, Integer> pipelineToOpenContainer;

    public ReconContainerManager(Configuration conf, DBStore store, Table<ContainerID, ContainerInfo> containerStore, PipelineManager pipelineManager, StorageContainerServiceProvider scm, ContainerHealthSchemaManager containerHealthSchemaManager, ReconContainerMetadataManager reconContainerMetadataManager, SCMHAManager scmhaManager, SequenceIdGenerator sequenceIdGen) throws IOException {
        super(conf, scmhaManager, sequenceIdGen, pipelineManager, containerStore);
        this.scmClient = scm;
        this.pipelineManager = pipelineManager;
        this.containerHealthSchemaManager = containerHealthSchemaManager;
        this.cdbServiceProvider = reconContainerMetadataManager;
        this.nodeDB = ReconSCMDBDefinition.NODES.getTable(store);
        this.replicaHistoryMap = new ConcurrentHashMap<Long, Map<UUID, ContainerReplicaHistory>>();
        this.pipelineToOpenContainer = new ConcurrentHashMap<PipelineID, Integer>();
    }

    public void checkAndAddNewContainer(ContainerID containerID, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State replicaState, DatanodeDetails datanodeDetails) throws Exception {
        if (!this.containerExist(containerID)) {
            LOG.info("New container {} got from {}.", (Object)containerID, (Object)datanodeDetails.getHostName());
            ContainerWithPipeline containerWithPipeline = this.scmClient.getContainerWithPipeline(containerID.getId());
            LOG.debug("Verified new container from SCM {}, {} ", (Object)containerID, (Object)containerWithPipeline.getPipeline().getId());
            this.addNewContainer(containerWithPipeline);
        } else {
            this.checkContainerStateAndUpdate(containerID, replicaState);
        }
    }

    public void checkAndAddNewContainerBatch(List<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto> containerReplicaProtoList) {
        Map<Boolean, List<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto>> containers = containerReplicaProtoList.parallelStream().collect(Collectors.groupingBy(c -> this.containerExist(ContainerID.valueOf((long)c.getContainerID()))));
        List<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto> existContainers = null;
        if (containers.containsKey(true)) {
            existContainers = containers.get(true);
        }
        List noExistContainers = null;
        if (containers.containsKey(false)) {
            noExistContainers = containers.get(false).parallelStream().map(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto::getContainerID).collect(Collectors.toList());
        }
        if (null != noExistContainers) {
            List<ContainerWithPipeline> verifiedContainerPipeline = this.scmClient.getExistContainerWithPipelinesInBatch(noExistContainers);
            LOG.debug("{} new containers have been verified by SCM , {} containers not found at SCM", (Object)verifiedContainerPipeline.size(), (Object)(noExistContainers.size() - verifiedContainerPipeline.size()));
            for (ContainerWithPipeline cwp : verifiedContainerPipeline) {
                try {
                    this.addNewContainer(cwp);
                }
                catch (IOException ioe) {
                    LOG.error("Exception while checking and adding new container.", (Throwable)ioe);
                }
            }
        }
        if (null != existContainers) {
            for (StorageContainerDatanodeProtocolProtos.ContainerReplicaProto crp : existContainers) {
                ContainerID cID = ContainerID.valueOf((long)crp.getContainerID());
                StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State crpState = crp.getState();
                try {
                    this.checkContainerStateAndUpdate(cID, crpState);
                }
                catch (Exception ioe) {
                    LOG.error("Exception while checkContainerStateAndUpdate container", (Throwable)ioe);
                }
            }
        }
    }

    private void checkContainerStateAndUpdate(ContainerID containerID, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State state) throws Exception {
        ContainerInfo containerInfo = this.getContainer(containerID);
        if (containerInfo.getState().equals((Object)HddsProtos.LifeCycleState.OPEN) && !state.equals((Object)StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN) && this.isHealthy(state)) {
            LOG.info("Container {} has state OPEN, but given state is {}.", (Object)containerID, (Object)state);
            PipelineID pipelineID = containerInfo.getPipelineID();
            int curCnt = this.pipelineToOpenContainer.getOrDefault(pipelineID, 0);
            if (curCnt == 1) {
                this.pipelineToOpenContainer.remove(pipelineID);
            } else if (curCnt > 0) {
                this.pipelineToOpenContainer.put(pipelineID, curCnt - 1);
            }
            this.updateContainerState(containerID, HddsProtos.LifeCycleEvent.FINALIZE);
        }
    }

    private boolean isHealthy(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State replicaState) {
        return replicaState != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY && replicaState != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.INVALID && replicaState != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.DELETED;
    }

    public void addNewContainer(ContainerWithPipeline containerWithPipeline) throws IOException {
        ContainerInfo containerInfo = containerWithPipeline.getContainerInfo();
        try {
            if (containerInfo.getState().equals((Object)HddsProtos.LifeCycleState.OPEN)) {
                PipelineID pipelineID = containerWithPipeline.getPipeline().getId();
                if (this.pipelineManager.containsPipeline(pipelineID)) {
                    this.getContainerStateManager().addContainer(containerInfo.getProtobuf());
                    this.pipelineManager.addContainerToPipeline(containerWithPipeline.getPipeline().getId(), containerInfo.containerID());
                    this.pipelineToOpenContainer.put(pipelineID, this.pipelineToOpenContainer.getOrDefault(pipelineID, 0) + 1);
                    LOG.info("Successfully added container {} to Recon.", (Object)containerInfo.containerID());
                } else {
                    LOG.warn(String.format("Pipeline %s not found. Cannot add container %s", pipelineID, containerInfo.containerID()));
                }
            } else {
                this.getContainerStateManager().addContainer(containerInfo.getProtobuf());
                LOG.info("Successfully added no open container {} to Recon.", (Object)containerInfo.containerID());
            }
        }
        catch (IOException ex) {
            LOG.info("Exception while adding container {} .", (Object)containerInfo.containerID(), (Object)ex);
            this.pipelineManager.removeContainerFromPipeline(containerInfo.getPipelineID(), ContainerID.valueOf((long)containerInfo.getContainerID()));
            throw ex;
        }
    }

    public void updateContainerReplica(ContainerID containerID, ContainerReplica replica) throws ContainerNotFoundException {
        super.updateContainerReplica(containerID, replica);
        final long currTime = System.currentTimeMillis();
        long id = containerID.getId();
        DatanodeDetails dnInfo = replica.getDatanodeDetails();
        final UUID uuid = dnInfo.getUuid();
        Map<UUID, ContainerReplicaHistory> replicaLastSeenMap = this.replicaHistoryMap.get(id);
        boolean flushToDB = false;
        if (replicaLastSeenMap == null) {
            this.replicaHistoryMap.putIfAbsent(id, (Map<UUID, ContainerReplicaHistory>)new ConcurrentHashMap<UUID, ContainerReplicaHistory>(){
                {
                    this.put(uuid, new ContainerReplicaHistory(uuid, currTime, currTime));
                }
            });
            flushToDB = true;
        } else {
            ContainerReplicaHistory ts = replicaLastSeenMap.get(uuid);
            if (ts == null) {
                replicaLastSeenMap.put(uuid, new ContainerReplicaHistory(uuid, currTime, currTime));
                flushToDB = true;
            } else {
                ts.setLastSeenTime(currTime);
            }
        }
        if (flushToDB) {
            this.upsertContainerHistory(id, uuid, currTime);
        }
    }

    public void removeContainerReplica(ContainerID containerID, ContainerReplica replica) throws ContainerNotFoundException, ContainerReplicaNotFoundException {
        ContainerReplicaHistory ts;
        super.removeContainerReplica(containerID, replica);
        long id = containerID.getId();
        DatanodeDetails dnInfo = replica.getDatanodeDetails();
        UUID uuid = dnInfo.getUuid();
        Map<UUID, ContainerReplicaHistory> replicaLastSeenMap = this.replicaHistoryMap.get(id);
        if (replicaLastSeenMap != null && (ts = replicaLastSeenMap.get(uuid)) != null) {
            this.upsertContainerHistory(id, uuid, ts.getLastSeenTime());
            replicaLastSeenMap.remove(uuid);
        }
    }

    @VisibleForTesting
    public ContainerHealthSchemaManager getContainerSchemaManager() {
        return this.containerHealthSchemaManager;
    }

    @VisibleForTesting
    public Map<Long, Map<UUID, ContainerReplicaHistory>> getReplicaHistoryMap() {
        return this.replicaHistoryMap;
    }

    public List<ContainerHistory> getAllContainerHistory(long containerID) {
        Map<UUID, ContainerReplicaHistory> replicaLastSeenMap;
        Map<UUID, ContainerReplicaHistory> resMap;
        try {
            resMap = this.cdbServiceProvider.getContainerReplicaHistory(containerID);
        }
        catch (IOException ex) {
            resMap = new HashMap<UUID, ContainerReplicaHistory>();
            LOG.debug("Unable to retrieve container replica history from RDB.");
        }
        if (this.replicaHistoryMap != null && (replicaLastSeenMap = this.replicaHistoryMap.get(containerID)) != null) {
            Map<UUID, ContainerReplicaHistory> finalResMap = resMap;
            replicaLastSeenMap.forEach((k, v) -> finalResMap.merge((UUID)k, (ContainerReplicaHistory)v, (old, latest) -> latest));
            resMap = finalResMap;
        }
        ArrayList<ContainerHistory> resList = new ArrayList<ContainerHistory>();
        for (Map.Entry<UUID, ContainerReplicaHistory> entry : resMap.entrySet()) {
            UUID uuid = entry.getKey();
            String hostname = "N/A";
            if (this.nodeDB != null) {
                try {
                    DatanodeDetails dnDetails = (DatanodeDetails)this.nodeDB.get((Object)uuid);
                    if (dnDetails != null) {
                        hostname = dnDetails.getHostName();
                    }
                }
                catch (IOException ex) {
                    LOG.debug("Unable to retrieve from NODES table of node {}. {}", (Object)uuid, (Object)ex.getMessage());
                }
            }
            long firstSeenTime = entry.getValue().getFirstSeenTime();
            long lastSeenTime = entry.getValue().getLastSeenTime();
            resList.add(new ContainerHistory(containerID, uuid.toString(), hostname, firstSeenTime, lastSeenTime));
        }
        return resList;
    }

    public List<ContainerHistory> getLatestContainerHistory(long containerID, int limit) {
        List<ContainerHistory> res = this.getAllContainerHistory(containerID);
        res.sort(Comparator.comparingLong(ContainerHistory::getLastSeenTime).reversed());
        return res.stream().limit(limit).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushReplicaHistoryMapToDB(boolean clearMap) {
        if (this.replicaHistoryMap == null) {
            return;
        }
        Map<Long, Map<UUID, ContainerReplicaHistory>> map = this.replicaHistoryMap;
        synchronized (map) {
            try {
                this.cdbServiceProvider.batchStoreContainerReplicaHistory(this.replicaHistoryMap);
            }
            catch (IOException e) {
                LOG.debug("Error flushing container replica history to DB. {}", (Object)e.getMessage());
            }
            if (clearMap) {
                this.replicaHistoryMap.clear();
            }
        }
    }

    public void upsertContainerHistory(long containerID, UUID uuid, long time) {
        try {
            Map<UUID, ContainerReplicaHistory> tsMap = this.cdbServiceProvider.getContainerReplicaHistory(containerID);
            ContainerReplicaHistory ts = tsMap.get(uuid);
            if (ts == null) {
                tsMap.put(uuid, new ContainerReplicaHistory(uuid, time, time));
            } else {
                ts.setLastSeenTime(time);
            }
            this.cdbServiceProvider.storeContainerReplicaHistory(containerID, tsMap);
        }
        catch (IOException e) {
            LOG.debug("Error on DB operations. {}", (Object)e.getMessage());
        }
    }

    public Table<UUID, DatanodeDetails> getNodeDB() {
        return this.nodeDB;
    }

    public Map<PipelineID, Integer> getPipelineToOpenContainer() {
        return this.pipelineToOpenContainer;
    }
}

