/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.LongCodec;
import org.apache.hadoop.ozone.recon.scm.ContainerReplicaHistory;
import org.apache.hadoop.ozone.recon.scm.ContainerReplicaHistoryList;

public class ContainerReplicaHistoryListCodec
implements Codec<ContainerReplicaHistoryList> {
    static final int SIZE_PER_ENTRY = 32;
    private final Codec<Long> lc = new LongCodec();

    public byte[] toPersistedFormat(ContainerReplicaHistoryList obj) throws IOException {
        List<ContainerReplicaHistory> lst = obj.getList();
        int sizeOfRes = 32 * lst.size();
        ByteArrayOutputStream out = new ByteArrayOutputStream(sizeOfRes);
        for (ContainerReplicaHistory ts : lst) {
            out.write(this.lc.toPersistedFormat((Object)ts.getUuid().getMostSignificantBits()));
            out.write(this.lc.toPersistedFormat((Object)ts.getUuid().getLeastSignificantBits()));
            out.write(this.lc.toPersistedFormat((Object)ts.getFirstSeenTime()));
            out.write(this.lc.toPersistedFormat((Object)ts.getLastSeenTime()));
        }
        return out.toByteArray();
    }

    public ContainerReplicaHistoryList fromPersistedFormat(byte[] rawData) throws IOException {
        assert (rawData.length % 32 == 0);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(rawData));
        ArrayList<ContainerReplicaHistory> lst = new ArrayList<ContainerReplicaHistory>();
        while (in.available() > 0) {
            long uuidMsb = in.readLong();
            long uuidLsb = in.readLong();
            long firstSeenTime = in.readLong();
            long lastSeenTime = in.readLong();
            UUID id = new UUID(uuidMsb, uuidLsb);
            lst.add(new ContainerReplicaHistory(id, firstSeenTime, lastSeenTime));
        }
        in.close();
        return new ContainerReplicaHistoryList(lst);
    }

    public ContainerReplicaHistoryList copyObject(ContainerReplicaHistoryList obj) {
        return obj;
    }
}

