/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.types;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.ozone.recon.ReconConstants;

public class NSSummary {
    private int numOfFiles;
    private long sizeOfFiles;
    private int[] fileSizeBucket;
    private Set<Long> childDir;
    private String dirName;

    public NSSummary() {
        this.numOfFiles = 0;
        this.sizeOfFiles = 0L;
        this.fileSizeBucket = new int[ReconConstants.NUM_OF_BINS];
        this.childDir = new HashSet<Long>();
        this.dirName = "";
    }

    public NSSummary(int numOfFiles, long sizeOfFiles, int[] bucket, Set<Long> childDir, String dirName) {
        this.numOfFiles = numOfFiles;
        this.sizeOfFiles = sizeOfFiles;
        this.setFileSizeBucket(bucket);
        this.childDir = childDir;
        this.dirName = dirName;
    }

    public int getNumOfFiles() {
        return this.numOfFiles;
    }

    public long getSizeOfFiles() {
        return this.sizeOfFiles;
    }

    public int[] getFileSizeBucket() {
        return Arrays.copyOf(this.fileSizeBucket, ReconConstants.NUM_OF_BINS);
    }

    public Set<Long> getChildDir() {
        return this.childDir;
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setNumOfFiles(int numOfFiles) {
        this.numOfFiles = numOfFiles;
    }

    public void setSizeOfFiles(long sizeOfFiles) {
        this.sizeOfFiles = sizeOfFiles;
    }

    public void setFileSizeBucket(int[] fileSizeBucket) {
        this.fileSizeBucket = Arrays.copyOf(fileSizeBucket, ReconConstants.NUM_OF_BINS);
    }

    public void setChildDir(Set<Long> childDir) {
        this.childDir = childDir;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public void addChildDir(long childId) {
        if (this.childDir.contains(childId)) {
            return;
        }
        this.childDir.add(childId);
    }

    public void removeChildDir(long childId) {
        if (this.childDir.contains(childId)) {
            this.childDir.remove(childId);
        }
    }
}

