/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.recon.ReconConstants;
import org.apache.hadoop.ozone.recon.api.AdminOnly;
import org.apache.hadoop.ozone.recon.api.types.DUResponse;
import org.apache.hadoop.ozone.recon.api.types.EntityType;
import org.apache.hadoop.ozone.recon.api.types.FileSizeDistributionResponse;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.api.types.NamespaceSummaryResponse;
import org.apache.hadoop.ozone.recon.api.types.QuotaUsageResponse;
import org.apache.hadoop.ozone.recon.api.types.ResponseStatus;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/namespace")
@Produces(value={"application/json"})
@AdminOnly
public class NSSummaryEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(NSSummaryEndpoint.class);
    @Inject
    private ReconNamespaceSummaryManager reconNamespaceSummaryManager;
    @Inject
    private ReconOMMetadataManager omMetadataManager;
    private ContainerManager containerManager;

    @Inject
    public NSSummaryEndpoint(ReconNamespaceSummaryManager namespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM) {
        this.reconNamespaceSummaryManager = namespaceSummaryManager;
        this.omMetadataManager = omMetadataManager;
        this.containerManager = reconSCM.getContainerManager();
    }

    @GET
    @Path(value="/summary")
    public Response getBasicInfo(@QueryParam(value="path") String path) throws IOException {
        if (path == null || path.length() == 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        NamespaceSummaryResponse namespaceSummaryResponse = null;
        if (!this.isInitializationComplete()) {
            namespaceSummaryResponse = new NamespaceSummaryResponse(EntityType.UNKNOWN);
            namespaceSummaryResponse.setStatus(ResponseStatus.INITIALIZING);
            return Response.ok((Object)namespaceSummaryResponse).build();
        }
        String normalizedPath = NSSummaryEndpoint.normalizePath(path);
        String[] names = NSSummaryEndpoint.parseRequestPath(normalizedPath);
        EntityType type = this.getEntityType(normalizedPath, names);
        switch (type) {
            case ROOT: {
                namespaceSummaryResponse = new NamespaceSummaryResponse(EntityType.ROOT);
                List<OmVolumeArgs> volumes = this.listVolumes();
                namespaceSummaryResponse.setNumVolume(volumes.size());
                List<OmBucketInfo> allBuckets = this.listBucketsUnderVolume(null);
                namespaceSummaryResponse.setNumBucket(allBuckets.size());
                int totalNumDir = 0;
                long totalNumKey = 0L;
                for (OmBucketInfo bucket : allBuckets) {
                    long bucketObjectId = bucket.getObjectID();
                    totalNumDir += this.getTotalDirCount(bucketObjectId);
                    totalNumKey += this.getTotalKeyCount(bucketObjectId);
                }
                namespaceSummaryResponse.setNumTotalDir(totalNumDir);
                namespaceSummaryResponse.setNumTotalKey(totalNumKey);
                break;
            }
            case VOLUME: {
                namespaceSummaryResponse = new NamespaceSummaryResponse(EntityType.VOLUME);
                List<OmBucketInfo> buckets = this.listBucketsUnderVolume(names[0]);
                namespaceSummaryResponse.setNumBucket(buckets.size());
                int totalDir = 0;
                long totalKey = 0L;
                for (OmBucketInfo bucket : buckets) {
                    long bucketObjectId = bucket.getObjectID();
                    totalDir += this.getTotalDirCount(bucketObjectId);
                    totalKey += this.getTotalKeyCount(bucketObjectId);
                }
                namespaceSummaryResponse.setNumTotalDir(totalDir);
                namespaceSummaryResponse.setNumTotalKey(totalKey);
                break;
            }
            case BUCKET: {
                namespaceSummaryResponse = new NamespaceSummaryResponse(EntityType.BUCKET);
                assert (names.length == 2);
                long bucketObjectId = this.getBucketObjectId(names);
                namespaceSummaryResponse.setNumTotalDir(this.getTotalDirCount(bucketObjectId));
                namespaceSummaryResponse.setNumTotalKey(this.getTotalKeyCount(bucketObjectId));
                break;
            }
            case DIRECTORY: {
                long dirObjectId = this.getDirObjectId(names);
                namespaceSummaryResponse = new NamespaceSummaryResponse(EntityType.DIRECTORY);
                namespaceSummaryResponse.setNumTotalDir(this.getTotalDirCount(dirObjectId));
                namespaceSummaryResponse.setNumTotalKey(this.getTotalKeyCount(dirObjectId));
                break;
            }
            case KEY: {
                namespaceSummaryResponse = new NamespaceSummaryResponse(EntityType.KEY);
                break;
            }
            case UNKNOWN: {
                namespaceSummaryResponse = new NamespaceSummaryResponse(EntityType.UNKNOWN);
                namespaceSummaryResponse.setStatus(ResponseStatus.PATH_NOT_FOUND);
                break;
            }
        }
        return Response.ok((Object)namespaceSummaryResponse).build();
    }

    @GET
    @Path(value="/du")
    public Response getDiskUsage(@QueryParam(value="path") String path, @DefaultValue(value="false") @QueryParam(value="files") boolean listFile, @DefaultValue(value="false") @QueryParam(value="replica") boolean withReplica) throws IOException {
        if (path == null || path.length() == 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        DUResponse duResponse = new DUResponse();
        if (!this.isInitializationComplete()) {
            duResponse.setStatus(ResponseStatus.INITIALIZING);
            return Response.ok((Object)duResponse).build();
        }
        String normalizedPath = NSSummaryEndpoint.normalizePath(path);
        String[] names = NSSummaryEndpoint.parseRequestPath(normalizedPath);
        EntityType type = this.getEntityType(normalizedPath, names);
        duResponse.setPath(normalizedPath);
        switch (type) {
            case ROOT: {
                List<OmVolumeArgs> volumes = this.listVolumes();
                duResponse.setCount(volumes.size());
                ArrayList<DUResponse.DiskUsage> volumeDuData = new ArrayList<DUResponse.DiskUsage>();
                long totalDataSize = 0L;
                long totalDataSizeWithReplica = 0L;
                for (OmVolumeArgs volume : volumes) {
                    String volumeName = volume.getVolume();
                    String subpath = this.omMetadataManager.getVolumeKey(volumeName);
                    DUResponse.DiskUsage diskUsage = new DUResponse.DiskUsage();
                    long dataSize = 0L;
                    diskUsage.setSubpath(subpath);
                    for (OmBucketInfo bucket : this.listBucketsUnderVolume(volumeName)) {
                        long bucketObjectID = bucket.getObjectID();
                        dataSize += this.getTotalSize(bucketObjectID);
                    }
                    totalDataSize += dataSize;
                    if (withReplica) {
                        long volumeDU = this.calculateDUForVolume(volumeName);
                        totalDataSizeWithReplica += volumeDU;
                        diskUsage.setSizeWithReplica(volumeDU);
                    }
                    diskUsage.setSize(dataSize);
                    volumeDuData.add(diskUsage);
                }
                if (withReplica) {
                    duResponse.setSizeWithReplica(totalDataSizeWithReplica);
                }
                duResponse.setSize(totalDataSize);
                duResponse.setDuData(volumeDuData);
                break;
            }
            case VOLUME: {
                String volName = names[0];
                List<OmBucketInfo> buckets = this.listBucketsUnderVolume(volName);
                duResponse.setCount(buckets.size());
                ArrayList<DUResponse.DiskUsage> bucketDuData = new ArrayList<DUResponse.DiskUsage>();
                long volDataSize = 0L;
                long volDataSizeWithReplica = 0L;
                for (OmBucketInfo bucket : buckets) {
                    String bucketName = bucket.getBucketName();
                    long bucketObjectID = bucket.getObjectID();
                    String subpath = this.omMetadataManager.getBucketKey(volName, bucketName);
                    DUResponse.DiskUsage diskUsage = new DUResponse.DiskUsage();
                    diskUsage.setSubpath(subpath);
                    long dataSize = this.getTotalSize(bucketObjectID);
                    volDataSize += dataSize;
                    if (withReplica) {
                        long bucketDU = this.calculateDUUnderObject(bucketObjectID);
                        diskUsage.setSizeWithReplica(bucketDU);
                        volDataSizeWithReplica += bucketDU;
                    }
                    diskUsage.setSize(dataSize);
                    bucketDuData.add(diskUsage);
                }
                if (withReplica) {
                    duResponse.setSizeWithReplica(volDataSizeWithReplica);
                }
                duResponse.setSize(volDataSize);
                duResponse.setDuData(bucketDuData);
                break;
            }
            case BUCKET: {
                long bucketObjectId = this.getBucketObjectId(names);
                NSSummary bucketNSSummary = this.reconNamespaceSummaryManager.getNSSummary(bucketObjectId);
                if (bucketNSSummary == null) {
                    if (!withReplica) break;
                    duResponse.setSizeWithReplica(0L);
                    break;
                }
                Set<Long> bucketSubdirs = bucketNSSummary.getChildDir();
                duResponse.setKeySize(bucketNSSummary.getSizeOfFiles());
                ArrayList<DUResponse.DiskUsage> dirDUData = new ArrayList<DUResponse.DiskUsage>();
                long bucketDataSize = duResponse.getKeySize();
                long bucketDataSizeWithReplica = 0L;
                for (long subdirObjectId : bucketSubdirs) {
                    NSSummary subdirNSSummary = this.reconNamespaceSummaryManager.getNSSummary(subdirObjectId);
                    String dirName = subdirNSSummary.getDirName();
                    String subpath = NSSummaryEndpoint.buildSubpath(normalizedPath, dirName);
                    DUResponse.DiskUsage diskUsage = new DUResponse.DiskUsage();
                    diskUsage.setSubpath(subpath);
                    long dataSize = this.getTotalSize(subdirObjectId);
                    bucketDataSize += dataSize;
                    if (withReplica) {
                        long dirDU = this.calculateDUUnderObject(subdirObjectId);
                        diskUsage.setSizeWithReplica(dirDU);
                        bucketDataSizeWithReplica += dirDU;
                    }
                    diskUsage.setSize(dataSize);
                    dirDUData.add(diskUsage);
                }
                if (listFile || withReplica) {
                    bucketDataSizeWithReplica += this.handleDirectKeys(bucketObjectId, withReplica, listFile, dirDUData, normalizedPath);
                }
                if (withReplica) {
                    duResponse.setSizeWithReplica(bucketDataSizeWithReplica);
                }
                duResponse.setCount(dirDUData.size());
                duResponse.setSize(bucketDataSize);
                duResponse.setDuData(dirDUData);
                break;
            }
            case DIRECTORY: {
                long dirObjectId = this.getDirObjectId(names);
                NSSummary dirNSSummary = this.reconNamespaceSummaryManager.getNSSummary(dirObjectId);
                if (dirNSSummary == null) {
                    if (!withReplica) break;
                    duResponse.setSizeWithReplica(0L);
                    break;
                }
                Set<Long> subdirs = dirNSSummary.getChildDir();
                duResponse.setKeySize(dirNSSummary.getSizeOfFiles());
                long dirDataSize = duResponse.getKeySize();
                long dirDataSizeWithReplica = 0L;
                ArrayList<DUResponse.DiskUsage> subdirDUData = new ArrayList<DUResponse.DiskUsage>();
                for (long subdirObjectId : subdirs) {
                    NSSummary subdirNSSummary = this.reconNamespaceSummaryManager.getNSSummary(subdirObjectId);
                    String subdirName = subdirNSSummary.getDirName();
                    String subpath = NSSummaryEndpoint.buildSubpath(normalizedPath, subdirName);
                    DUResponse.DiskUsage diskUsage = new DUResponse.DiskUsage();
                    diskUsage.setSubpath(subpath);
                    long dataSize = this.getTotalSize(subdirObjectId);
                    dirDataSize += dataSize;
                    if (withReplica) {
                        long subdirDU = this.calculateDUUnderObject(subdirObjectId);
                        diskUsage.setSizeWithReplica(subdirDU);
                        dirDataSizeWithReplica += subdirDU;
                    }
                    diskUsage.setSize(dataSize);
                    subdirDUData.add(diskUsage);
                }
                if (listFile || withReplica) {
                    dirDataSizeWithReplica += this.handleDirectKeys(dirObjectId, withReplica, listFile, subdirDUData, normalizedPath);
                }
                if (withReplica) {
                    duResponse.setSizeWithReplica(dirDataSizeWithReplica);
                }
                duResponse.setCount(subdirDUData.size());
                duResponse.setSize(dirDataSize);
                duResponse.setDuData(subdirDUData);
                break;
            }
            case KEY: {
                duResponse.setCount(0);
                long parentObjectId = this.getDirObjectId(names, names.length - 1);
                String fileName = names[names.length - 1];
                String ozoneKey = this.omMetadataManager.getOzonePathKey(parentObjectId, fileName);
                OmKeyInfo keyInfo = (OmKeyInfo)this.omMetadataManager.getFileTable().getSkipCache((Object)ozoneKey);
                duResponse.setSize(keyInfo.getDataSize());
                if (!withReplica) break;
                long keySizeWithReplica = this.getKeySizeWithReplication(keyInfo);
                duResponse.setSizeWithReplica(keySizeWithReplica);
                break;
            }
            case UNKNOWN: {
                duResponse.setStatus(ResponseStatus.PATH_NOT_FOUND);
                break;
            }
        }
        return Response.ok((Object)duResponse).build();
    }

    @GET
    @Path(value="/quota")
    public Response getQuotaUsage(@QueryParam(value="path") String path) throws IOException {
        String[] names;
        if (path == null || path.length() == 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        QuotaUsageResponse quotaUsageResponse = new QuotaUsageResponse();
        if (!this.isInitializationComplete()) {
            quotaUsageResponse.setResponseCode(ResponseStatus.INITIALIZING);
            return Response.ok((Object)quotaUsageResponse).build();
        }
        String normalizedPath = NSSummaryEndpoint.normalizePath(path);
        EntityType type = this.getEntityType(normalizedPath, names = NSSummaryEndpoint.parseRequestPath(normalizedPath));
        if (type == EntityType.ROOT) {
            List<OmVolumeArgs> volumes = this.listVolumes();
            List<OmBucketInfo> buckets = this.listBucketsUnderVolume(null);
            long quotaInBytes = 0L;
            long quotaUsedInBytes = 0L;
            for (OmVolumeArgs volume : volumes) {
                long quota = volume.getQuotaInBytes();
                assert (quota >= -1L);
                if (quota == -1L) {
                    quotaInBytes = -1L;
                    break;
                }
                quotaInBytes += quota;
            }
            for (OmBucketInfo bucket : buckets) {
                long bucketObjectId = bucket.getObjectID();
                quotaUsedInBytes += this.getTotalSize(bucketObjectId);
            }
            quotaUsageResponse.setQuota(quotaInBytes);
            quotaUsageResponse.setQuotaUsed(quotaUsedInBytes);
        } else if (type == EntityType.VOLUME) {
            List<OmBucketInfo> buckets = this.listBucketsUnderVolume(names[0]);
            String volKey = this.omMetadataManager.getVolumeKey(names[0]);
            OmVolumeArgs volumeArgs = (OmVolumeArgs)this.omMetadataManager.getVolumeTable().getSkipCache((Object)volKey);
            long quotaInBytes = volumeArgs.getQuotaInBytes();
            long quotaUsedInBytes = 0L;
            for (OmBucketInfo bucketInfo : buckets) {
                long bucketObjectId = bucketInfo.getObjectID();
                quotaUsedInBytes += this.getTotalSize(bucketObjectId);
            }
            quotaUsageResponse.setQuota(quotaInBytes);
            quotaUsageResponse.setQuotaUsed(quotaUsedInBytes);
        } else if (type == EntityType.BUCKET) {
            String bucketKey = this.omMetadataManager.getBucketKey(names[0], names[1]);
            OmBucketInfo bucketInfo = (OmBucketInfo)this.omMetadataManager.getBucketTable().getSkipCache((Object)bucketKey);
            long bucketObjectId = bucketInfo.getObjectID();
            long quotaInBytes = bucketInfo.getQuotaInBytes();
            long quotaUsedInBytes = this.getTotalSize(bucketObjectId);
            quotaUsageResponse.setQuota(quotaInBytes);
            quotaUsageResponse.setQuotaUsed(quotaUsedInBytes);
        } else if (type == EntityType.UNKNOWN) {
            quotaUsageResponse.setResponseCode(ResponseStatus.PATH_NOT_FOUND);
        } else {
            quotaUsageResponse.setResponseCode(ResponseStatus.TYPE_NOT_APPLICABLE);
        }
        return Response.ok((Object)quotaUsageResponse).build();
    }

    @GET
    @Path(value="/dist")
    public Response getFileSizeDistribution(@QueryParam(value="path") String path) throws IOException {
        if (path == null || path.length() == 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        FileSizeDistributionResponse distResponse = new FileSizeDistributionResponse();
        if (!this.isInitializationComplete()) {
            distResponse.setStatus(ResponseStatus.INITIALIZING);
            return Response.ok((Object)distResponse).build();
        }
        String normalizedPath = NSSummaryEndpoint.normalizePath(path);
        String[] names = NSSummaryEndpoint.parseRequestPath(normalizedPath);
        EntityType type = this.getEntityType(normalizedPath, names);
        switch (type) {
            case ROOT: {
                List<OmBucketInfo> allBuckets = this.listBucketsUnderVolume(null);
                int[] fileSizeDist = new int[ReconConstants.NUM_OF_BINS];
                for (OmBucketInfo bucket : allBuckets) {
                    long bucketObjectId = bucket.getObjectID();
                    int[] bucketFileSizeDist = this.getTotalFileSizeDist(bucketObjectId);
                    for (int i = 0; i < ReconConstants.NUM_OF_BINS; ++i) {
                        int n = i;
                        fileSizeDist[n] = fileSizeDist[n] + bucketFileSizeDist[i];
                    }
                }
                distResponse.setFileSizeDist(fileSizeDist);
                break;
            }
            case VOLUME: {
                List<OmBucketInfo> buckets = this.listBucketsUnderVolume(names[0]);
                int[] volumeFileSizeDist = new int[ReconConstants.NUM_OF_BINS];
                for (OmBucketInfo bucket : buckets) {
                    long bucketObjectId = bucket.getObjectID();
                    int[] bucketFileSizeDist = this.getTotalFileSizeDist(bucketObjectId);
                    for (int i = 0; i < ReconConstants.NUM_OF_BINS; ++i) {
                        int n = i;
                        volumeFileSizeDist[n] = volumeFileSizeDist[n] + bucketFileSizeDist[i];
                    }
                }
                distResponse.setFileSizeDist(volumeFileSizeDist);
                break;
            }
            case BUCKET: {
                long bucketObjectId = this.getBucketObjectId(names);
                int[] bucketFileSizeDist = this.getTotalFileSizeDist(bucketObjectId);
                distResponse.setFileSizeDist(bucketFileSizeDist);
                break;
            }
            case DIRECTORY: {
                long dirObjectId = this.getDirObjectId(names);
                int[] dirFileSizeDist = this.getTotalFileSizeDist(dirObjectId);
                distResponse.setFileSizeDist(dirFileSizeDist);
                break;
            }
            case KEY: {
                distResponse.setStatus(ResponseStatus.TYPE_NOT_APPLICABLE);
                break;
            }
            case UNKNOWN: {
                distResponse.setStatus(ResponseStatus.PATH_NOT_FOUND);
                break;
            }
        }
        return Response.ok((Object)distResponse).build();
    }

    @VisibleForTesting
    public EntityType getEntityType(String path, String[] names) throws IOException {
        if (path.equals("/")) {
            return EntityType.ROOT;
        }
        if (names.length == 0) {
            return EntityType.UNKNOWN;
        }
        if (names.length == 1) {
            String volName = names[0];
            if (!this.volumeExists(volName)) {
                return EntityType.UNKNOWN;
            }
            return EntityType.VOLUME;
        }
        if (names.length == 2) {
            String volName = names[0];
            String bucketName = names[1];
            if (!this.bucketExists(volName, bucketName)) {
                return EntityType.UNKNOWN;
            }
            return EntityType.BUCKET;
        }
        String volName = names[0];
        String bucketName = names[1];
        String keyName = NSSummaryEndpoint.getKeyName(names);
        if (!this.volumeExists(volName) || !this.bucketExists(volName, bucketName)) {
            return EntityType.UNKNOWN;
        }
        long bucketObjectId = this.getBucketObjectId(names);
        return this.determineKeyPath(keyName, bucketObjectId);
    }

    private long getBucketObjectId(String[] names) throws IOException {
        String bucketKey = this.omMetadataManager.getBucketKey(names[0], names[1]);
        OmBucketInfo bucketInfo = (OmBucketInfo)this.omMetadataManager.getBucketTable().getSkipCache((Object)bucketKey);
        return bucketInfo.getObjectID();
    }

    private long getDirObjectId(String[] names) throws IOException {
        return this.getDirObjectId(names, names.length);
    }

    private long getDirObjectId(String[] names, int cutoff) throws IOException {
        long dirObjectId = this.getBucketObjectId(names);
        String dirKey = null;
        for (int i = 2; i < cutoff; ++i) {
            dirKey = this.omMetadataManager.getOzonePathKey(dirObjectId, names[i]);
            OmDirectoryInfo dirInfo = (OmDirectoryInfo)this.omMetadataManager.getDirectoryTable().getSkipCache((Object)dirKey);
            dirObjectId = dirInfo.getObjectID();
        }
        return dirObjectId;
    }

    static String[] parseRequestPath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] names = path.split("/");
        return names;
    }

    static String getKeyName(String[] names) {
        CharSequence[] keyArr = Arrays.copyOfRange(names, 2, names.length);
        return String.join((CharSequence)"/", keyArr);
    }

    static String buildSubpath(String path, String nextLevel) {
        String subpath = path;
        if (!subpath.startsWith("/")) {
            subpath = "/" + subpath;
        }
        subpath = OzoneFSUtils.removeTrailingSlashIfNeeded((String)subpath);
        if (nextLevel != null) {
            subpath = subpath + "/" + nextLevel;
        }
        return subpath;
    }

    private boolean volumeExists(String volName) throws IOException {
        String volDBKey = this.omMetadataManager.getVolumeKey(volName);
        return this.omMetadataManager.getVolumeTable().getSkipCache((Object)volDBKey) != null;
    }

    private boolean bucketExists(String volName, String bucketName) throws IOException {
        String bucketDBKey = this.omMetadataManager.getBucketKey(volName, bucketName);
        return this.omMetadataManager.getBucketTable().getSkipCache((Object)bucketDBKey) != null;
    }

    private long getTotalKeyCount(long objectId) throws IOException {
        NSSummary nsSummary = this.reconNamespaceSummaryManager.getNSSummary(objectId);
        if (nsSummary == null) {
            return 0L;
        }
        long totalCnt = nsSummary.getNumOfFiles();
        for (long childId : nsSummary.getChildDir()) {
            totalCnt += this.getTotalKeyCount(childId);
        }
        return totalCnt;
    }

    private int getTotalDirCount(long objectId) throws IOException {
        NSSummary nsSummary = this.reconNamespaceSummaryManager.getNSSummary(objectId);
        if (nsSummary == null) {
            return 0;
        }
        Set<Long> subdirs = nsSummary.getChildDir();
        int totalCnt = subdirs.size();
        for (long subdir : subdirs) {
            totalCnt += this.getTotalDirCount(subdir);
        }
        return totalCnt;
    }

    private long getTotalSize(long objectId) throws IOException {
        NSSummary nsSummary = this.reconNamespaceSummaryManager.getNSSummary(objectId);
        if (nsSummary == null) {
            return 0L;
        }
        long totalSize = nsSummary.getSizeOfFiles();
        for (long childId : nsSummary.getChildDir()) {
            totalSize += this.getTotalSize(childId);
        }
        return totalSize;
    }

    private int[] getTotalFileSizeDist(long objectId) throws IOException {
        NSSummary nsSummary = this.reconNamespaceSummaryManager.getNSSummary(objectId);
        if (nsSummary == null) {
            return new int[ReconConstants.NUM_OF_BINS];
        }
        int[] res = nsSummary.getFileSizeBucket();
        for (long childId : nsSummary.getChildDir()) {
            int[] subDirFileSizeDist = this.getTotalFileSizeDist(childId);
            for (int i = 0; i < ReconConstants.NUM_OF_BINS; ++i) {
                int n = i;
                res[n] = res[n] + subDirFileSizeDist[i];
            }
        }
        return res;
    }

    private List<OmVolumeArgs> listVolumes() throws IOException {
        ArrayList<OmVolumeArgs> result = new ArrayList<OmVolumeArgs>();
        Table volumeTable = this.omMetadataManager.getVolumeTable();
        for (Table.KeyValue kv : volumeTable) {
            OmVolumeArgs omVolumeArgs = (OmVolumeArgs)kv.getValue();
            if (omVolumeArgs == null) continue;
            result.add(omVolumeArgs);
        }
        return result;
    }

    private List<OmBucketInfo> listBucketsUnderVolume(String volumeName) throws IOException {
        ArrayList<OmBucketInfo> result = new ArrayList<OmBucketInfo>();
        String seekPrefix = "";
        Table bucketTable = this.omMetadataManager.getBucketTable();
        TableIterator iterator = bucketTable.iterator();
        if (volumeName != null) {
            if (!this.volumeExists(volumeName)) {
                return result;
            }
            seekPrefix = this.omMetadataManager.getVolumeKey(volumeName + "/");
        }
        while (iterator.hasNext()) {
            Table.KeyValue kv = (Table.KeyValue)iterator.next();
            String key = (String)kv.getKey();
            OmBucketInfo omBucketInfo = (OmBucketInfo)kv.getValue();
            if (omBucketInfo == null || !key.startsWith(seekPrefix)) continue;
            result.add(omBucketInfo);
        }
        return result;
    }

    private long calculateDUForVolume(String volumeName) throws IOException {
        long result = 0L;
        Table keyTable = this.omMetadataManager.getFileTable();
        for (Table.KeyValue kv : keyTable) {
            OmKeyInfo keyInfo = (OmKeyInfo)kv.getValue();
            if (keyInfo == null || !volumeName.equals(keyInfo.getVolumeName())) continue;
            result += this.getKeySizeWithReplication(keyInfo);
        }
        return result;
    }

    private long calculateDUUnderObject(long parentId) throws IOException {
        Table.KeyValue kv;
        String dbKey;
        Table keyTable = this.omMetadataManager.getFileTable();
        TableIterator iterator = keyTable.iterator();
        String seekPrefix = parentId + "/";
        iterator.seek((Object)seekPrefix);
        long totalDU = 0L;
        while (iterator.hasNext() && (dbKey = (String)(kv = (Table.KeyValue)iterator.next()).getKey()).startsWith(seekPrefix)) {
            OmKeyInfo keyInfo = (OmKeyInfo)kv.getValue();
            if (keyInfo == null) continue;
            totalDU += this.getKeySizeWithReplication(keyInfo);
        }
        NSSummary nsSummary = this.reconNamespaceSummaryManager.getNSSummary(parentId);
        if (nsSummary == null) {
            return 0L;
        }
        Set<Long> subDirIds = nsSummary.getChildDir();
        for (long subDirId : subDirIds) {
            totalDU += this.calculateDUUnderObject(subDirId);
        }
        return totalDU;
    }

    private long handleDirectKeys(long parentId, boolean withReplica, boolean listFile, List<DUResponse.DiskUsage> duData, String normalizedPath) throws IOException {
        Table.KeyValue kv;
        String dbKey;
        Table keyTable = this.omMetadataManager.getFileTable();
        TableIterator iterator = keyTable.iterator();
        String seekPrefix = parentId + "/";
        iterator.seek((Object)seekPrefix);
        long keyDataSizeWithReplica = 0L;
        while (iterator.hasNext() && (dbKey = (String)(kv = (Table.KeyValue)iterator.next()).getKey()).startsWith(seekPrefix)) {
            OmKeyInfo keyInfo = (OmKeyInfo)kv.getValue();
            if (keyInfo == null) continue;
            DUResponse.DiskUsage diskUsage = new DUResponse.DiskUsage();
            String subpath = NSSummaryEndpoint.buildSubpath(normalizedPath, keyInfo.getFileName());
            diskUsage.setSubpath(subpath);
            diskUsage.setKey(true);
            diskUsage.setSize(keyInfo.getDataSize());
            if (withReplica) {
                long keyDU = this.getKeySizeWithReplication(keyInfo);
                keyDataSizeWithReplica += keyDU;
                diskUsage.setSizeWithReplica(keyDU);
            }
            if (!listFile) continue;
            duData.add(diskUsage);
        }
        return keyDataSizeWithReplica;
    }

    private long getKeySizeWithReplication(OmKeyInfo keyInfo) {
        OmKeyLocationInfoGroup locationGroup = keyInfo.getLatestVersionLocations();
        List keyLocations = locationGroup.getBlocksLatestVersionOnly();
        long du = 0L;
        for (OmKeyLocationInfo location : keyLocations) {
            BlockID block = location.getBlockID();
            ContainerID containerId = new ContainerID(block.getContainerID());
            try {
                int replicationFactor = this.containerManager.getContainerReplicas(containerId).size();
                long blockSize = location.getLength() * (long)replicationFactor;
                du += blockSize;
            }
            catch (ContainerNotFoundException cnfe) {
                LOG.warn("Cannot find container {}", (Object)block.getContainerID(), (Object)cnfe);
            }
        }
        return du;
    }

    private EntityType determineKeyPath(String keyName, long bucketObjectId) throws IOException {
        java.nio.file.Path keyPath = Paths.get(keyName, new String[0]);
        Iterator<java.nio.file.Path> elements = keyPath.iterator();
        long lastKnownParentId = bucketObjectId;
        OmDirectoryInfo omDirInfo = null;
        while (elements.hasNext()) {
            String fileName = elements.next().toString();
            String dbNodeName = this.omMetadataManager.getOzonePathKey(lastKnownParentId, fileName);
            omDirInfo = (OmDirectoryInfo)this.omMetadataManager.getDirectoryTable().getSkipCache((Object)dbNodeName);
            if (omDirInfo != null) {
                lastKnownParentId = omDirInfo.getObjectID();
                continue;
            }
            if (!elements.hasNext()) {
                OmKeyInfo omKeyInfo = (OmKeyInfo)this.omMetadataManager.getFileTable().getSkipCache((Object)dbNodeName);
                if (omKeyInfo == null) continue;
                omKeyInfo.setKeyName(keyName);
                return EntityType.KEY;
            }
            return EntityType.UNKNOWN;
        }
        if (omDirInfo != null) {
            return EntityType.DIRECTORY;
        }
        return EntityType.UNKNOWN;
    }

    private boolean isInitializationComplete() {
        if (this.omMetadataManager == null) {
            return false;
        }
        return this.omMetadataManager.getVolumeTable() != null && this.omMetadataManager.getBucketTable() != null && this.omMetadataManager.getDirectoryTable() != null && this.omMetadataManager.getFileTable() != null;
    }

    private static String normalizePath(String path) {
        return "/" + OmUtils.normalizeKey((String)path, (boolean)false);
    }
}

