/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon;

import com.google.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.ozone.recon.ReconConstants;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.hadoop.ozone.recon.schema.tables.daos.GlobalStatsDao;
import org.hadoop.ozone.recon.schema.tables.pojos.GlobalStats;
import org.jooq.Configuration;
import org.jooq.ResultQuery;
import org.jooq.SelectField;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReconUtils {
    private static final int WRITE_BUFFER = 0x100000;
    private static final Logger LOG = LoggerFactory.getLogger(ReconUtils.class);

    public static File getReconScmDbDir(ConfigurationSource conf) {
        return new ReconUtils().getReconDbDir(conf, "ozone.recon.scm.db.dirs");
    }

    public File getReconDbDir(ConfigurationSource conf, String dirConfigKey) {
        File metadataDir = ServerUtils.getDirectoryFromConfig((ConfigurationSource)conf, (String)dirConfigKey, (String)"Recon");
        if (metadataDir != null) {
            return metadataDir;
        }
        LOG.warn("{} is not configured. We recommend adding this setting. Falling back to {} instead.", (Object)dirConfigKey, (Object)"ozone.metadata.dirs");
        return ServerUtils.getOzoneMetaDirPath((ConfigurationSource)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createTarFile(Path sourcePath) throws IOException {
        File file;
        TarArchiveOutputStream tarOs = null;
        FileOutputStream fileOutputStream = null;
        GZIPOutputStream gzipOutputStream = null;
        try {
            String sourceDir = sourcePath.toString();
            String fileName = sourceDir.concat(".tar.gz");
            fileOutputStream = new FileOutputStream(fileName);
            gzipOutputStream = new GZIPOutputStream(new BufferedOutputStream(fileOutputStream));
            tarOs = new TarArchiveOutputStream((OutputStream)gzipOutputStream);
            File folder = new File(sourceDir);
            File[] filesInDir = folder.listFiles();
            if (filesInDir != null) {
                for (File file2 : filesInDir) {
                    ReconUtils.addFilesToArchive(file2.getName(), file2, tarOs);
                }
            }
            file = new File(fileName);
        }
        catch (Throwable throwable) {
            try {
                org.apache.hadoop.io.IOUtils.closeStream(tarOs);
                org.apache.hadoop.io.IOUtils.closeStream(fileOutputStream);
                org.apache.hadoop.io.IOUtils.closeStream(gzipOutputStream);
            }
            catch (Exception e) {
                LOG.error("Exception encountered when closing TAR file output stream: " + e);
            }
            throw throwable;
        }
        try {
            org.apache.hadoop.io.IOUtils.closeStream((Closeable)tarOs);
            org.apache.hadoop.io.IOUtils.closeStream((Closeable)fileOutputStream);
            org.apache.hadoop.io.IOUtils.closeStream((Closeable)gzipOutputStream);
        }
        catch (Exception e) {
            LOG.error("Exception encountered when closing TAR file output stream: " + e);
        }
        return file;
    }

    private static void addFilesToArchive(String source, File file, TarArchiveOutputStream tarFileOutputStream) throws IOException {
        tarFileOutputStream.putArchiveEntry((ArchiveEntry)new TarArchiveEntry(file, source));
        if (file.isFile()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                IOUtils.copy((InputStream)bufferedInputStream, (OutputStream)tarFileOutputStream);
                tarFileOutputStream.closeArchiveEntry();
            }
        } else if (file.isDirectory()) {
            tarFileOutputStream.closeArchiveEntry();
            File[] filesInDir = file.listFiles();
            if (filesInDir != null) {
                for (File cFile : filesInDir) {
                    ReconUtils.addFilesToArchive(cFile.getAbsolutePath(), cFile, tarFileOutputStream);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void untarCheckpointFile(File tarFile, Path destPath) throws IOException {
        FileInputStream fileInputStream = null;
        BufferedInputStream buffIn = null;
        GzipCompressorInputStream gzIn = null;
        try {
            boolean success;
            fileInputStream = new FileInputStream(tarFile);
            buffIn = new BufferedInputStream(fileInputStream);
            gzIn = new GzipCompressorInputStream((InputStream)buffIn);
            if (!destPath.toFile().exists() && !(success = destPath.toFile().mkdirs())) {
                throw new IOException("Unable to create Destination directory.");
            }
            try (TarArchiveInputStream tarInStream = new TarArchiveInputStream((InputStream)gzIn);){
                TarArchiveEntry entry;
                while ((entry = (TarArchiveEntry)tarInStream.getNextEntry()) != null) {
                    BufferedOutputStream dest;
                    block27: {
                        Path path = Paths.get(destPath.toString(), entry.getName());
                        HddsUtils.validatePath((Path)path, (Path)destPath);
                        File f = path.toFile();
                        if (entry.isDirectory()) {
                            boolean success2 = f.mkdirs();
                            if (success2) continue;
                            LOG.error("Unable to create directory found in tar.");
                            continue;
                        }
                        byte[] data = new byte[0x100000];
                        FileOutputStream fos = new FileOutputStream(f);
                        dest = new BufferedOutputStream(fos, 0x100000);
                        Throwable throwable = null;
                        try {
                            int count;
                            while ((count = tarInStream.read(data, 0, 0x100000)) != -1) {
                                dest.write(data, 0, count);
                            }
                            if (dest == null) continue;
                            if (throwable == null) break block27;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (dest == null) throw throwable3;
                                if (throwable == null) {
                                    dest.close();
                                    throw throwable3;
                                }
                                try {
                                    dest.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            dest.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    dest.close();
                }
            }
        }
        catch (Throwable throwable) {
            org.apache.hadoop.io.IOUtils.closeStream(gzIn);
            org.apache.hadoop.io.IOUtils.closeStream(buffIn);
            org.apache.hadoop.io.IOUtils.closeStream((Closeable)fileInputStream);
            throw throwable;
        }
        org.apache.hadoop.io.IOUtils.closeStream((Closeable)gzIn);
        org.apache.hadoop.io.IOUtils.closeStream((Closeable)buffIn);
        org.apache.hadoop.io.IOUtils.closeStream((Closeable)fileInputStream);
    }

    public HttpURLConnection makeHttpCall(URLConnectionFactory connectionFactory, String url, boolean isSpnego) throws IOException, AuthenticationException {
        HttpURLConnection urlConnection = (HttpURLConnection)connectionFactory.openConnection(new URL(url), isSpnego);
        urlConnection.connect();
        return urlConnection;
    }

    public File getLastKnownDB(File reconDbDir, String fileNamePrefix) {
        File[] snapshotFiles;
        String lastKnownSnapshotFileName = null;
        long lastKnonwnSnapshotTs = Long.MIN_VALUE;
        if (reconDbDir != null && (snapshotFiles = reconDbDir.listFiles((dir, name) -> name.startsWith(fileNamePrefix))) != null) {
            for (File snapshotFile : snapshotFiles) {
                String fileName = snapshotFile.getName();
                try {
                    long snapshotTimestamp;
                    String[] fileNameSplits = fileName.split("_");
                    if (fileNameSplits.length <= 1 || lastKnonwnSnapshotTs >= (snapshotTimestamp = Long.parseLong(fileNameSplits[1]))) continue;
                    lastKnonwnSnapshotTs = snapshotTimestamp;
                    lastKnownSnapshotFileName = fileName;
                }
                catch (NumberFormatException nfEx) {
                    LOG.warn("Unknown file found in Recon DB dir : {}", (Object)fileName);
                }
            }
        }
        return lastKnownSnapshotFileName == null ? null : new File(reconDbDir.getPath(), lastKnownSnapshotFileName);
    }

    public static void upsertGlobalStatsTable(Configuration sqlConfiguration, GlobalStatsDao globalStatsDao, String key, Long count) {
        Timestamp now = (Timestamp)DSL.using((Configuration)sqlConfiguration).fetchValue((ResultQuery)DSL.select((SelectField)DSL.currentTimestamp()));
        GlobalStats record = globalStatsDao.fetchOneByKey(key);
        GlobalStats newRecord = new GlobalStats(key, count, now);
        if (record == null) {
            globalStatsDao.insert(newRecord);
        } else {
            globalStatsDao.update(newRecord);
        }
    }

    public static long getFileSizeUpperBound(long fileSize) {
        if (fileSize >= 0x4000000000000L) {
            return Long.MAX_VALUE;
        }
        int binIndex = ReconUtils.getBinIndex(fileSize);
        return (long)Math.pow(2.0, 10 + binIndex);
    }

    public static int getBinIndex(long fileSize) {
        if (fileSize >= 0x4000000000000L) {
            return ReconConstants.NUM_OF_BINS - 1;
        }
        int index = ReconUtils.nextClosestPowerIndexOfTwo(fileSize);
        return index < 10 ? 0 : index - 10;
    }

    private static int nextClosestPowerIndexOfTwo(long dataSize) {
        int index = 0;
        while (dataSize != 0L) {
            dataSize >>= 1;
            ++index;
        }
        return index;
    }
}

