/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon;

import com.google.inject.Scopes;
import com.google.inject.servlet.ServletModule;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.UriBuilder;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.recon.GuiceResourceConfig;
import org.apache.hadoop.ozone.recon.api.AdminOnly;
import org.apache.hadoop.ozone.recon.api.filters.ReconAdminFilter;
import org.apache.hadoop.ozone.recon.api.filters.ReconAuthFilter;
import org.glassfish.jersey.servlet.ServletContainer;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconRestServletModule
extends ServletModule {
    public static final String BASE_API_PATH = UriBuilder.fromPath((String)"/api").path("v1").build(new Object[0]).toString();
    public static final String API_PACKAGE = "org.apache.hadoop.ozone.recon.api";
    private static final Logger LOG = LoggerFactory.getLogger(ReconRestServletModule.class);
    private final ConfigurationSource conf;

    public ReconRestServletModule(ConfigurationSource conf) {
        this.conf = conf;
    }

    protected void configureServlets() {
        this.configureApi(BASE_API_PATH, API_PACKAGE);
    }

    private void configureApi(String baseApiPath, String ... packages) {
        StringBuilder sb = new StringBuilder();
        HashSet<String> adminEndpoints = new HashSet<String>();
        for (String pkg : packages) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            this.checkIfPackageExistsAndLog(pkg, baseApiPath);
            sb.append(pkg);
            Reflections reflections = new Reflections(pkg, new Scanner[]{new TypeAnnotationsScanner(), new SubTypesScanner()});
            Set adminEndpointClasses = reflections.getTypesAnnotatedWith(AdminOnly.class);
            adminEndpointClasses.stream().map(clss -> UriBuilder.fromResource((Class)clss).build(new Object[0]).toString()).forEachOrdered(adminEndpoints::add);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Registered the following endpoint classes as admin only: {}", (Object)adminEndpointClasses);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("javax.ws.rs.Application", GuiceResourceConfig.class.getCanonicalName());
        if (sb.length() > 0) {
            params.put("jersey.config.server.provider.packages", sb.toString());
        }
        this.bind(ServletContainer.class).in(Scopes.SINGLETON);
        String allApiPath = UriBuilder.fromPath((String)baseApiPath).path("*").build(new Object[0]).toString();
        this.serve(allApiPath, new String[0]).with(ServletContainer.class, params);
        this.addFilters(baseApiPath, adminEndpoints);
    }

    private void addFilters(String basePath, Set<String> adminSubPaths) {
        if (OzoneSecurityUtil.isHttpSecurityEnabled((ConfigurationSource)this.conf)) {
            boolean aclEnabled;
            String authPath = UriBuilder.fromPath((String)basePath).path("*").build(new Object[0]).toString();
            this.filter(authPath, new String[0]).through(ReconAuthFilter.class);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added authentication filter to path {}", (Object)authPath);
            }
            if (aclEnabled = this.conf.getBoolean("ozone.acl.enabled", false)) {
                for (String path : adminSubPaths) {
                    String adminPath = UriBuilder.fromPath((String)basePath).path(path).build(new Object[0]).toString();
                    this.filter(adminPath, new String[0]).through(ReconAdminFilter.class);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Added admin filter to path {}", (Object)adminPath);
                }
            }
        }
    }

    private void checkIfPackageExistsAndLog(String pkg, String path) {
        String resourcePath = pkg.replace(".", "/");
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourcePath);
        if (resource != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using API endpoints from package {} for paths under {}.", (Object)pkg, (Object)path);
            }
        } else {
            LOG.warn("No Beans in '{}' found. Requests {} will fail.", (Object)pkg, (Object)path);
        }
    }
}

