/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import com.google.protobuf.ByteString;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

public final class OzonePBHelper {
    private static final ConcurrentHashMap<Object, ByteString> FIXED_BYTESTRING_CACHE = new ConcurrentHashMap();

    private OzonePBHelper() {
    }

    public static ByteString getFixedByteString(Text key) {
        ByteString value = FIXED_BYTESTRING_CACHE.get(key);
        if (value == null) {
            value = ByteString.copyFromUtf8((String)key.toString());
            ByteString oldValue = FIXED_BYTESTRING_CACHE.putIfAbsent(key, value);
            return oldValue != null ? oldValue : value;
        }
        return value;
    }

    public static ByteString getByteString(byte[] bytes) {
        return bytes.length == 0 ? ByteString.EMPTY : ByteString.copyFrom((byte[])bytes);
    }

    public static Token<? extends TokenIdentifier> tokenFromProto(SecurityProtos.TokenProto tokenProto) {
        Token token = new Token(tokenProto.getIdentifier().toByteArray(), tokenProto.getPassword().toByteArray(), new Text(tokenProto.getKind()), new Text(tokenProto.getService()));
        return token;
    }

    public static SecurityProtos.TokenProto protoFromToken(Token<?> tok) {
        SecurityProtos.TokenProto.Builder builder = SecurityProtos.TokenProto.newBuilder().setIdentifier(OzonePBHelper.getByteString(tok.getIdentifier())).setPassword(OzonePBHelper.getByteString(tok.getPassword())).setKindBytes(OzonePBHelper.getFixedByteString(tok.getKind())).setServiceBytes(OzonePBHelper.getFixedByteString(tok.getService()));
        return builder.build();
    }
}

