/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.protocolPB;

import java.io.IOException;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.ozone.om.protocolPB.OmTransport;
import org.apache.hadoop.security.UserGroupInformation;

public interface OmTransportFactory {
    public OmTransport createOmTransport(ConfigurationSource var1, UserGroupInformation var2, String var3) throws IOException;

    public static OmTransport create(ConfigurationSource conf, UserGroupInformation ugi, String omServiceId) throws IOException {
        OmTransportFactory factory = OmTransportFactory.createFactory();
        return factory.createOmTransport(conf, ugi, omServiceId);
    }

    public static OmTransportFactory createFactory() throws IOException {
        ServiceLoader<OmTransportFactory> transportFactoryServiceLoader = ServiceLoader.load(OmTransportFactory.class);
        Iterator<OmTransportFactory> iterator = transportFactoryServiceLoader.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        try {
            return OmTransportFactory.class.getClassLoader().loadClass("org.apache.hadoop.ozone.om.protocolPB.Hadoop3OmTransportFactory").asSubclass(OmTransportFactory.class).newInstance();
        }
        catch (Exception ex) {
            throw new IOException("Can't create the default OmTransport implementation", ex);
        }
    }
}

