/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.Objects;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.UnknownPipelineStateException;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OzonePBHelper;
import org.apache.hadoop.security.token.Token;

public final class OmKeyLocationInfo {
    private final BlockID blockID;
    private long length;
    private final long offset;
    private Token<OzoneBlockTokenIdentifier> token;
    private long createVersion;
    private Pipeline pipeline;
    private int partNumber = -1;

    private OmKeyLocationInfo(BlockID blockID, Pipeline pipeline, long length, long offset, int partNumber) {
        this.blockID = blockID;
        this.pipeline = pipeline;
        this.length = length;
        this.offset = offset;
        this.partNumber = partNumber;
    }

    private OmKeyLocationInfo(BlockID blockID, Pipeline pipeline, long length, long offset, Token<OzoneBlockTokenIdentifier> token, int partNumber) {
        this.blockID = blockID;
        this.pipeline = pipeline;
        this.length = length;
        this.offset = offset;
        this.token = token;
        this.partNumber = partNumber;
    }

    public void setCreateVersion(long version) {
        this.createVersion = version;
    }

    public long getCreateVersion() {
        return this.createVersion;
    }

    public BlockID getBlockID() {
        return this.blockID;
    }

    public long getContainerID() {
        return this.blockID.getContainerID();
    }

    public long getLocalID() {
        return this.blockID.getLocalID();
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getBlockCommitSequenceId() {
        return this.blockID.getBlockCommitSequenceId();
    }

    public Token<OzoneBlockTokenIdentifier> getToken() {
        return this.token;
    }

    public void setToken(Token<OzoneBlockTokenIdentifier> token) {
        this.token = token;
    }

    public void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    public void setPartNumber(int partNumber) {
        this.partNumber = partNumber;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public OzoneManagerProtocolProtos.KeyLocation getProtobuf(int clientVersion) {
        return this.getProtobuf(false, clientVersion);
    }

    public OzoneManagerProtocolProtos.KeyLocation getProtobuf(boolean ignorePipeline, int clientVersion) {
        OzoneManagerProtocolProtos.KeyLocation.Builder builder = OzoneManagerProtocolProtos.KeyLocation.newBuilder().setBlockID(this.blockID.getProtobuf()).setLength(this.length).setOffset(this.offset).setCreateVersion(this.createVersion).setPartNumber(this.partNumber);
        if (!ignorePipeline) {
            try {
                if (this.token != null) {
                    builder.setToken(OzonePBHelper.protoFromToken(this.token));
                }
                builder.setPipeline(this.pipeline.getProtobufMessage(clientVersion));
            }
            catch (UnknownPipelineStateException unknownPipelineStateException) {
                // empty catch block
            }
        }
        return builder.build();
    }

    private static Pipeline getPipeline(OzoneManagerProtocolProtos.KeyLocation keyLocation) {
        try {
            return keyLocation.hasPipeline() ? Pipeline.getFromProtobuf((HddsProtos.Pipeline)keyLocation.getPipeline()) : null;
        }
        catch (UnknownPipelineStateException e) {
            return null;
        }
    }

    public static OmKeyLocationInfo getFromProtobuf(OzoneManagerProtocolProtos.KeyLocation keyLocation) {
        OmKeyLocationInfo info = new OmKeyLocationInfo(BlockID.getFromProtobuf((HddsProtos.BlockID)keyLocation.getBlockID()), OmKeyLocationInfo.getPipeline(keyLocation), keyLocation.getLength(), keyLocation.getOffset(), keyLocation.getPartNumber());
        if (keyLocation.hasToken()) {
            info.token = OzonePBHelper.tokenFromProto(keyLocation.getToken());
        }
        info.setCreateVersion(keyLocation.getCreateVersion());
        return info;
    }

    public String toString() {
        return "{blockID={containerID=" + this.blockID.getContainerID() + ", localID=" + this.blockID.getLocalID() + "}, length=" + this.length + ", offset=" + this.offset + ", token=" + this.token + ", pipeline=" + this.pipeline + ", createVersion=" + this.createVersion + ", partNumber=" + this.partNumber + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OmKeyLocationInfo that = (OmKeyLocationInfo)o;
        return this.length == that.length && this.offset == that.offset && this.createVersion == that.createVersion && Objects.equals(this.blockID, that.blockID) && Objects.equals(this.token, that.token) && Objects.equals(this.pipeline, that.pipeline);
    }

    public int hashCode() {
        return Objects.hash(this.blockID, this.length, this.offset, this.token, this.createVersion, this.pipeline);
    }

    public static class Builder {
        private BlockID blockID;
        private long length;
        private long offset;
        private Token<OzoneBlockTokenIdentifier> token;
        private Pipeline pipeline;
        private int partNumber;

        public Builder setBlockID(BlockID blockId) {
            this.blockID = blockId;
            return this;
        }

        public Builder setPipeline(Pipeline pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public Builder setLength(long len) {
            this.length = len;
            return this;
        }

        public Builder setOffset(long off) {
            this.offset = off;
            return this;
        }

        public Builder setToken(Token<OzoneBlockTokenIdentifier> bToken) {
            this.token = bToken;
            return this;
        }

        public Builder setPartNumber(int partNum) {
            this.partNumber = partNum;
            return this;
        }

        public OmKeyLocationInfo build() {
            return new OmKeyLocationInfo(this.blockID, this.pipeline, this.length, this.offset, this.token, this.partNumber);
        }
    }
}

