/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.Auditable;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;

public final class OmKeyArgs
implements Auditable {
    private final String volumeName;
    private final String bucketName;
    private final String keyName;
    private long dataSize;
    private final ReplicationConfig replicationConfig;
    private List<OmKeyLocationInfo> locationInfoList;
    private final boolean isMultipartKey;
    private final String multipartUploadID;
    private final int multipartUploadPartNumber;
    private Map<String, String> metadata;
    private boolean refreshPipeline;
    private boolean sortDatanodesInPipeline;
    private List<OzoneAcl> acls;
    private boolean latestVersionLocation;
    private boolean recursive;
    private boolean headOp;

    private OmKeyArgs(String volumeName, String bucketName, String keyName, long dataSize, ReplicationConfig replicationConfig, List<OmKeyLocationInfo> locationInfoList, boolean isMultipart, String uploadID, int partNumber, Map<String, String> metadataMap, boolean refreshPipeline, List<OzoneAcl> acls, boolean sortDatanode, boolean latestVersionLocation, boolean recursive, boolean headOp) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.keyName = keyName;
        this.dataSize = dataSize;
        this.replicationConfig = replicationConfig;
        this.locationInfoList = locationInfoList;
        this.isMultipartKey = isMultipart;
        this.multipartUploadID = uploadID;
        this.multipartUploadPartNumber = partNumber;
        this.metadata = metadataMap;
        this.refreshPipeline = refreshPipeline;
        this.acls = acls;
        this.sortDatanodesInPipeline = sortDatanode;
        this.latestVersionLocation = latestVersionLocation;
        this.recursive = recursive;
        this.headOp = headOp;
    }

    public boolean getIsMultipartKey() {
        return this.isMultipartKey;
    }

    public String getMultipartUploadID() {
        return this.multipartUploadID;
    }

    public int getMultipartUploadPartNumber() {
        return this.multipartUploadPartNumber;
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(long size) {
        this.dataSize = size;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setLocationInfoList(List<OmKeyLocationInfo> locationInfoList) {
        this.locationInfoList = locationInfoList;
    }

    public List<OmKeyLocationInfo> getLocationInfoList() {
        return this.locationInfoList;
    }

    public boolean getRefreshPipeline() {
        return this.refreshPipeline;
    }

    public boolean getSortDatanodes() {
        return this.sortDatanodesInPipeline;
    }

    public boolean getLatestVersionLocation() {
        return this.latestVersionLocation;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public boolean isHeadOp() {
        return this.headOp;
    }

    public Map<String, String> toAuditMap() {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", this.volumeName);
        auditMap.put("bucket", this.bucketName);
        auditMap.put("key", this.keyName);
        auditMap.put("dataSize", String.valueOf(this.dataSize));
        auditMap.put("replicationConfig", this.replicationConfig != null ? this.replicationConfig.toString() : null);
        return auditMap;
    }

    @VisibleForTesting
    public void addLocationInfo(OmKeyLocationInfo locationInfo) {
        if (this.locationInfoList == null) {
            this.locationInfoList = new ArrayList<OmKeyLocationInfo>();
        }
        this.locationInfoList.add(locationInfo);
    }

    public Builder toBuilder() {
        return new Builder().setVolumeName(this.volumeName).setBucketName(this.bucketName).setKeyName(this.keyName).setDataSize(this.dataSize).setReplicationConfig(this.replicationConfig).setLocationInfoList(this.locationInfoList).setIsMultipartKey(this.isMultipartKey).setMultipartUploadID(this.multipartUploadID).setMultipartUploadPartNumber(this.multipartUploadPartNumber).addAllMetadata(this.metadata).setRefreshPipeline(this.refreshPipeline).setSortDatanodesInPipeline(this.sortDatanodesInPipeline).setLatestVersionLocation(this.latestVersionLocation).setAcls(this.acls);
    }

    public static class Builder {
        private String volumeName;
        private String bucketName;
        private String keyName;
        private long dataSize;
        private ReplicationConfig replicationConfig;
        private List<OmKeyLocationInfo> locationInfoList;
        private boolean isMultipartKey;
        private String multipartUploadID;
        private int multipartUploadPartNumber;
        private Map<String, String> metadata = new HashMap<String, String>();
        private boolean refreshPipeline;
        private boolean sortDatanodesInPipeline;
        private boolean latestVersionLocation;
        private List<OzoneAcl> acls;
        private boolean recursive;
        private boolean headOp;

        public Builder setVolumeName(String volume) {
            this.volumeName = volume;
            return this;
        }

        public Builder setBucketName(String bucket) {
            this.bucketName = bucket;
            return this;
        }

        public Builder setKeyName(String key) {
            this.keyName = key;
            return this;
        }

        public Builder setDataSize(long size) {
            this.dataSize = size;
            return this;
        }

        public Builder setReplicationConfig(ReplicationConfig replConfig) {
            this.replicationConfig = replConfig;
            return this;
        }

        public Builder setLocationInfoList(List<OmKeyLocationInfo> locationInfos) {
            this.locationInfoList = locationInfos;
            return this;
        }

        public Builder setAcls(List<OzoneAcl> listOfAcls) {
            this.acls = listOfAcls;
            return this;
        }

        public Builder setIsMultipartKey(boolean isMultipart) {
            this.isMultipartKey = isMultipart;
            return this;
        }

        public Builder setMultipartUploadID(String uploadID) {
            this.multipartUploadID = uploadID;
            return this;
        }

        public Builder setMultipartUploadPartNumber(int partNumber) {
            this.multipartUploadPartNumber = partNumber;
            return this;
        }

        public Builder addMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder addAllMetadata(Map<String, String> metadatamap) {
            this.metadata.putAll(metadatamap);
            return this;
        }

        public Builder setRefreshPipeline(boolean refresh) {
            this.refreshPipeline = refresh;
            return this;
        }

        public Builder setSortDatanodesInPipeline(boolean sort) {
            this.sortDatanodesInPipeline = sort;
            return this;
        }

        public Builder setLatestVersionLocation(boolean latest) {
            this.latestVersionLocation = latest;
            return this;
        }

        public Builder setRecursive(boolean isRecursive) {
            this.recursive = isRecursive;
            return this;
        }

        public Builder setHeadOp(boolean isHeadOp) {
            this.headOp = isHeadOp;
            return this;
        }

        public OmKeyArgs build() {
            return new OmKeyArgs(this.volumeName, this.bucketName, this.keyName, this.dataSize, this.replicationConfig, this.locationInfoList, this.isMultipartKey, this.multipartUploadID, this.multipartUploadPartNumber, this.metadata, this.refreshPipeline, this.acls, this.sortDatanodesInPipeline, this.latestVersionLocation, this.recursive, this.headOp);
        }
    }
}

