/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.ozone.BasicKeyInfo;
import org.apache.hadoop.fs.ozone.BasicRootedOzoneClientAdapterImpl;
import org.apache.hadoop.fs.ozone.FileStatusAdapter;
import org.apache.hadoop.fs.ozone.OzoneClientAdapter;
import org.apache.hadoop.fs.ozone.OzoneFSInputStream;
import org.apache.hadoop.fs.ozone.Statistic;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;
import org.apache.hadoop.ozone.OFSPath;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BasicRootedOzoneFileSystem
extends FileSystem {
    static final Logger LOG = LoggerFactory.getLogger(BasicRootedOzoneFileSystem.class);
    private URI uri;
    private String userName;
    private Path workingDir;
    private OzoneClientAdapter adapter;
    private BasicRootedOzoneClientAdapterImpl adapterImpl;
    private static final String URI_EXCEPTION_TEXT = "URL should be one of the following formats: ofs://om-service-id/path/to/key  OR ofs://om-host.example.com/path/to/key  OR ofs://om-host.example.com:5678/path/to/key";

    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.setConf(conf);
        Preconditions.checkNotNull((Object)name.getScheme(), (String)"No scheme provided in %s", (Object)name);
        Preconditions.checkArgument((boolean)this.getScheme().equals(name.getScheme()), (String)"Invalid scheme provided in %s", (Object)name);
        String authority = name.getAuthority();
        if (authority == null) {
            throw new IllegalArgumentException(URI_EXCEPTION_TEXT);
        }
        int omPort = -1;
        String[] parts = authority.split(":");
        if (parts.length > 2) {
            throw new IllegalArgumentException(URI_EXCEPTION_TEXT);
        }
        String omHostOrServiceId = parts[0];
        if (parts.length == 2) {
            try {
                omPort = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(URI_EXCEPTION_TEXT);
            }
        }
        try {
            this.uri = new URIBuilder().setScheme("ofs").setHost(authority).build();
            LOG.trace("Ozone URI for OFS initialization is " + this.uri);
            ConfigurationSource source = this.getConfSource();
            this.adapter = this.createAdapter(source, omHostOrServiceId, omPort);
            this.adapterImpl = (BasicRootedOzoneClientAdapterImpl)this.adapter;
            try {
                this.userName = UserGroupInformation.getCurrentUser().getShortUserName();
            }
            catch (IOException e) {
                this.userName = "hdfs";
            }
            this.workingDir = new Path("/user", this.userName).makeQualified(this.uri, this.workingDir);
        }
        catch (URISyntaxException ue) {
            String msg = "Invalid Ozone endpoint " + name;
            LOG.error(msg, (Throwable)ue);
            throw new IOException(msg, ue);
        }
    }

    protected OzoneClientAdapter createAdapter(ConfigurationSource conf, String omHost, int omPort) throws IOException {
        return new BasicRootedOzoneClientAdapterImpl(omHost, omPort, conf);
    }

    public void close() throws IOException {
        try {
            this.adapter.close();
        }
        finally {
            super.close();
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public String getScheme() {
        return "ofs";
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_OPEN, 1L);
        this.statistics.incrementReadOps(1);
        LOG.trace("open() path: {}", (Object)path);
        String key = this.pathToKey(path);
        return new FSDataInputStream((InputStream)((Object)new OzoneFSInputStream(this.adapter.readFile(key), this.statistics)));
    }

    protected void incrementCounter(Statistic statistic) {
        this.incrementCounter(statistic, 1L);
    }

    protected void incrementCounter(Statistic statistic, long count) {
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        LOG.trace("create() path:{}", (Object)f);
        this.incrementCounter(Statistic.INVOCATION_CREATE, 1L);
        this.statistics.incrementWriteOps(1);
        String key = this.pathToKey(f);
        return this.createOutputStream(key, replication, overwrite, true);
    }

    public FSDataOutputStream createNonRecursive(Path path, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_CREATE_NON_RECURSIVE, 1L);
        this.statistics.incrementWriteOps(1);
        String key = this.pathToKey(path);
        return this.createOutputStream(key, replication, flags.contains(CreateFlag.OVERWRITE), false);
    }

    private FSDataOutputStream createOutputStream(String key, short replication, boolean overwrite, boolean recursive) throws IOException {
        return new FSDataOutputStream((OutputStream)this.adapter.createFile(key, replication, overwrite, recursive), this.statistics);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("append() Not implemented by the " + ((Object)((Object)this)).getClass().getSimpleName() + " FileSystem implementation");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        FileStatus dstStatus;
        FileStatus srcStatus;
        Path dstParent;
        this.incrementCounter(Statistic.INVOCATION_RENAME, 1L);
        this.statistics.incrementWriteOps(1);
        if (src.equals((Object)dst)) {
            return true;
        }
        LOG.trace("rename() from: {} to: {}", (Object)src, (Object)dst);
        if (src.isRoot()) {
            LOG.trace("Cannot rename the root of a filesystem");
            return false;
        }
        OFSPath ofsSrc = new OFSPath(src);
        OFSPath ofsDst = new OFSPath(dst);
        if (!ofsSrc.isInSameBucketAs(ofsDst)) {
            throw new IOException("Cannot rename a key to a different bucket");
        }
        OzoneBucket bucket = this.adapterImpl.getBucket(ofsSrc, false);
        if (OzoneFSUtils.isFSOptimizedBucket((BucketLayout)bucket.getBucketLayout())) {
            return this.renameFSO(bucket, ofsSrc, ofsDst);
        }
        for (dstParent = dst.getParent(); dstParent != null && !src.equals((Object)dstParent); dstParent = dstParent.getParent()) {
        }
        Preconditions.checkArgument((dstParent == null ? 1 : 0) != 0, (Object)"Cannot rename a directory to its own subdirectory");
        try {
            srcStatus = this.getFileStatus(src);
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        try {
            dstStatus = this.getFileStatus(dst);
        }
        catch (FileNotFoundException fnde) {
            dstStatus = null;
        }
        if (dstStatus == null) {
            dstStatus = this.getFileStatus(dst.getParent());
            if (!dstStatus.isDirectory()) {
                throw new IOException(String.format("Failed to rename %s to %s, %s is a file", src, dst, dst.getParent()));
            }
        } else {
            if (srcStatus.getPath().equals((Object)dstStatus.getPath())) {
                return !srcStatus.isDirectory();
            }
            if (dstStatus.isDirectory()) {
                FileStatus[] statuses;
                dst = new Path(dst, src.getName());
                try {
                    statuses = this.listStatus(dst);
                }
                catch (FileNotFoundException fnde) {
                    statuses = null;
                }
                if (statuses != null && statuses.length > 0) {
                    LOG.warn("Failed to rename {} to {}, file already exists or not empty!", (Object)src, (Object)dst);
                    return false;
                }
            } else {
                LOG.warn("Failed to rename {} to {}, file already exists!", (Object)src, (Object)dst);
                return false;
            }
        }
        if (srcStatus.isDirectory() && dst.toString().startsWith(src.toString() + "/")) {
            LOG.trace("Cannot rename a directory to a subdirectory of self");
            return false;
        }
        RenameIterator iterator = new RenameIterator(src, dst);
        boolean result = iterator.iterate();
        if (result) {
            this.createFakeParentDirectory(src);
        }
        return result;
    }

    private boolean renameFSO(OzoneBucket bucket, OFSPath srcPath, OFSPath dstPath) throws IOException {
        String srcKeyPath = srcPath.getNonKeyPathNoPrefixDelim() + "/" + srcPath.getKeyName();
        String dstKeyPath = dstPath.getNonKeyPathNoPrefixDelim() + "/" + dstPath.getKeyName();
        try {
            this.adapterImpl.rename(bucket, srcKeyPath, dstKeyPath);
        }
        catch (OMException ome) {
            LOG.error("rename key failed: {}. source:{}, destin:{}", new Object[]{ome.getMessage(), srcKeyPath, dstKeyPath});
            if (OMException.ResultCodes.KEY_ALREADY_EXISTS == ome.getResult() || OMException.ResultCodes.KEY_RENAME_ERROR == ome.getResult() || OMException.ResultCodes.KEY_NOT_FOUND == ome.getResult()) {
                return false;
            }
            throw ome;
        }
        return true;
    }

    @Deprecated
    protected void rename(Path src, Path dst, Options.Rename ... options) throws IOException {
        boolean hasMoveToTrash = false;
        if (options != null) {
            for (Options.Rename option : options) {
                if (option != Options.Rename.TO_TRASH) continue;
                hasMoveToTrash = true;
                break;
            }
        }
        if (!hasMoveToTrash) {
            super.rename(src, dst, options);
        } else {
            this.rename(src, dst);
        }
    }

    private boolean innerDelete(Path f, boolean recursive) throws IOException {
        LOG.trace("delete() path:{} recursive:{}", (Object)f, (Object)recursive);
        try {
            DeleteIterator iterator = new DeleteIterator(f, recursive);
            return iterator.iterate();
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Couldn't delete {} - does not exist", (Object)f);
            }
            return false;
        }
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        boolean result;
        FileStatus status;
        this.incrementCounter(Statistic.INVOCATION_DELETE, 1L);
        this.statistics.incrementWriteOps(1);
        LOG.debug("Delete path {} - recursive {}", (Object)f, (Object)recursive);
        try {
            status = this.getFileStatus(f);
        }
        catch (FileNotFoundException ex) {
            LOG.warn("delete: Path does not exist: {}", (Object)f);
            return false;
        }
        if (status == null) {
            return false;
        }
        String key = this.pathToKey(f);
        if (status.isDirectory()) {
            OzoneBucket bucket;
            LOG.debug("delete: Path is a directory: {}", (Object)f);
            OFSPath ofsPath = new OFSPath(key);
            if (ofsPath.isRoot()) {
                LOG.warn("delete: OFS does not support rm root. To wipe the cluster, please re-init OM instead.");
                return false;
            }
            if (!ofsPath.isVolume() && !ofsPath.isBucket() && OzoneFSUtils.isFSOptimizedBucket((BucketLayout)(bucket = this.adapterImpl.getBucket(ofsPath, false)).getBucketLayout())) {
                String ofsKeyPath = ofsPath.getNonKeyPathNoPrefixDelim() + "/" + ofsPath.getKeyName();
                return this.adapterImpl.deleteObject(ofsKeyPath, recursive);
            }
            if (ofsPath.isVolume()) {
                String volumeName = ofsPath.getVolumeName();
                if (recursive) {
                    OzoneVolume volume = this.adapterImpl.getObjectStore().getVolume(volumeName);
                    Iterator it = volume.listBuckets("");
                    String prefixVolumePathStr = this.addTrailingSlashIfNeeded(f.toString());
                    while (it.hasNext()) {
                        OzoneBucket bucket2 = (OzoneBucket)it.next();
                        String nextBucket = prefixVolumePathStr + bucket2.getName();
                        this.delete(new Path(nextBucket), true);
                    }
                }
                try {
                    this.adapterImpl.getObjectStore().deleteVolume(volumeName);
                    return true;
                }
                catch (OMException ex) {
                    if (ex.getResult() == OMException.ResultCodes.VOLUME_NOT_EMPTY) {
                        throw new PathIsNotEmptyDirectoryException(f.toString());
                    }
                    throw ex;
                }
            }
            result = this.innerDelete(f, recursive);
            if (ofsPath.isBucket()) {
                OzoneVolume volume = this.adapterImpl.getObjectStore().getVolume(ofsPath.getVolumeName());
                try {
                    volume.deleteBucket(ofsPath.getBucketName());
                    return result;
                }
                catch (OMException ex) {
                    if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_EMPTY) {
                        throw new PathIsNotEmptyDirectoryException(f.toString());
                    }
                    throw ex;
                }
            }
        } else {
            LOG.debug("delete: Path is a file: {}", (Object)f);
            result = this.adapter.deleteObject(key);
        }
        if (result) {
            this.createFakeParentDirectory(f);
        }
        return result;
    }

    private void createFakeParentDirectory(Path f) throws IOException {
        Path parent = f.getParent();
        if (parent != null && !parent.isRoot()) {
            this.createFakeDirectoryIfNecessary(parent);
        }
    }

    private void createFakeDirectoryIfNecessary(Path f) throws IOException {
        String key = this.pathToKey(f);
        if (!key.isEmpty() && !this.o3Exists(f)) {
            LOG.debug("Creating new fake directory at {}", (Object)f);
            String dirKey = this.addTrailingSlashIfNeeded(key);
            this.adapter.createDirectory(dirKey);
        }
    }

    private boolean o3Exists(Path f) throws IOException {
        Path path = this.makeQualified(f);
        try {
            this.getFileStatus(path);
            return true;
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        List tmpStatusList;
        this.incrementCounter(Statistic.INVOCATION_LIST_STATUS, 1L);
        this.statistics.incrementReadOps(1);
        LOG.trace("listStatus() path:{}", (Object)f);
        int numEntries = 1024;
        LinkedList statuses = new LinkedList();
        String startPath = "";
        do {
            if ((tmpStatusList = this.adapter.listStatus(this.pathToKey(f), false, startPath, numEntries, this.uri, this.workingDir, this.getUsername()).stream().map(this::convertFileStatus).collect(Collectors.toList())).isEmpty()) continue;
            if (startPath.isEmpty()) {
                statuses.addAll(tmpStatusList);
            } else {
                statuses.addAll(tmpStatusList.subList(1, tmpStatusList.size()));
            }
            startPath = this.pathToKey(((FileStatus)statuses.getLast()).getPath());
        } while (tmpStatusList.size() == numEntries);
        return statuses.toArray(new FileStatus[0]);
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = newDir;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public Token<?> getDelegationToken(String renewer) throws IOException {
        return this.adapter.getDelegationToken(renewer);
    }

    public String getCanonicalServiceName() {
        return this.adapter.getCanonicalServiceName();
    }

    public String getUsername() {
        return this.userName;
    }

    public Path getTrashRoot(Path path) {
        OFSPath ofsPath = new OFSPath(path);
        return ofsPath.getTrashRoot();
    }

    public Collection<FileStatus> getTrashRoots(boolean allUsers) {
        return this.adapterImpl.getTrashRoots(allUsers, this);
    }

    private boolean mkdir(Path path) throws IOException {
        return this.adapter.createDirectory(this.pathToKey(path));
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_MKDIRS);
        LOG.trace("mkdir() path:{} ", (Object)f);
        String key = this.pathToKey(f);
        if (this.isEmpty(key)) {
            return false;
        }
        return this.mkdir(f);
    }

    public long getDefaultBlockSize() {
        return (long)this.getConfSource().getStorageSize("ozone.scm.block.size", "256MB", StorageUnit.BYTES);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        FileStatus fileStatus;
        block3: {
            this.incrementCounter(Statistic.INVOCATION_GET_FILE_STATUS, 1L);
            this.statistics.incrementReadOps(1);
            LOG.trace("getFileStatus() path:{}", (Object)f);
            Path qualifiedPath = f.makeQualified(this.uri, this.workingDir);
            String key = this.pathToKey(qualifiedPath);
            if (key.equals("NONE")) {
                throw new FileNotFoundException("File not found. path /NONE.");
            }
            fileStatus = null;
            try {
                fileStatus = this.convertFileStatus(this.adapter.getFileStatus(key, this.uri, qualifiedPath, this.getUsername()));
            }
            catch (OMException ex) {
                if (!ex.getResult().equals((Object)OMException.ResultCodes.KEY_NOT_FOUND) && !ex.getResult().equals((Object)OMException.ResultCodes.BUCKET_NOT_FOUND) && !ex.getResult().equals((Object)OMException.ResultCodes.VOLUME_NOT_FOUND)) break block3;
                throw new FileNotFoundException("File not found. path:" + f);
            }
        }
        return fileStatus;
    }

    public BlockLocation[] getFileBlockLocations(FileStatus fileStatus, long start, long len) throws IOException {
        if (fileStatus instanceof LocatedFileStatus) {
            return ((LocatedFileStatus)fileStatus).getBlockLocations();
        }
        return super.getFileBlockLocations(fileStatus, start, len);
    }

    public short getDefaultReplication() {
        return this.adapter.getDefaultReplication();
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_COPY_FROM_LOCAL_FILE);
        super.copyFromLocalFile(delSrc, overwrite, srcs, dst);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_COPY_FROM_LOCAL_FILE);
        super.copyFromLocalFile(delSrc, overwrite, src, dst);
    }

    public boolean exists(Path f) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_EXISTS);
        return super.exists(f);
    }

    public FileChecksum getFileChecksum(Path f, long length) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_GET_FILE_CHECKSUM);
        return super.getFileChecksum(f, length);
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_GLOB_STATUS);
        return super.globStatus(pathPattern);
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_GLOB_STATUS);
        return super.globStatus(pathPattern, filter);
    }

    public boolean isDirectory(Path f) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_IS_DIRECTORY);
        return super.isDirectory(f);
    }

    public boolean isFile(Path f) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_IS_FILE);
        return super.isFile(f);
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_LIST_FILES);
        return super.listFiles(f, recursive);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_LIST_LOCATED_STATUS);
        return super.listLocatedStatus(f);
    }

    public String pathToKey(Path path) {
        String key;
        Objects.requireNonNull(path, "Path can't be null!");
        if (!path.isAbsolute()) {
            path = new Path(this.workingDir, path);
        }
        if (!OzoneFSUtils.isValidName((String)(key = path.toUri().getPath()))) {
            throw new InvalidPathException("Invalid path Name " + key);
        }
        key = key.substring(1);
        LOG.trace("path for key: {} is: {}", (Object)key, (Object)path);
        return key;
    }

    private String addTrailingSlashIfNeeded(String key) {
        if (!this.isEmpty(key) && !key.endsWith("/")) {
            return key + "/";
        }
        return key;
    }

    public String toString() {
        return "RootedOzoneFileSystem{URI=" + this.uri + ", workingDir=" + this.workingDir + ", userName=" + this.userName + ", statistics=" + this.statistics + "}";
    }

    public ConfigurationSource getConfSource() {
        Configuration conf = super.getConf();
        Object source = conf instanceof OzoneConfiguration ? (ConfigurationSource)conf : new LegacyHadoopConfigurationSource(conf);
        return source;
    }

    public OzoneClientAdapter getAdapter() {
        return this.adapter;
    }

    public boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public boolean isNumber(String number) {
        try {
            Integer.parseInt(number);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    FileStatus convertFileStatus(FileStatusAdapter fileStatusAdapter) {
        Path symLink = null;
        try {
            fileStatusAdapter.getSymlink();
        }
        catch (Exception exception) {
            // empty catch block
        }
        FileStatus fileStatus = new FileStatus(fileStatusAdapter.getLength(), fileStatusAdapter.isDir(), (int)fileStatusAdapter.getBlockReplication(), fileStatusAdapter.getBlocksize(), fileStatusAdapter.getModificationTime(), fileStatusAdapter.getAccessTime(), new FsPermission(fileStatusAdapter.getPermission()), fileStatusAdapter.getOwner(), fileStatusAdapter.getGroup(), symLink, fileStatusAdapter.getPath());
        BlockLocation[] blockLocations = fileStatusAdapter.getBlockLocations();
        if (blockLocations == null || blockLocations.length == 0) {
            return fileStatus;
        }
        return new LocatedFileStatus(fileStatus, blockLocations);
    }

    private abstract class OzoneListingIterator {
        private final Path path;
        private final FileStatus status;
        private String pathKey;
        private Iterator<BasicKeyInfo> keyIterator;

        OzoneListingIterator(Path path) throws IOException {
            this.path = path;
            this.status = BasicRootedOzoneFileSystem.this.getFileStatus(path);
            this.pathKey = BasicRootedOzoneFileSystem.this.pathToKey(path);
            if (this.status.isDirectory()) {
                this.pathKey = BasicRootedOzoneFileSystem.this.addTrailingSlashIfNeeded(this.pathKey);
            }
            this.keyIterator = BasicRootedOzoneFileSystem.this.adapter.listKeys(this.pathKey);
        }

        abstract boolean processKeyPath(List<String> var1) throws IOException;

        boolean iterate() throws IOException {
            LOG.trace("Iterating path: {}", (Object)this.path);
            ArrayList<String> keyPathList = new ArrayList<String>();
            int batchSize = BasicRootedOzoneFileSystem.this.getConf().getInt("ozone.fs.iterate.batch-size", 100);
            if (this.status.isDirectory()) {
                LOG.trace("Iterating directory: {}", (Object)this.pathKey);
                OFSPath ofsPath = new OFSPath(this.pathKey);
                String ofsPathPrefix = ofsPath.getNonKeyPathNoPrefixDelim() + "/";
                while (this.keyIterator.hasNext()) {
                    BasicKeyInfo key = this.keyIterator.next();
                    String keyPath = ofsPathPrefix + key.getName();
                    LOG.trace("iterating key path: {}", (Object)keyPath);
                    if (!key.getName().equals("")) {
                        keyPathList.add(keyPath);
                    }
                    if (keyPathList.size() < batchSize) continue;
                    if (!this.processKeyPath(keyPathList)) {
                        return false;
                    }
                    keyPathList.clear();
                }
                return keyPathList.size() <= 0 || this.processKeyPath(keyPathList);
            }
            LOG.trace("iterating file: {}", (Object)this.path);
            keyPathList.add(this.pathKey);
            return this.processKeyPath(keyPathList);
        }

        String getPathKey() {
            return this.pathKey;
        }

        boolean pathIsDirectory() {
            return this.status.isDirectory();
        }

        FileStatus getStatus() {
            return this.status;
        }
    }

    private class DeleteIterator
    extends OzoneListingIterator {
        private final boolean recursive;
        private final OzoneBucket bucket;
        private final BasicRootedOzoneClientAdapterImpl adapterImpl;

        DeleteIterator(Path f, boolean recursive) throws IOException {
            super(f);
            this.recursive = recursive;
            if (this.getStatus().isDirectory() && !this.recursive && BasicRootedOzoneFileSystem.this.listStatus(f).length != 0) {
                throw new PathIsNotEmptyDirectoryException(f.toString());
            }
            OFSPath ofsPath = new OFSPath(f);
            this.adapterImpl = (BasicRootedOzoneClientAdapterImpl)BasicRootedOzoneFileSystem.this.adapter;
            this.bucket = this.adapterImpl.getBucket(ofsPath, false);
        }

        @Override
        boolean processKeyPath(List<String> keyPathList) {
            LOG.trace("Deleting keys: {}", keyPathList);
            boolean succeed = this.adapterImpl.deleteObjects(this.bucket, keyPathList);
            return this.recursive || succeed;
        }
    }

    private class RenameIterator
    extends OzoneListingIterator {
        private final String srcPath;
        private final String dstPath;
        private final OzoneBucket bucket;
        private final BasicRootedOzoneClientAdapterImpl adapterImpl;

        RenameIterator(Path srcPath, Path dstPath) throws IOException {
            super(srcPath);
            this.srcPath = BasicRootedOzoneFileSystem.this.pathToKey(srcPath);
            this.dstPath = BasicRootedOzoneFileSystem.this.pathToKey(dstPath);
            LOG.trace("rename from:{} to:{}", (Object)this.srcPath, (Object)this.dstPath);
            OFSPath ofsPath = new OFSPath(srcPath);
            this.adapterImpl = (BasicRootedOzoneClientAdapterImpl)BasicRootedOzoneFileSystem.this.adapter;
            this.bucket = this.adapterImpl.getBucket(ofsPath, false);
        }

        @Override
        boolean processKeyPath(List<String> keyPathList) throws IOException {
            for (String keyPath : keyPathList) {
                String newPath = this.dstPath.concat(keyPath.substring(this.srcPath.length()));
                this.adapterImpl.rename(this.bucket, keyPath, newPath);
            }
            return true;
        }
    }
}

