/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.ozone.BasicKeyInfo;
import org.apache.hadoop.fs.ozone.BasicRootedOzoneFileSystem;
import org.apache.hadoop.fs.ozone.FileStatusAdapter;
import org.apache.hadoop.fs.ozone.OzoneClientAdapter;
import org.apache.hadoop.fs.ozone.OzoneFSOutputStream;
import org.apache.hadoop.fs.ozone.Statistic;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.OFSPath;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicRootedOzoneClientAdapterImpl
implements OzoneClientAdapter {
    static final Logger LOG = LoggerFactory.getLogger(BasicRootedOzoneClientAdapterImpl.class);
    private OzoneClient ozoneClient;
    private ObjectStore objectStore;
    private ClientProtocol proxy;
    private ReplicationConfig replicationConfig;
    private boolean securityEnabled;
    private int configuredDnPort;

    public BasicRootedOzoneClientAdapterImpl() throws IOException {
        this(BasicRootedOzoneClientAdapterImpl.createConf());
    }

    private static OzoneConfiguration createConf() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(null);
        try {
            OzoneConfiguration ozoneConfiguration = new OzoneConfiguration();
            return ozoneConfiguration;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public BasicRootedOzoneClientAdapterImpl(OzoneConfiguration conf) throws IOException {
        this(null, -1, (ConfigurationSource)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicRootedOzoneClientAdapterImpl(String omHost, int omPort, ConfigurationSource hadoopConf) throws IOException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(null);
        try {
            SecurityConfig secConfig;
            OzoneConfiguration conf = OzoneConfiguration.of((ConfigurationSource)hadoopConf);
            if (omHost == null && OmUtils.isServiceIdsDefined((ConfigurationSource)conf)) {
                throw new IllegalArgumentException("Service ID or host name must not be omitted when ozone.om.service.ids is defined.");
            }
            if (omPort != -1) {
                if (OmUtils.isOmHAServiceId((ConfigurationSource)conf, (String)omHost)) {
                    throw new IllegalArgumentException("Port " + omPort + " specified in URI but host '" + omHost + "' is a logical (HA) OzoneManager and does not use port information.");
                }
            } else {
                omPort = OmUtils.getOmRpcPort((ConfigurationSource)conf);
            }
            if ((secConfig = new SecurityConfig((ConfigurationSource)conf)).isSecurityEnabled()) {
                this.securityEnabled = true;
            }
            this.replicationConfig = ReplicationConfig.getDefault((ConfigurationSource)conf);
            this.ozoneClient = OmUtils.isOmHAServiceId((ConfigurationSource)conf, (String)omHost) ? OzoneClientFactory.getRpcClient((String)omHost, (ConfigurationSource)conf) : (StringUtils.isNotEmpty((CharSequence)omHost) && omPort != -1 ? OzoneClientFactory.getRpcClient((String)omHost, (Integer)omPort, (MutableConfigurationSource)conf) : OzoneClientFactory.getRpcClient((ConfigurationSource)conf));
            this.objectStore = this.ozoneClient.getObjectStore();
            this.proxy = this.objectStore.getClientProxy();
            this.configuredDnPort = conf.getInt("dfs.container.ipc", 9859);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    OzoneBucket getBucket(OFSPath ofsPath, boolean createIfNotExist) throws IOException {
        return this.getBucket(ofsPath.getVolumeName(), ofsPath.getBucketName(), createIfNotExist);
    }

    /*
     * Unable to fully structure code
     */
    private OzoneBucket getBucket(String volumeStr, String bucketStr, boolean createIfNotExist) throws IOException {
        Preconditions.checkNotNull((Object)volumeStr);
        Preconditions.checkNotNull((Object)bucketStr);
        if (bucketStr.isEmpty()) {
            throw new FileNotFoundException("getBucket: Invalid argument: given bucket string is empty.");
        }
        try {
            bucket = this.proxy.getBucketDetails(volumeStr, bucketStr);
        }
        catch (OMException ex) {
            block10: {
                if (!createIfNotExist) break block10;
                switch (1.$SwitchMap$org$apache$hadoop$ozone$om$exceptions$OMException$ResultCodes[ex.getResult().ordinal()]) {
                    case 1: 
                    case 2: {
                        try {
                            this.objectStore.createVolume(volumeStr);
                        }
                        catch (OMException newVolEx) {
                            if (newVolEx.getResult().equals((Object)OMException.ResultCodes.VOLUME_ALREADY_EXISTS)) ** GOTO lbl20
                            throw newVolEx;
                        }
lbl20:
                        // 2 sources

                        volume = this.proxy.getVolumeDetails(volumeStr);
                        try {
                            volume.createBucket(bucketStr);
                            break;
                        }
                        catch (OMException newBucEx) {
                            if (newBucEx.getResult().equals((Object)OMException.ResultCodes.BUCKET_ALREADY_EXISTS)) break;
                            throw newBucEx;
                        }
                    }
                    default: {
                        throw ex;
                    }
                }
                bucket = this.proxy.getBucketDetails(volumeStr, bucketStr);
            }
            throw ex;
        }
        return bucket;
    }

    @Override
    public short getDefaultReplication() {
        return (short)this.replicationConfig.getRequiredNodes();
    }

    @Override
    public void close() throws IOException {
        this.ozoneClient.close();
    }

    @Override
    public InputStream readFile(String pathStr) throws IOException {
        this.incrementCounter(Statistic.OBJECTS_READ, 1L);
        OFSPath ofsPath = new OFSPath(pathStr);
        String key = ofsPath.getKeyName();
        try {
            OzoneBucket bucket = this.getBucket(ofsPath, false);
            return bucket.readFile(key).getInputStream();
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.FILE_NOT_FOUND || ex.getResult() == OMException.ResultCodes.NOT_A_FILE) {
                throw new FileNotFoundException(ex.getResult().name() + ": " + ex.getMessage());
            }
            throw ex;
        }
    }

    protected void incrementCounter(Statistic objectsRead, long count) {
    }

    @Override
    public OzoneFSOutputStream createFile(String pathStr, short replication, boolean overWrite, boolean recursive) throws IOException {
        this.incrementCounter(Statistic.OBJECTS_CREATED, 1L);
        OFSPath ofsPath = new OFSPath(pathStr);
        if (ofsPath.isRoot() || ofsPath.isVolume() || ofsPath.isBucket()) {
            throw new IOException("Cannot create file under root or volume.");
        }
        String key = ofsPath.getKeyName();
        try {
            OzoneBucket bucket = this.getBucket(ofsPath, recursive);
            OzoneOutputStream ozoneOutputStream = null;
            ozoneOutputStream = replication == ReplicationFactor.ONE.getValue() || replication == ReplicationFactor.THREE.getValue() ? bucket.createFile(key, 0L, ReplicationConfig.adjustReplication((ReplicationConfig)this.replicationConfig, (short)replication), overWrite, recursive) : bucket.createFile(key, 0L, this.replicationConfig, overWrite, recursive);
            return new OzoneFSOutputStream(ozoneOutputStream.getOutputStream());
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.FILE_ALREADY_EXISTS || ex.getResult() == OMException.ResultCodes.NOT_A_FILE) {
                throw new FileAlreadyExistsException(ex.getResult().name() + ": " + ex.getMessage());
            }
            throw ex;
        }
    }

    @Override
    public void renameKey(String key, String newKeyName) throws IOException {
        throw new IOException("OFS doesn't support renameKey, use rename instead.");
    }

    @Override
    public void rename(String path, String newPath) throws IOException {
        this.incrementCounter(Statistic.OBJECTS_RENAMED, 1L);
        OFSPath ofsPath = new OFSPath(path);
        OFSPath ofsNewPath = new OFSPath(newPath);
        if (!ofsPath.isInSameBucketAs(ofsNewPath)) {
            throw new IOException("Can't rename a key to a different bucket.");
        }
        OzoneBucket bucket = this.getBucket(ofsPath, false);
        String key = ofsPath.getKeyName();
        String newKey = ofsNewPath.getKeyName();
        bucket.renameKey(key, newKey);
    }

    void rename(OzoneBucket bucket, String path, String newPath) throws IOException {
        this.incrementCounter(Statistic.OBJECTS_RENAMED, 1L);
        OFSPath ofsPath = new OFSPath(path);
        OFSPath ofsNewPath = new OFSPath(newPath);
        String key = ofsPath.getKeyName();
        String newKey = ofsNewPath.getKeyName();
        bucket.renameKey(key, newKey);
    }

    @Override
    public boolean createDirectory(String pathStr) throws IOException {
        LOG.trace("creating dir for path: {}", (Object)pathStr);
        this.incrementCounter(Statistic.OBJECTS_CREATED, 1L);
        OFSPath ofsPath = new OFSPath(pathStr);
        if (ofsPath.getVolumeName().isEmpty()) {
            return false;
        }
        if (ofsPath.getBucketName().isEmpty()) {
            this.objectStore.createVolume(ofsPath.getVolumeName());
            return true;
        }
        String keyStr = ofsPath.getKeyName();
        try {
            OzoneBucket bucket = this.getBucket(ofsPath, true);
            if (keyStr != null && keyStr.length() > 0) {
                bucket.createDirectory(keyStr);
            }
        }
        catch (OMException e) {
            if (e.getResult() == OMException.ResultCodes.FILE_ALREADY_EXISTS) {
                throw new FileAlreadyExistsException(e.getMessage());
            }
            throw e;
        }
        return true;
    }

    @Override
    public boolean deleteObject(String path, boolean recursive) throws IOException {
        LOG.trace("issuing delete for path to key: {}", (Object)path);
        this.incrementCounter(Statistic.OBJECTS_DELETED, 1L);
        OFSPath ofsPath = new OFSPath(path);
        String keyName = ofsPath.getKeyName();
        if (keyName.length() == 0) {
            return false;
        }
        try {
            OzoneBucket bucket = this.getBucket(ofsPath, false);
            bucket.deleteDirectory(keyName, recursive);
            return true;
        }
        catch (OMException ome) {
            LOG.error("delete key failed {}", (Object)ome.getMessage());
            if (OMException.ResultCodes.DIRECTORY_NOT_EMPTY == ome.getResult()) {
                throw new PathIsNotEmptyDirectoryException(ome.getMessage());
            }
            return false;
        }
        catch (IOException ioe) {
            LOG.error("delete key failed " + ioe.getMessage());
            return false;
        }
    }

    @Override
    public boolean deleteObject(String path) throws IOException {
        return this.deleteObject(path, false);
    }

    private boolean areInSameBucket(List<String> keyNameList) {
        if (keyNameList.isEmpty()) {
            return true;
        }
        String firstKeyPath = keyNameList.get(0);
        String volAndBucket = new OFSPath(firstKeyPath).getNonKeyPath();
        return keyNameList.stream().skip(1L).allMatch(p -> new OFSPath(p).getNonKeyPath().equals(volAndBucket));
    }

    @Override
    public boolean deleteObjects(List<String> keyNameList) {
        if (keyNameList.size() == 0) {
            return true;
        }
        if (!this.areInSameBucket(keyNameList)) {
            LOG.error("Deleting keys from different buckets in a single batch is not supported.");
            return false;
        }
        try {
            OFSPath firstKeyPath = new OFSPath(keyNameList.get(0));
            OzoneBucket bucket = this.getBucket(firstKeyPath, false);
            return this.deleteObjects(bucket, keyNameList);
        }
        catch (IOException ioe) {
            LOG.error("delete key failed: {}", (Object)ioe.getMessage());
            return false;
        }
    }

    boolean deleteObjects(OzoneBucket bucket, List<String> keyNameList) {
        List keyList = keyNameList.stream().map(p -> new OFSPath(p).getKeyName()).collect(Collectors.toList());
        try {
            this.incrementCounter(Statistic.OBJECTS_DELETED, keyNameList.size());
            bucket.deleteKeys(keyList);
            return true;
        }
        catch (IOException ioe) {
            LOG.error("delete key failed: {}", (Object)ioe.getMessage());
            return false;
        }
    }

    @Override
    public FileStatusAdapter getFileStatus(String path, URI uri, Path qualifiedPath, String userName) throws IOException {
        this.incrementCounter(Statistic.OBJECTS_QUERY, 1L);
        OFSPath ofsPath = new OFSPath(path);
        String key = ofsPath.getKeyName();
        if (ofsPath.isRoot()) {
            return BasicRootedOzoneClientAdapterImpl.getFileStatusAdapterForRoot(uri);
        }
        if (ofsPath.isVolume()) {
            OzoneVolume volume = this.objectStore.getVolume(ofsPath.getVolumeName());
            return BasicRootedOzoneClientAdapterImpl.getFileStatusAdapterForVolume(volume, uri);
        }
        try {
            OzoneBucket bucket = this.getBucket(ofsPath, false);
            OzoneFileStatus status = bucket.getFileStatus(key);
            return this.toFileStatusAdapter(status, userName, uri, qualifiedPath, ofsPath.getNonKeyPath());
        }
        catch (OMException e) {
            if (e.getResult() == OMException.ResultCodes.FILE_NOT_FOUND) {
                throw new FileNotFoundException(key + ": No such file or directory!");
            }
            if (e.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                throw new FileNotFoundException(key + ": Bucket doesn't exist!");
            }
            throw e;
        }
    }

    public Collection<FileStatus> getTrashRoots(boolean allUsers, BasicRootedOzoneFileSystem fs) {
        ArrayList<FileStatus> ret = new ArrayList<FileStatus>();
        try {
            String username = UserGroupInformation.getCurrentUser().getShortUserName();
            Iterator iterVol = allUsers ? this.objectStore.listVolumes("") : this.objectStore.listVolumesByUser(username, "", "");
            while (iterVol.hasNext()) {
                OzoneVolume volume = (OzoneVolume)iterVol.next();
                Path volumePath = new Path("/", volume.getName());
                Iterator bucketIter = volume.listBuckets("");
                while (bucketIter.hasNext()) {
                    OzoneBucket bucket = (OzoneBucket)bucketIter.next();
                    Path bucketPath = new Path(volumePath, bucket.getName());
                    Path trashRoot = new Path(bucketPath, ".Trash");
                    if (allUsers) {
                        if (!fs.exists(trashRoot)) continue;
                        for (FileStatus candidate : fs.listStatus(trashRoot)) {
                            if (!fs.exists(candidate.getPath()) || !candidate.isDirectory()) continue;
                            ret.add(candidate);
                        }
                        continue;
                    }
                    Path userTrash = new Path(trashRoot, username);
                    if (!fs.exists(userTrash) || !fs.getFileStatus(userTrash).isDirectory()) continue;
                    ret.add(fs.getFileStatus(userTrash));
                }
            }
        }
        catch (IOException ex) {
            LOG.warn("Can't get all trash roots", (Throwable)ex);
            return Collections.emptyList();
        }
        return ret;
    }

    @Override
    public Iterator<BasicKeyInfo> listKeys(String pathStr) throws IOException {
        OzoneBucket bucket;
        this.incrementCounter(Statistic.OBJECTS_LIST, 1L);
        OFSPath ofsPath = new OFSPath(pathStr);
        String key = ofsPath.getKeyName();
        try {
            bucket = this.getBucket(ofsPath, false);
        }
        catch (IOException ex) {
            return new IteratorAdapter(Collections.emptyIterator());
        }
        return new IteratorAdapter(bucket.listKeys(key));
    }

    private List<FileStatusAdapter> listStatusRoot(boolean recursive, String startPath, long numEntries, URI uri, Path workingDir, String username) throws IOException {
        OFSPath ofsStartPath = new OFSPath(startPath);
        Iterator iter = this.objectStore.listVolumesByUser(username, null, ofsStartPath.getVolumeName());
        ArrayList<FileStatusAdapter> res = new ArrayList<FileStatusAdapter>();
        while (iter.hasNext() && (long)res.size() < numEntries) {
            OzoneVolume volume = (OzoneVolume)iter.next();
            res.add(BasicRootedOzoneClientAdapterImpl.getFileStatusAdapterForVolume(volume, uri));
            if (!recursive) continue;
            String pathStrNextVolume = volume.getName();
            res.addAll(this.listStatus(pathStrNextVolume, recursive, startPath, numEntries - (long)res.size(), uri, workingDir, username));
        }
        return res;
    }

    private List<FileStatusAdapter> listStatusVolume(String volumeStr, boolean recursive, String startPath, long numEntries, URI uri, Path workingDir, String username) throws IOException {
        OFSPath ofsStartPath = new OFSPath(startPath);
        OzoneVolume volume = this.objectStore.getVolume(volumeStr);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)volume.getOwner());
        String owner = ugi.getShortUserName();
        String group = BasicRootedOzoneClientAdapterImpl.getGroupName(ugi);
        Iterator iter = volume.listBuckets(null, ofsStartPath.getBucketName());
        ArrayList<FileStatusAdapter> res = new ArrayList<FileStatusAdapter>();
        while (iter.hasNext() && (long)res.size() < numEntries) {
            OzoneBucket bucket = (OzoneBucket)iter.next();
            res.add(BasicRootedOzoneClientAdapterImpl.getFileStatusAdapterForBucket(bucket, uri, owner, group));
            if (!recursive) continue;
            String pathStrNext = volumeStr + "/" + bucket.getName();
            res.addAll(this.listStatus(pathStrNext, recursive, startPath, numEntries - (long)res.size(), uri, workingDir, username));
        }
        return res;
    }

    @Override
    public List<FileStatusAdapter> listStatus(String pathStr, boolean recursive, String startPath, long numEntries, URI uri, Path workingDir, String username) throws IOException {
        OFSPath ofsPath;
        this.incrementCounter(Statistic.OBJECTS_LIST, 1L);
        if (startPath.startsWith(uri.toString())) {
            try {
                startPath = new URI(startPath).getPath();
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex);
            }
        }
        if ((ofsPath = new OFSPath(pathStr)).isRoot()) {
            return this.listStatusRoot(recursive, startPath, numEntries, uri, workingDir, username);
        }
        OFSPath ofsStartPath = new OFSPath(startPath);
        if (ofsPath.isVolume()) {
            String startBucket = ofsStartPath.getBucketName();
            return this.listStatusVolume(ofsPath.getVolumeName(), recursive, startBucket, numEntries, uri, workingDir, username);
        }
        String keyName = ofsPath.getKeyName();
        String startKey = ofsStartPath.getKeyName();
        try {
            OzoneBucket bucket = this.getBucket(ofsPath, false);
            List statuses = bucket.listStatus(keyName, recursive, startKey, numEntries);
            String ofsPathPrefix = ofsPath.getNonKeyPath();
            ArrayList<FileStatusAdapter> result = new ArrayList<FileStatusAdapter>();
            for (OzoneFileStatus status : statuses) {
                result.add(this.toFileStatusAdapter(status, username, uri, workingDir, ofsPathPrefix));
            }
            return result;
        }
        catch (OMException e) {
            if (e.getResult() == OMException.ResultCodes.FILE_NOT_FOUND) {
                throw new FileNotFoundException(e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public Token<OzoneTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        if (!this.securityEnabled) {
            return null;
        }
        Token token = this.ozoneClient.getObjectStore().getDelegationToken(renewer == null ? null : new Text(renewer));
        token.setKind(OzoneTokenIdentifier.KIND_NAME);
        return token;
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    @Override
    public KeyProvider getKeyProvider() throws IOException {
        return this.objectStore.getKeyProvider();
    }

    @Override
    public URI getKeyProviderUri() throws IOException {
        return this.objectStore.getKeyProviderUri();
    }

    @Override
    public String getCanonicalServiceName() {
        return this.objectStore.getCanonicalServiceName();
    }

    private FileStatusAdapter toFileStatusAdapter(OzoneFileStatus status, String owner, URI defaultUri, Path workingDir, String ofsPathPrefix) {
        OmKeyInfo keyInfo = status.getKeyInfo();
        short replication = (short)keyInfo.getReplicationConfig().getRequiredNodes();
        return new FileStatusAdapter(keyInfo.getDataSize(), new Path(ofsPathPrefix + "/" + keyInfo.getKeyName()).makeQualified(defaultUri, workingDir), status.isDirectory(), replication, status.getBlockSize(), keyInfo.getModificationTime(), keyInfo.getModificationTime(), status.isDirectory() ? (short)511 : 438, owner, owner, null, this.getBlockLocations(status));
    }

    private BlockLocation[] getBlockLocations(OzoneFileStatus fileStatus) {
        if (fileStatus == null) {
            return new BlockLocation[0];
        }
        OmKeyInfo keyInfo = fileStatus.getKeyInfo();
        if (keyInfo == null || CollectionUtils.isEmpty((Collection)keyInfo.getKeyLocationVersions())) {
            return new BlockLocation[0];
        }
        List omKeyLocationInfoGroups = keyInfo.getKeyLocationVersions();
        if (CollectionUtils.isEmpty((Collection)omKeyLocationInfoGroups)) {
            return new BlockLocation[0];
        }
        OmKeyLocationInfoGroup omKeyLocationInfoGroup = keyInfo.getLatestVersionLocations();
        BlockLocation[] blockLocations = new BlockLocation[omKeyLocationInfoGroup.getBlocksLatestVersionOnly().size()];
        int i = 0;
        long offsetOfBlockInFile = 0L;
        for (OmKeyLocationInfo omKeyLocationInfo : omKeyLocationInfoGroup.getBlocksLatestVersionOnly()) {
            ArrayList hostList = new ArrayList();
            ArrayList nameList = new ArrayList();
            omKeyLocationInfo.getPipeline().getNodes().forEach(dn -> {
                hostList.add(dn.getHostName());
                int port = dn.getPort(DatanodeDetails.Port.Name.STANDALONE).getValue();
                if (port == 0) {
                    port = this.configuredDnPort;
                }
                nameList.add(dn.getHostName() + ":" + port);
            });
            String[] hosts = hostList.toArray(new String[hostList.size()]);
            String[] names = nameList.toArray(new String[nameList.size()]);
            BlockLocation blockLocation = new BlockLocation(names, hosts, offsetOfBlockInFile, omKeyLocationInfo.getLength());
            offsetOfBlockInFile += omKeyLocationInfo.getLength();
            blockLocations[i++] = blockLocation;
        }
        return blockLocations;
    }

    private static String getGroupName(UserGroupInformation ugi) {
        try {
            return ugi.getPrimaryGroupName();
        }
        catch (IOException ignored) {
            return "";
        }
    }

    private static FileStatusAdapter getFileStatusAdapterForVolume(OzoneVolume ozoneVolume, URI uri) {
        String pathStr = uri.toString() + "/" + ozoneVolume.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("getFileStatusAdapterForVolume: ozoneVolume={}, pathStr={}", (Object)ozoneVolume.getName(), (Object)pathStr);
        }
        Path path = new Path(pathStr);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)ozoneVolume.getOwner());
        String owner = ugi.getShortUserName();
        String group = BasicRootedOzoneClientAdapterImpl.getGroupName(ugi);
        return new FileStatusAdapter(0L, path, true, 0, 0L, ozoneVolume.getCreationTime().getEpochSecond() * 1000L, 0L, FsPermission.getDirDefault().toShort(), owner, group, path, new BlockLocation[0]);
    }

    private static FileStatusAdapter getFileStatusAdapterForBucket(OzoneBucket ozoneBucket, URI uri, String owner, String group) {
        String pathStr = uri.toString() + "/" + ozoneBucket.getVolumeName() + "/" + ozoneBucket.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("getFileStatusAdapterForBucket: ozoneBucket={}, pathStr={}", (Object)(ozoneBucket.getVolumeName() + "/" + ozoneBucket.getName()), (Object)pathStr);
        }
        Path path = new Path(pathStr);
        return new FileStatusAdapter(0L, path, true, 0, 0L, ozoneBucket.getCreationTime().getEpochSecond() * 1000L, 0L, FsPermission.getDirDefault().toShort(), owner, group, path, new BlockLocation[0]);
    }

    private static FileStatusAdapter getFileStatusAdapterForRoot(URI uri) {
        Path path = new Path(uri.toString() + "/");
        return new FileStatusAdapter(0L, path, true, 0, 0L, System.currentTimeMillis(), 0L, FsPermission.getDirDefault().toShort(), null, null, null, new BlockLocation[0]);
    }

    @Override
    public boolean isFSOptimizedBucket() {
        return false;
    }

    public static class IteratorAdapter
    implements Iterator<BasicKeyInfo> {
        private Iterator<? extends OzoneKey> original;

        public IteratorAdapter(Iterator<? extends OzoneKey> listKeys) {
            this.original = listKeys;
        }

        @Override
        public boolean hasNext() {
            return this.original.hasNext();
        }

        @Override
        public BasicKeyInfo next() {
            OzoneKey next = this.original.next();
            if (next == null) {
                return null;
            }
            return new BasicKeyInfo(next.getName(), next.getModificationTime().toEpochMilli(), next.getDataSize());
        }
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends TokenRenewer {
        public Text getKind() {
            return OzoneTokenIdentifier.KIND_NAME;
        }

        public boolean handleKind(Text kind) {
            return this.getKind().equals((Object)kind);
        }

        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }

        public long renew(Token<?> token, Configuration conf) throws IOException, InterruptedException {
            Token<?> ozoneDt = token;
            OzoneClient ozoneClient = OzoneClientFactory.getOzoneClient((Configuration)OzoneConfiguration.of((Configuration)conf), ozoneDt);
            return ozoneClient.getObjectStore().renewDelegationToken(ozoneDt);
        }

        public void cancel(Token<?> token, Configuration conf) throws IOException, InterruptedException {
            Token<?> ozoneDt = token;
            OzoneClient ozoneClient = OzoneClientFactory.getOzoneClient((Configuration)OzoneConfiguration.of((Configuration)conf), ozoneDt);
            ozoneClient.getObjectStore().cancelDelegationToken(ozoneDt);
        }

        static {
            OzoneConfiguration.activate();
        }
    }
}

