/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.volume;

import com.google.common.base.Strings;
import java.io.IOException;
import org.apache.hadoop.hdds.client.OzoneQuota;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.SetSpaceQuotaOptions;
import org.apache.hadoop.ozone.shell.volume.VolumeHandler;
import picocli.CommandLine;

@CommandLine.Command(name="setquota", description={"Set quota of the volumes"})
public class SetQuotaHandler
extends VolumeHandler {
    @CommandLine.Mixin
    private SetSpaceQuotaOptions quotaOptions;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        String volumeName = address.getVolumeName();
        OzoneVolume volume = client.getObjectStore().getVolume(volumeName);
        long spaceQuota = volume.getQuotaInBytes();
        long namespaceQuota = volume.getQuotaInNamespace();
        if (!Strings.isNullOrEmpty((String)this.quotaOptions.getQuotaInBytes())) {
            spaceQuota = OzoneQuota.parseSpaceQuota((String)this.quotaOptions.getQuotaInBytes()).getQuotaInBytes();
        }
        if (!Strings.isNullOrEmpty((String)this.quotaOptions.getQuotaInNamespace())) {
            namespaceQuota = OzoneQuota.parseNameSpaceQuota((String)this.quotaOptions.getQuotaInNamespace()).getQuotaInNamespace();
        }
        if (volume.getQuotaInNamespace() == -2L) {
            String msg = "Volume " + volumeName + " is created before version 1.1.0, usedNamespace may be inaccurate and it is not recommended to enable quota.";
            this.printMsg(msg);
        }
        volume.setQuota(OzoneQuota.getOzoneQuota((long)spaceQuota, (long)namespaceQuota));
    }
}

