/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.volume;

import com.google.common.base.Strings;
import java.io.IOException;
import org.apache.hadoop.hdds.client.OzoneQuota;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.VolumeArgs;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.SetSpaceQuotaOptions;
import org.apache.hadoop.ozone.shell.volume.VolumeHandler;
import org.apache.hadoop.security.UserGroupInformation;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Creates a volume for the specified user"})
public class CreateVolumeHandler
extends VolumeHandler {
    @CommandLine.Option(names={"--user", "-u"}, description={"Owner of the volume"})
    private String ownerName;
    @CommandLine.Mixin
    private SetSpaceQuotaOptions quotaOptions;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        if (this.ownerName == null) {
            this.ownerName = UserGroupInformation.getCurrentUser().getUserName();
        }
        String volumeName = address.getVolumeName();
        String adminName = UserGroupInformation.getCurrentUser().getUserName();
        VolumeArgs.Builder volumeArgsBuilder = VolumeArgs.newBuilder().setAdmin(adminName).setOwner(this.ownerName);
        if (!Strings.isNullOrEmpty((String)this.quotaOptions.getQuotaInBytes())) {
            volumeArgsBuilder.setQuotaInBytes(OzoneQuota.parseSpaceQuota((String)this.quotaOptions.getQuotaInBytes()).getQuotaInBytes());
        }
        if (!Strings.isNullOrEmpty((String)this.quotaOptions.getQuotaInNamespace())) {
            volumeArgsBuilder.setQuotaInNamespace(OzoneQuota.parseNameSpaceQuota((String)this.quotaOptions.getQuotaInNamespace()).getQuotaInNamespace());
        }
        client.getObjectStore().createVolume(volumeName, volumeArgsBuilder.build());
        if (this.isVerbose()) {
            OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
            this.printObjectAsJson(vol);
        }
    }
}

