/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.volume;

import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.shell.ClearSpaceQuotaOptions;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.volume.VolumeHandler;
import picocli.CommandLine;

@CommandLine.Command(name="clrquota", description={"clear quota of the volume"})
public class ClearQuotaHandler
extends VolumeHandler {
    @CommandLine.Mixin
    private ClearSpaceQuotaOptions clrSpaceQuota;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        String volumeName = address.getVolumeName();
        OzoneVolume volume = client.getObjectStore().getVolume(volumeName);
        if (this.clrSpaceQuota.getClrSpaceQuota()) {
            volume.clearSpaceQuota();
        }
        if (this.clrSpaceQuota.getClrNamespaceQuota()) {
            volume.clearNamespaceQuota();
        }
    }
}

