/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.genesis;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStoreImpl;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.server.SCMConfigurator;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.utils.MetadataStore;
import org.apache.hadoop.hdds.utils.MetadataStoreBuilder;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.om.OMStorage;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.security.authentication.client.AuthenticationException;

public final class GenesisUtil {
    public static final String DEFAULT_TYPE = "default";
    public static final String CACHE_10MB_TYPE = "Cache10MB";
    public static final String CACHE_1GB_TYPE = "Cache1GB";
    public static final String CLOSED_TYPE = "ClosedContainer";
    private static final int DB_FILE_LEN = 7;
    private static final String TMP_DIR = "java.io.tmpdir";
    private static final Random RANDOM = new Random();
    private static final String RANDOM_LOCAL_ADDRESS = "127.0.0.1:0";

    private GenesisUtil() {
    }

    public static Path getTempPath() {
        return Paths.get(System.getProperty(TMP_DIR), new String[0]);
    }

    public static MetadataStore getMetadataStore(String dbType) throws IOException {
        OzoneConfiguration conf = new OzoneConfiguration();
        MetadataStoreBuilder builder = MetadataStoreBuilder.newBuilder();
        builder.setConf((ConfigurationSource)conf);
        builder.setCreateIfMissing(true);
        builder.setDbFile(GenesisUtil.getTempPath().resolve(RandomStringUtils.randomNumeric((int)7)).toFile());
        switch (dbType) {
            case "default": {
                break;
            }
            case "ClosedContainer": {
                break;
            }
            case "Cache10MB": {
                builder.setCacheSize((long)StorageUnit.MB.toBytes(10.0));
                break;
            }
            case "Cache1GB": {
                builder.setCacheSize((long)StorageUnit.GB.toBytes(1.0));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type: " + dbType);
            }
        }
        return builder.build();
    }

    public static DatanodeDetails createDatanodeDetails(UUID uuid) {
        String ipAddress = RANDOM.nextInt(256) + "." + RANDOM.nextInt(256) + "." + RANDOM.nextInt(256) + "." + RANDOM.nextInt(256);
        DatanodeDetails.Port containerPort = DatanodeDetails.newPort((DatanodeDetails.Port.Name)DatanodeDetails.Port.Name.STANDALONE, (Integer)0);
        DatanodeDetails.Port ratisPort = DatanodeDetails.newPort((DatanodeDetails.Port.Name)DatanodeDetails.Port.Name.RATIS, (Integer)0);
        DatanodeDetails.Port restPort = DatanodeDetails.newPort((DatanodeDetails.Port.Name)DatanodeDetails.Port.Name.REST, (Integer)0);
        DatanodeDetails.Builder builder = DatanodeDetails.newBuilder();
        builder.setUuid(uuid).setHostName("localhost").setIpAddress(ipAddress).addPort(containerPort).addPort(ratisPort).addPort(restPort);
        return builder.build();
    }

    static StorageContainerManager getScm(OzoneConfiguration conf, SCMConfigurator configurator) throws IOException, AuthenticationException {
        SCMStorageConfig scmStore = new SCMStorageConfig(conf);
        if (scmStore.getState() != Storage.StorageState.INITIALIZED) {
            String clusterId = UUID.randomUUID().toString();
            String scmId = UUID.randomUUID().toString();
            scmStore.setClusterId(clusterId);
            scmStore.setScmId(scmId);
            scmStore.initialize();
        }
        return new StorageContainerManager(conf, configurator);
    }

    static void configureSCM(OzoneConfiguration conf, int numHandlers) {
        conf.set("ozone.scm.client.address", RANDOM_LOCAL_ADDRESS);
        conf.set("ozone.scm.block.client.address", RANDOM_LOCAL_ADDRESS);
        conf.set("ozone.scm.datanode.address", RANDOM_LOCAL_ADDRESS);
        conf.set("ozone.scm.http-address", RANDOM_LOCAL_ADDRESS);
        conf.setInt("ozone.scm.handler.count.key", numHandlers);
    }

    static void addPipelines(HddsProtos.ReplicationFactor factor, int numPipelines, ConfigurationSource conf) throws Exception {
        int i;
        SCMMetadataStoreImpl scmMetadataStore = new SCMMetadataStoreImpl((OzoneConfiguration)conf);
        Table pipelineTable = scmMetadataStore.getPipelineTable();
        ArrayList<DatanodeDetails> nodes = new ArrayList<DatanodeDetails>();
        for (i = 0; i < factor.getNumber(); ++i) {
            nodes.add(GenesisUtil.createDatanodeDetails(UUID.randomUUID()));
        }
        for (i = 0; i < numPipelines; ++i) {
            Pipeline pipeline = Pipeline.newBuilder().setState(Pipeline.PipelineState.OPEN).setId(PipelineID.randomId()).setType(HddsProtos.ReplicationType.RATIS).setFactor(factor).setNodes(nodes).build();
            pipelineTable.put((Object)pipeline.getId(), (Object)pipeline);
        }
        scmMetadataStore.getStore().close();
    }

    static OzoneManager getOm(OzoneConfiguration conf) throws IOException, AuthenticationException {
        OMStorage omStorage = new OMStorage(conf);
        SCMStorageConfig scmStore = new SCMStorageConfig(conf);
        if (omStorage.getState() != Storage.StorageState.INITIALIZED) {
            omStorage.setClusterId(scmStore.getClusterID());
            omStorage.setScmId(scmStore.getScmId());
            omStorage.setOmId(UUID.randomUUID().toString());
            omStorage.initialize();
        }
        return OzoneManager.createOm((OzoneConfiguration)conf);
    }

    static void configureOM(OzoneConfiguration conf, int numHandlers) {
        conf.set("ozone.om.http-address", RANDOM_LOCAL_ADDRESS);
        conf.setInt("ozone.om.handler.count.key", numHandlers);
    }
}

