/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.genesis;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ContainerBlockID;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
public class BenchmarkBlockDataToString {
    @Param(value={"1000"})
    private int count;
    @Param(value={"112"})
    private int capacity;
    private List<BlockData> data;
    private List<String> values;

    @Setup
    public void createData() {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        this.data = new ArrayList<BlockData>(this.count);
        this.values = new ArrayList<String>(this.count);
        for (int i = 0; i < this.count; ++i) {
            BlockID blockID = new BlockID(rnd.nextLong(), rnd.nextLong());
            BlockData item = new BlockData(blockID);
            item.setBlockCommitSequenceId(rnd.nextLong());
            this.data.add(item);
            this.values.add(item.toString());
        }
    }

    @Benchmark
    public void usingToStringBuilderDefaultCapacity(BenchmarkBlockDataToString state, Blackhole sink) {
        for (int i = 0; i < state.count; ++i) {
            BlockData item = state.data.get(i);
            String str = new ToStringBuilder((Object)item, ToStringStyle.NO_CLASS_NAME_STYLE).append("blockId", (Object)item.getBlockID().toString()).append("size", item.getSize()).toString();
            sink.consume((Object)str);
            Preconditions.checkArgument((boolean)str.equals(state.values.get(i)));
        }
    }

    @Benchmark
    public void usingToStringBuilder(BenchmarkBlockDataToString state, Blackhole sink) {
        for (int i = 0; i < state.count; ++i) {
            BlockData item = state.data.get(i);
            String str = new ToStringBuilder((Object)item, ToStringStyle.NO_CLASS_NAME_STYLE, new StringBuffer(this.capacity)).append("blockId", (Object)item.getBlockID().toString()).append("size", item.getSize()).toString();
            sink.consume((Object)str);
            Preconditions.checkArgument((boolean)str.equals(state.values.get(i)));
        }
    }

    @Benchmark
    public void usingSimpleStringBuilder(BenchmarkBlockDataToString state, Blackhole sink) {
        for (int i = 0; i < state.count; ++i) {
            BlockData item = state.data.get(i);
            String str = new StringBuilder(this.capacity).append("[").append("blockId=").append(item.getBlockID()).append(",size=").append(item.getSize()).append("]").toString();
            sink.consume((Object)str);
            Preconditions.checkArgument((boolean)str.equals(state.values.get(i)));
        }
    }

    @Benchmark
    public void usingPushDownStringBuilder(BenchmarkBlockDataToString state, Blackhole sink) {
        for (int i = 0; i < state.count; ++i) {
            BlockData item = state.data.get(i);
            StringBuilder sb = new StringBuilder(this.capacity);
            item.appendTo(sb);
            String str = sb.toString();
            sink.consume((Object)str);
            Preconditions.checkArgument((boolean)str.equals(state.values.get(i)));
        }
    }

    @Benchmark
    public void usingConcatenation(BenchmarkBlockDataToString state, Blackhole sink) {
        for (int i = 0; i < state.count; ++i) {
            BlockData item = state.data.get(i);
            String str = "[blockId=" + item.getBlockID() + ",size=" + item.getSize() + "]";
            sink.consume((Object)str);
            Preconditions.checkArgument((boolean)str.equals(state.values.get(i)));
        }
    }

    @Benchmark
    public void usingInlineStringBuilder(BenchmarkBlockDataToString state, Blackhole sink) {
        for (int i = 0; i < state.count; ++i) {
            BlockData item = state.data.get(i);
            BlockID blockID = item.getBlockID();
            ContainerBlockID containerBlockID = blockID.getContainerBlockID();
            String str = new StringBuilder(this.capacity).append("[").append("blockId=").append("conID: ").append(containerBlockID.getContainerID()).append(" locID: ").append(containerBlockID.getLocalID()).append(" bcsId: ").append(blockID.getBlockCommitSequenceId()).append(",size=").append(item.getSize()).append("]").toString();
            sink.consume((Object)str);
            Preconditions.checkArgument((boolean)str.equals(state.values.get(i)));
        }
    }
}

