/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.genesis;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.server.SCMConfigurator;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.ozone.genesis.GenesisUtil;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.security.UserGroupInformation;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
public class BenchMarkOzoneManager {
    private static String testDir;
    private static OzoneManager om;
    private static StorageContainerManager scm;
    private static ReentrantLock lock;
    private static String volumeName;
    private static String bucketName;
    private static List<String> keyNames;
    private static List<Long> clientIDs;
    private static int numPipelines;
    private static int numContainersPerPipeline;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Setup(value=Level.Trial)
    public static void initialize() throws Exception {
        try {
            lock.lock();
            if (scm == null) {
                OzoneConfiguration conf = new OzoneConfiguration();
                testDir = GenesisUtil.getTempPath().resolve(RandomStringUtils.randomNumeric((int)7)).toString();
                conf.set("ozone.metadata.dirs", testDir);
                GenesisUtil.configureSCM(conf, 10);
                GenesisUtil.configureOM(conf, 20);
                conf.setInt("ozone.scm.pipeline.owner.container.count", numContainersPerPipeline);
                GenesisUtil.addPipelines(HddsProtos.ReplicationFactor.THREE, numPipelines, (ConfigurationSource)conf);
                scm = GenesisUtil.getScm(conf, new SCMConfigurator());
                scm.start();
                om = GenesisUtil.getOm(conf);
                om.start();
                PipelineManager pipelineManager = scm.getPipelineManager();
                for (Pipeline pipeline : pipelineManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE)) {
                    pipelineManager.openPipeline(pipeline.getId());
                }
                scm.getEventQueue().fireEvent((Event)SCMEvents.SAFE_MODE_STATUS, (Object)new SCMSafeModeManager.SafeModeStatus(false, false));
                Thread.sleep(1000L);
                om.createVolume(new OmVolumeArgs.Builder().setVolume(volumeName).setAdminName(UserGroupInformation.getLoginUser().getUserName()).setOwnerName(UserGroupInformation.getLoginUser().getUserName()).build());
                om.createBucket(new OmBucketInfo.Builder().setBucketName(bucketName).setVolumeName(volumeName).build());
                BenchMarkOzoneManager.createKeys(100000);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static void createKeys(int numKeys) throws IOException {
        for (int i = 0; i < numKeys; ++i) {
            String key = UUID.randomUUID().toString();
            OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(key).setDataSize(0L).setFactor(HddsProtos.ReplicationFactor.THREE).setType(HddsProtos.ReplicationType.RATIS).build();
            OpenKeySession keySession = om.getKeyManager().openKey(omKeyArgs);
            long clientID = keySession.getId();
            keyNames.add(key);
            clientIDs.add(clientID);
        }
    }

    @TearDown(value=Level.Trial)
    public static void tearDown() {
        try {
            lock.lock();
            if (scm != null) {
                scm.stop();
                scm.join();
                scm = null;
                om.stop();
                om.join();
                om = null;
                FileUtil.fullyDelete((File)new File(testDir));
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Threads(value=4)
    @Benchmark
    public void allocateBlockBenchMark(BenchMarkOzoneManager state, Blackhole bh) throws IOException {
        int index = (int)(Math.random() * (double)keyNames.size());
        String key = keyNames.get(index);
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(key).setDataSize(50L).setFactor(HddsProtos.ReplicationFactor.THREE).setType(HddsProtos.ReplicationType.RATIS).build();
        om.allocateBlock(omKeyArgs, clientIDs.get(index).longValue(), new ExcludeList());
    }

    @Threads(value=4)
    @Benchmark
    public void createAndCommitKeyBenchMark(BenchMarkOzoneManager state, Blackhole bh) throws IOException {
        String key = UUID.randomUUID().toString();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(key).setDataSize(50L).setFactor(HddsProtos.ReplicationFactor.THREE).setType(HddsProtos.ReplicationType.RATIS).build();
        OpenKeySession openKeySession = om.openKey(omKeyArgs);
        om.allocateBlock(omKeyArgs, openKeySession.getId(), new ExcludeList());
    }

    static {
        lock = new ReentrantLock();
        volumeName = UUID.randomUUID().toString();
        bucketName = UUID.randomUUID().toString();
        keyNames = new ArrayList<String>();
        clientIDs = new ArrayList<Long>();
        numPipelines = 1;
        numContainersPerPipeline = 3;
    }
}

