/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.genesis;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.hdds.utils.MetadataStore;
import org.apache.hadoop.ozone.genesis.GenesisUtil;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
public class BenchMarkMetadataStoreReads {
    private static final int DATA_LEN = 1024;
    private static final long MAX_KEYS = 10240L;
    private MetadataStore store;
    @Param(value={"default", "Cache10MB", "Cache1GB", "ClosedContainer"})
    private String type;

    @Setup
    public void initialize() throws IOException {
        this.store = GenesisUtil.getMetadataStore(this.type);
        byte[] data = RandomStringUtils.randomAlphanumeric((int)1024).getBytes(StandardCharsets.UTF_8);
        int x = 0;
        while ((long)x < 10240L) {
            this.store.put(Long.toHexString(x).getBytes(StandardCharsets.UTF_8), data);
            ++x;
        }
        if (this.type.compareTo("ClosedContainer") == 0) {
            this.store.compactDB();
        }
    }

    @Benchmark
    public void test(Blackhole bh) throws IOException {
        long x = RandomUtils.nextLong((long)0L, (long)10240L);
        bh.consume((Object)this.store.get(Long.toHexString(x).getBytes(StandardCharsets.UTF_8)));
    }
}

