/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.genesis;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.ozone.common.ChecksumByteBuffer;
import org.apache.hadoop.ozone.common.ChecksumByteBufferFactory;
import org.apache.hadoop.ozone.common.ChecksumByteBufferImpl;
import org.apache.hadoop.ozone.common.NativeCheckSumCRC32;
import org.apache.hadoop.ozone.common.PureJavaCrc32ByteBuffer;
import org.apache.hadoop.ozone.common.PureJavaCrc32CByteBuffer;
import org.apache.hadoop.util.NativeCRC32Wrapper;
import org.apache.hadoop.util.PureJavaCrc32;
import org.apache.hadoop.util.PureJavaCrc32C;
import org.openjdk.jmh.Main;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

public class BenchMarkCRCStreaming {
    private static int dataSize = 0x4000000;

    @Benchmark
    @Threads(value=1)
    @Warmup(iterations=3, time=1000, timeUnit=TimeUnit.MILLISECONDS)
    @Fork(value=1, warmups=0)
    @Measurement(iterations=5, time=2000, timeUnit=TimeUnit.MILLISECONDS)
    @BenchmarkMode(value={Mode.Throughput})
    public void runCRC(Blackhole blackhole, BenchmarkState state) {
        ByteBuffer data = state.data;
        data.clear();
        ChecksumByteBuffer csum = state.checksum;
        int bytesPerCheckSum = state.checksumSize;
        for (int i = 0; i < data.capacity(); i += bytesPerCheckSum) {
            data.position(i);
            data.limit(i + bytesPerCheckSum);
            csum.update(data);
            blackhole.consume(csum.getValue());
            csum.reset();
        }
    }

    public static void main(String[] args) throws Exception {
        Main.main((String[])args);
    }

    static /* synthetic */ int access$000() {
        return dataSize;
    }

    @State(value=Scope.Thread)
    public static class BenchmarkState {
        private final ByteBuffer data = ByteBuffer.allocate(BenchMarkCRCStreaming.access$000());
        @Param(value={"512", "1024", "2048", "4096", "32768", "1048576"})
        private int checksumSize;
        @Param(value={"pureCRC32", "pureCRC32C", "hadoopCRC32C", "hadoopCRC32", "zipCRC32", "zipCRC32C", "nativeCRC32", "nativeCRC32C"})
        private String crcImpl;
        private ChecksumByteBuffer checksum;

        public ChecksumByteBuffer checksum() {
            return this.checksum;
        }

        public String crcImpl() {
            return this.crcImpl;
        }

        public int checksumSize() {
            return this.checksumSize;
        }

        @Setup(value=Level.Trial)
        public void setUp() {
            switch (this.crcImpl) {
                case "pureCRC32": {
                    this.checksum = new PureJavaCrc32ByteBuffer();
                    break;
                }
                case "pureCRC32C": {
                    this.checksum = new PureJavaCrc32CByteBuffer();
                    break;
                }
                case "hadoopCRC32": {
                    this.checksum = new ChecksumByteBufferImpl((Checksum)new PureJavaCrc32());
                    break;
                }
                case "hadoopCRC32C": {
                    this.checksum = new ChecksumByteBufferImpl((Checksum)new PureJavaCrc32C());
                    break;
                }
                case "zipCRC32": {
                    this.checksum = new ChecksumByteBufferImpl((Checksum)new CRC32());
                    break;
                }
                case "zipCRC32C": {
                    try {
                        this.checksum = new ChecksumByteBufferImpl(ChecksumByteBufferFactory.Java9Crc32CFactory.createChecksum());
                        break;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("zipCRC32C is not available pre Java 9");
                    }
                }
                case "nativeCRC32": {
                    if (NativeCRC32Wrapper.isAvailable()) {
                        this.checksum = new ChecksumByteBufferImpl((Checksum)new NativeCheckSumCRC32(1, this.checksumSize));
                        break;
                    }
                    throw new RuntimeException("Native library is not available");
                }
                case "nativeCRC32C": {
                    if (NativeCRC32Wrapper.isAvailable()) {
                        this.checksum = new ChecksumByteBufferImpl((Checksum)new NativeCheckSumCRC32(2, this.checksumSize));
                        break;
                    }
                    throw new RuntimeException("Native library is not available");
                }
            }
            this.data.clear();
            this.data.put(RandomUtils.nextBytes((int)this.data.remaining()));
        }
    }
}

