/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import picocli.CommandLine;

@CommandLine.Command(name="ombg", aliases={"om-bucket-generator"}, description={"Generate ozone buckets on OM side."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class OmBucketGenerator
extends BaseFreonGenerator
implements Callable<Void> {
    @CommandLine.Option(names={"-v", "--volume"}, description={"Name of the bucket which contains the test data. Will be created if missing."}, defaultValue="vol1")
    private String volumeName;
    @CommandLine.Option(names={"--om-service-id"}, description={"OM Service ID"})
    private String omServiceID = null;
    private OzoneManagerProtocol ozoneManagerClient;
    private Timer bucketCreationTimer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        this.init();
        OzoneConfiguration ozoneConfiguration = this.createOzoneConfiguration();
        try (OzoneClient rpcClient = this.createOzoneClient(this.omServiceID, ozoneConfiguration);){
            this.ensureVolumeExists(rpcClient, this.volumeName);
            this.ozoneManagerClient = this.createOmClient(ozoneConfiguration, this.omServiceID);
            this.bucketCreationTimer = this.getMetrics().timer("bucket-create");
            this.runTests(this::createBucket);
        }
        finally {
            if (this.ozoneManagerClient != null) {
                this.ozoneManagerClient.close();
            }
        }
        return null;
    }

    private void createBucket(long index) throws Exception {
        OmBucketInfo bucketInfo = new OmBucketInfo.Builder().setBucketName(this.getPrefix() + index).setVolumeName(this.volumeName).setStorageType(StorageType.DISK).build();
        this.bucketCreationTimer.time(() -> {
            this.ozoneManagerClient.createBucket(bucketInfo);
            return null;
        });
    }
}

