/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.RandomStringUtils;

public class ContentGenerator {
    private long keySize;
    private int bufferSize;
    private final int copyBufferSize;
    private final byte[] buffer;

    ContentGenerator(long keySize, int bufferSize) {
        this(keySize, bufferSize, bufferSize);
    }

    ContentGenerator(long keySize, int bufferSize, int copyBufferSize) {
        this.keySize = keySize;
        this.bufferSize = bufferSize;
        this.copyBufferSize = copyBufferSize;
        this.buffer = RandomStringUtils.randomAscii((int)bufferSize).getBytes(StandardCharsets.UTF_8);
    }

    public void write(OutputStream outputStream) throws IOException {
        for (long nrRemaining = this.keySize; nrRemaining > 0L; nrRemaining -= (long)this.bufferSize) {
            int i;
            int curSize = (int)Math.min((long)this.bufferSize, nrRemaining);
            if (this.copyBufferSize == 1) {
                for (i = 0; i < curSize; ++i) {
                    outputStream.write(this.buffer[i]);
                }
                continue;
            }
            for (i = 0; i < curSize; i += this.copyBufferSize) {
                outputStream.write(this.buffer, i, Math.min(this.copyBufferSize, curSize - i));
            }
        }
    }

    @VisibleForTesting
    byte[] getBuffer() {
        return this.buffer;
    }
}

