/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.impl.ChunkLayOutVersion;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.VolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.DispatcherContext;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.RoundRobinVolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainer;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.impl.ChunkManagerFactory;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.ChunkManager;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="cmdw", aliases={"chunk-manager-disk-write"}, description={"Write chunks as fast as possible."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class ChunkManagerDiskWrite
extends BaseFreonGenerator
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkManagerDiskWrite.class);
    @CommandLine.Option(names={"-s", "--size"}, description={"Size of the generated chunks (in bytes)"}, defaultValue="1024")
    private int chunkSize;
    @CommandLine.Option(names={"-c", "--chunks-per-block"}, description={"The number of chunks to write per block"}, defaultValue="16")
    private int chunksPerBlock;
    @CommandLine.Option(names={"-l", "--layout"}, description={"Strategy to layout files in the container"}, defaultValue="FILE_PER_CHUNK")
    private ChunkLayOutVersion chunkLayout;
    private ChunkManager chunkManager;
    private final Map<Integer, KeyValueContainer> containersPerThread = new ConcurrentHashMap<Integer, KeyValueContainer>();
    private Timer timer;
    private byte[] data;
    private long blockSize;
    private final ThreadLocal<AtomicLong> bytesWrittenInThread = ThreadLocal.withInitial(AtomicLong::new);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        try {
            this.init();
            OzoneConfiguration ozoneConfiguration = this.createOzoneConfiguration();
            MutableVolumeSet volumeSet = new MutableVolumeSet("dnid", "clusterid", (ConfigurationSource)ozoneConfiguration);
            Random random = new Random();
            RoundRobinVolumeChoosingPolicy volumeChoicePolicy = new RoundRobinVolumeChoosingPolicy();
            int threadCount = this.getThreadNo();
            for (int i = 1; i <= threadCount; ++i) {
                long containerId = random.nextLong() & 0xFFFFFFFFFFFFFFFL;
                KeyValueContainerData keyValueContainerData = new KeyValueContainerData(containerId, this.chunkLayout, 1000000L, this.getPrefix(), "nodeid");
                KeyValueContainer keyValueContainer = new KeyValueContainer(keyValueContainerData, (ConfigurationSource)ozoneConfiguration);
                keyValueContainer.create((VolumeSet)volumeSet, (VolumeChoosingPolicy)volumeChoicePolicy, "scmid");
                this.containersPerThread.put(i, keyValueContainer);
            }
            this.blockSize = this.chunkSize * this.chunksPerBlock;
            this.data = RandomStringUtils.randomAscii((int)this.chunkSize).getBytes(StandardCharsets.UTF_8);
            this.chunkManager = ChunkManagerFactory.createChunkManager((ConfigurationSource)ozoneConfiguration, null);
            this.timer = this.getMetrics().timer("chunk-write");
            LOG.info("Running chunk write test: threads={} chunkSize={} chunksPerBlock={} layout={}", new Object[]{threadCount, this.chunkSize, this.chunksPerBlock, this.chunkLayout});
            this.runTests(this::writeChunk);
        }
        finally {
            if (this.chunkManager != null) {
                this.chunkManager.shutdown();
            }
        }
        return null;
    }

    private void writeChunk(long l) {
        int threadID = Integer.parseInt(Thread.currentThread().getName().split("-")[3]);
        KeyValueContainer container = this.containersPerThread.get(threadID);
        long containerID = container.getContainerData().getContainerID();
        long bytesWritten = this.bytesWrittenInThread.get().getAndAdd(this.chunkSize);
        long offset = bytesWritten % this.blockSize;
        long localID = bytesWritten / this.blockSize;
        BlockID blockId = new BlockID(containerID, localID);
        String chunkName = this.getPrefix() + "_chunk_" + l;
        ChunkInfo chunkInfo = new ChunkInfo(chunkName, offset, (long)this.chunkSize);
        LOG.debug("Writing chunk {}: containerID:{} localID:{} offset:{} bytesWritten:{}", new Object[]{l, containerID, localID, offset, bytesWritten});
        DispatcherContext context = new DispatcherContext.Builder().setStage(DispatcherContext.WriteChunkStage.WRITE_DATA).setTerm(1L).setLogIndex(l).setReadFromTmpFile(false).build();
        ByteBuffer buffer = ByteBuffer.wrap(this.data);
        this.timer.time(() -> {
            try {
                this.chunkManager.writeChunk((Container)container, blockId, chunkInfo, buffer, context);
            }
            catch (StorageContainerException e) {
                throw new UncheckedIOException((IOException)((Object)e));
            }
        });
    }
}

