/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.GenericParentCommand;
import org.apache.hadoop.hdds.cli.SubcommandWithParent;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.ozone.common.InconsistentStorageStateException;
import org.apache.hadoop.ozone.container.common.helpers.ContainerMetrics;
import org.apache.hadoop.ozone.container.common.helpers.DatanodeVersionFile;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.interfaces.Handler;
import org.apache.hadoop.ozone.container.common.utils.HddsVolumeUtil;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerReader;
import org.apache.hadoop.ozone.container.replication.OnDemandContainerReplicationSource;
import org.apache.hadoop.ozone.debug.OzoneDebug;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="export-container", description={"Export one container to a tarball"})
public class ExportContainer
implements SubcommandWithParent,
Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(ExportContainer.class);
    @CommandLine.ParentCommand
    private GenericParentCommand parent;
    @CommandLine.Option(names={"--container"}, required=true, description={"Container Id"})
    private long containerId;
    @CommandLine.Option(names={"--dest"}, defaultValue="/tmp", description={"Destination directory"})
    private String destination;

    public Class<?> getParentType() {
        return OzoneDebug.class;
    }

    @Override
    public Void call() throws Exception {
        OzoneConfiguration conf = this.parent.createOzoneConfiguration();
        ContainerSet containerSet = new ContainerSet();
        ContainerMetrics metrics = ContainerMetrics.create((ConfigurationSource)conf);
        String firstStorageDir = this.getFirstStorageDir((ConfigurationSource)conf);
        String datanodeUuid = this.getDatanodeUUID(firstStorageDir, (ConfigurationSource)conf);
        String scmId = this.getScmId(firstStorageDir);
        MutableVolumeSet volumeSet = new MutableVolumeSet(datanodeUuid, (ConfigurationSource)conf);
        HashMap<ContainerProtos.ContainerType, Handler> handlers = new HashMap<ContainerProtos.ContainerType, Handler>();
        for (ContainerProtos.ContainerType containerType : ContainerProtos.ContainerType.values()) {
            Handler handler = Handler.getHandlerForContainerType((ContainerProtos.ContainerType)containerType, (ConfigurationSource)conf, (String)datanodeUuid, (ContainerSet)containerSet, (VolumeSet)volumeSet, (ContainerMetrics)metrics, containerReplicaProto -> {});
            handler.setScmID(scmId);
            handlers.put(containerType, handler);
        }
        ContainerController controller = new ContainerController(containerSet, handlers);
        OnDemandContainerReplicationSource replicationSource = new OnDemandContainerReplicationSource(controller);
        Iterator volumeSetIterator = volumeSet.getVolumesList().iterator();
        LOG.info("Starting the read all the container metadata");
        while (volumeSetIterator.hasNext()) {
            HddsVolume volume = (HddsVolume)volumeSetIterator.next();
            LOG.info("Loading container metadata from volume " + volume.toString());
            ContainerReader reader = new ContainerReader(volumeSet, volume, containerSet, (ConfigurationSource)conf);
            reader.run();
        }
        LOG.info("All the container metadata is loaded. Starting to replication");
        replicationSource.prepare(this.containerId);
        LOG.info("Preparation is done");
        File destinationFile = new File(this.destination, "container-" + this.containerId + ".tar.gz");
        try (FileOutputStream fos = new FileOutputStream(destinationFile);){
            replicationSource.copyData(this.containerId, (OutputStream)fos);
        }
        LOG.info("Container is exported to {}", (Object)destinationFile);
        return null;
    }

    public String getScmId(String storageDir) throws IOException {
        Preconditions.checkNotNull((Object)storageDir);
        Path firstStorageDirPath = Files.list(Paths.get(storageDir, "hdds")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findFirst().get().getFileName();
        if (firstStorageDirPath == null) {
            throw new IllegalArgumentException("HDDS storage dir couldn't be identified!");
        }
        return firstStorageDirPath.toString();
    }

    public String getDatanodeUUID(String storageDir, ConfigurationSource config) throws IOException {
        File versionFile = new File(storageDir, "hdds/VERSION");
        Properties props = DatanodeVersionFile.readFrom((File)versionFile);
        if (props.isEmpty()) {
            throw new InconsistentStorageStateException("Version file " + versionFile + " is missing");
        }
        return HddsVolumeUtil.getProperty((Properties)props, (String)"datanodeUuid", (File)versionFile);
    }

    private String getFirstStorageDir(ConfigurationSource config) throws IOException {
        Collection storageDirs = MutableVolumeSet.getDatanodeStorageDirs((ConfigurationSource)config);
        return StorageLocation.parse((String)((String)storageDirs.iterator().next())).getUri().getPath();
    }
}

