/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.cli.SubcommandWithParent;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.cli.ContainerOperationClient;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.impl.ChunkLayOutVersion;
import org.apache.hadoop.ozone.debug.ChunkDetails;
import org.apache.hadoop.ozone.debug.ContainerChunkInfo;
import org.apache.hadoop.ozone.debug.OzoneDebug;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.keys.KeyHandler;
import org.apache.hadoop.security.token.Token;
import picocli.CommandLine;

@CommandLine.Command(name="chunkinfo", description={"returns chunk location information about an existing key"})
public class ChunkKeyHandler
extends KeyHandler
implements SubcommandWithParent {
    private ContainerOperationClient containerOperationClient;
    private XceiverClientManager xceiverClientManager;
    private XceiverClientSpi xceiverClient;
    private OzoneManagerProtocol ozoneManagerClient;

    private String getChunkLocationPath(String containerLocation) {
        return containerLocation + File.separator + "chunks";
    }

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException, OzoneClientException {
        this.containerOperationClient = new ContainerOperationClient(this.createOzoneConfiguration());
        this.xceiverClientManager = this.containerOperationClient.getXceiverClientManager();
        this.ozoneManagerClient = client.getObjectStore().getClientProxy().getOzoneManagerClient();
        address.ensureKeyAddress();
        JsonObject result = new JsonObject();
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        String keyName = address.getKeyName();
        List tempchunks = null;
        ArrayList<ChunkDetails> chunkDetailsList = new ArrayList<ChunkDetails>();
        HashSet<String> chunkPaths = new HashSet<String>();
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setRefreshPipeline(true).build();
        OmKeyInfo keyInfo = this.ozoneManagerClient.lookupKey(keyArgs);
        List locationInfos = keyInfo.getLatestVersionLocations().getBlocksLatestVersionOnly();
        if (locationInfos.isEmpty()) {
            System.out.println("No Key Locations Found");
            return;
        }
        ChunkLayOutVersion chunkLayOutVersion = ChunkLayOutVersion.getConfiguredVersion((ConfigurationSource)this.getConf());
        JsonArray responseArrayList = new JsonArray();
        for (OmKeyLocationInfo keyLocation : locationInfos) {
            ContainerChunkInfo containerChunkInfoVerbose = new ContainerChunkInfo();
            ContainerChunkInfo containerChunkInfo = new ContainerChunkInfo();
            long containerId = keyLocation.getContainerID();
            chunkPaths.clear();
            Pipeline pipeline = keyLocation.getPipeline();
            if (pipeline.getType() != HddsProtos.ReplicationType.STAND_ALONE) {
                pipeline = Pipeline.newBuilder((Pipeline)pipeline).setType(HddsProtos.ReplicationType.STAND_ALONE).build();
            }
            this.xceiverClient = this.xceiverClientManager.acquireClientForReadData(pipeline);
            ContainerProtos.DatanodeBlockID datanodeBlockID = keyLocation.getBlockID().getDatanodeBlockIDProtobuf();
            HashMap responses = null;
            try {
                responses = ContainerProtocolCalls.getBlockFromAllNodes((XceiverClientSpi)this.xceiverClient, (ContainerProtos.DatanodeBlockID)datanodeBlockID, (Token)keyLocation.getToken());
            }
            catch (InterruptedException e) {
                LOG.error("Execution interrupted due to " + e);
            }
            JsonArray responseFromAllNodes = new JsonArray();
            for (Map.Entry entry : responses.entrySet()) {
                JsonObject jsonObj = new JsonObject();
                if (entry.getValue() == null) {
                    LOG.error("Cant execute getBlock on this node");
                    continue;
                }
                tempchunks = ((ContainerProtos.GetBlockResponseProto)entry.getValue()).getBlockData().getChunksList();
                ContainerProtos.ContainerDataProto containerData = this.containerOperationClient.readContainer(keyLocation.getContainerID(), keyLocation.getPipeline());
                for (ContainerProtos.ChunkInfo chunkInfo : tempchunks) {
                    String fileName = chunkLayOutVersion.getChunkFile(new File(this.getChunkLocationPath(containerData.getContainerPath())), keyLocation.getBlockID(), ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunkInfo)).toString();
                    chunkPaths.add(fileName);
                    ChunkDetails chunkDetails = new ChunkDetails();
                    chunkDetails.setChunkName(fileName);
                    chunkDetails.setChunkOffset(chunkInfo.getOffset());
                    chunkDetailsList.add(chunkDetails);
                }
                containerChunkInfoVerbose.setContainerPath(containerData.getContainerPath());
                containerChunkInfoVerbose.setPipeline(keyLocation.getPipeline());
                containerChunkInfoVerbose.setChunkInfos(chunkDetailsList);
                containerChunkInfo.setFiles(chunkPaths);
                containerChunkInfo.setPipelineID(keyLocation.getPipeline().getId().getId());
                Gson gson = new GsonBuilder().create();
                JsonElement element = this.isVerbose() ? gson.toJsonTree((Object)containerChunkInfoVerbose) : gson.toJsonTree((Object)containerChunkInfo);
                jsonObj.addProperty("Datanode-HostName", ((DatanodeDetails)entry.getKey()).getHostName());
                jsonObj.addProperty("Datanode-IP", ((DatanodeDetails)entry.getKey()).getIpAddress());
                jsonObj.addProperty("Container-ID", (Number)containerId);
                jsonObj.addProperty("Block-ID", (Number)keyLocation.getLocalID());
                jsonObj.add("Locations", element);
                responseFromAllNodes.add((JsonElement)jsonObj);
                this.xceiverClientManager.releaseClientForReadData(this.xceiverClient, false);
            }
            responseArrayList.add((JsonElement)responseFromAllNodes);
        }
        result.add("KeyLocations", (JsonElement)responseArrayList);
        Gson gson2 = new GsonBuilder().setPrettyPrinting().create();
        String prettyJson = gson2.toJson((JsonElement)result);
        System.out.println(prettyJson);
    }

    public Class<?> getParentType() {
        return OzoneDebug.class;
    }
}

