/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.om;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.cli.OzoneAdmin;
import org.apache.hadoop.hdds.cli.SubcommandWithParent;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.admin.om.GetServiceRolesSubcommand;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.om.protocolPB.Hadoop3OmTransportFactory;
import org.apache.hadoop.ozone.om.protocolPB.OmTransport;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ratis.protocol.ClientId;
import picocli.CommandLine;

@CommandLine.Command(name="om", description={"Ozone Manager specific admin operations"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class, subcommands={GetServiceRolesSubcommand.class})
public class OMAdmin
extends GenericCli
implements SubcommandWithParent {
    @CommandLine.ParentCommand
    private OzoneAdmin parent;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    public OzoneAdmin getParent() {
        return this.parent;
    }

    public Void call() throws Exception {
        GenericCli.missingSubcommand((CommandLine.Model.CommandSpec)this.spec);
        return null;
    }

    public ClientProtocol createClient(String omServiceId) throws Exception {
        OzoneConfiguration conf = this.parent.getOzoneConf();
        if (OmUtils.isOmHAServiceId((ConfigurationSource)conf, (String)omServiceId)) {
            return OzoneClientFactory.getRpcClient((String)omServiceId, (ConfigurationSource)conf).getObjectStore().getClientProxy();
        }
        throw new OzoneClientException("This command works only on OzoneManager HA cluster. Service ID specified does not match with ozone.om.service.ids defined in the configuration. Configured ozone.om.service.ids are " + conf.getTrimmedStringCollection("ozone.om.service.ids") + "\n");
    }

    public OzoneManagerProtocolClientSideTranslatorPB createOmClient(String omServiceID) throws Exception {
        OzoneConfiguration conf = this.parent.getOzoneConf();
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        RPC.setProtocolEngine((Configuration)conf, OzoneManagerProtocolPB.class, ProtobufRpcEngine.class);
        String clientId = ClientId.randomId().toString();
        if (OmUtils.isOmHAServiceId((ConfigurationSource)conf, (String)omServiceID)) {
            OmTransport omTransport = new Hadoop3OmTransportFactory().createOmTransport((ConfigurationSource)conf, ugi, omServiceID);
            return new OzoneManagerProtocolClientSideTranslatorPB(omTransport, clientId);
        }
        throw new OzoneClientException("This command works only on OzoneManager HA cluster. Service ID specified does not match with ozone.om.service.ids defined in the configuration. Configured ozone.om.service.ids are " + conf.getTrimmedStringCollection("ozone.om.service.ids") + "\n");
    }

    public Class<?> getParentType() {
        return OzoneAdmin.class;
    }
}

