/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.datanode;

import com.google.common.base.Strings;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.List;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import picocli.CommandLine;

@CommandLine.Command(name="usageinfo", description={"List usage information (such as Capacity, SCMUsed, Remaining) of a datanode by IP address or UUID"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class UsageInfoSubcommand
extends ScmSubcommand {
    @CommandLine.ArgGroup(multiplicity="1")
    private ExclusiveArguments exclusiveArguments;
    @CommandLine.Option(names={"-c", "--count"}, description={"Number of datanodes to display (Default: ${DEFAULT-VALUE})."}, paramLabel="NUMBER OF NODES", defaultValue="3")
    private int count;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        if (this.count < 1) {
            throw new IOException("Count must be an integer greater than 0.");
        }
        List infoList = !Strings.isNullOrEmpty((String)this.exclusiveArguments.ipaddress) || !Strings.isNullOrEmpty((String)this.exclusiveArguments.uuid) ? scmClient.getDatanodeUsageInfo(this.exclusiveArguments.ipaddress, this.exclusiveArguments.uuid) : scmClient.getDatanodeUsageInfo(this.exclusiveArguments.mostUsed, this.count);
        infoList.forEach(this::printInfo);
    }

    public void printInfo(HddsProtos.DatanodeUsageInfoProto info) {
        double capacity = info.getCapacity();
        double usedRatio = (double)info.getUsed() / capacity;
        double remainingRatio = (double)info.getRemaining() / capacity;
        NumberFormat percentFormat = NumberFormat.getPercentInstance();
        percentFormat.setMinimumFractionDigits(5);
        System.out.printf("Usage info for datanode with UUID %s:%n", info.getNode().getUuid());
        System.out.printf("%-10s: %20sB %n", "Capacity", info.getCapacity());
        System.out.printf("%-10s: %20sB (%s) %n", "SCMUsed", info.getUsed(), percentFormat.format(usedRatio));
        System.out.printf("%-10s: %20sB (%s) %n%n", "Remaining", info.getRemaining(), percentFormat.format(remainingRatio));
    }

    private static class ExclusiveArguments {
        @CommandLine.Option(names={"--ip"}, paramLabel="IP", description={"Show info by datanode ip address."}, defaultValue="")
        private String ipaddress;
        @CommandLine.Option(names={"--uuid"}, paramLabel="UUID", description={"Show info by datanode UUID."}, defaultValue="")
        private String uuid;
        @CommandLine.Option(names={"-m", "--most-used"}, description={"Show the most used datanodes."}, defaultValue="false")
        private boolean mostUsed;
        @CommandLine.Option(names={"-l", "--least-used"}, description={"Show the least used datanodes."}, defaultValue="false")
        private boolean leastUsed;

        private ExclusiveArguments() {
        }
    }
}

