/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.datanode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import picocli.CommandLine;

@CommandLine.Command(name="maintenance", description={"Put a datanode into Maintenance Mode"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class MaintenanceSubCommand
extends ScmSubcommand {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Parameters(description={"List of fully qualified host names"})
    private List<String> hosts = new ArrayList<String>();
    @CommandLine.Option(names={"--end"}, description={"Automatically end maintenance after the given hours. By default, maintenance must be ended manually."})
    private int endInHours = 0;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        if (this.hosts.size() > 0) {
            scmClient.startMaintenanceNodes(this.hosts, this.endInHours);
            System.out.println("Entering maintenance mode on datanode(s):\n" + String.join((CharSequence)"\n", this.hosts));
        } else {
            GenericCli.missingSubcommand((CommandLine.Model.CommandSpec)this.spec);
        }
    }
}

