/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.cert;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.SCMSecurityProtocol;
import org.apache.hadoop.hdds.scm.cli.cert.ScmCertSubcommand;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="info", description={"Show detailed information for a specific certificate"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
class InfoSubcommand
extends ScmCertSubcommand {
    private static final Logger LOG = LoggerFactory.getLogger(InfoSubcommand.class);
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Parameters(description={"Serial id of the certificate in decimal."})
    private String serialId;

    InfoSubcommand() {
    }

    @Override
    public void execute(SCMSecurityProtocol client) throws IOException {
        String certPemStr = client.getCertificate(this.serialId);
        Preconditions.checkNotNull((Object)certPemStr, (Object)"Certificate can't be found");
        LOG.info("Certificate id: {}", (Object)this.serialId);
        try {
            X509Certificate cert = CertificateCodec.getX509Cert((String)certPemStr);
            LOG.info(cert.toString());
        }
        catch (CertificateException ex) {
            LOG.error("Failed to get certificate id " + this.serialId);
            throw new IOException("Fail to get certificate id " + this.serialId, ex);
        }
    }
}

