/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.cli.GenericParentCommand;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.SCMSecurityProtocol;
import org.apache.hadoop.hdds.scm.cli.ContainerOperationClient;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import picocli.CommandLine;

public class ScmOption {
    @CommandLine.Spec(value=CommandLine.Spec.Target.MIXEE)
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--scm"}, description={"The destination scm (host:port)"})
    private String scm;

    public ScmClient createScmClient() {
        try {
            GenericParentCommand parent = (GenericParentCommand)this.spec.root().userObject();
            OzoneConfiguration conf = parent.createOzoneConfiguration();
            this.checkAndSetSCMAddressArg((MutableConfigurationSource)conf);
            return new ContainerOperationClient(conf);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Can't create SCM client", ex);
        }
    }

    private void checkAndSetSCMAddressArg(MutableConfigurationSource conf) {
        if (StringUtils.isNotEmpty((CharSequence)this.scm)) {
            conf.set("ozone.scm.client.address", this.scm);
        }
        if (!HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.scm.client.address"}).isPresent()) {
            throw new IllegalArgumentException("ozone.scm.client.address should be set in ozone-site.xml or with the --scm option");
        }
    }

    public SCMSecurityProtocol createScmSecurityClient() {
        try {
            GenericParentCommand parent = (GenericParentCommand)this.spec.root().userObject();
            return HddsServerUtil.getScmSecurityClient((OzoneConfiguration)parent.createOzoneConfiguration());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Can't create SCM Security client", ex);
        }
    }
}

