/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerOperationClient
implements ScmClient {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerOperationClient.class);
    private final long containerSizeB;
    private final HddsProtos.ReplicationFactor replicationFactor;
    private final HddsProtos.ReplicationType replicationType;
    private final StorageContainerLocationProtocol storageContainerLocationClient;
    private final XceiverClientManager xceiverClientManager;

    public XceiverClientManager getXceiverClientManager() {
        return this.xceiverClientManager;
    }

    public ContainerOperationClient(OzoneConfiguration conf) throws IOException {
        this.storageContainerLocationClient = ContainerOperationClient.newContainerRpcClient((ConfigurationSource)conf);
        this.xceiverClientManager = this.newXCeiverClientManager((ConfigurationSource)conf);
        this.containerSizeB = (int)conf.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
        boolean useRatis = conf.getBoolean("dfs.container.ratis.enabled", false);
        if (useRatis) {
            this.replicationFactor = HddsProtos.ReplicationFactor.THREE;
            this.replicationType = HddsProtos.ReplicationType.RATIS;
        } else {
            this.replicationFactor = HddsProtos.ReplicationFactor.ONE;
            this.replicationType = HddsProtos.ReplicationType.STAND_ALONE;
        }
    }

    @VisibleForTesting
    public StorageContainerLocationProtocol getStorageContainerLocationProtocol() {
        return this.storageContainerLocationClient;
    }

    private XceiverClientManager newXCeiverClientManager(ConfigurationSource conf) throws IOException {
        XceiverClientManager manager;
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
            SecurityConfig securityConfig = new SecurityConfig(conf);
            SCMSecurityProtocolClientSideTranslatorPB scmSecurityProtocolClient = HddsServerUtil.getScmSecurityClient((OzoneConfiguration)((OzoneConfiguration)securityConfig.getConfiguration()));
            String caCertificate = scmSecurityProtocolClient.getCACertificate();
            manager = new XceiverClientManager(conf, (XceiverClientManager.ScmClientConfig)conf.getObject(XceiverClientManager.ScmClientConfig.class), caCertificate);
        } else {
            manager = new XceiverClientManager(conf);
        }
        return manager;
    }

    public static StorageContainerLocationProtocol newContainerRpcClient(ConfigurationSource configSource) throws IOException {
        Class<StorageContainerLocationProtocolPB> protocol = StorageContainerLocationProtocolPB.class;
        Configuration conf = LegacyHadoopConfigurationSource.asHadoopConfiguration((ConfigurationSource)configSource);
        RPC.setProtocolEngine((Configuration)conf, protocol, ProtobufRpcEngine.class);
        long version = RPC.getProtocolVersion(protocol);
        InetSocketAddress scmAddress = HddsUtils.getScmAddressForClients((ConfigurationSource)configSource);
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        SocketFactory socketFactory = NetUtils.getDefaultSocketFactory((Configuration)conf);
        int rpcTimeOut = Client.getRpcTimeout((Configuration)conf);
        StorageContainerLocationProtocolPB rpcProxy = (StorageContainerLocationProtocolPB)RPC.getProxy(protocol, (long)version, (InetSocketAddress)scmAddress, (UserGroupInformation)user, (Configuration)conf, (SocketFactory)socketFactory, (int)rpcTimeOut);
        StorageContainerLocationProtocolClientSideTranslatorPB client = new StorageContainerLocationProtocolClientSideTranslatorPB(rpcProxy);
        return (StorageContainerLocationProtocol)TracingUtil.createProxy((Object)client, StorageContainerLocationProtocol.class, (ConfigurationSource)configSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerWithPipeline createContainer(String owner) throws IOException {
        ContainerWithPipeline containerWithPipeline;
        block3: {
            XceiverClientSpi client = null;
            try {
                ContainerWithPipeline containerWithPipeline2 = this.storageContainerLocationClient.allocateContainer(this.replicationType, this.replicationFactor, owner);
                Pipeline pipeline = containerWithPipeline2.getPipeline();
                client = this.xceiverClientManager.acquireClient(pipeline);
                Preconditions.checkState((boolean)pipeline.isOpen(), (String)"Unexpected state=%s for pipeline=%s, expected state=%s", (Object)pipeline.getPipelineState(), (Object)pipeline.getId(), (Object)Pipeline.PipelineState.OPEN);
                this.createContainer(client, containerWithPipeline2.getContainerInfo().getContainerID());
                containerWithPipeline = containerWithPipeline2;
                if (client == null) break block3;
            }
            catch (Throwable throwable) {
                if (client != null) {
                    this.xceiverClientManager.releaseClient(client, false);
                }
                throw throwable;
            }
            this.xceiverClientManager.releaseClient(client, false);
        }
        return containerWithPipeline;
    }

    public void createContainer(XceiverClientSpi client, long containerId) throws IOException {
        ContainerProtocolCalls.createContainer((XceiverClientSpi)client, (long)containerId, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created container " + containerId + " machines:" + client.getPipeline().getNodes());
        }
    }

    private void createPipeline(XceiverClientSpi client, Pipeline pipeline) throws IOException {
        Preconditions.checkNotNull((Object)pipeline.getId(), (Object)"Pipeline name cannot be null when client create flag is set.");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pipeline creation successful. Pipeline: {}", (Object)pipeline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerWithPipeline createContainer(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, String owner) throws IOException {
        ContainerWithPipeline containerWithPipeline;
        block3: {
            XceiverClientSpi client = null;
            try {
                ContainerWithPipeline containerWithPipeline2 = this.storageContainerLocationClient.allocateContainer(type, factor, owner);
                Pipeline pipeline = containerWithPipeline2.getPipeline();
                client = this.xceiverClientManager.acquireClient(pipeline);
                this.createContainer(client, containerWithPipeline2.getContainerInfo().getContainerID());
                containerWithPipeline = containerWithPipeline2;
                if (client == null) break block3;
            }
            catch (Throwable throwable) {
                if (client != null) {
                    this.xceiverClientManager.releaseClient(client, false);
                }
                throw throwable;
            }
            this.xceiverClientManager.releaseClient(client, false);
        }
        return containerWithPipeline;
    }

    public List<HddsProtos.Node> queryNode(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState nodeState, HddsProtos.QueryScope queryScope, String poolName) throws IOException {
        return this.storageContainerLocationClient.queryNode(opState, nodeState, queryScope, poolName, 1);
    }

    public void decommissionNodes(List<String> hosts) throws IOException {
        this.storageContainerLocationClient.decommissionNodes(hosts);
    }

    public void recommissionNodes(List<String> hosts) throws IOException {
        this.storageContainerLocationClient.recommissionNodes(hosts);
    }

    public void startMaintenanceNodes(List<String> hosts, int endHours) throws IOException {
        this.storageContainerLocationClient.startMaintenanceNodes(hosts, endHours);
    }

    public Pipeline createReplicationPipeline(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, HddsProtos.NodePool nodePool) throws IOException {
        return this.storageContainerLocationClient.createReplicationPipeline(type, factor, nodePool);
    }

    public List<Pipeline> listPipelines() throws IOException {
        return this.storageContainerLocationClient.listPipelines();
    }

    public Pipeline getPipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        return this.storageContainerLocationClient.getPipeline(pipelineID);
    }

    public void activatePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        this.storageContainerLocationClient.activatePipeline(pipelineID);
    }

    public void deactivatePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        this.storageContainerLocationClient.deactivatePipeline(pipelineID);
    }

    public void closePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        this.storageContainerLocationClient.closePipeline(pipelineID);
    }

    public void close() {
        try {
            this.xceiverClientManager.close();
        }
        catch (Exception ex) {
            LOG.error("Can't close " + this.getClass().getSimpleName(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteContainer(long containerId, Pipeline pipeline, boolean force) throws IOException {
        XceiverClientSpi client = null;
        try {
            client = this.xceiverClientManager.acquireClient(pipeline);
            ContainerProtocolCalls.deleteContainer((XceiverClientSpi)client, (long)containerId, (boolean)force, null);
            this.storageContainerLocationClient.deleteContainer(containerId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleted container {}, machines: {} ", (Object)containerId, (Object)pipeline.getNodes());
            }
        }
        finally {
            if (client != null) {
                this.xceiverClientManager.releaseClient(client, false);
            }
        }
    }

    public void deleteContainer(long containerID, boolean force) throws IOException {
        ContainerWithPipeline info = this.getContainerWithPipeline(containerID);
        this.deleteContainer(containerID, info.getPipeline(), force);
    }

    public List<ContainerInfo> listContainer(long startContainerID, int count) throws IOException {
        return this.storageContainerLocationClient.listContainer(startContainerID, count);
    }

    public List<ContainerInfo> listContainer(long startContainerID, int count, HddsProtos.LifeCycleState state) throws IOException {
        return this.storageContainerLocationClient.listContainer(startContainerID, count, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerProtos.ContainerDataProto readContainer(long containerID, Pipeline pipeline) throws IOException {
        XceiverClientSpi client = null;
        try {
            client = this.xceiverClientManager.acquireClientForReadData(pipeline);
            ContainerProtos.ReadContainerResponseProto response = ContainerProtocolCalls.readContainer((XceiverClientSpi)client, (long)containerID, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read container {}, machines: {} ", (Object)containerID, (Object)pipeline.getNodes());
            }
            ContainerProtos.ContainerDataProto containerDataProto = response.getContainerData();
            return containerDataProto;
        }
        finally {
            if (client != null) {
                this.xceiverClientManager.releaseClient(client, false);
            }
        }
    }

    public ContainerProtos.ContainerDataProto readContainer(long containerID) throws IOException {
        ContainerWithPipeline info = this.getContainerWithPipeline(containerID);
        return this.readContainer(containerID, info.getPipeline());
    }

    public ContainerInfo getContainer(long containerId) throws IOException {
        return this.storageContainerLocationClient.getContainer(containerId);
    }

    public ContainerWithPipeline getContainerWithPipeline(long containerId) throws IOException {
        return this.storageContainerLocationClient.getContainerWithPipeline(containerId);
    }

    public void closeContainer(long containerId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Close container {}", (Object)containerId);
        }
        this.storageContainerLocationClient.closeContainer(containerId);
    }

    public long getContainerSize(long containerID) throws IOException {
        return this.containerSizeB;
    }

    public boolean inSafeMode() throws IOException {
        return this.storageContainerLocationClient.inSafeMode();
    }

    public Map<String, Pair<Boolean, String>> getSafeModeRuleStatuses() throws IOException {
        return this.storageContainerLocationClient.getSafeModeRuleStatuses();
    }

    public boolean forceExitSafeMode() throws IOException {
        return this.storageContainerLocationClient.forceExitSafeMode();
    }

    public void startReplicationManager() throws IOException {
        this.storageContainerLocationClient.startReplicationManager();
    }

    public void stopReplicationManager() throws IOException {
        this.storageContainerLocationClient.stopReplicationManager();
    }

    public boolean getReplicationManagerStatus() throws IOException {
        return this.storageContainerLocationClient.getReplicationManagerStatus();
    }

    public List<HddsProtos.DatanodeUsageInfoProto> getDatanodeUsageInfo(String ipaddress, String uuid) throws IOException {
        return this.storageContainerLocationClient.getDatanodeUsageInfo(ipaddress, uuid);
    }

    public List<HddsProtos.DatanodeUsageInfoProto> getDatanodeUsageInfo(boolean mostUsed, int count) throws IOException {
        return this.storageContainerLocationClient.getDatanodeUsageInfo(mostUsed, count);
    }
}

